"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sandbox = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_efs_1 = require("@aws-cdk/aws-efs");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const definition_bucket_1 = require("./definition-bucket");
class Sandbox extends core_1.Construct {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        this.vpc = new aws_ec2_1.Vpc(this, 'VPC', {
            subnetConfiguration: [
                {
                    subnetType: aws_ec2_1.SubnetType.ISOLATED,
                    name: 'Sandbox',
                },
            ],
        });
        this.vpc.addFlowLog('FlowLog');
        this.s3Endpoint = this.vpc.addGatewayEndpoint('S3Endpoint', {
            service: aws_ec2_1.GatewayVpcEndpointAwsService.S3,
        });
        this.definitionBucket = new definition_bucket_1.DefinitionBucket(this, 'DefinitionBucket', {
            vpcEndpoint: this.s3Endpoint.vpcEndpointId,
        });
        this.s3Endpoint.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject', 's3:ListBucket'],
            resources: [this.definitionBucket.arnForObjects('*'), this.definitionBucket.bucketArn],
            principals: [new aws_iam_1.AnyPrincipal()],
        }));
        const fileSystem = new aws_efs_1.FileSystem(this, 'FileSystem', {
            vpc: this.vpc,
            lifecyclePolicy: aws_efs_1.LifecyclePolicy.AFTER_7_DAYS,
            performanceMode: aws_efs_1.PerformanceMode.GENERAL_PURPOSE,
            removalPolicy: core_1.RemovalPolicy.DESTROY,
            securityGroup: new aws_ec2_1.SecurityGroup(this, 'SecurityGroup', {
                vpc: this.vpc,
                allowAllOutbound: false,
            }),
            encrypted: (_b = props.encryptedFileSystem) !== null && _b !== void 0 ? _b : true,
        });
        this.lambdaAccessPoint = fileSystem.addAccessPoint('ScanLambdaAP', {
            createAcl: {
                ownerGid: '1000',
                ownerUid: '1000',
                permissions: '755',
            },
            posixUser: {
                gid: '1000',
                uid: '1000',
            },
            path: '/lambda',
        });
    }
    addToS3EnpointPolicy(statement) {
        this.s3Endpoint.addToPolicy(statement);
    }
}
exports.Sandbox = Sandbox;
_a = JSII_RTTI_SYMBOL_1;
Sandbox[_a] = { fqn: "@cloudcomponents/cdk-s3-antivirus.Sandbox", version: "1.2.0" };
//# sourceMappingURL=data:application/json;base64,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