# Generated by Django 3.1.5 on 2021-02-09 04:32

from django.db import migrations, models


def mark_archived_as_zipped(apps, schema_editor):
    Observation = apps.get_model('base', 'Observation')
    Observation.objects.filter(archived=True).update(audio_zipped=True)

def reverse_mark_archived_as_zipped(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('base', '0084_add_observation_status_index'),
    ]

    operations = [
        migrations.AddField(
            model_name='observation',
            name='audio_zipped',
            field=models.BooleanField(default=False),
        ),
    migrations.RunPython(mark_archived_as_zipped, reverse_mark_archived_as_zipped),
    ]
