import streamlit as st
import os,json
import urllib
from snowflake.snowpark.context import get_active_session

plugin_app_database = get_active_session().get_current_database().replace('"','')

st.set_page_config(
    page_title="Plugin Configuration",
    layout="wide"
)
def inline_svg_src(svg_source: str):
    return f"data:image/svg+xml,{urllib.parse.quote(svg_source)}"

PLUGIN_DIAGRAM="""<svg width="574" height="326" viewBox="0 0 574 326" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M409.826 1.99693H9.98357C5.57254 1.99693 1.9967 5.57317 1.9967 9.98468V316.015C1.9967 320.427 5.57254 324.003 9.98357 324.003H409.826C414.237 324.003 417.813 320.427 417.813 316.015V9.98468C417.813 5.57317 414.237 1.99693 409.826 1.99693Z" fill="#B4E3F5" fill-opacity="0.2" stroke="#2BB5E9" stroke-width="8"/>
<path d="M487.698 184.717H350.923C350.096 184.717 349.425 185.387 349.425 186.214V202.19C349.425 203.017 350.096 203.688 350.923 203.688H487.698C488.525 203.688 489.195 203.017 489.195 202.19V186.214C489.195 185.387 488.525 184.717 487.698 184.717Z" fill="white"/>
<path d="M359.949 196.278V195.392L363.087 190.435H363.785V191.74H363.342L361.098 195.293V195.349H365.398V196.278H359.949ZM363.391 197.697V196.009L363.399 195.605V190.435H364.438V197.697H363.391ZM367.396 197.764C367.202 197.764 367.035 197.696 366.896 197.558C366.757 197.419 366.687 197.251 366.687 197.055C366.687 196.861 366.757 196.696 366.896 196.559C367.035 196.419 367.202 196.349 367.396 196.349C367.59 196.349 367.756 196.419 367.896 196.559C368.035 196.696 368.105 196.861 368.105 197.055C368.105 197.185 368.072 197.304 368.006 197.413C367.942 197.52 367.857 197.604 367.751 197.668C367.644 197.732 367.526 197.764 367.396 197.764ZM378.958 192.797H377.852C377.809 192.56 377.73 192.352 377.614 192.173C377.498 191.993 377.356 191.84 377.189 191.715C377.021 191.59 376.833 191.495 376.625 191.431C376.419 191.367 376.201 191.336 375.969 191.336C375.551 191.336 375.176 191.441 374.845 191.652C374.517 191.862 374.256 192.17 374.065 192.577C373.876 192.984 373.782 193.48 373.782 194.066C373.782 194.657 373.876 195.156 374.065 195.562C374.256 195.969 374.518 196.276 374.848 196.484C375.179 196.692 375.552 196.796 375.966 196.796C376.195 196.796 376.412 196.765 376.618 196.704C376.826 196.64 377.014 196.547 377.182 196.424C377.349 196.301 377.491 196.151 377.607 195.973C377.725 195.794 377.807 195.589 377.852 195.356L378.958 195.36C378.899 195.717 378.784 196.046 378.614 196.346C378.446 196.644 378.23 196.902 377.965 197.119C377.703 197.334 377.402 197.501 377.064 197.619C376.726 197.737 376.358 197.796 375.959 197.796C375.33 197.796 374.77 197.647 374.278 197.349C373.786 197.049 373.399 196.62 373.115 196.062C372.834 195.504 372.693 194.839 372.693 194.066C372.693 193.291 372.835 192.625 373.119 192.07C373.402 191.512 373.79 191.084 374.281 190.786C374.773 190.486 375.332 190.336 375.959 190.336C376.344 190.336 376.703 190.391 377.036 190.502C377.372 190.611 377.673 190.772 377.94 190.985C378.207 191.195 378.428 191.453 378.603 191.758C378.778 192.06 378.896 192.406 378.958 192.797ZM380.308 197.697V190.435H382.897C383.459 190.435 383.926 190.532 384.297 190.726C384.67 190.92 384.949 191.188 385.134 191.531C385.318 191.871 385.41 192.265 385.41 192.711C385.41 193.156 385.317 193.547 385.13 193.885C384.946 194.221 384.667 194.482 384.293 194.669C383.923 194.856 383.456 194.949 382.893 194.949H380.932V194.006H382.794C383.148 194.006 383.437 193.955 383.659 193.853C383.884 193.752 384.048 193.604 384.152 193.41C384.256 193.216 384.307 192.984 384.307 192.711C384.307 192.437 384.255 192.2 384.148 191.999C384.044 191.798 383.88 191.644 383.655 191.538C383.433 191.429 383.141 191.375 382.779 191.375H381.404V197.697H380.308ZM383.893 194.421L385.687 197.697H384.439L382.681 194.421H383.893ZM386.783 197.697V190.435H391.335V191.378H387.879V193.591H391.098V194.531H387.879V196.754H391.378V197.697H386.783ZM393.452 197.697H392.289L394.902 190.435H396.168L398.781 197.697H397.618L395.565 191.754H395.508L393.452 197.697ZM393.647 194.853H397.419V195.775H393.647V194.853ZM398.653 191.378V190.435H404.272V191.378H402.007V197.697H400.915V191.378H398.653ZM405.554 197.697V190.435H410.106V191.378H406.65V193.591H409.868V194.531H406.65V196.754H410.149V197.697H405.554ZM420.322 192.797H419.216C419.174 192.56 419.094 192.352 418.978 192.173C418.863 191.993 418.721 191.84 418.553 191.715C418.385 191.59 418.197 191.495 417.989 191.431C417.783 191.367 417.565 191.336 417.333 191.336C416.915 191.336 416.54 191.441 416.209 191.652C415.881 191.862 415.621 192.17 415.43 192.577C415.241 192.984 415.146 193.48 415.146 194.066C415.146 194.657 415.241 195.156 415.43 195.562C415.621 195.969 415.882 196.276 416.213 196.484C416.544 196.692 416.916 196.796 417.33 196.796C417.559 196.796 417.776 196.765 417.982 196.704C418.19 196.64 418.378 196.547 418.546 196.424C418.714 196.301 418.856 196.151 418.971 195.973C419.089 195.794 419.171 195.589 419.216 195.356L420.322 195.36C420.263 195.717 420.148 196.046 419.978 196.346C419.811 196.644 419.594 196.902 419.329 197.119C419.067 197.334 418.767 197.501 418.429 197.619C418.091 197.737 417.722 197.796 417.323 197.796C416.694 197.796 416.134 197.647 415.642 197.349C415.151 197.049 414.763 196.62 414.479 196.062C414.198 195.504 414.057 194.839 414.057 194.066C414.057 193.291 414.199 192.625 414.483 192.07C414.766 191.512 415.154 191.084 415.646 190.786C416.138 190.486 416.696 190.336 417.323 190.336C417.708 190.336 418.067 190.391 418.4 190.502C418.736 190.611 419.037 190.772 419.304 190.985C419.571 191.195 419.793 191.453 419.967 191.758C420.142 192.06 420.261 192.406 420.322 192.797ZM427.98 194.066C427.98 194.841 427.838 195.508 427.554 196.066C427.271 196.621 426.882 197.049 426.388 197.349C425.897 197.647 425.337 197.796 424.711 197.796C424.082 197.796 423.521 197.647 423.027 197.349C422.536 197.049 422.148 196.62 421.864 196.062C421.581 195.504 421.439 194.839 421.439 194.066C421.439 193.291 421.581 192.625 421.864 192.07C422.148 191.512 422.536 191.084 423.027 190.786C423.521 190.486 424.082 190.336 424.711 190.336C425.337 190.336 425.897 190.486 426.388 190.786C426.882 191.084 427.271 191.512 427.554 192.07C427.838 192.625 427.98 193.291 427.98 194.066ZM426.895 194.066C426.895 193.475 426.8 192.978 426.608 192.573C426.419 192.167 426.159 191.859 425.828 191.652C425.499 191.441 425.127 191.336 424.711 191.336C424.293 191.336 423.919 191.441 423.591 191.652C423.262 191.859 423.002 192.167 422.811 192.573C422.622 192.978 422.527 193.475 422.527 194.066C422.527 194.657 422.622 195.156 422.811 195.562C423.002 195.966 423.262 196.274 423.591 196.484C423.919 196.692 424.293 196.796 424.711 196.796C425.127 196.796 425.499 196.692 425.828 196.484C426.159 196.274 426.419 195.966 426.608 195.562C426.8 195.156 426.895 194.657 426.895 194.066ZM435.246 190.435V197.697H434.239L430.548 192.371H430.481V197.697H429.386V190.435H430.4L434.094 195.768H434.161V190.435H435.246ZM442.744 190.435V197.697H441.737L438.047 192.371H437.98V197.697H436.884V190.435H437.898L441.592 195.768H441.66V190.435H442.744ZM444.383 197.697V190.435H448.935V191.378H445.478V193.591H448.697V194.531H445.478V196.754H448.977V197.697H444.383ZM456.468 192.797H455.363C455.32 192.56 455.241 192.352 455.125 192.173C455.009 191.993 454.867 191.84 454.699 191.715C454.531 191.59 454.344 191.495 454.136 191.431C453.93 191.367 453.711 191.336 453.48 191.336C453.061 191.336 452.687 191.441 452.356 191.652C452.028 191.862 451.767 192.17 451.576 192.577C451.387 192.984 451.292 193.48 451.292 194.066C451.292 194.657 451.387 195.156 451.576 195.562C451.767 195.969 452.029 196.276 452.359 196.484C452.69 196.692 453.063 196.796 453.476 196.796C453.705 196.796 453.923 196.765 454.129 196.704C454.337 196.64 454.524 196.547 454.692 196.424C454.86 196.301 455.002 196.151 455.117 195.973C455.236 195.794 455.318 195.589 455.363 195.356L456.468 195.36C456.409 195.717 456.295 196.046 456.125 196.346C455.957 196.644 455.74 196.902 455.476 197.119C455.213 197.334 454.913 197.501 454.575 197.619C454.237 197.737 453.869 197.796 453.469 197.796C452.84 197.796 452.28 197.647 451.788 197.349C451.297 197.049 450.909 196.62 450.626 196.062C450.344 195.504 450.204 194.839 450.204 194.066C450.204 193.291 450.346 192.625 450.629 192.07C450.913 191.512 451.301 191.084 451.792 190.786C452.284 190.486 452.843 190.336 453.469 190.336C453.855 190.336 454.213 190.391 454.547 190.502C454.882 190.611 455.184 190.772 455.451 190.985C455.718 191.195 455.939 191.453 456.114 191.758C456.289 192.06 456.407 192.406 456.468 192.797ZM457.461 191.378V190.435H463.08V191.378H460.815V197.697H459.723V191.378H457.461ZM465.457 190.435V197.697H464.362V190.435H465.457ZM473.4 194.066C473.4 194.841 473.258 195.508 472.975 196.066C472.691 196.621 472.302 197.049 471.808 197.349C471.317 197.647 470.758 197.796 470.131 197.796C469.503 197.796 468.941 197.647 468.448 197.349C467.956 197.049 467.568 196.62 467.284 196.062C467.001 195.504 466.859 194.839 466.859 194.066C466.859 193.291 467.001 192.625 467.284 192.07C467.568 191.512 467.956 191.084 468.448 190.786C468.941 190.486 469.503 190.336 470.131 190.336C470.758 190.336 471.317 190.486 471.808 190.786C472.302 191.084 472.691 191.512 472.975 192.07C473.258 192.625 473.4 193.291 473.4 194.066ZM472.315 194.066C472.315 193.475 472.219 192.978 472.028 192.573C471.839 192.167 471.579 191.859 471.248 191.652C470.919 191.441 470.547 191.336 470.131 191.336C469.713 191.336 469.34 191.441 469.011 191.652C468.683 191.859 468.423 192.167 468.231 192.573C468.042 192.978 467.947 193.475 467.947 194.066C467.947 194.657 468.042 195.156 468.231 195.562C468.423 195.966 468.683 196.274 469.011 196.484C469.34 196.692 469.713 196.796 470.131 196.796C470.547 196.796 470.919 196.692 471.248 196.484C471.579 196.274 471.839 195.966 472.028 195.562C472.219 195.156 472.315 194.657 472.315 194.066ZM480.666 190.435V197.697H479.66L475.969 192.371H475.901V197.697H474.806V190.435H475.82L479.514 195.768H479.581V190.435H480.666Z" fill="#3A3A44"/>
<path d="M487.698 184.717H350.923C350.096 184.717 349.425 185.387 349.425 186.214V202.19C349.425 203.017 350.096 203.688 350.923 203.688H487.698C488.525 203.688 489.195 203.017 489.195 202.19V186.214C489.195 185.387 488.525 184.717 487.698 184.717Z" stroke="#2BB5E9" stroke-width="2"/>
<path d="M254.581 184.717H128.788C127.961 184.717 127.291 185.387 127.291 186.214V202.19C127.291 203.017 127.961 203.688 128.788 203.688H254.581C255.408 203.688 256.079 203.017 256.079 202.19V186.214C256.079 185.387 255.408 184.717 254.581 184.717Z" fill="white"/>
<path d="M140.464 197.796C139.977 197.796 139.542 197.712 139.159 197.545C138.779 197.376 138.477 197.144 138.255 196.846C138.035 196.546 137.917 196.198 137.901 195.803H139.014C139.028 196.018 139.1 196.205 139.23 196.364C139.362 196.52 139.535 196.64 139.748 196.725C139.96 196.81 140.197 196.853 140.457 196.853C140.743 196.853 140.996 196.803 141.216 196.704C141.438 196.604 141.612 196.467 141.737 196.289C141.862 196.11 141.925 195.903 141.925 195.669C141.925 195.425 141.862 195.211 141.737 195.027C141.614 194.84 141.433 194.693 141.194 194.587C140.958 194.481 140.672 194.428 140.336 194.428H139.723V193.534H140.336C140.606 193.534 140.842 193.486 141.046 193.389C141.251 193.292 141.412 193.157 141.528 192.985C141.644 192.81 141.701 192.605 141.701 192.371C141.701 192.147 141.651 191.952 141.549 191.786C141.449 191.618 141.308 191.487 141.123 191.392C140.941 191.298 140.726 191.251 140.478 191.251C140.242 191.251 140.021 191.295 139.815 191.382C139.612 191.467 139.446 191.59 139.319 191.75C139.191 191.909 139.123 192.099 139.113 192.322H138.053C138.065 191.929 138.181 191.584 138.4 191.286C138.623 190.988 138.916 190.755 139.28 190.588C139.644 190.42 140.048 190.336 140.492 190.336C140.958 190.336 141.36 190.427 141.697 190.609C142.038 190.788 142.3 191.029 142.485 191.329C142.671 191.629 142.764 191.958 142.761 192.315C142.764 192.721 142.65 193.066 142.421 193.35C142.194 193.634 141.892 193.824 141.513 193.921V193.977C141.995 194.05 142.369 194.242 142.633 194.552C142.9 194.862 143.033 195.246 143.031 195.704C143.033 196.104 142.922 196.462 142.697 196.779C142.475 197.095 142.172 197.345 141.786 197.527C141.401 197.706 140.96 197.796 140.464 197.796ZM145.162 197.764C144.969 197.764 144.802 197.696 144.663 197.558C144.523 197.419 144.453 197.251 144.453 197.055C144.453 196.861 144.523 196.696 144.663 196.559C144.802 196.419 144.969 196.349 145.162 196.349C145.356 196.349 145.523 196.419 145.662 196.559C145.802 196.696 145.872 196.861 145.872 197.055C145.872 197.185 145.838 197.304 145.772 197.413C145.708 197.52 145.623 197.604 145.517 197.668C145.41 197.732 145.293 197.764 145.162 197.764ZM156.724 192.797H155.618C155.576 192.56 155.496 192.352 155.38 192.173C155.265 191.993 155.123 191.84 154.955 191.715C154.787 191.59 154.599 191.495 154.391 191.431C154.186 191.367 153.967 191.336 153.736 191.336C153.317 191.336 152.942 191.441 152.612 191.652C152.283 191.862 152.023 192.17 151.832 192.577C151.643 192.984 151.548 193.48 151.548 194.066C151.548 194.657 151.643 195.156 151.832 195.562C152.023 195.969 152.284 196.276 152.615 196.484C152.946 196.692 153.318 196.796 153.732 196.796C153.961 196.796 154.178 196.765 154.384 196.704C154.592 196.64 154.78 196.547 154.948 196.424C155.116 196.301 155.258 196.151 155.373 195.973C155.492 195.794 155.573 195.589 155.618 195.356L156.724 195.36C156.665 195.717 156.551 196.046 156.38 196.346C156.213 196.644 155.996 196.902 155.731 197.119C155.469 197.334 155.169 197.501 154.831 197.619C154.493 197.737 154.124 197.796 153.725 197.796C153.096 197.796 152.536 197.647 152.044 197.349C151.553 197.049 151.165 196.62 150.881 196.062C150.6 195.504 150.46 194.839 150.46 194.066C150.46 193.291 150.601 192.625 150.885 192.07C151.168 191.512 151.556 191.084 152.048 190.786C152.54 190.486 153.098 190.336 153.725 190.336C154.11 190.336 154.469 190.391 154.802 190.502C155.138 190.611 155.439 190.772 155.706 190.985C155.973 191.195 156.195 191.453 156.37 191.758C156.545 192.06 156.663 192.406 156.724 192.797ZM164.382 194.066C164.382 194.841 164.24 195.508 163.956 196.066C163.673 196.621 163.284 197.049 162.79 197.349C162.299 197.647 161.739 197.796 161.113 197.796C160.485 197.796 159.923 197.647 159.429 197.349C158.938 197.049 158.55 196.62 158.266 196.062C157.983 195.504 157.841 194.839 157.841 194.066C157.841 193.291 157.983 192.625 158.266 192.07C158.55 191.512 158.938 191.084 159.429 190.786C159.923 190.486 160.485 190.336 161.113 190.336C161.739 190.336 162.299 190.486 162.79 190.786C163.284 191.084 163.673 191.512 163.956 192.07C164.24 192.625 164.382 193.291 164.382 194.066ZM163.297 194.066C163.297 193.475 163.202 192.978 163.01 192.573C162.821 192.167 162.561 191.859 162.23 191.652C161.902 191.441 161.529 191.336 161.113 191.336C160.695 191.336 160.321 191.441 159.993 191.652C159.664 191.859 159.404 192.167 159.213 192.573C159.024 192.978 158.929 193.475 158.929 194.066C158.929 194.657 159.024 195.156 159.213 195.562C159.404 195.966 159.664 196.274 159.993 196.484C160.321 196.692 160.695 196.796 161.113 196.796C161.529 196.796 161.902 196.692 162.23 196.484C162.561 196.274 162.821 195.966 163.01 195.562C163.202 195.156 163.297 194.657 163.297 194.066ZM171.648 190.435V197.697H170.641L166.95 192.371H166.884V197.697H165.788V190.435H166.802L170.496 195.768H170.563V190.435H171.648ZM173.286 197.697V190.435H177.789V191.378H174.382V193.591H177.466V194.531H174.382V197.697H173.286ZM180.271 190.435V197.697H179.176V190.435H180.271ZM186.82 192.729C186.752 192.514 186.659 192.322 186.544 192.151C186.43 191.979 186.295 191.832 186.136 191.711C185.978 191.589 185.797 191.495 185.594 191.431C185.393 191.367 185.172 191.336 184.931 191.336C184.522 191.336 184.153 191.441 183.825 191.652C183.496 191.862 183.236 192.17 183.045 192.577C182.856 192.981 182.761 193.476 182.761 194.062C182.761 194.651 182.857 195.149 183.048 195.555C183.24 195.962 183.502 196.27 183.835 196.481C184.169 196.691 184.548 196.796 184.973 196.796C185.368 196.796 185.712 196.716 186.005 196.555C186.301 196.394 186.529 196.168 186.689 195.874C186.852 195.579 186.934 195.232 186.934 194.832L187.218 194.885H185.14V193.981H187.994V194.807C187.994 195.417 187.864 195.946 187.604 196.395C187.346 196.842 186.989 197.188 186.533 197.431C186.079 197.674 185.559 197.796 184.973 197.796C184.316 197.796 183.74 197.645 183.243 197.342C182.749 197.04 182.364 196.61 182.088 196.055C181.811 195.497 181.673 194.835 181.673 194.069C181.673 193.49 181.753 192.971 181.914 192.509C182.075 192.048 182.3 191.657 182.591 191.336C182.884 191.012 183.228 190.765 183.622 190.595C184.02 190.422 184.453 190.336 184.924 190.336C185.316 190.336 185.681 190.394 186.019 190.51C186.359 190.626 186.662 190.79 186.927 191.003C187.194 191.215 187.415 191.468 187.59 191.761C187.765 192.052 187.883 192.374 187.944 192.729H186.82ZM194.094 190.435H195.193V195.211C195.193 195.719 195.073 196.17 194.835 196.562C194.596 196.952 194.26 197.259 193.828 197.484C193.395 197.706 192.888 197.817 192.307 197.817C191.728 197.817 191.222 197.706 190.79 197.484C190.357 197.259 190.021 196.952 189.782 196.562C189.544 196.17 189.424 195.719 189.424 195.211V190.435H190.52V195.123C190.52 195.451 190.592 195.743 190.736 195.998C190.883 196.253 191.09 196.455 191.357 196.601C191.624 196.745 191.94 196.818 192.307 196.818C192.676 196.818 192.994 196.745 193.261 196.601C193.53 196.455 193.736 196.253 193.878 195.998C194.021 195.743 194.094 195.451 194.094 195.123V190.435ZM196.825 197.697V190.435H199.414C199.976 190.435 200.443 190.532 200.814 190.726C201.187 190.92 201.466 191.188 201.65 191.531C201.835 191.871 201.927 192.265 201.927 192.711C201.927 193.156 201.834 193.547 201.647 193.885C201.463 194.221 201.184 194.482 200.81 194.669C200.439 194.856 199.973 194.949 199.41 194.949H197.449V194.006H199.311C199.665 194.006 199.954 193.955 200.176 193.853C200.4 193.752 200.565 193.604 200.668 193.41C200.772 193.216 200.825 192.984 200.825 192.711C200.825 192.437 200.771 192.2 200.665 191.999C200.561 191.798 200.397 191.644 200.172 191.538C199.95 191.429 199.658 191.375 199.297 191.375H197.921V197.697H196.825ZM200.41 194.421L202.203 197.697H200.955L199.197 194.421H200.41ZM203.3 197.697V190.435H207.852V191.378H204.395V193.591H207.615V194.531H204.395V196.754H207.895V197.697H203.3ZM212.038 197.697V190.435H214.626C215.191 190.435 215.658 190.538 216.03 190.743C216.401 190.949 216.679 191.231 216.863 191.588C217.047 191.942 217.139 192.341 217.139 192.786C217.139 193.233 217.046 193.635 216.859 193.991C216.675 194.346 216.396 194.627 216.023 194.835C215.651 195.041 215.185 195.144 214.622 195.144H212.842V194.215H214.523C214.88 194.215 215.169 194.153 215.391 194.03C215.613 193.905 215.777 193.735 215.88 193.52C215.985 193.305 216.037 193.06 216.037 192.786C216.037 192.512 215.985 192.268 215.88 192.055C215.777 191.843 215.612 191.676 215.388 191.556C215.166 191.435 214.873 191.375 214.509 191.375H213.133V197.697H212.038ZM218.464 197.697V190.435H219.559V196.754H222.849V197.697H218.464ZM228.808 190.435H229.907V195.211C229.907 195.719 229.788 196.17 229.549 196.562C229.31 196.952 228.974 197.259 228.542 197.484C228.109 197.706 227.603 197.817 227.021 197.817C226.442 197.817 225.936 197.706 225.504 197.484C225.071 197.259 224.735 196.952 224.497 196.562C224.258 196.17 224.139 195.719 224.139 195.211V190.435H225.234V195.123C225.234 195.451 225.306 195.743 225.451 195.998C225.597 196.253 225.804 196.455 226.071 196.601C226.338 196.745 226.655 196.818 227.021 196.818C227.39 196.818 227.707 196.745 227.975 196.601C228.244 196.455 228.45 196.253 228.592 195.998C228.736 195.743 228.808 195.451 228.808 195.123V190.435ZM236.453 192.729C236.385 192.514 236.293 192.322 236.177 192.151C236.063 191.979 235.927 191.832 235.769 191.711C235.611 191.589 235.43 191.495 235.227 191.431C235.026 191.367 234.805 191.336 234.564 191.336C234.155 191.336 233.786 191.441 233.458 191.652C233.129 191.862 232.869 192.17 232.678 192.577C232.489 192.981 232.394 193.476 232.394 194.062C232.394 194.651 232.49 195.149 232.681 195.555C232.872 195.962 233.135 196.27 233.468 196.481C233.801 196.691 234.181 196.796 234.606 196.796C235.001 196.796 235.345 196.716 235.638 196.555C235.933 196.394 236.162 196.168 236.322 195.874C236.485 195.579 236.567 195.232 236.567 194.832L236.85 194.885H234.773V193.981H237.627V194.807C237.627 195.417 237.497 195.946 237.237 196.395C236.979 196.842 236.622 197.188 236.166 197.431C235.712 197.674 235.192 197.796 234.606 197.796C233.949 197.796 233.373 197.645 232.876 197.342C232.382 197.04 231.997 196.61 231.72 196.055C231.444 195.497 231.306 194.835 231.306 194.069C231.306 193.49 231.386 192.971 231.547 192.509C231.707 192.048 231.933 191.657 232.224 191.336C232.517 191.012 232.861 190.765 233.255 190.595C233.653 190.422 234.087 190.336 234.557 190.336C234.949 190.336 235.314 190.394 235.652 190.51C235.992 190.626 236.295 190.79 236.56 191.003C236.827 191.215 237.048 191.468 237.223 191.761C237.398 192.052 237.516 192.374 237.577 192.729H236.453ZM240.153 190.435V197.697H239.057V190.435H240.153ZM247.649 190.435V197.697H246.642L242.951 192.371H242.884V197.697H241.788V190.435H242.802L246.497 195.768H246.564V190.435H247.649Z" fill="#3A3A44"/>
<path d="M254.581 184.717H128.788C127.961 184.717 127.291 185.387 127.291 186.214V202.19C127.291 203.017 127.961 203.688 128.788 203.688H254.581C255.408 203.688 256.079 203.017 256.079 202.19V186.214C256.079 185.387 255.408 184.717 254.581 184.717Z" stroke="#2BB5E9" stroke-width="2"/>
<path d="M344.726 219.956C344.336 220.346 344.336 220.978 344.726 221.367L351.08 227.722C351.469 228.112 352.101 228.112 352.491 227.722C352.881 227.332 352.881 226.7 352.491 226.31L346.844 220.662L352.491 215.013C352.881 214.623 352.881 213.991 352.491 213.601C352.101 213.211 351.469 213.211 351.08 213.601L344.726 219.956ZM490.9 221.367C491.289 220.978 491.289 220.346 490.9 219.956L484.546 213.601C484.156 213.211 483.524 213.211 483.134 213.601C482.744 213.991 482.744 214.623 483.134 215.013L488.782 220.662L483.134 226.31C482.744 226.7 482.744 227.332 483.134 227.722C483.524 228.112 484.156 228.112 484.546 227.722L490.9 221.367ZM345.432 221.66H490.194V219.663H345.432V221.66Z" fill="#787885"/>
<path d="M87.1497 179.931C87.5395 180.321 88.1715 180.321 88.5613 179.931L94.9149 173.577C95.3048 173.187 95.3048 172.555 94.9149 172.165C94.525 171.775 93.8931 171.775 93.5032 172.165L87.8555 177.813L82.2078 172.165C81.8179 171.775 81.186 171.775 80.7961 172.165C80.4063 172.555 80.4063 173.187 80.7961 173.577L87.1497 179.931ZM86.8571 87.366V179.225H88.8539V87.366H86.8571Z" fill="#787885"/>
<path d="M302.795 179.931C303.185 180.32 303.817 180.32 304.207 179.931L310.56 173.576C310.95 173.186 310.95 172.554 310.56 172.164C310.17 171.775 309.538 171.775 309.149 172.164L303.501 177.813L297.853 172.164C297.463 171.775 296.831 171.775 296.441 172.164C296.052 172.554 296.052 173.186 296.441 173.576L302.795 179.931ZM302.502 102.593V179.225H304.499V102.593H302.502ZM93.596 95.6034H295.514V93.6064H93.596V95.6034ZM86.8571 88.3645V88.8632H88.8538V88.3645H86.8571ZM86.8571 88.8632C86.8571 92.5855 89.8742 95.6034 93.596 95.6034V93.6064C90.9768 93.6064 88.8538 91.4827 88.8538 88.8632H86.8571ZM304.499 102.593C304.499 97.6298 300.476 93.6064 295.514 93.6064V95.6034C299.374 95.6034 302.502 98.7326 302.502 102.593H304.499Z" fill="#787885"/>
<path d="M130.079 220.455C129.689 220.845 129.689 221.477 130.079 221.867L136.433 228.221C136.822 228.611 137.454 228.611 137.844 228.221C138.234 227.831 138.234 227.199 137.844 226.809L132.197 221.161L137.844 215.512C138.234 215.123 138.234 214.491 137.844 214.101C137.454 213.711 136.822 213.711 136.433 214.101L130.079 220.455ZM259.78 221.867C260.17 221.477 260.17 220.845 259.78 220.455L253.426 214.101C253.036 213.711 252.404 213.711 252.014 214.101C251.625 214.491 251.625 215.123 252.014 215.512L257.662 221.161L252.014 226.809C251.625 227.199 251.625 227.831 252.014 228.221C252.404 228.611 253.036 228.611 253.426 228.221L259.78 221.867ZM130.785 222.159H259.074V220.162H130.785V222.159Z" fill="#787885"/>
<g filter="url(#filter0_dd_2290_131464)">
<path d="M111.317 189.21H63.3957C60.0875 189.21 57.4056 191.892 57.4056 195.201V243.127C57.4056 246.436 60.0875 249.118 63.3957 249.118H111.317C114.625 249.118 117.307 246.436 117.307 243.127V195.201C117.307 191.892 114.625 189.21 111.317 189.21Z" fill="white"/>
</g>
<path d="M81.4595 216.703C81.3437 216.587 81.2064 216.495 81.0547 216.432C80.9034 216.369 80.7407 216.337 80.577 216.337C80.4127 216.337 80.2505 216.369 80.0988 216.432C79.9475 216.495 79.8097 216.587 79.6939 216.703L77.0942 219.303C76.8601 219.537 76.7283 219.855 76.7283 220.186C76.7283 220.517 76.8601 220.835 77.0942 221.069C77.3283 221.304 77.6458 221.435 77.9768 221.435C78.3082 221.435 78.6257 221.304 78.8598 221.069L79.3734 220.553C79.5337 222.083 80.1043 223.541 81.0252 224.773C81.9457 226.005 83.1827 226.964 84.6043 227.551C86.0265 228.137 87.58 228.328 89.1015 228.103C90.623 227.878 92.0551 227.246 93.2466 226.274C93.5032 226.064 93.6659 225.762 93.6994 225.432C93.7328 225.103 93.634 224.774 93.4243 224.517C93.2152 224.261 92.9127 224.098 92.5832 224.064C92.2538 224.031 91.9243 224.13 91.6677 224.339C90.8511 225.006 89.8737 225.447 88.8329 225.618C87.7926 225.789 86.7254 225.684 85.738 225.314C84.7506 224.944 83.8775 224.322 83.2056 223.509C82.5338 222.696 82.087 221.722 81.9088 220.683L82.2936 221.069C82.5278 221.304 82.8457 221.435 83.1767 221.435C83.5077 221.435 83.8256 221.304 84.0597 221.069C84.2939 220.835 84.4251 220.517 84.4251 220.186C84.4251 219.855 84.2939 219.537 84.0597 219.303L81.4595 216.703ZM81.9382 215.245C82.051 215.364 82.1863 215.46 82.3366 215.527C82.4863 215.594 82.6486 215.631 82.8128 215.635C82.977 215.639 83.1403 215.611 83.2935 215.552C83.4467 215.493 83.587 215.404 83.7058 215.291C84.4985 214.538 85.4804 214.015 86.5472 213.778C87.6134 213.54 88.7246 213.596 89.7614 213.941C90.7987 214.286 91.7221 214.906 92.4345 215.735C93.1463 216.564 93.6195 217.571 93.8042 218.648L93.4193 218.263C93.1852 218.029 92.8673 217.897 92.5363 217.897C92.2053 217.897 91.8874 218.029 91.6533 218.263C91.4191 218.497 91.2879 218.815 91.2879 219.146C91.2879 219.477 91.4191 219.795 91.6533 220.029L94.2535 222.63C94.3693 222.745 94.5071 222.837 94.6583 222.9C94.8101 222.963 94.9723 222.995 95.136 222.995C95.3003 222.995 95.4625 222.963 95.6142 222.9C95.7655 222.837 95.9033 222.745 96.0191 222.63L98.6188 220.029C98.8534 219.795 98.9847 219.477 98.9847 219.146C98.9847 218.815 98.8534 218.497 98.6188 218.263C98.3847 218.029 98.0672 217.897 97.7363 217.897C97.4048 217.897 97.0873 218.029 96.8532 218.263L96.3376 218.779C96.1718 217.195 95.5658 215.69 94.5889 214.433C93.612 213.176 92.3027 212.217 90.8091 211.666C89.3156 211.115 87.6978 210.993 86.1383 211.313C84.5794 211.634 83.1408 212.385 81.9862 213.481C81.7461 213.709 81.6068 214.023 81.5978 214.353C81.5893 214.684 81.7106 215.005 81.9382 215.245Z" fill="#160937"/>
<path d="M110.818 219.413C110.818 232.234 100.425 242.628 87.6059 242.628C74.7865 242.628 64.3941 232.234 64.3941 219.413C64.3941 206.593 74.7865 196.199 87.6059 196.199C100.425 196.199 110.818 206.593 110.818 219.413ZM71.1305 219.413C71.1305 228.514 78.5069 235.891 87.6059 235.891C96.705 235.891 104.081 228.514 104.081 219.413C104.081 210.313 96.705 202.936 87.6059 202.936C78.5069 202.936 71.1305 210.313 71.1305 219.413Z" fill="#FFCD1A"/>
<g filter="url(#filter1_dd_2290_131464)">
<path d="M326.962 189.21H279.041C275.733 189.21 273.051 191.892 273.051 195.201V243.127C273.051 246.436 275.733 249.118 279.041 249.118H326.962C330.271 249.118 332.952 246.436 332.952 243.127V195.201C332.952 191.892 330.271 189.21 326.962 189.21Z" fill="white"/>
</g>
<path d="M326.463 219.413C326.463 232.234 316.071 242.628 303.251 242.628C290.432 242.628 280.039 232.234 280.039 219.413C280.039 206.593 290.432 196.199 303.251 196.199C316.071 196.199 326.463 206.593 326.463 219.413ZM286.776 219.413C286.776 228.514 294.152 235.891 303.251 235.891C312.35 235.891 319.727 228.514 319.727 219.413C319.727 210.313 312.35 202.936 303.251 202.936C294.152 202.936 286.776 210.313 286.776 219.413Z" fill="#FFCD1A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M295.629 228.591C295.877 228.578 296.111 228.474 296.286 228.299L298.439 226.149C299.793 227.162 301.468 227.652 303.155 227.532C304.843 227.41 306.431 226.686 307.627 225.491L310.468 222.65C310.657 222.462 310.762 222.207 310.762 221.941C310.762 221.675 310.657 221.419 310.468 221.231L309.047 219.812L312.181 216.674C312.276 216.581 312.353 216.47 312.405 216.348C312.458 216.225 312.485 216.094 312.486 215.961C312.487 215.827 312.462 215.695 312.411 215.572C312.36 215.449 312.285 215.337 312.191 215.242C312.096 215.149 311.984 215.074 311.861 215.024C311.737 214.974 311.604 214.948 311.471 214.95C311.338 214.951 311.206 214.979 311.083 215.032C310.961 215.085 310.85 215.161 310.757 215.257L307.625 218.393L304.783 215.554L307.918 212.419C308.017 212.327 308.098 212.216 308.153 212.093C308.209 211.969 308.239 211.836 308.242 211.701C308.244 211.566 308.22 211.431 308.169 211.305C308.118 211.18 308.043 211.066 307.947 210.97C307.851 210.875 307.737 210.8 307.611 210.749C307.485 210.699 307.351 210.674 307.215 210.677C307.08 210.68 306.947 210.71 306.823 210.766C306.7 210.822 306.589 210.902 306.497 211.001L303.362 214.133L301.941 212.716C301.753 212.528 301.497 212.422 301.231 212.422C300.965 212.422 300.709 212.528 300.52 212.716L297.679 215.554C296.483 216.749 295.758 218.334 295.637 220.019C295.515 221.704 296.007 223.377 297.019 224.73L294.868 226.88C294.692 227.055 294.588 227.288 294.575 227.536C294.543 228.131 295.034 228.622 295.629 228.591Z" fill="#160937"/>
<g filter="url(#filter2_dd_2290_131464)">
<path d="M559.58 189.21H511.658C508.35 189.21 505.668 191.892 505.668 195.201V243.127C505.668 246.436 508.35 249.118 511.658 249.118H559.58C562.888 249.118 565.57 246.436 565.57 243.127V195.201C565.57 191.892 562.888 189.21 559.58 189.21Z" fill="white"/>
</g>
<mask id="mask0_2290_131464" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="512" y="196" width="48" height="47">
<path d="M559.08 196.199H512.657V242.628H559.08V196.199Z" fill="white"/>
</mask>
<g mask="url(#mask0_2290_131464)">
<path fill-rule="evenodd" clip-rule="evenodd" d="M547.475 207.806H514.978C513.7 207.806 512.657 208.851 512.657 210.128V240.306C512.657 241.583 513.7 242.628 514.978 242.628H547.475C548.752 242.628 549.796 241.583 549.796 240.306V210.128C549.796 208.851 548.752 207.806 547.475 207.806ZM545.153 237.985H517.299V214.771H545.153V237.985ZM520.783 219.413H537.032C537.681 219.413 538.19 218.903 538.19 218.253C538.19 217.603 537.681 217.092 537.032 217.092H520.783C520.13 217.092 519.62 217.603 519.62 218.253C519.62 218.903 520.13 219.413 520.783 219.413ZM520.783 224.056H527.747C528.396 224.056 528.905 223.546 528.905 222.896C528.905 222.246 528.396 221.735 527.747 221.735H520.783C520.13 221.735 519.62 222.246 519.62 222.896C519.62 223.546 520.13 224.056 520.783 224.056ZM520.783 228.699H532.389C533.038 228.699 533.547 228.189 533.547 227.539C533.547 226.889 533.038 226.378 532.389 226.378H520.783C520.13 226.378 519.62 226.889 519.62 227.539C519.62 228.189 520.13 228.699 520.783 228.699ZM556.759 196.199H524.263C522.985 196.199 521.942 197.243 521.942 198.521V205.485H526.584V203.163H554.438V226.378H552.117V231.021H556.759C558.037 231.021 559.08 229.976 559.08 228.699V198.521C559.08 197.243 558.037 196.199 556.759 196.199Z" fill="#4A4B57"/>
</g>
<path d="M35.8074 272.219C35.8074 273.158 35.6316 273.962 35.2799 274.631C34.931 275.298 34.4545 275.808 33.8504 276.163C33.2491 276.518 32.567 276.695 31.8041 276.695C31.0411 276.695 30.3576 276.518 29.7535 276.163C29.1522 275.805 28.6757 275.294 28.324 274.627C27.9751 273.958 27.8007 273.155 27.8007 272.219C27.8007 271.28 27.9751 270.477 28.324 269.811C28.6757 269.141 29.1522 268.629 29.7535 268.275C30.3576 267.92 31.0411 267.743 31.8041 267.743C32.567 267.743 33.2491 267.92 33.8504 268.275C34.4545 268.629 34.931 269.141 35.2799 269.811C35.6316 270.477 35.8074 271.28 35.8074 272.219ZM34.2206 272.219C34.2206 271.558 34.117 271 33.91 270.547C33.7058 270.09 33.4221 269.745 33.0591 269.513C32.6961 269.277 32.2777 269.16 31.8041 269.16C31.3304 269.16 30.9121 269.277 30.549 269.513C30.186 269.745 29.901 270.09 29.6939 270.547C29.4897 271 29.3876 271.558 29.3876 272.219C29.3876 272.88 29.4897 273.439 29.6939 273.895C29.901 274.349 30.186 274.694 30.549 274.929C30.9121 275.162 31.3304 275.278 31.8041 275.278C32.2777 275.278 32.6961 275.162 33.0591 274.929C33.4221 274.694 33.7058 274.349 33.91 273.895C34.117 273.439 34.2206 272.88 34.2206 272.219ZM37.2795 276.576V270.04H38.7515V271.151H38.8281C38.9642 270.777 39.1897 270.484 39.5045 270.274C39.8194 270.062 40.1951 269.955 40.6319 269.955C41.0744 269.955 41.4474 270.063 41.7508 270.278C42.0572 270.491 42.2727 270.782 42.3975 271.151H42.4655C42.6102 270.788 42.8541 270.499 43.1973 270.283C43.5433 270.064 43.9532 269.955 44.4268 269.955C45.0281 269.955 45.5188 270.145 45.8989 270.526C46.2789 270.905 46.4689 271.46 46.4689 272.189V276.576H44.9246V272.427C44.9246 272.022 44.8168 271.725 44.6012 271.538C44.3857 271.348 44.1219 271.253 43.8099 271.253C43.4384 271.253 43.1477 271.369 42.9378 271.602C42.7308 271.832 42.6272 272.131 42.6272 272.5V276.576H41.1169V272.363C41.1169 272.026 41.0148 271.757 40.8106 271.555C40.6093 271.354 40.3455 271.253 40.0193 271.253C39.7981 271.253 39.5967 271.31 39.4152 271.423C39.2337 271.534 39.089 271.691 38.9812 271.895C38.8735 272.097 38.8196 272.332 38.8196 272.602V276.576H37.2795ZM49.6193 272.747V276.576H48.0793V270.04H49.5513V271.151H49.6279C49.7782 270.785 50.0177 270.494 50.3467 270.278C50.6786 270.063 51.0885 269.955 51.5762 269.955C52.0274 269.955 52.4203 270.052 52.7547 270.245C53.0922 270.438 53.3532 270.717 53.5374 271.083C53.7246 271.449 53.817 271.892 53.814 272.415V276.576H52.274V272.653C52.274 272.216 52.1607 271.874 51.9336 271.627C51.7094 271.381 51.399 271.257 51.0021 271.257C50.7326 271.257 50.4929 271.317 50.2828 271.436C50.0761 271.552 49.9129 271.721 49.7938 271.942C49.6775 272.164 49.6193 272.432 49.6193 272.747ZM57.3082 276.708C56.8939 276.708 56.521 276.634 56.1891 276.486C55.8601 276.336 55.599 276.115 55.4064 275.822C55.2162 275.53 55.1213 275.17 55.1213 274.742C55.1213 274.373 55.1892 274.068 55.3255 273.827C55.4618 273.586 55.6475 273.393 55.8831 273.248C56.1182 273.104 56.3833 272.995 56.6783 272.921C56.9763 272.845 57.2838 272.789 57.6018 272.755C57.9846 272.715 58.2951 272.68 58.5332 272.649C58.7718 272.614 58.9445 272.563 59.0524 272.496C59.1632 272.425 59.2181 272.315 59.2181 272.168V272.142C59.2181 271.822 59.1233 271.573 58.9331 271.398C58.7434 271.222 58.4693 271.134 58.1124 271.134C57.735 271.134 57.4355 271.216 57.2144 271.381C56.9962 271.545 56.8485 271.739 56.7721 271.963L55.334 271.759C55.4473 271.362 55.6345 271.03 55.8956 270.764C56.1566 270.494 56.4756 270.293 56.853 270.16C57.2299 270.023 57.6472 269.955 58.1034 269.955C58.4184 269.955 58.7319 269.992 59.0439 270.066C59.3559 270.14 59.6409 270.261 59.899 270.432C60.1571 270.599 60.3642 270.828 60.52 271.117C60.6792 271.406 60.7586 271.768 60.7586 272.202V276.576H59.278V275.678H59.2266C59.1332 275.859 59.0015 276.03 58.8312 276.188C58.664 276.345 58.4524 276.471 58.1973 276.567C57.9447 276.661 57.6487 276.708 57.3082 276.708ZM57.7081 275.576C58.0171 275.576 58.2851 275.515 58.5123 275.393C58.7389 275.268 58.9136 275.104 59.0354 274.899C59.1602 274.695 59.2226 274.473 59.2226 274.231V273.461C59.1742 273.501 59.0923 273.538 58.976 273.572C58.8622 273.606 58.7349 273.636 58.5931 273.661C58.4514 273.687 58.3106 273.71 58.1718 273.729C58.0325 273.749 57.9122 273.766 57.8099 273.781C57.5803 273.812 57.3746 273.862 57.1934 273.933C57.0117 274.004 56.8685 274.104 56.7636 274.231C56.6588 274.356 56.6059 274.518 56.6059 274.717C56.6059 275 56.7097 275.214 56.9169 275.359C57.1235 275.503 57.3876 275.576 57.7081 275.576ZM65.6181 270.04V271.231H61.8612V270.04H65.6181ZM62.7887 268.475H64.3287V274.61C64.3287 274.817 64.3601 274.976 64.4225 275.087C64.4879 275.194 64.5728 275.268 64.6776 275.308C64.7829 275.348 64.8993 275.368 65.0265 275.368C65.1229 275.368 65.2112 275.36 65.2906 275.346C65.3725 275.332 65.4349 275.319 65.4778 275.308L65.7374 276.512C65.655 276.54 65.5372 276.571 65.384 276.606C65.2337 276.64 65.0495 276.66 64.8309 276.665C64.445 276.677 64.0976 276.618 63.7886 276.491C63.4796 276.36 63.234 276.159 63.0528 275.886C62.8741 275.614 62.7862 275.274 62.7887 274.865V268.475ZM68.8343 276.708C68.4205 276.708 68.0471 276.634 67.7156 276.486C67.3867 276.336 67.1256 276.115 66.9329 275.822C66.7427 275.53 66.6474 275.17 66.6474 274.742C66.6474 274.373 66.7158 274.068 66.852 273.827C66.9878 273.586 67.1735 273.393 67.4091 273.248C67.6447 273.104 67.9098 272.995 68.2048 272.921C68.5023 272.845 68.8103 272.789 69.1278 272.755C69.5107 272.715 69.8212 272.68 70.0598 272.649C70.2979 272.614 70.4711 272.563 70.5784 272.496C70.6892 272.425 70.7446 272.315 70.7446 272.168V272.142C70.7446 271.822 70.6498 271.573 70.4596 271.398C70.2694 271.222 69.9959 271.134 69.6385 271.134C69.2611 271.134 68.9621 271.216 68.7409 271.381C68.5223 271.545 68.375 271.739 68.2982 271.963L66.8605 271.759C66.9738 271.362 67.161 271.03 67.4221 270.764C67.6827 270.494 68.0021 270.293 68.379 270.16C68.7564 270.023 69.1732 269.955 69.63 269.955C69.945 269.955 70.2579 269.992 70.5699 270.066C70.8819 270.14 71.1669 270.261 71.4255 270.432C71.6836 270.599 71.8903 270.828 72.0465 271.117C72.2052 271.406 72.2846 271.768 72.2846 272.202V276.576H70.804V275.678H70.7531C70.6593 275.859 70.5275 276.03 70.3573 276.188C70.19 276.345 69.9789 276.471 69.7233 276.567C69.4712 276.661 69.1747 276.708 68.8343 276.708ZM69.2341 275.576C69.5436 275.576 69.8117 275.515 70.0383 275.393C70.2654 275.268 70.4396 275.104 70.5614 274.899C70.6862 274.695 70.7486 274.473 70.7486 274.231V273.461C70.7007 273.501 70.6183 273.538 70.502 273.572C70.3887 273.606 70.2609 273.636 70.1192 273.661C69.9774 273.687 69.8371 273.71 69.6979 273.729C69.5591 273.749 69.4383 273.766 69.3365 273.781C69.1068 273.812 68.9012 273.862 68.7195 273.933C68.5378 274.004 68.3945 274.104 68.2897 274.231C68.1848 274.356 68.1324 274.518 68.1324 274.717C68.1324 275 68.2358 275.214 68.4429 275.359C68.6501 275.503 68.9136 275.576 69.2341 275.576ZM81.7041 270.257C81.6642 269.886 81.497 269.596 81.2019 269.389C80.9099 269.182 80.5295 269.079 80.0618 269.079C79.7328 269.079 79.4503 269.128 79.2152 269.228C78.9796 269.327 78.7994 269.462 78.6746 269.632C78.5498 269.802 78.4864 269.996 78.4834 270.215C78.4834 270.396 78.5243 270.554 78.6067 270.687C78.6921 270.821 78.8069 270.934 78.9511 271.027C79.0959 271.118 79.2561 271.195 79.4324 271.257C79.6081 271.32 79.7853 271.372 79.964 271.415L80.7806 271.619C81.1096 271.695 81.4261 271.799 81.7296 271.929C82.0356 272.06 82.3096 272.224 82.5507 272.423C82.7943 272.622 82.9875 272.862 83.1293 273.142C83.271 273.423 83.3419 273.752 83.3419 274.129C83.3419 274.64 83.2116 275.09 82.9506 275.478C82.6895 275.864 82.3121 276.166 81.8189 276.384C81.3282 276.6 80.7337 276.708 80.0364 276.708C79.3585 276.708 78.7699 276.603 78.2708 276.393C77.7746 276.183 77.3857 275.876 77.1052 275.474C76.8271 275.071 76.6769 274.58 76.6539 274.002H78.2069C78.2293 274.305 78.3232 274.557 78.4874 274.759C78.6521 274.96 78.8663 275.111 79.1298 275.21C79.3969 275.309 79.6944 275.359 80.0234 275.359C80.3668 275.359 80.6673 275.308 80.9254 275.206C81.1865 275.101 81.3906 274.956 81.5379 274.772C81.6856 274.584 81.7605 274.366 81.7635 274.117C81.7605 273.889 81.6941 273.702 81.5633 273.555C81.4331 273.405 81.2504 273.28 81.0147 273.18C80.7821 273.078 80.5101 272.987 80.1981 272.908L79.2067 272.653C78.4889 272.469 77.9218 272.189 77.505 271.815C77.0907 271.437 76.8835 270.937 76.8835 270.313C76.8835 269.799 77.0228 269.35 77.3009 268.964C77.5814 268.578 77.9628 268.279 78.445 268.066C78.9272 267.851 79.4733 267.743 80.0833 267.743C80.7013 267.743 81.2429 267.851 81.7081 268.066C82.1763 268.279 82.5432 268.575 82.8103 268.956C83.0769 269.332 83.2141 269.767 83.2226 270.257H81.7041ZM85.6861 279.027C85.4764 279.027 85.2817 279.01 85.103 278.976C84.9273 278.944 84.787 278.907 84.6822 278.865L85.0396 277.665C85.2633 277.731 85.4634 277.761 85.6391 277.758C85.8153 277.756 85.9696 277.701 86.1029 277.593C86.2392 277.488 86.354 277.312 86.4478 277.065L86.5796 276.712L84.21 270.04H85.8433L87.3493 274.976H87.4177L88.9277 270.04H90.566L87.9493 277.367C87.8275 277.713 87.6658 278.01 87.4646 278.256C87.263 278.506 87.0164 278.696 86.7243 278.827C86.4348 278.96 86.0889 279.027 85.6861 279.027ZM93.2197 272.747V276.576H91.6797V270.04H93.1513V271.151H93.2282C93.3784 270.785 93.618 270.494 93.947 270.278C94.2789 270.063 94.6888 269.955 95.1765 269.955C95.6277 269.955 96.0206 270.052 96.355 270.245C96.6925 270.438 96.9535 270.717 97.1377 271.083C97.3249 271.449 97.4173 271.892 97.4143 272.415V276.576H95.8743V272.653C95.8743 272.216 95.761 271.874 95.5339 271.627C95.3097 271.381 94.9992 271.257 94.6024 271.257C94.3328 271.257 94.0932 271.317 93.8831 271.436C93.6764 271.552 93.5132 271.721 93.3939 271.942C93.2776 272.164 93.2197 272.432 93.2197 272.747ZM101.878 276.704C101.226 276.704 100.666 276.56 100.198 276.274C99.733 275.987 99.374 275.591 99.1215 275.087C98.8719 274.579 98.7471 273.995 98.7471 273.334C98.7471 272.67 98.8749 272.084 99.13 271.576C99.385 271.066 99.7454 270.669 100.211 270.385C100.678 270.099 101.231 269.955 101.87 269.955C102.4 269.955 102.87 270.053 103.278 270.249C103.689 270.442 104.017 270.715 104.261 271.07C104.505 271.422 104.644 271.833 104.678 272.304H103.206C103.146 271.989 103.004 271.727 102.78 271.517C102.559 271.304 102.263 271.198 101.891 271.198C101.576 271.198 101.3 271.283 101.061 271.453C100.823 271.62 100.637 271.862 100.504 272.177C100.374 272.491 100.309 272.868 100.309 273.308C100.309 273.754 100.374 274.137 100.504 274.457C100.634 274.775 100.818 275.02 101.053 275.193C101.291 275.363 101.57 275.448 101.891 275.448C102.118 275.448 102.321 275.406 102.499 275.321C102.681 275.233 102.833 275.107 102.955 274.942C103.076 274.778 103.16 274.577 103.206 274.342H104.678C104.641 274.805 104.505 275.214 104.27 275.572C104.034 275.926 103.713 276.204 103.308 276.406C102.902 276.604 102.426 276.704 101.878 276.704ZM109.078 276.576V267.862H114.745V269.185H110.656V271.551H114.451V272.874H110.656V275.252H114.779V276.576H109.078ZM117.875 272.747V276.576H116.335V270.04H117.807V271.151H117.884C118.034 270.785 118.273 270.494 118.602 270.278C118.934 270.063 119.344 269.955 119.832 269.955C120.283 269.955 120.676 270.052 121.01 270.245C121.348 270.438 121.609 270.717 121.793 271.083C121.98 271.449 122.073 271.892 122.07 272.415V276.576H120.53V272.653C120.53 272.216 120.416 271.874 120.189 271.627C119.965 271.381 119.655 271.257 119.258 271.257C118.988 271.257 118.749 271.317 118.539 271.436C118.331 271.552 118.169 271.721 118.049 271.942C117.933 272.164 117.875 272.432 117.875 272.747ZM126.525 279.163C125.972 279.163 125.497 279.087 125.1 278.937C124.703 278.79 124.384 278.591 124.143 278.342C123.902 278.092 123.734 277.815 123.641 277.512L125.028 277.176C125.09 277.303 125.181 277.43 125.3 277.554C125.419 277.682 125.579 277.787 125.781 277.869C125.985 277.954 126.241 277.997 126.551 277.997C126.988 277.997 127.349 277.891 127.636 277.678C127.922 277.468 128.065 277.122 128.065 276.64V275.402H127.988C127.909 275.56 127.793 275.724 127.64 275.891C127.489 276.058 127.29 276.198 127.04 276.312C126.793 276.426 126.482 276.482 126.108 276.482C125.606 276.482 125.151 276.365 124.743 276.129C124.337 275.891 124.014 275.536 123.772 275.065C123.534 274.592 123.415 273.999 123.415 273.287C123.415 272.569 123.534 271.963 123.772 271.47C124.014 270.973 124.338 270.598 124.747 270.342C125.155 270.084 125.61 269.955 126.113 269.955C126.495 269.955 126.81 270.02 127.057 270.151C127.307 270.278 127.505 270.433 127.653 270.615C127.8 270.794 127.912 270.962 127.988 271.121H128.074V270.04H129.592V276.682C129.592 277.241 129.459 277.704 129.193 278.069C128.926 278.435 128.562 278.709 128.099 278.89C127.637 279.072 127.112 279.163 126.525 279.163ZM126.538 275.274C126.864 275.274 127.142 275.194 127.372 275.036C127.602 274.877 127.776 274.648 127.895 274.351C128.014 274.053 128.074 273.695 128.074 273.278C128.074 272.867 128.014 272.507 127.895 272.198C127.779 271.888 127.606 271.649 127.376 271.479C127.149 271.305 126.87 271.219 126.538 271.219C126.195 271.219 125.908 271.308 125.679 271.487C125.449 271.666 125.276 271.911 125.16 272.223C125.043 272.533 124.985 272.884 124.985 273.278C124.985 273.678 125.043 274.029 125.16 274.329C125.278 274.627 125.453 274.859 125.683 275.027C125.915 275.191 126.2 275.274 126.538 275.274ZM131.219 276.576V270.04H132.759V276.576H131.219ZM131.993 269.113C131.749 269.113 131.539 269.032 131.363 268.87C131.188 268.706 131.1 268.509 131.1 268.279C131.1 268.046 131.188 267.849 131.363 267.687C131.539 267.523 131.749 267.441 131.993 267.441C132.24 267.441 132.45 267.523 132.623 267.687C132.799 267.849 132.886 268.046 132.886 268.279C132.886 268.509 132.799 268.706 132.623 268.87C132.45 269.032 132.24 269.113 131.993 269.113ZM135.93 272.747V276.576H134.39V270.04H135.863V271.151H135.939C136.09 270.785 136.329 270.494 136.658 270.278C136.99 270.063 137.4 269.955 137.888 269.955C138.338 269.955 138.731 270.052 139.066 270.245C139.404 270.438 139.665 270.717 139.849 271.083C140.036 271.449 140.129 271.892 140.126 272.415V276.576H138.586V272.653C138.586 272.216 138.472 271.874 138.245 271.627C138.021 271.381 137.71 271.257 137.313 271.257C137.044 271.257 136.804 271.317 136.594 271.436C136.387 271.552 136.224 271.721 136.105 271.942C135.989 272.164 135.93 272.432 135.93 272.747ZM144.632 276.704C143.977 276.704 143.411 276.567 142.934 276.295C142.461 276.02 142.096 275.631 141.841 275.129C141.586 274.624 141.458 274.03 141.458 273.346C141.458 272.674 141.586 272.084 141.841 271.576C142.099 271.066 142.459 270.669 142.922 270.385C143.384 270.099 143.927 269.955 144.551 269.955C144.954 269.955 145.334 270.02 145.691 270.151C146.051 270.278 146.369 270.477 146.644 270.747C146.922 271.016 147.14 271.359 147.299 271.776C147.458 272.191 147.538 272.684 147.538 273.257V273.729H142.182V272.691H146.061C146.059 272.396 145.995 272.134 145.87 271.904C145.745 271.671 145.571 271.489 145.346 271.355C145.125 271.222 144.867 271.155 144.572 271.155C144.258 271.155 143.981 271.231 143.743 271.385C143.504 271.535 143.319 271.734 143.185 271.98C143.055 272.224 142.988 272.493 142.985 272.785V273.691C142.985 274.071 143.055 274.397 143.194 274.67C143.333 274.939 143.527 275.146 143.777 275.291C144.027 275.433 144.319 275.503 144.653 275.503C144.877 275.503 145.08 275.472 145.262 275.41C145.443 275.345 145.601 275.25 145.734 275.125C145.867 275 145.968 274.845 146.036 274.661L147.474 274.823C147.383 275.203 147.21 275.535 146.955 275.818C146.702 276.099 146.379 276.318 145.985 276.473C145.591 276.627 145.14 276.704 144.632 276.704Z" fill="#3A3A44"/>
<path d="M269.286 272.219C269.286 273.158 269.11 273.962 268.758 274.631C268.409 275.298 267.933 275.808 267.329 276.163C266.727 276.518 266.045 276.695 265.282 276.695C264.519 276.695 263.836 276.518 263.232 276.163C262.631 275.805 262.154 275.294 261.802 274.627C261.453 273.958 261.279 273.155 261.279 272.219C261.279 271.28 261.453 270.477 261.802 269.811C262.154 269.141 262.631 268.629 263.232 268.275C263.836 267.92 264.519 267.743 265.282 267.743C266.045 267.743 266.727 267.92 267.329 268.275C267.933 268.629 268.409 269.141 268.758 269.811C269.11 270.477 269.286 271.28 269.286 272.219ZM267.699 272.219C267.699 271.558 267.595 271 267.388 270.547C267.184 270.09 266.9 269.745 266.537 269.513C266.174 269.277 265.756 269.16 265.282 269.16C264.808 269.16 264.39 269.277 264.027 269.513C263.664 269.745 263.379 270.09 263.172 270.547C262.968 271 262.866 271.558 262.866 272.219C262.866 272.88 262.968 273.439 263.172 273.895C263.379 274.349 263.664 274.694 264.027 274.929C264.39 275.162 264.808 275.278 265.282 275.278C265.756 275.278 266.174 275.162 266.537 274.929C266.9 274.694 267.184 274.349 267.388 273.895C267.595 273.439 267.699 272.88 267.699 272.219ZM270.758 276.576V270.04H272.23V271.151H272.306C272.442 270.777 272.668 270.484 272.982 270.274C273.297 270.062 273.673 269.955 274.11 269.955C274.552 269.955 274.925 270.063 275.229 270.278C275.535 270.491 275.751 270.782 275.876 271.151H275.944C276.088 270.788 276.332 270.499 276.675 270.283C277.021 270.064 277.431 269.955 277.905 269.955C278.506 269.955 278.997 270.145 279.377 270.526C279.757 270.905 279.947 271.46 279.947 272.189V276.576H278.403V272.427C278.403 272.022 278.295 271.725 278.08 271.538C277.864 271.348 277.6 271.253 277.288 271.253C276.917 271.253 276.626 271.369 276.416 271.602C276.209 271.832 276.105 272.131 276.105 272.5V276.576H274.595V272.363C274.595 272.026 274.493 271.757 274.289 271.555C274.087 271.354 273.824 271.253 273.498 271.253C273.276 271.253 273.075 271.31 272.893 271.423C272.712 271.534 272.567 271.691 272.459 271.895C272.352 272.097 272.298 272.332 272.298 272.602V276.576H270.758ZM283.097 272.747V276.576H281.557V270.04H283.029V271.151H283.106C283.256 270.785 283.496 270.494 283.825 270.278C284.157 270.063 284.566 269.955 285.055 269.955C285.505 269.955 285.898 270.052 286.233 270.245C286.571 270.438 286.831 270.717 287.016 271.083C287.203 271.449 287.295 271.892 287.292 272.415V276.576H285.752V272.653C285.752 272.216 285.639 271.874 285.412 271.627C285.188 271.381 284.877 271.257 284.48 271.257C284.211 271.257 283.971 271.317 283.761 271.436C283.554 271.552 283.391 271.721 283.272 271.942C283.156 272.164 283.097 272.432 283.097 272.747ZM290.786 276.708C290.372 276.708 289.999 276.634 289.668 276.486C289.339 276.336 289.078 276.115 288.884 275.822C288.695 275.53 288.599 275.17 288.599 274.742C288.599 274.373 288.668 274.068 288.804 273.827C288.94 273.586 289.125 273.393 289.361 273.248C289.597 273.104 289.862 272.995 290.157 272.921C290.454 272.845 290.762 272.789 291.08 272.755C291.463 272.715 291.773 272.68 292.012 272.649C292.25 272.614 292.423 272.563 292.53 272.496C292.641 272.425 292.697 272.315 292.697 272.168V272.142C292.697 271.822 292.601 271.573 292.412 271.398C292.221 271.222 291.948 271.134 291.59 271.134C291.213 271.134 290.914 271.216 290.693 271.381C290.474 271.545 290.327 271.739 290.25 271.963L288.812 271.759C288.926 271.362 289.113 271.03 289.374 270.764C289.635 270.494 289.954 270.293 290.331 270.16C290.708 270.023 291.125 269.955 291.582 269.955C291.897 269.955 292.21 269.992 292.522 270.066C292.834 270.14 293.119 270.261 293.377 270.432C293.636 270.599 293.842 270.828 293.998 271.117C294.157 271.406 294.237 271.768 294.237 272.202V276.576H292.756V275.678H292.705C292.611 275.859 292.479 276.03 292.309 276.188C292.142 276.345 291.931 276.471 291.675 276.567C291.423 276.661 291.127 276.708 290.786 276.708ZM291.186 275.576C291.496 275.576 291.764 275.515 291.99 275.393C292.217 275.268 292.392 275.104 292.513 274.899C292.638 274.695 292.701 274.473 292.701 274.231V273.461C292.653 273.501 292.57 273.538 292.454 273.572C292.341 273.606 292.213 273.636 292.071 273.661C291.929 273.687 291.789 273.71 291.65 273.729C291.511 273.749 291.39 273.766 291.288 273.781C291.059 273.812 290.853 273.862 290.671 273.933C290.49 274.004 290.346 274.104 290.242 274.231C290.137 274.356 290.084 274.518 290.084 274.717C290.084 275 290.188 275.214 290.395 275.359C290.602 275.503 290.866 275.576 291.186 275.576ZM299.096 270.04V271.231H295.34V270.04H299.096ZM296.267 268.475H297.807V274.61C297.807 274.817 297.838 274.976 297.901 275.087C297.966 275.194 298.051 275.268 298.156 275.308C298.261 275.348 298.377 275.368 298.505 275.368C298.601 275.368 298.689 275.36 298.769 275.346C298.851 275.332 298.913 275.319 298.956 275.308L299.215 276.512C299.133 276.54 299.015 276.571 298.862 276.606C298.712 276.64 298.527 276.66 298.309 276.665C297.923 276.677 297.576 276.618 297.267 276.491C296.958 276.36 296.712 276.159 296.531 275.886C296.352 275.614 296.264 275.274 296.267 274.865V268.475ZM302.313 276.708C301.898 276.708 301.526 276.634 301.194 276.486C300.865 276.336 300.604 276.115 300.411 275.822C300.221 275.53 300.126 275.17 300.126 274.742C300.126 274.373 300.194 274.068 300.33 273.827C300.466 273.586 300.652 273.393 300.887 273.248C301.123 273.104 301.388 272.995 301.683 272.921C301.981 272.845 302.288 272.789 302.606 272.755C302.989 272.715 303.3 272.68 303.538 272.649C303.776 272.614 303.949 272.563 304.057 272.496C304.167 272.425 304.223 272.315 304.223 272.168V272.142C304.223 271.822 304.128 271.573 303.938 271.398C303.748 271.222 303.474 271.134 303.116 271.134C302.74 271.134 302.44 271.216 302.219 271.381C302.001 271.545 301.853 271.739 301.777 271.963L300.339 271.759C300.452 271.362 300.639 271.03 300.9 270.764C301.161 270.494 301.48 270.293 301.858 270.16C302.234 270.023 302.652 269.955 303.108 269.955C303.423 269.955 303.736 269.992 304.048 270.066C304.36 270.14 304.645 270.261 304.903 270.432C305.162 270.599 305.369 270.828 305.524 271.117C305.683 271.406 305.763 271.768 305.763 272.202V276.576H304.283V275.678H304.231C304.138 275.859 304.006 276.03 303.836 276.188C303.668 276.345 303.457 276.471 303.202 276.567C302.949 276.661 302.653 276.708 302.313 276.708ZM302.713 275.576C303.022 275.576 303.29 275.515 303.516 275.393C303.743 275.268 303.918 275.104 304.04 274.899C304.165 274.695 304.227 274.473 304.227 274.231V273.461C304.179 273.501 304.096 273.538 303.98 273.572C303.867 273.606 303.739 273.636 303.597 273.661C303.455 273.687 303.315 273.71 303.176 273.729C303.037 273.749 302.917 273.766 302.814 273.781C302.585 273.812 302.379 273.862 302.197 273.933C302.016 274.004 301.873 274.104 301.768 274.231C301.663 274.356 301.61 274.518 301.61 274.717C301.61 275 301.714 275.214 301.921 275.359C302.128 275.503 302.392 275.576 302.713 275.576ZM310.447 276.576V267.862H313.715C314.384 267.862 314.945 267.986 315.399 268.236C315.855 268.486 316.2 268.829 316.433 269.266C316.668 269.7 316.786 270.194 316.786 270.747C316.786 271.305 316.668 271.802 316.433 272.236C316.197 272.67 315.85 273.012 315.391 273.261C314.931 273.508 314.365 273.631 313.693 273.631H311.528V272.334H313.48C313.872 272.334 314.192 272.265 314.442 272.13C314.691 271.993 314.876 271.806 314.995 271.568C315.117 271.329 315.178 271.056 315.178 270.747C315.178 270.438 315.117 270.165 314.995 269.93C314.876 269.694 314.69 269.511 314.438 269.381C314.188 269.248 313.866 269.181 313.472 269.181H312.025V276.576H310.447ZM319.677 267.862V276.576H318.137V267.862H319.677ZM325.474 273.827V270.04H327.014V276.576H325.521V275.414H325.452C325.305 275.78 325.062 276.08 324.725 276.312C324.39 276.544 323.978 276.661 323.487 276.661C323.059 276.661 322.68 276.566 322.351 276.376C322.025 276.183 321.769 275.903 321.585 275.537C321.401 275.169 321.309 274.724 321.309 274.201V270.04H322.848V273.963C322.848 274.378 322.962 274.707 323.189 274.95C323.416 275.194 323.714 275.316 324.082 275.316C324.309 275.316 324.529 275.261 324.742 275.15C324.955 275.04 325.129 274.875 325.265 274.657C325.404 274.436 325.474 274.159 325.474 273.827ZM331.487 279.163C330.934 279.163 330.459 279.087 330.062 278.937C329.665 278.79 329.346 278.591 329.105 278.342C328.864 278.092 328.696 277.815 328.603 277.512L329.99 277.176C330.052 277.303 330.143 277.43 330.262 277.554C330.381 277.682 330.541 277.787 330.743 277.869C330.947 277.954 331.204 277.997 331.513 277.997C331.95 277.997 332.311 277.891 332.597 277.678C332.884 277.468 333.027 277.122 333.027 276.64V275.402H332.951C332.871 275.56 332.755 275.724 332.602 275.891C332.452 276.058 332.252 276.198 332.002 276.312C331.755 276.426 331.445 276.482 331.07 276.482C330.568 276.482 330.113 276.365 329.705 276.129C329.299 275.891 328.976 275.536 328.735 275.065C328.496 274.592 328.377 273.999 328.377 273.287C328.377 272.569 328.496 271.963 328.735 271.47C328.976 270.973 329.3 270.598 329.709 270.342C330.117 270.084 330.572 269.955 331.074 269.955C331.457 269.955 331.772 270.02 332.019 270.151C332.269 270.278 332.467 270.433 332.614 270.615C332.762 270.794 332.874 270.962 332.951 271.121H333.036V270.04H334.555V276.682C334.555 277.241 334.421 277.704 334.155 278.069C333.888 278.435 333.523 278.709 333.061 278.89C332.599 279.072 332.074 279.163 331.487 279.163ZM331.5 275.274C331.826 275.274 332.104 275.194 332.334 275.036C332.564 274.877 332.738 274.648 332.857 274.351C332.976 274.053 333.036 273.695 333.036 273.278C333.036 272.867 332.976 272.507 332.857 272.198C332.741 271.888 332.568 271.649 332.338 271.479C332.111 271.305 331.832 271.219 331.5 271.219C331.157 271.219 330.87 271.308 330.641 271.487C330.411 271.666 330.238 271.911 330.122 272.223C330.005 272.533 329.947 272.884 329.947 273.278C329.947 273.678 330.005 274.029 330.122 274.329C330.241 274.627 330.415 274.859 330.645 275.027C330.877 275.191 331.162 275.274 331.5 275.274ZM336.181 276.576V270.04H337.721V276.576H336.181ZM336.955 269.113C336.711 269.113 336.502 269.032 336.325 268.87C336.15 268.706 336.062 268.509 336.062 268.279C336.062 268.046 336.15 267.849 336.325 267.687C336.502 267.523 336.711 267.441 336.955 267.441C337.202 267.441 337.412 267.523 337.585 267.687C337.76 267.849 337.848 268.046 337.848 268.279C337.848 268.509 337.76 268.706 337.585 268.87C337.412 269.032 337.202 269.113 336.955 269.113ZM340.893 272.747V276.576H339.352V270.04H340.824V271.151H340.901C341.052 270.785 341.291 270.494 341.62 270.278C341.952 270.063 342.362 269.955 342.85 269.955C343.3 269.955 343.693 270.052 344.028 270.245C344.366 270.438 344.627 270.717 344.811 271.083C344.998 271.449 345.09 271.892 345.087 272.415V276.576H343.547V272.653C343.547 272.216 343.434 271.874 343.207 271.627C342.983 271.381 342.672 271.257 342.275 271.257C342.006 271.257 341.766 271.317 341.556 271.436C341.349 271.552 341.186 271.721 341.067 271.942C340.951 272.164 340.893 272.432 340.893 272.747Z" fill="#3A3A44"/>
<path d="M513.815 276.576H512.128L515.198 267.862H517.144L520.214 276.576H518.532L516.206 269.649H516.136L513.815 276.576ZM513.87 273.159H518.462V274.427H513.87V273.159ZM521.343 279.027V270.04H522.86V271.121H522.945C523.025 270.962 523.14 270.794 523.284 270.615C523.429 270.433 523.624 270.278 523.868 270.151C524.118 270.02 524.432 269.955 524.817 269.955C525.321 269.955 525.775 270.084 526.18 270.342C526.589 270.598 526.913 270.976 527.148 271.479C527.393 271.978 527.512 272.59 527.512 273.317C527.512 274.034 527.393 274.644 527.158 275.146C526.923 275.648 526.604 276.031 526.2 276.295C525.79 276.559 525.331 276.691 524.817 276.691C524.442 276.691 524.133 276.628 523.888 276.503C523.639 276.379 523.444 276.228 523.289 276.053C523.145 275.874 523.03 275.705 522.945 275.546H522.885V279.027H521.343ZM522.855 273.308C522.855 273.731 522.915 274.101 523.03 274.419C523.155 274.736 523.329 274.984 523.554 275.163C523.784 275.339 524.063 275.427 524.388 275.427C524.732 275.427 525.017 275.336 525.246 275.154C525.476 274.97 525.645 274.719 525.765 274.402C525.88 274.081 525.94 273.717 525.94 273.308C525.94 272.902 525.885 272.542 525.765 272.227C525.65 271.912 525.481 271.666 525.246 271.487C525.017 271.308 524.732 271.219 524.388 271.219C524.058 271.219 523.779 271.305 523.549 271.479C523.319 271.651 523.145 271.894 523.03 272.206C522.91 272.518 522.855 272.885 522.855 273.308ZM528.88 279.027V270.04H530.393V271.121H530.483C530.562 270.962 530.672 270.794 530.817 270.615C530.962 270.433 531.161 270.278 531.406 270.151C531.651 270.02 531.965 269.955 532.349 269.955C532.854 269.955 533.308 270.084 533.717 270.342C534.127 270.598 534.446 270.976 534.686 271.479C534.925 271.978 535.045 272.59 535.045 273.317C535.045 274.034 534.93 274.644 534.696 275.146C534.461 275.648 534.137 276.031 533.732 276.295C533.328 276.559 532.869 276.691 532.354 276.691C531.98 276.691 531.671 276.628 531.421 276.503C531.176 276.379 530.977 276.228 530.827 276.053C530.677 275.874 530.562 275.705 530.483 275.546H530.418V279.027H528.88ZM530.388 273.308C530.388 273.731 530.448 274.101 530.567 274.419C530.687 274.736 530.862 274.984 531.092 275.163C531.321 275.339 531.601 275.427 531.925 275.427C532.265 275.427 532.549 275.336 532.779 275.154C533.008 274.97 533.183 274.719 533.298 274.402C533.418 274.081 533.478 273.717 533.478 273.308C533.478 272.902 533.418 272.542 533.303 272.227C533.188 271.912 533.013 271.666 532.784 271.487C532.554 271.308 532.27 271.219 531.925 271.219C531.596 271.219 531.316 271.305 531.087 271.479C530.857 271.651 530.682 271.894 530.562 272.206C530.448 272.518 530.388 272.885 530.388 273.308ZM540.621 276.576H538.939L542.004 267.862H543.95L547.025 276.576H545.338L543.012 269.649H542.942L540.621 276.576ZM540.676 273.159H545.273V274.427H540.676V273.159ZM548.218 276.576V267.862H551.488C552.157 267.862 552.716 267.986 553.17 268.236C553.629 268.486 553.974 268.829 554.204 269.266C554.438 269.7 554.558 270.194 554.558 270.747C554.558 271.305 554.438 271.802 554.204 272.236C553.969 272.67 553.624 273.012 553.165 273.261C552.701 273.508 552.137 273.631 551.463 273.631H549.302V272.334H551.253C551.643 272.334 551.962 272.265 552.212 272.13C552.461 271.993 552.646 271.806 552.766 271.568C552.891 271.329 552.951 271.056 552.951 270.747C552.951 270.438 552.891 270.165 552.766 269.93C552.646 269.694 552.461 269.511 552.212 269.381C551.962 269.248 551.638 269.181 551.243 269.181H549.796V276.576H548.218ZM557.553 267.862V276.576H555.976V267.862H557.553Z" fill="#3A3A44"/>
<path d="M147.258 119.317H27.954C27.127 119.317 26.4565 119.988 26.4565 120.815V136.79C26.4565 137.617 27.127 138.288 27.954 138.288H147.258C148.085 138.288 148.755 137.617 148.755 136.79V120.815C148.755 119.988 148.085 119.317 147.258 119.317Z" fill="white"/>
<path d="M40.6478 125.036V132.297H39.5488V126.135H39.5063L37.7691 127.269V126.22L39.5807 125.036H40.6478ZM44.2472 132.364C44.0534 132.364 43.8868 132.296 43.7473 132.159C43.6079 132.02 43.5382 131.851 43.5382 131.655C43.5382 131.461 43.6079 131.296 43.7473 131.159C43.8868 131.02 44.0534 130.95 44.2472 130.95C44.441 130.95 44.6077 131.02 44.7471 131.159C44.8866 131.296 44.9563 131.461 44.9563 131.655C44.9563 131.785 44.9232 131.905 44.857 132.014C44.7932 132.12 44.7081 132.205 44.6017 132.269C44.4954 132.333 44.3772 132.364 44.2472 132.364ZM50.8738 125.036V132.297H49.7785V125.036H50.8738ZM58.3695 125.036V132.297H57.3626L53.6722 126.971H53.6048V132.297H52.5091V125.036H53.5235L57.2174 130.368H57.2848V125.036H58.3695ZM63.9678 126.943C63.9298 126.607 63.7741 126.347 63.4996 126.163C63.2255 125.976 62.8806 125.883 62.4648 125.883C62.1667 125.883 61.9092 125.93 61.6915 126.025C61.4744 126.117 61.3052 126.244 61.1849 126.408C61.0666 126.568 61.0077 126.752 61.0077 126.957C61.0077 127.13 61.0476 127.279 61.128 127.404C61.2108 127.529 61.3181 127.635 61.4504 127.72C61.5852 127.802 61.7295 127.872 61.8832 127.929C62.037 127.983 62.1842 128.028 62.3265 128.064L63.0353 128.248C63.2669 128.305 63.5045 128.382 63.7481 128.478C63.9912 128.575 64.2169 128.703 64.425 128.861C64.6332 129.02 64.8009 129.216 64.9287 129.45C65.0585 129.684 65.1234 129.964 65.1234 130.29C65.1234 130.702 65.0171 131.067 64.8044 131.386C64.5943 131.705 64.2883 131.957 63.8864 132.141C63.4866 132.326 63.0034 132.417 62.4363 132.417C61.8927 132.417 61.4225 132.332 61.0251 132.159C60.6283 131.986 60.3173 131.741 60.0927 131.425C59.868 131.106 59.7442 130.728 59.7203 130.29H60.8195C60.8409 130.553 60.9258 130.771 61.0745 130.946C61.2263 131.119 61.4185 131.248 61.6526 131.333C61.8892 131.415 62.1478 131.457 62.4293 131.457C62.7388 131.457 63.0139 131.408 63.255 131.312C63.4986 131.212 63.6902 131.075 63.8295 130.9C63.9688 130.723 64.0387 130.516 64.0387 130.28C64.0387 130.065 63.9773 129.888 63.8545 129.751C63.7337 129.614 63.5694 129.501 63.3613 129.411C63.1561 129.321 62.923 129.242 62.6629 129.173L61.8053 128.939C61.2238 128.781 60.7626 128.548 60.4226 128.241C60.0847 127.933 59.9154 127.527 59.9154 127.021C59.9154 126.603 60.0288 126.237 60.2559 125.925C60.4825 125.613 60.79 125.371 61.1774 125.198C61.5652 125.024 62.0025 124.936 62.4892 124.936C62.9809 124.936 63.4147 125.023 63.7906 125.195C64.1685 125.368 64.4665 125.605 64.6841 125.908C64.9012 126.208 65.0146 126.553 65.024 126.943H63.9678ZM66.1143 125.979V125.036H71.734V125.979H69.4682V132.297H68.3765V125.979H66.1143ZM72.7708 132.297H71.6082L74.2209 125.036H75.4863L78.0995 132.297H76.9365L74.8838 126.355H74.8269L72.7708 132.297ZM72.966 129.453H76.7383V130.376H72.966V129.453ZM79.1878 132.297V125.036H80.2834V131.354H83.5735V132.297H79.1878ZM84.8629 132.297V125.036H85.9586V131.354H89.2487V132.297H84.8629ZM93.2202 125.036H94.55L96.8612 130.68H96.9465L99.2582 125.036H100.588V132.297H99.5453V127.042H99.4779L97.3364 132.287H96.4713L94.3298 127.039H94.2625V132.297H93.2202V125.036ZM102.833 132.297H101.671L104.283 125.036H105.549L108.162 132.297H106.999L104.946 126.355H104.89L102.833 132.297ZM103.029 129.453H106.801V130.376H103.029V129.453ZM110.346 125.036V132.297H109.251V125.036H110.346ZM117.842 125.036V132.297H116.835L113.144 126.971H113.077V132.297H111.981V125.036H112.995L116.69 130.368H116.757V125.036H117.842ZM122.775 132.297H121.612L124.225 125.036H125.491L128.104 132.297H126.941L124.888 126.355H124.832L122.775 132.297ZM122.97 129.453H126.743V130.376H122.97V129.453ZM129.192 132.297V125.036H131.78C132.345 125.036 132.813 125.139 133.184 125.344C133.555 125.549 133.833 125.831 134.018 126.188C134.202 126.542 134.294 126.942 134.294 127.386C134.294 127.833 134.201 128.235 134.014 128.592C133.829 128.946 133.55 129.228 133.177 129.435C132.806 129.641 132.339 129.744 131.777 129.744H129.997V128.815H131.677C132.034 128.815 132.324 128.754 132.546 128.631C132.768 128.505 132.931 128.335 133.035 128.12C133.14 127.905 133.191 127.661 133.191 127.386C133.191 127.112 133.14 126.868 133.035 126.656C132.931 126.443 132.767 126.276 132.542 126.156C132.32 126.035 132.027 125.975 131.663 125.975H130.288V132.297H129.192ZM135.618 132.297V125.036H138.206C138.771 125.036 139.239 125.139 139.61 125.344C139.981 125.549 140.259 125.831 140.443 126.188C140.628 126.542 140.72 126.942 140.72 127.386C140.72 127.833 140.627 128.235 140.44 128.592C140.255 128.946 139.976 129.228 139.603 129.435C139.232 129.641 138.765 129.744 138.203 129.744H136.423V128.815H138.103C138.46 128.815 138.75 128.754 138.972 128.631C139.194 128.505 139.357 128.335 139.461 128.12C139.565 127.905 139.617 127.661 139.617 127.386C139.617 127.112 139.565 126.868 139.461 126.656C139.357 126.443 139.193 126.276 138.968 126.156C138.746 126.035 138.453 125.975 138.089 125.975H136.714V132.297H135.618Z" fill="#3A3A44"/>
<path d="M147.258 119.317H27.954C27.127 119.317 26.4565 119.988 26.4565 120.815V136.79C26.4565 137.617 27.127 138.288 27.954 138.288H147.258C148.085 138.288 148.755 137.617 148.755 136.79V120.815C148.755 119.988 148.085 119.317 147.258 119.317Z" stroke="#2BB5E9" stroke-width="2"/>
<path d="M368.893 119.317H238.608C237.78 119.317 237.11 119.988 237.11 120.815V136.79C237.11 137.617 237.78 138.288 238.608 138.288H368.893C369.72 138.288 370.391 137.617 370.391 136.79V120.815C370.391 119.988 369.72 119.317 368.893 119.317Z" fill="white"/>
<path d="M247.819 132.297V131.503L250.276 128.957C250.539 128.681 250.755 128.438 250.925 128.23C251.098 128.02 251.227 127.82 251.312 127.631C251.397 127.442 251.439 127.241 251.439 127.028C251.439 126.787 251.382 126.579 251.269 126.404C251.156 126.227 251.001 126.091 250.804 125.996C250.608 125.899 250.388 125.851 250.142 125.851C249.882 125.851 249.655 125.904 249.461 126.011C249.267 126.117 249.118 126.267 249.014 126.461C248.91 126.655 248.858 126.881 248.858 127.141H247.812C247.812 126.7 247.914 126.313 248.117 125.982C248.321 125.651 248.6 125.395 248.954 125.213C249.308 125.028 249.712 124.936 250.163 124.936C250.619 124.936 251.021 125.027 251.369 125.209C251.718 125.389 251.991 125.635 252.187 125.947C252.383 126.256 252.482 126.606 252.482 126.996C252.482 127.266 252.431 127.529 252.329 127.787C252.23 128.045 252.056 128.332 251.808 128.649C251.56 128.963 251.215 129.345 250.773 129.794L249.33 131.304V131.358H252.599V132.297H247.819ZM254.897 132.364C254.703 132.364 254.536 132.296 254.397 132.159C254.257 132.02 254.188 131.851 254.188 131.655C254.188 131.461 254.257 131.296 254.397 131.159C254.536 131.02 254.703 130.95 254.897 130.95C255.091 130.95 255.257 131.02 255.397 131.159C255.536 131.296 255.606 131.461 255.606 131.655C255.606 131.785 255.573 131.905 255.507 132.014C255.443 132.12 255.358 132.205 255.251 132.269C255.145 132.333 255.027 132.364 254.897 132.364ZM261.524 125.036V132.297H260.428V125.036H261.524ZM269.02 125.036V132.297H268.013L264.322 126.971H264.254V132.297H263.159V125.036H264.173L267.867 130.368H267.934V125.036H269.02ZM274.617 126.943C274.579 126.607 274.424 126.347 274.15 126.163C273.875 125.976 273.53 125.883 273.114 125.883C272.816 125.883 272.559 125.93 272.342 126.025C272.124 126.117 271.955 126.244 271.834 126.408C271.716 126.568 271.657 126.752 271.657 126.957C271.657 127.13 271.697 127.279 271.777 127.404C271.86 127.529 271.968 127.635 272.1 127.72C272.235 127.802 272.379 127.872 272.533 127.929C272.686 127.983 272.834 128.028 272.976 128.064L273.685 128.248C273.916 128.305 274.154 128.382 274.398 128.478C274.641 128.575 274.867 128.703 275.075 128.861C275.283 129.02 275.45 129.216 275.578 129.45C275.708 129.684 275.773 129.964 275.773 130.29C275.773 130.702 275.667 131.067 275.454 131.386C275.244 131.705 274.938 131.957 274.536 132.141C274.137 132.326 273.653 132.417 273.086 132.417C272.542 132.417 272.072 132.332 271.675 132.159C271.278 131.986 270.967 131.741 270.742 131.425C270.518 131.106 270.394 130.728 270.37 130.29H271.469C271.49 130.553 271.575 130.771 271.725 130.946C271.876 131.119 272.068 131.248 272.302 131.333C272.539 131.415 272.797 131.457 273.079 131.457C273.388 131.457 273.664 131.408 273.905 131.312C274.148 131.212 274.34 131.075 274.479 130.9C274.619 130.723 274.688 130.516 274.688 130.28C274.688 130.065 274.627 129.888 274.504 129.751C274.383 129.614 274.219 129.501 274.011 129.411C273.806 129.321 273.573 129.242 273.313 129.173L272.455 128.939C271.873 128.781 271.413 128.548 271.072 128.241C270.734 127.933 270.565 127.527 270.565 127.021C270.565 126.603 270.679 126.237 270.905 125.925C271.133 125.613 271.44 125.371 271.827 125.198C272.215 125.024 272.652 124.936 273.139 124.936C273.63 124.936 274.064 125.023 274.44 125.195C274.818 125.368 275.116 125.605 275.334 125.908C275.551 126.208 275.665 126.553 275.674 126.943H274.617ZM276.764 125.979V125.036H282.384V125.979H280.118V132.297H279.026V125.979H276.764ZM283.42 132.297H282.258L284.87 125.036H286.136L288.749 132.297H287.586L285.533 126.355H285.477L283.42 132.297ZM283.615 129.453H287.388V130.376H283.615V129.453ZM289.838 132.297V125.036H290.933V131.354H294.223V132.297H289.838ZM295.513 132.297V125.036H296.608V131.354H299.898V132.297H295.513ZM303.87 132.297V125.036H306.458C307.023 125.036 307.491 125.139 307.862 125.344C308.233 125.549 308.511 125.831 308.695 126.188C308.879 126.542 308.972 126.942 308.972 127.386C308.972 127.833 308.878 128.235 308.692 128.592C308.507 128.946 308.229 129.228 307.855 129.435C307.484 129.641 307.017 129.744 306.454 129.744H304.675V128.815H306.355C306.712 128.815 307.002 128.754 307.224 128.631C307.446 128.505 307.609 128.335 307.713 128.12C307.817 127.905 307.869 127.661 307.869 127.386C307.869 127.112 307.817 126.868 307.713 126.656C307.609 126.443 307.445 126.276 307.22 126.156C306.998 126.035 306.705 125.975 306.341 125.975H304.965V132.297H303.87ZM310.296 132.297V125.036H311.391V131.354H314.681V132.297H310.296ZM320.64 125.036H321.739V129.811C321.739 130.32 321.62 130.77 321.381 131.162C321.143 131.553 320.807 131.86 320.375 132.084C319.942 132.307 319.435 132.417 318.854 132.417C318.274 132.417 317.769 132.307 317.336 132.084C316.904 131.86 316.568 131.553 316.329 131.162C316.091 130.77 315.971 130.32 315.971 129.811V125.036H317.066V129.723C317.066 130.052 317.139 130.344 317.283 130.599C317.429 130.854 317.636 131.055 317.903 131.201C318.17 131.346 318.487 131.418 318.854 131.418C319.222 131.418 319.54 131.346 319.807 131.201C320.077 131.055 320.282 130.854 320.424 130.599C320.568 130.344 320.64 130.052 320.64 129.723V125.036ZM328.286 127.33C328.217 127.115 328.125 126.922 328.009 126.752C327.896 126.579 327.76 126.433 327.602 126.312C327.443 126.189 327.262 126.096 327.059 126.032C326.858 125.968 326.637 125.936 326.396 125.936C325.987 125.936 325.618 126.041 325.29 126.252C324.961 126.462 324.701 126.771 324.51 127.177C324.321 127.581 324.226 128.077 324.226 128.663C324.226 129.251 324.322 129.749 324.514 130.155C324.705 130.562 324.967 130.871 325.3 131.081C325.634 131.291 326.013 131.396 326.439 131.396C326.833 131.396 327.177 131.316 327.47 131.155C327.766 130.995 327.994 130.768 328.155 130.474C328.317 130.179 328.399 129.832 328.399 129.432L328.683 129.485H326.605V128.581H329.459V129.408C329.459 130.017 329.329 130.547 329.069 130.996C328.812 131.442 328.455 131.788 327.998 132.031C327.545 132.275 327.025 132.396 326.439 132.396C325.782 132.396 325.205 132.245 324.708 131.943C324.215 131.64 323.829 131.211 323.553 130.656C323.276 130.097 323.138 129.435 323.138 128.67C323.138 128.091 323.218 127.571 323.379 127.11C323.54 126.649 323.765 126.257 324.056 125.936C324.35 125.612 324.693 125.365 325.088 125.195C325.485 125.023 325.919 124.936 326.389 124.936C326.781 124.936 327.146 124.994 327.484 125.11C327.825 125.226 328.127 125.39 328.392 125.603C328.659 125.816 328.88 126.069 329.055 126.362C329.23 126.652 329.348 126.975 329.41 127.33H328.286ZM331.985 125.036V132.297H330.89V125.036H331.985ZM339.481 125.036V132.297H338.474L334.783 126.971H334.716V132.297H333.621V125.036H334.635L338.329 130.368H338.396V125.036H339.481ZM344.414 132.297H343.251L345.865 125.036H347.13L349.743 132.297H348.58L346.528 126.355H346.471L344.414 132.297ZM344.61 129.453H348.381V130.376H344.61V129.453ZM350.831 132.297V125.036H353.42C353.984 125.036 354.452 125.139 354.823 125.344C355.195 125.549 355.472 125.831 355.656 126.188C355.841 126.542 355.933 126.942 355.933 127.386C355.933 127.833 355.84 128.235 355.653 128.592C355.469 128.946 355.19 129.228 354.816 129.435C354.445 129.641 353.979 129.744 353.416 129.744H351.636V128.815H353.317C353.674 128.815 353.963 128.754 354.185 128.631C354.408 128.505 354.571 128.335 354.675 128.12C354.778 127.905 354.831 127.661 354.831 127.386C354.831 127.112 354.778 126.868 354.675 126.656C354.571 126.443 354.407 126.276 354.182 126.156C353.96 126.035 353.667 125.975 353.302 125.975H351.927V132.297H350.831ZM357.257 132.297V125.036H359.846C360.41 125.036 360.878 125.139 361.249 125.344C361.621 125.549 361.898 125.831 362.082 126.188C362.267 126.542 362.359 126.942 362.359 127.386C362.359 127.833 362.266 128.235 362.079 128.592C361.895 128.946 361.616 129.228 361.242 129.435C360.871 129.641 360.405 129.744 359.842 129.744H358.062V128.815H359.743C360.1 128.815 360.389 128.754 360.611 128.631C360.833 128.505 360.997 128.335 361.101 128.12C361.204 127.905 361.256 127.661 361.256 127.386C361.256 127.112 361.204 126.868 361.101 126.656C360.997 126.443 360.832 126.276 360.608 126.156C360.386 126.035 360.093 125.975 359.728 125.975H358.353V132.297H357.257Z" fill="#3A3A44"/>
<path d="M368.893 119.317H238.608C237.78 119.317 237.11 119.988 237.11 120.815V136.79C237.11 137.617 237.78 138.288 238.608 138.288H368.893C369.72 138.288 370.391 137.617 370.391 136.79V120.815C370.391 119.988 369.72 119.317 368.893 119.317Z" stroke="#2BB5E9" stroke-width="2"/>
<path d="M109.32 20.9678H65.3924C60.9814 20.9678 57.4056 24.5441 57.4056 28.9556V72.8882C57.4056 77.2997 60.9814 80.8759 65.3924 80.8759H109.32C113.731 80.8759 117.307 77.2997 117.307 72.8882V28.9556C117.307 24.5441 113.731 20.9678 109.32 20.9678Z" fill="#FAFAFA"/>
<mask id="mask1_2290_131464" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="64" y="28" width="46" height="46">
<path d="M109.819 28.4564H64.8932V73.3874H109.819V28.4564Z" fill="white"/>
</mask>
<g mask="url(#mask1_2290_131464)">
<path d="M87.3563 57.9421L87.3538 57.9496M87.3538 57.9496C90.1627 57.9466 92.3266 59.3465 92.3266 62.1547C92.3266 62.1547 92.3266 64.1806 92.3266 66.3667C92.3266 69.1749 92.4769 70.7445 95.2848 70.7445C98.5728 70.748 99.2487 70.7445 99.2487 70.7445C102.057 70.7445 103.536 69.1749 103.536 66.3667V49.9449M87.3538 57.9496C84.5454 57.9526 82.3845 59.3395 82.3875 62.1517C82.3875 62.1517 82.3865 64.1751 82.386 66.3667C82.386 69.1724 82.2377 70.7445 79.4283 70.7445C76.619 70.7445 75.4644 70.7445 75.4644 70.7445C72.6565 70.7445 71.2598 69.1749 71.2598 66.3667V49.9449" stroke="#65676C" stroke-width="4"/>
<path d="M74.2528 50.8675C77.8824 50.8675 80.8046 47.745 80.8046 43.8665C80.8046 47.8072 83.0429 50.9219 87.3733 50.9219C91.7036 50.9219 93.9155 46.2073 93.908 43.8665C93.908 47.3427 96.4608 50.9179 100.46 50.9179C104.054 50.9179 106.716 47.9095 106.989 44.451C107.018 44.0664 106.933 43.6857 106.779 43.3314C105.408 40.1536 103.503 35.5135 102.482 33.0144C102.05 31.9556 101.022 31.2646 99.8782 31.2646H74.8154C73.6813 31.2646 72.6585 31.947 72.2232 32.9943L68.1319 42.831C67.8474 43.5146 67.6742 44.252 67.7835 44.9843C68.2812 48.3278 70.9792 50.8675 74.2528 50.8675Z" stroke="#65676C" stroke-width="4"/>
</g>
<path d="M131.151 44.795H133.727L137.175 53.2139H137.311L140.761 44.795H143.336V56.4135H141.316V48.4314H141.208L137.998 56.3795H136.489L133.278 48.4144H133.17V56.4135H131.151V44.795ZM148.107 56.5892C147.555 56.5892 147.058 56.4909 146.616 56.2942C146.177 56.094 145.829 55.7989 145.572 55.4095C145.318 55.0196 145.192 54.5394 145.192 53.9682C145.192 53.4765 145.283 53.0701 145.464 52.7486C145.646 52.4271 145.894 52.17 146.208 51.9773C146.521 51.7841 146.875 51.6388 147.268 51.5405C147.665 51.4381 148.075 51.3642 148.499 51.3188C149.009 51.2659 149.424 51.2189 149.741 51.177C150.059 51.1316 150.29 51.0637 150.434 50.9728C150.581 50.8785 150.655 50.7327 150.655 50.536V50.502C150.655 50.0747 150.528 49.7438 150.274 49.5093C150.021 49.2748 149.656 49.1576 149.18 49.1576C148.677 49.1576 148.278 49.2672 147.983 49.4866C147.692 49.706 147.495 49.9649 147.393 50.2639L145.476 49.9913C145.627 49.462 145.877 49.0195 146.225 48.664C146.572 48.3047 146.998 48.0362 147.501 47.8584C148.004 47.6769 148.56 47.5861 149.168 47.5861C149.588 47.5861 150.006 47.6353 150.422 47.7336C150.838 47.8319 151.218 47.9946 151.562 48.2215C151.906 48.4447 152.182 48.7491 152.39 49.1349C152.602 49.5207 152.708 50.0028 152.708 50.5814V56.4135H150.734V55.2163H150.666C150.541 55.4584 150.365 55.6856 150.139 55.8973C149.915 56.1055 149.633 56.2737 149.293 56.402C148.957 56.5268 148.562 56.5892 148.107 56.5892ZM148.641 55.0805C149.053 55.0805 149.41 54.9992 149.713 54.8364C150.015 54.6702 150.248 54.4505 150.411 54.1784C150.577 53.9058 150.66 53.6093 150.66 53.2878V52.2608C150.596 52.3138 150.487 52.3627 150.331 52.4081C150.18 52.4536 150.01 52.4935 149.821 52.5274C149.632 52.5614 149.445 52.5918 149.259 52.6183C149.074 52.6448 148.913 52.6672 148.777 52.6862C148.471 52.7276 148.197 52.796 147.955 52.8904C147.713 52.9852 147.521 53.1175 147.382 53.2878C147.242 53.454 147.171 53.6697 147.171 53.9343C147.171 54.3127 147.31 54.5983 147.586 54.791C147.862 54.9837 148.214 55.0805 148.641 55.0805ZM154.837 56.4135V47.6996H156.828V49.1519H156.918C157.077 48.6489 157.35 48.2612 157.736 47.9889C158.125 47.7128 158.569 47.5748 159.068 47.5748C159.182 47.5748 159.308 47.5804 159.448 47.5918C159.592 47.5993 159.711 47.6126 159.806 47.6315V49.5207C159.719 49.4904 159.581 49.4639 159.392 49.4412C159.207 49.4148 159.027 49.4015 158.853 49.4015C158.478 49.4015 158.142 49.4828 157.843 49.6455C157.548 49.8043 157.316 50.0258 157.146 50.3093C156.975 50.5929 156.89 50.9199 156.89 51.2908V56.4135H154.837ZM163.106 53.6792L163.1 51.2H163.429L166.561 47.6996H168.96L165.108 51.9883H164.683L163.106 53.6792ZM161.234 56.4135V44.795H163.287V56.4135H161.234ZM166.702 56.4135L163.866 52.4481L165.25 51.0013L169.158 56.4135H166.702ZM173.891 56.5837C173.017 56.5837 172.263 56.402 171.627 56.0391C170.996 55.6721 170.51 55.1539 170.17 54.4844C169.829 53.8115 169.659 53.0192 169.659 52.1076C169.659 51.2115 169.829 50.4247 170.17 49.7476C170.514 49.0668 170.994 48.5373 171.61 48.1591C172.227 47.7771 172.951 47.5861 173.783 47.5861C174.32 47.5861 174.827 47.6731 175.303 47.8471C175.783 48.0173 176.207 48.282 176.574 48.6413C176.944 49.0006 177.236 49.4582 177.448 50.0143C177.659 50.5664 177.765 51.2244 177.765 51.9883V52.6183H170.623V51.2339H175.797C175.793 50.8405 175.708 50.4906 175.541 50.1845C175.375 49.8743 175.142 49.6303 174.844 49.4526C174.549 49.2748 174.204 49.1859 173.811 49.1859C173.392 49.1859 173.023 49.2881 172.705 49.4923C172.387 49.6927 172.14 49.9574 171.962 50.2864C171.788 50.6119 171.699 50.9693 171.696 51.3587V52.5669C171.696 53.0741 171.788 53.5089 171.974 53.8719C172.159 54.2313 172.418 54.5074 172.75 54.7001C173.083 54.8893 173.473 54.9837 173.919 54.9837C174.218 54.9837 174.489 54.9422 174.73 54.8589C174.972 54.772 175.182 54.6452 175.36 54.4789C175.538 54.3127 175.672 54.1065 175.763 53.8604L177.68 54.0761C177.559 54.5828 177.328 55.0256 176.988 55.4035C176.651 55.778 176.22 56.0695 175.695 56.2772C175.169 56.4814 174.568 56.5837 173.891 56.5837ZM183.917 47.6996V49.2881H178.908V47.6996H183.917ZM180.145 45.6118H182.198V53.7925C182.198 54.0686 182.24 54.2803 182.323 54.428C182.41 54.5718 182.523 54.6702 182.664 54.7231C182.803 54.776 182.958 54.8025 183.128 54.8025C183.257 54.8025 183.374 54.793 183.48 54.774C183.59 54.755 183.673 54.7381 183.73 54.7231L184.076 56.3286C183.966 56.3661 183.809 56.408 183.605 56.4534C183.404 56.4984 183.159 56.5248 182.868 56.5328C182.353 56.5478 181.89 56.4704 181.478 56.3002C181.066 56.1259 180.738 55.8573 180.497 55.4944C180.258 55.1314 180.141 54.6776 180.145 54.133V45.6118ZM185.698 59.681V47.6996H187.718V49.1405H187.837C187.942 48.9288 188.092 48.7037 188.285 48.4654C188.478 48.2234 188.739 48.0173 189.068 47.8471C189.396 47.6731 189.816 47.5861 190.327 47.5861C191 47.5861 191.607 47.7582 192.148 48.1024C192.693 48.4428 193.123 48.9477 193.441 49.6171C193.763 50.2829 193.924 51.0996 193.924 52.0676C193.924 53.0247 193.766 53.8379 193.452 54.5074C193.139 55.1769 192.712 55.6871 192.17 56.0391C191.63 56.391 191.017 56.5667 190.332 56.5667C189.833 56.5667 189.419 56.4834 189.091 56.3171C188.762 56.1504 188.496 55.9502 188.296 55.7156C188.1 55.4774 187.946 55.2523 187.837 55.0406H187.752V59.681H185.698ZM187.712 52.0567C187.712 52.6203 187.791 53.1135 187.95 53.5374C188.113 53.9607 188.345 54.2917 188.648 54.5299C188.954 54.7645 189.325 54.8818 189.76 54.8818C190.214 54.8818 190.594 54.7605 190.9 54.5189C191.206 54.2728 191.437 53.9383 191.592 53.5144C191.751 53.0871 191.83 52.6013 191.83 52.0567C191.83 51.5155 191.753 51.0352 191.597 50.6154C191.443 50.1955 191.212 49.8667 190.906 49.6284C190.599 49.3902 190.217 49.271 189.76 49.271C189.321 49.271 188.949 49.3864 188.642 49.6171C188.336 49.8478 188.103 50.1711 187.944 50.5874C187.79 51.0033 187.712 51.493 187.712 52.0567ZM197.799 44.795V56.4135H195.746V44.795H197.799ZM202.482 56.5892C201.93 56.5892 201.432 56.4909 200.99 56.2942C200.551 56.094 200.203 55.7989 199.946 55.4095C199.693 55.0196 199.566 54.5394 199.566 53.9682C199.566 53.4765 199.657 53.0701 199.838 52.7486C200.02 52.4271 200.268 52.17 200.582 51.9773C200.896 51.7841 201.249 51.6388 201.642 51.5405C202.039 51.4381 202.45 51.3642 202.873 51.3188C203.384 51.2659 203.798 51.2189 204.115 51.177C204.433 51.1316 204.664 51.0637 204.808 50.9728C204.955 50.8785 205.029 50.7327 205.029 50.536V50.502C205.029 50.0747 204.902 49.7438 204.649 49.5093C204.395 49.2748 204.03 49.1576 203.554 49.1576C203.051 49.1576 202.652 49.2672 202.357 49.4866C202.066 49.706 201.869 49.9649 201.767 50.2639L199.85 49.9913C200.001 49.462 200.251 49.0195 200.599 48.664C200.947 48.3047 201.372 48.0362 201.875 47.8584C202.378 47.6769 202.934 47.5861 203.543 47.5861C203.963 47.5861 204.38 47.6353 204.796 47.7336C205.212 47.8319 205.592 47.9946 205.936 48.2215C206.281 48.4447 206.557 48.7491 206.764 49.1349C206.977 49.5207 207.082 50.0028 207.082 50.5814V56.4135H205.108V55.2163H205.04C204.915 55.4584 204.739 55.6856 204.513 55.8973C204.29 56.1055 204.008 56.2737 203.668 56.402C203.331 56.5268 202.936 56.5892 202.482 56.5892ZM203.015 55.0805C203.427 55.0805 203.785 54.9992 204.087 54.8364C204.39 54.6702 204.622 54.4505 204.785 54.1784C204.951 53.9058 205.034 53.6093 205.034 53.2878V52.2608C204.97 52.3138 204.861 52.3627 204.705 52.4081C204.554 52.4536 204.384 52.4935 204.195 52.5274C204.006 52.5614 203.819 52.5918 203.634 52.6183C203.448 52.6448 203.287 52.6672 203.151 52.6862C202.845 52.7276 202.571 52.796 202.329 52.8904C202.087 52.9852 201.895 53.1175 201.756 53.2878C201.616 53.454 201.546 53.6697 201.546 53.9343C201.546 54.3127 201.684 54.5983 201.96 54.791C202.236 54.9837 202.588 55.0805 203.015 55.0805ZM213.012 56.5837C212.142 56.5837 211.395 56.3925 210.771 56.0106C210.151 55.6287 209.672 55.101 209.336 54.428C209.003 53.7511 208.837 52.9718 208.837 52.0906C208.837 51.2055 209.007 50.4247 209.347 49.7476C209.688 49.0668 210.168 48.5373 210.788 48.1591C211.412 47.7771 212.149 47.5861 213 47.5861C213.708 47.5861 214.333 47.7166 214.878 47.9776C215.426 48.2347 215.863 48.5997 216.188 49.0725C216.513 49.5414 216.699 50.0897 216.744 50.7177H214.781C214.702 50.2979 214.513 49.9479 214.214 49.6681C213.919 49.3845 213.524 49.2427 213.029 49.2427C212.609 49.2427 212.24 49.3561 211.922 49.5831C211.604 49.8062 211.357 50.1276 211.179 50.5475C211.005 50.9673 210.918 51.4701 210.918 52.0567C210.918 52.6503 211.005 53.161 211.179 53.5883C211.353 54.0117 211.597 54.3392 211.911 54.5698C212.228 54.7965 212.601 54.9103 213.029 54.9103C213.331 54.9103 213.601 54.8534 213.84 54.74C214.082 54.6227 214.284 54.4545 214.447 54.2348C214.609 54.0157 214.721 53.7491 214.781 53.435H216.744C216.695 54.0516 216.513 54.5983 216.199 55.0745C215.885 55.5473 215.458 55.9182 214.918 56.1863C214.376 56.4514 213.741 56.5837 213.012 56.5837ZM222.351 56.5837C221.478 56.5837 220.723 56.402 220.088 56.0391C219.457 55.6721 218.97 55.1539 218.63 54.4844C218.29 53.8115 218.12 53.0192 218.12 52.1076C218.12 51.2115 218.29 50.4247 218.63 49.7476C218.974 49.0668 219.455 48.5373 220.071 48.1591C220.688 47.7771 221.411 47.5861 222.243 47.5861C222.781 47.5861 223.287 47.6731 223.764 47.8471C224.244 48.0173 224.667 48.282 225.034 48.6413C225.405 49.0006 225.696 49.4582 225.908 50.0143C226.12 50.5664 226.225 51.2244 226.225 51.9883V52.6183H219.084V51.2339H224.257C224.254 50.8405 224.168 50.4906 224.002 50.1845C223.836 49.8743 223.603 49.6303 223.304 49.4526C223.009 49.2748 222.665 49.1859 222.272 49.1859C221.852 49.1859 221.483 49.2881 221.166 49.4923C220.848 49.6927 220.6 49.9574 220.422 50.2864C220.249 50.6119 220.16 50.9693 220.156 51.3587V52.5669C220.156 53.0741 220.249 53.5089 220.434 53.8719C220.619 54.2313 220.878 54.5074 221.211 54.7001C221.544 54.8893 221.933 54.9837 222.38 54.9837C222.678 54.9837 222.949 54.9422 223.191 54.8589C223.433 54.772 223.643 54.6452 223.82 54.4789C223.998 54.3127 224.132 54.1065 224.223 53.8604L226.141 54.0761C226.02 54.5828 225.789 55.0256 225.449 55.4035C225.112 55.778 224.681 56.0695 224.155 56.2772C223.63 56.4814 223.028 56.5837 222.351 56.5837Z" fill="#65676C"/>
<defs>
<filter id="filter0_dd_2290_131464" x="49.4056" y="185.21" width="75.9015" height="75.9081" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
<feFlood flood-opacity="0" result="BackgroundImageFix"/>
<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
<feOffset dy="4"/>
<feGaussianBlur stdDeviation="4"/>
<feColorMatrix type="matrix" values="0 0 0 0 0.352941 0 0 0 0 0.356863 0 0 0 0 0.415686 0 0 0 0.2 0"/>
<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2290_131464"/>
<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
<feOffset dy="2"/>
<feGaussianBlur stdDeviation="2"/>
<feColorMatrix type="matrix" values="0 0 0 0 0.227451 0 0 0 0 0.227451 0 0 0 0 0.266667 0 0 0 0.2 0"/>
<feBlend mode="normal" in2="effect1_dropShadow_2290_131464" result="effect2_dropShadow_2290_131464"/>
<feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_2290_131464" result="shape"/>
</filter>
<filter id="filter1_dd_2290_131464" x="265.051" y="185.21" width="75.9015" height="75.9081" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
<feFlood flood-opacity="0" result="BackgroundImageFix"/>
<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
<feOffset dy="4"/>
<feGaussianBlur stdDeviation="4"/>
<feColorMatrix type="matrix" values="0 0 0 0 0.352941 0 0 0 0 0.356863 0 0 0 0 0.415686 0 0 0 0.2 0"/>
<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2290_131464"/>
<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
<feOffset dy="2"/>
<feGaussianBlur stdDeviation="2"/>
<feColorMatrix type="matrix" values="0 0 0 0 0.227451 0 0 0 0 0.227451 0 0 0 0 0.266667 0 0 0 0.2 0"/>
<feBlend mode="normal" in2="effect1_dropShadow_2290_131464" result="effect2_dropShadow_2290_131464"/>
<feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_2290_131464" result="shape"/>
</filter>
<filter id="filter2_dd_2290_131464" x="497.668" y="185.21" width="75.9015" height="75.9081" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
<feFlood flood-opacity="0" result="BackgroundImageFix"/>
<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
<feOffset dy="4"/>
<feGaussianBlur stdDeviation="4"/>
<feColorMatrix type="matrix" values="0 0 0 0 0.352941 0 0 0 0 0.356863 0 0 0 0 0.415686 0 0 0 0.2 0"/>
<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2290_131464"/>
<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
<feOffset dy="2"/>
<feGaussianBlur stdDeviation="2"/>
<feColorMatrix type="matrix" values="0 0 0 0 0.227451 0 0 0 0 0.227451 0 0 0 0 0.266667 0 0 0 0.2 0"/>
<feBlend mode="normal" in2="effect1_dropShadow_2290_131464" result="effect2_dropShadow_2290_131464"/>
<feBlend mode="normal" in="SourceGraphic" in2="effect2_dropShadow_2290_131464" result="shape"/>
</filter>
</defs>
</svg>
"""

st.header("Plugin configuration")
plugin_info = json.loads(get_active_session().sql(f"select PLUGIN.OMNATA_PLUGIN_INFO()").collect()[0][0])
manifest = plugin_info['manifest']
developer_id = manifest['developer_id']
# TODO: this should really come from the Omnata engine rather than reimplement the same logic
plugin_id = manifest['plugin_id']
plugin_fqn = f"{developer_id}__{plugin_id}".upper()
plugin_application_role_name = f"PLUGIN_{plugin_fqn}"

if 'installed_sync_engine_answer' not in st.session_state:
    st.session_state['installed_sync_engine_answer'] = None

def handle_installed_sync_engine(answer:str):
    st.session_state['installed_sync_engine_answer'] = answer

installed_sync_engine_answer = st.session_state['installed_sync_engine_answer']
# first, check for an existing registration
registrations = get_active_session().sql(f"select APPLICATION_NAME,EXTERNAL_ACCESS_INTEGRATIONS from DATA.OMNATA_REGISTRATION").collect()
if len(registrations)==0:
    st.write(f"Welcome to the Omnata {manifest['plugin_name']} Plugin.")
    if installed_sync_engine_answer is None:
        st.markdown("**Have you installed the Omnata Sync Engine?**")
        col1,col2 = st.columns([1,3])
        with col1:
            button1_col,button2_col2 = st.columns([1,1])
            st.button(label="Yes",
                    key="handle_installed_sync_engine_yes",
                    on_click=handle_installed_sync_engine,
                    kwargs={"answer":"Yes"})
            st.button(label="No",
                    key="handle_installed_sync_engine_no",
                    on_click=handle_installed_sync_engine,
                    kwargs={"answer":"No"})
            st.stop()
    elif installed_sync_engine_answer=="Yes":
        omnata_app_name = st.text_input(label="Omnata App name",
            value="OMNATA_SYNC_ENGINE",
            help="You only need to change this if you chose a different application name during installation.")
        # if there's no registration, prep for registration by making the plugin app visible to the engine
        applications_list = get_active_session().sql(f"show databases like '{omnata_app_name}' in account").collect()
        if len(applications_list)==0:
            st.write("""To start using an Omnata plugin, you must grant the Omnata Sync Engine visibility of this plugin application and then register it:""")
            st.code(f"""
            -- as ACCOUNTADMIN
            grant application role {plugin_app_database}.OMNATA_MANAGEMENT 
            to application {omnata_app_name};
            call {omnata_app_name}.API.REGISTER_PLUGIN('{plugin_app_database}');
            """,language='sql')
            clicked_1 = st.button(label="Show next step",key="next_step_button_1")
            if clicked_1:
                st.info("Plugin was not registered, please try following the above instructions again")
            st.stop()
        else:
            st.write("""To start using an Omnata plugin, you must register it:""")
            st.code(f"""
            -- as ACCOUNTADMIN
            call {omnata_app_name}.API.REGISTER_PLUGIN('{plugin_app_database}');
            """,language='sql')
            clicked_3 = st.button(label="Show next step",key="next_step_button_3")
            if clicked_3:
                st.info("Plugin was not registered, please try following the above instructions again")
            st.stop()
    else:
        st.markdown("""To use Omnata Sync, you need to install:
1. The Omnata Sync Engine
2. The Omnata Plugin for the app you’d like to sync data to and from

*There is **no cost** to use the Sync Engine with **free** plugins
""")
        #st.link_button(
        #    label="Install the Omnata Sync Engine",
        #    url="https://app.snowflake.com/marketplace/listing/GZSUZ59IJT/omnata-omnata-sync-engine",
        #    type="primary",
        #    help="Click here to install the Sync Engine application from the Snowflake Marketplace"
        #)
        st.markdown(f"""[Install the Omnata Sync Engine](https://app.snowflake.com/marketplace/listing/GZSUZ13JOEUG/omnata-omnata-sync-engine)""")

        st.button(
            label="I've done this",
            on_click=handle_installed_sync_engine,
            kwargs={"answer":"Yes"},
            key="ive_done_this")
        col1,_ = st.columns([1,1])
        with col1:
            with st.expander("See explanation",expanded=False):
                st.markdown(f"![Diagram]({inline_svg_src(PLUGIN_DIAGRAM)})")
        st.stop()
elif len(registrations)>1:
    st.error(f"There are {len(registrations)}, this should never happen. Remove this plugin application and reinstall")
else:
    registration = registrations[0]
    omnata_app_name = registration.APPLICATION_NAME
    test_callback_result = json.loads(get_active_session().sql(f"call PLUGIN.TEST_CALLBACK('{omnata_app_name}')").collect()[0][0])
    if test_callback_result['success'] is False:
        st.error(test_callback_result['error'])
        st.stop()
    elif test_callback_result['data'] is False:
        st.write("""Now, you must complete the final registration step by granting the plugin application access to its Omnata app role:""")
        st.code(f"""grant application role {omnata_app_name}.{plugin_application_role_name}
to application {plugin_app_database};""",language='sql')
        clicked_2 = st.button(label="Show next step",key="next_step_button_2")
        if clicked_2:
            st.info("Plugin was not registered, please try following the above instructions again")
        st.stop()

st.success("Plugin is registered and ready to use")
st.write("Please return to the Omnata Sync Engine app to complete the configuration.")
st.write('---')
registration = registrations[0]
integrations = json.loads(registration.EXTERNAL_ACCESS_INTEGRATIONS)
st.subheader('External Access and Secrets')
st.write(f"### External Access Integrations used by plugin")
for integration_name,details in integrations.items():
    if 'oauth_secret' not in details:
        details['oauth_secret'] = None
    if 'other_secret' not in details:
        details['other_secret'] = None
    st.write(f"#### {integration_name}")
    col1,col2 = st.columns([2,6])
    with col1:
        st.write(f"**OAuth secret:**")
    with col2:
        st.code(details['oauth_secret'])
    col1,col2 = st.columns([2,6])
    with col1:
        st.write(f"**Other secrets:**")
    with col2:
        st.code(details['other_secret'])
    if details['oauth_secret'] is not None:
        oauth_secret = details['oauth_secret']
        st.write(f"**Secret details: {oauth_secret}**")
        secret_contents = json.loads(get_active_session().sql(f"call PLUGIN.RETRIEVE_SECRETS($${oauth_secret}$$,null)").collect()[0][0])
        if secret_contents['success'] is False:
            st.error(f"Error retrieving secrets contents: {str(secret_contents['error'])}")
        else:
            col1,col2 = st.columns([2,6])    
            with col1:
                st.write(f"**Retrieval test:**")
            with col2:
                st.info("Secret contents were retrieved successfully")

    if details['other_secret'] is not None:
        other_secret = details['other_secret']
        st.write(f"**Secret details: {other_secret}**")
        secret_contents = json.loads(get_active_session().sql(f"call PLUGIN.RETRIEVE_SECRETS(null,$${other_secret}$$)").collect()[0][0])
        if secret_contents['success'] is False:
            st.error(f"Error retrieving secrets contents: {str(secret_contents['error'])}")
        else:    
            col1,col2 = st.columns([2,6])    
            with col1:
                st.write(f"**Retrieval test:**")
            with col2:
                st.info("Secret contents were retrieved successfully")
            col1,col2 = st.columns([2,6])    
            with col1:
                st.write(f"**Secret parameters:**")
            with col2:
                st.code('\n'.join(secret_contents['data'].keys()))

st.write('---')
st.subheader('Plugin information')
col1,col2 = st.columns([2,6])
with col1:
    st.write(f"**Anaconda packages imported:**")
with col2:
    st.code(','.join(plugin_info['anaconda_packages']))
col1,col2 = st.columns([2,6])
with col1:
    st.write(f"**PyPi packages bundled:**")
with col2:
    st.code(','.join(plugin_info['bundled_packages']))
col1,col2 = st.columns([2,6])
with col1:
    st.write(f"**Plugin runtime version:**")
with col2:
    st.code(plugin_info['plugin_runtime_version'])
col1,col2 = st.columns([2,6])
with col1:
    st.write(f"**Plugin devkit version:**")
with col2:
    st.code(plugin_info['plugin_devkit_version'])
col1,col2 = st.columns([2,6])
with col1:
    st.write(f"**Developer ID:**")
with col2:
    st.code(manifest['developer_id'])
col1,col2 = st.columns([2,6])
with col1:
    st.write(f"**Developer Name:**")
with col2:
    st.code(manifest['developer_name'])
col1,col2 = st.columns([2,6])
with col1:
    st.write(f"**Plugin ID:**")
with col2:
    st.code(manifest['plugin_id'])
col1,col2 = st.columns([2,6])
with col1:
    st.write(f"**Plugin Name:**")
with col2:
    st.code(manifest['plugin_name'])
col1,col2 = st.columns([2,6])
with col1:
    st.write(f"**Docs URL:**")
with col2:
    st.write(manifest['docs_url'])
col1,col2 = st.columns([2,6])
with col1:
    st.write(f"**Supports Inbound:**")
with col2:
    st.code('Yes' if manifest['supports_inbound'] is True else 'No')

outbound_strategy_names = [s['name'] for s in manifest['supported_outbound_strategies']]

col1,col2 = st.columns([2,6])
with col1:
    st.write(f"**Supports Outbound:**")
with col2:
    st.code('Yes' if len(outbound_strategy_names) > 0 else 'No')
if len(outbound_strategy_names) > 0:
    col1,col2 = st.columns([2,6])
    with col1:
        st.write(f"**Outbound Strategies:**")
    with col2:
        st.code(','.join(outbound_strategy_names))

st.write('')
st.write('')
st.write('')
st.write('')
st.write('')