/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.taxonomy.ClassTaxonomyComputation;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.Interrupter;

class ClassTaxonomyComputationStage
extends AbstractReasonerStage {
    protected ClassTaxonomyComputation computation_ = null;

    public ClassTaxonomyComputationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Class Taxonomy Computation";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        this.reasoner.initClassTaxonomy();
        this.computation_ = new ClassTaxonomyComputation(Operations.split(this.reasoner.ontologyIndex.getIndexedClasses(), (int)64), this.reasoner.getProcessExecutor(), this.workerNo, this.progressMonitor, this.reasoner.saturationState, this.reasoner.classTaxonomyState.getTaxonomy());
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        this.computation_.process();
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.reasoner.classTaxonomyState.getWriter().setTaxonomy(this.computation_.getTaxonomy());
        this.reasoner.ruleAndConclusionStats.add(this.computation_.getRuleAndConclusionStatistics());
        return true;
    }

    @Override
    public boolean dispose() {
        if (!super.dispose()) {
            return false;
        }
        this.computation_ = null;
        return true;
    }

    @Override
    public void printInfo() {
        if (this.computation_ != null) {
            this.computation_.printStatistics();
        }
    }

    public void setInterrupt(boolean flag) {
        super.setInterrupt(flag);
        this.setInterrupt((Interrupter)this.computation_, flag);
    }
}

