/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap_lite.io;

import uk.ac.ox.krr.logmap_lite.io.OutputMappingsFormat;
import uk.ac.ox.krr.logmap_lite.io.WriteFile;

public class RDFAlignmentFormat
extends OutputMappingsFormat {
    WriteFile writer;

    public RDFAlignmentFormat(String output_file_str, String oiri1, String oiri2) throws Exception {
        super(output_file_str);
        this.setOutput();
        this.printHeader(oiri1, oiri2);
    }

    @Override
    protected void setOutput() throws Exception {
        this.writer = new WriteFile(this.output_file);
    }

    private void printHeader(String oiri1, String oiri2) {
        this.writer.writeLine("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.writer.writeLine("<rdf:RDF xmlns=\"http://knowledgeweb.semanticweb.org/heterogeneity/alignment\"");
        this.writer.writeLine("\txmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        this.writer.writeLine("\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\">");
        this.writer.writeLine("");
        this.writer.writeLine("<Alignment>");
        this.writer.writeLine("<xml>yes</xml>");
        this.writer.writeLine("<level>0</level>");
        this.writer.writeLine("<type>??</type>");
        this.writer.writeLine("<onto1>" + oiri1 + "</onto1>");
        this.writer.writeLine("<onto2>" + oiri2 + "</onto2>");
        this.writer.writeLine("<uri1>" + oiri1 + "</uri1>");
        this.writer.writeLine("<uri2>" + oiri2 + "</uri2>");
    }

    private void printTail() {
        this.writer.writeLine("</Alignment>");
        this.writer.writeLine("</rdf:RDF>");
    }

    @Override
    public void addClassMapping2Output(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        this.addMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
    }

    @Override
    public void addDataPropMapping2Output(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        this.addMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
    }

    @Override
    public void addObjPropMapping2Output(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        this.addMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
    }

    @Override
    public void addInstanceMapping2Output(String iri_str1, String iri_str2, double conf) throws Exception {
        this.addMapping2Output(iri_str1, iri_str2, -2, conf);
    }

    private void addMapping2Output(String iri_str1, String iri_str2, int dir_mapping, double conf) {
        this.writer.writeLine("<map>");
        this.writer.writeLine("\t<Cell>");
        this.writer.writeLine("\t\t<entity1 rdf:resource=\"" + iri_str1 + "\"/>");
        this.writer.writeLine("\t\t<entity2 rdf:resource=\"" + iri_str2 + "\"/>");
        this.writer.writeLine("\t\t<measure rdf:datatype=\"xsd:float\">" + this.getRoundConfidence(conf) + "</measure>");
        if (dir_mapping == -2) {
            this.writer.writeLine("\t\t<relation>=</relation>");
        } else if (dir_mapping == 0) {
            this.writer.writeLine("\t\t<relation>&lt;</relation>");
        } else {
            this.writer.writeLine("\t\t<relation>&gt;</relation>");
        }
        this.writer.writeLine("\t</Cell>");
        this.writer.writeLine("</map>");
    }

    @Override
    public void saveOutputFile() throws Exception {
        this.printTail();
        this.writer.closeBuffer();
    }
}

