/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.SIAssessment;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;

public class InstanceMatchingAssessment {
    protected IndexManager index;
    protected MappingManager mapping_manager;
    protected final int EMPTY_TYPES = 0;
    protected final int ONE_TYPE_EMPTY = 1;
    protected final int COMPATIBLE_TYPES = 2;
    protected final int INCOMPATIBLE_TYPES = 3;
    protected final int SAME_TYPES = 4;
    protected final int SUB_TYPES = 5;
    protected int compatibility = 0;
    Set<String> categories1;
    Set<String> categories2;
    private Set<String> additional_categories = new HashSet<String>();

    public InstanceMatchingAssessment(IndexManager index, MappingManager mapping_manager) {
        this.index = index;
        this.mapping_manager = mapping_manager;
    }

    public boolean haveInstancesCompatibleCategories(int ident1, int ident2) {
        this.categories1 = this.index.getIndividualCategory4Identifier(ident1);
        this.categories2 = this.index.getIndividualCategory4Identifier(ident2);
        if (this.categories1.size() == 0 || this.categories2.size() == 0) {
            return true;
        }
        this.extendCategoriesWithMappings(this.categories1);
        this.extendCategoriesWithMappings(this.categories2);
        this.extendCategoriesWithMappings(this.categories1);
        this.extendCategoriesWithMappings(this.categories2);
        return this.areCompatibleCategories(this.categories1, this.categories2);
    }

    private void extendCategoriesWithMappings(Set<String> categories) {
        for (String cat : categories) {
            if (!this.mapping_manager.hasCategoryMappings(cat)) continue;
            this.additional_categories.addAll(this.mapping_manager.getMappings4Category(cat));
        }
        categories.addAll(this.additional_categories);
        this.additional_categories.clear();
    }

    protected int areInstancesCompatible(int ident1, int ident2) {
        Set<Integer> types1 = this.index.getIndividualClassTypes4Identifier(ident1);
        Set<Integer> types2 = this.index.getIndividualClassTypes4Identifier(ident2);
        HashSet<Integer> mapped_types1 = new HashSet<Integer>();
        if (types1.isEmpty() && types2.isEmpty()) {
            return 0;
        }
        if (types1.isEmpty() || types2.isEmpty()) {
            return 1;
        }
        for (int cls1 : types1) {
            if (!this.mapping_manager.getLogMapMappings().containsKey(cls1)) continue;
            mapped_types1.addAll((Collection<Integer>)this.mapping_manager.getLogMapMappings().get(cls1));
        }
        if (this.areSameClassTypes(mapped_types1, types2)) {
            return 4;
        }
        for (int cls1 : types1) {
            for (int cls2 : types2) {
                if (!this.mapping_manager.isMappingInConflictWithFixedMappings(cls1, cls2)) continue;
                return 3;
            }
        }
        if (this.areAllSubTypes(types1, types2)) {
            return 5;
        }
        return 2;
    }

    public double getConfidence4Compatibility(int ident1, int ident2) {
        this.compatibility = this.areInstancesCompatible(ident1, ident2);
        switch (this.compatibility) {
            case 0: {
                return Parameters.min_isub_instances + 0.15;
            }
            case 1: {
                return Parameters.min_isub_instances + 0.15;
            }
            case 4: {
                return Parameters.min_isub_instances;
            }
            case 5: {
                return Parameters.min_isub_instances + 0.05;
            }
            case 2: {
                return Parameters.min_isub_instances + 0.1;
            }
            case 3: {
                return 2.0;
            }
        }
        return 2.0;
    }

    public double getCompatibilityFactor(int ident1, int ident2) {
        switch (this.compatibility) {
            case 0: {
                return 0.5;
            }
            case 1: {
                return 0.5;
            }
            case 4: {
                return 1.0;
            }
            case 5: {
                return 0.9;
            }
            case 2: {
                return 0.7;
            }
            case 3: {
                return 0.0;
            }
        }
        return 0.0;
    }

    protected boolean areSameClassTypes(Set<Integer> types1, Set<Integer> types2) {
        if (types1.size() > 0 && types2.size() > 0) {
            return types1.equals(types2);
        }
        return false;
    }

    protected boolean areCompatibleCategories(Set<String> cat1, Set<String> cat2) {
        HashSet<String> intersection = new HashSet<String>(cat1);
        intersection.retainAll(cat2);
        return intersection.size() > 0;
    }

    protected boolean areAllSubTypes(Set<Integer> types1, Set<Integer> types2) {
        for (int cls1 : types1) {
            for (int cls2 : types2) {
                if (this.index.isSubClassOf(cls1, cls2) || this.index.isSubClassOf(cls2, cls1)) continue;
                return false;
            }
        }
        return true;
    }
}

