/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2;

import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.manchester.syntactic_locality.ModuleExtractor;
import uk.ac.ox.krr.logmap2.OntologyLoader;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.background.CategoryMappingsLoader;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.indexing.JointIndexManager;
import uk.ac.ox.krr.logmap2.indexing.OntologyProcessing;
import uk.ac.ox.krr.logmap2.interactive.InteractiveProcess;
import uk.ac.ox.krr.logmap2.interactive.InteractiveProcessAmbiguity;
import uk.ac.ox.krr.logmap2.interactive.InteractiveProcessOAEI;
import uk.ac.ox.krr.logmap2.interactive.InteractiveProcessThreshold;
import uk.ac.ox.krr.logmap2.interactive.objects.MappingObjectInteractivity;
import uk.ac.ox.krr.logmap2.io.FlatAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.OWLAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.OutPutFilesManager;
import uk.ac.ox.krr.logmap2.io.ReadFile;
import uk.ac.ox.krr.logmap2.io.WriteFile;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;
import uk.ac.ox.krr.logmap2.mappings.CandidateMappingManager;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.oracle.OracleManager;
import uk.ac.ox.krr.logmap2.overlapping.LexicalOverlappingExtractor;
import uk.ac.ox.krr.logmap2.overlapping.NoOverlappingExtractor;
import uk.ac.ox.krr.logmap2.overlapping.OverlappingExtractor;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;
import uk.ac.ox.krr.logmap2.reasoning.SatisfiabilityIntegration;
import uk.ac.ox.krr.logmap2.repair.AnchorAssessment;
import uk.ac.ox.krr.logmap2.statistics.StatisticsManager;
import uk.ac.ox.krr.logmap2.statistics.StatisticsTimeMappings;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public class LogMap2Core {
    private OverlappingExtractor overlappingExtractor;
    private IndexManager index;
    private OntologyProcessing onto_process1;
    private OntologyProcessing onto_process2;
    private MappingManager mapping_extractor;
    private AnchorAssessment mappings_assessment;
    private InteractiveProcess interactiveProcessManager;
    private Set<MappingObjectStr> mappings_gs = new HashSet<MappingObjectStr>();
    private LexicalUtilities lexicalUtilities = new LexicalUtilities();
    private CategoryMappingsLoader categoryMappingsLoader = new CategoryMappingsLoader();
    private OWLDataFactory dataFactory;
    private String prefix4IRIs;
    private String logmap_mappings_path = "";
    private String gs_mappings = "";
    long init;
    boolean useInteractivity = true;
    boolean useHeuristics = true;
    boolean orderQuestions = true;
    int error_user = 0;
    boolean record_interactivity = false;
    boolean ask_everything = false;
    boolean evaluate_impact = false;
    SatisfiabilityIntegration sat_checker;
    boolean hasUnSat = false;
    int numUnsat = 0;
    Set<OWLEntity> signature_onto1 = new HashSet<OWLEntity>();
    Set<OWLEntity> signature_onto2 = new HashSet<OWLEntity>();
    double precision = 0.0;
    double recall = 0.0;
    double fmeasure = 0.0;

    public LogMap2Core(String iri1_str, String iri2_str) throws Exception {
        this(iri1_str, iri2_str, "", "", "", "", false, false, false, 0, false, false, false);
    }

    public LogMap2Core(String iri1_str, String iri2_str, boolean evaluate_impact, String file_gs) throws Exception {
        this(iri1_str, iri2_str, "", "", file_gs, "", false, false, false, 0, false, false, evaluate_impact);
    }

    public LogMap2Core(String iri1_str, String iri2_str, boolean evaluate_impact) throws Exception {
        this(iri1_str, iri2_str, "", "", "", "", false, false, false, 0, false, false, evaluate_impact);
    }

    public LogMap2Core(String iri1_str, String iri2_str, String output_path, String gs_file, boolean evaluate_impact) throws Exception {
        this(iri1_str, iri2_str, "", "", gs_file, output_path, false, false, false, 0, false, false, evaluate_impact);
    }

    public LogMap2Core(String iri1_str, String iri2_str, String output_path, boolean eval_impact) throws Exception {
        this(iri1_str, iri2_str, "", "", "", output_path, false, false, false, 0, false, false, eval_impact);
    }

    public LogMap2Core(OWLOntology onto1, OWLOntology onto2, boolean only_achors) throws Exception {
        this(onto1, onto2, new HashSet<MappingObjectStr>(), only_achors);
    }

    public LogMap2Core(OWLOntology onto1, OWLOntology onto2) throws Exception {
        this(onto1, onto2, new HashSet<MappingObjectStr>(), false);
    }

    public LogMap2Core(OWLOntology onto1, OWLOntology onto2, Set<MappingObjectStr> input_mappings) throws Exception {
        this(onto1, onto2, input_mappings, false);
    }

    public LogMap2Core(OWLOntology onto1, OWLOntology onto2, Set<MappingObjectStr> input_mappings, boolean are_input_mappings_validated) throws Exception {
        boolean only_anchors = false;
        this.evaluate_impact = true;
        this.dataFactory = SynchronizedOWLManager.createOWLDataFactory();
        StatisticsTimeMappings.setInitGlobalTime();
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.InitLogMap();
        this.OverlappingEstimation(onto1, onto2);
        this.IndexLexiconAndStructure(input_mappings);
        LogOutput.printAlways("Time Parsing and Index Lexicon (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        this.createAndCleanAnchors(are_input_mappings_validated);
        if (!only_anchors) {
            this.createCandidateMappings();
            this.createCandidateMappingsLevel2();
            if (Parameters.perform_property_matching) {
                this.createAndAssessPropertyMappings();
            }
            if (Parameters.perform_instance_matching) {
                this.createAndAssessInstanceMappings();
            }
        }
    }

    public LogMap2Core(String iri1_str, String iri2_str, String iri1_str_out, String iri2_str_out, String gs_mappings, String logmap_mappings_path, boolean useInteractivity, boolean useHeuristics, boolean orderQuestions, int error_user, boolean ask_everything, boolean record_interactivity, boolean evaluate_impact) throws Exception {
        this.logmap_mappings_path = logmap_mappings_path;
        this.gs_mappings = gs_mappings;
        this.useInteractivity = useInteractivity;
        this.useHeuristics = useHeuristics;
        this.orderQuestions = orderQuestions;
        this.error_user = error_user;
        this.record_interactivity = record_interactivity;
        this.ask_everything = ask_everything;
        this.evaluate_impact = evaluate_impact;
        this.dataFactory = SynchronizedOWLManager.createOWLDataFactory();
        this.prefix4IRIs = logmap_mappings_path.startsWith("/") ? "file:" : "file:/";
        StatisticsTimeMappings.setInitGlobalTime();
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.InitLogMap();
        this.OverlappingEstimation(iri1_str, iri2_str);
        this.IndexLexiconAndStructure();
        LogOutput.printAlways("Time Parsing and Index Lexicon (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        if (!gs_mappings.equals("")) {
            this.loadMappingsGS();
        }
        this.createAndCleanAnchors();
        this.createCandidateMappings();
        StatisticsManager.setPrecisionAndRecallAnchors(this.mapping_extractor.getStringGoldStandardAnchors().size());
        StatisticsManager.printStatisticsLogMap_mappings();
        this.createCandidateMappingsLevel2();
        StatisticsManager.printMappingsAskedHeur();
        if (Parameters.perform_property_matching) {
            this.createAndAssessPropertyMappings();
        }
        if (Parameters.perform_instance_matching) {
            this.createAndAssessInstanceMappings();
            if (Parameters.output_instance_mapping_files && !logmap_mappings_path.equals("")) {
                this.outputInstaceMappings4Evaluation();
            }
        }
        if (!gs_mappings.equals("")) {
            this.getPrecisionAndRecallMappings();
        }
        File file_folder = new File(logmap_mappings_path);
        if (!logmap_mappings_path.equals("") && file_folder.exists() && file_folder.isAbsolute()) {
            LogOutput.print("Creating overlapping output");
            this.createOutput4Overlapping(true);
            LogOutput.print("Saving output mapping files");
            this.saveExtractedMappings("logmap2_mappings");
        } else {
            LogOutput.print("The given output path is not absolute or it does not exist. The output mappings cannot be stored.");
        }
        LogOutput.print("Average time taxonomic queries: " + this.index.getAvgTime4TaxCalls() + ". Total: " + this.index.getTime4TaxCalls() + ". Num calls: " + this.index.getNumberOfTaxCalls());
        LogOutput.print("Average time disjointness queries: " + this.index.getAvgTime4DisjCalls() + ". Total: " + this.index.getTime4DisjCalls() + ". Num calls: " + this.index.getNumberOfDisjCalls());
        LogOutput.printAlways("Number of computed mappings: " + this.getLogMapMappings().size());
        LogOutput.printAlways("LogMap 2 Total Matching Time (s): " + StatisticsTimeMappings.getTotalRunningTime());
        if (evaluate_impact) {
            this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
            this.impactIntegration(iri1_str, iri2_str);
            LogOutput.printAlways("Time checking impact integration (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        }
    }

    public boolean hasUnsatClasses() {
        return this.hasUnSat;
    }

    public int getNumUnsatClasses() {
        return this.numUnsat;
    }

    private void impactIntegration() throws Exception {
        OWLOntology mappins_owl_onto = this.getOWLOntology4Mappings();
        LogOutput.print(this.overlappingExtractor.getOverlappingOnto1().getAxiomCount());
        LogOutput.print(this.overlappingExtractor.getOverlappingOnto2().getAxiomCount());
        LogOutput.print(mappins_owl_onto.getAxiomCount());
        this.sat_checker = new SatisfiabilityIntegration(this.overlappingExtractor.getOverlappingOnto1(), this.overlappingExtractor.getOverlappingOnto2(), mappins_owl_onto, true, false);
        this.hasUnSat = this.sat_checker.hasUnsatClasses();
        this.numUnsat = this.sat_checker.getNumUnsatClasses();
        LogOutput.print("Num unsat classes: " + this.sat_checker.getNumUnsatClasses());
    }

    private void impactIntegration(String iri1, String iri2) throws Exception {
        OWLOntology mappings_owl_onto = this.getOWLOntology4Mappings();
        OntologyLoader loader1 = new OntologyLoader(iri1);
        OntologyLoader loader2 = new OntologyLoader(iri2);
        LogOutput.printAlways("Evaluating impact...");
        LogOutput.print("Axioms onto1: " + loader1.getOWLOntology().getAxiomCount());
        LogOutput.print("Axioms onto2: " + loader2.getOWLOntology().getAxiomCount());
        LogOutput.print("Mapping Axioms: " + mappings_owl_onto.getAxiomCount());
        this.sat_checker = new SatisfiabilityIntegration(loader1.getOWLOntology(), loader2.getOWLOntology(), mappings_owl_onto, true, false);
        this.hasUnSat = this.sat_checker.hasUnsatClasses();
        this.numUnsat = this.sat_checker.getNumUnsatClasses();
        System.out.println("\nNum unsat classes after integration: " + this.sat_checker.getNumUnsatClasses());
    }

    public OWLOntology getOWLOntology4Mappings() throws Exception {
        OWLAlignmentFormat owlformat = new OWLAlignmentFormat("");
        for (int ide1 : this.getClassMappings().keySet()) {
            for (int ide2 : this.getClassMappings().get(ide1)) {
                int dir_mapping = this.getDirClassMapping(ide1, ide2);
                if (dir_mapping == -3) continue;
                owlformat.addClassMapping2Output(this.getIRI4ConceptIdentifier(ide1), this.getIRI4ConceptIdentifier(ide2), dir_mapping, this.getConfidence4ConceptMapping(ide1, ide2));
            }
        }
        for (int ide1 : this.getDataPropMappings().keySet()) {
            owlformat.addDataPropMapping2Output(this.getIRI4DataPropIdentifier(ide1), this.getIRI4DataPropIdentifier(this.getDataPropMappings().get(ide1)), -2, this.getConfidence4DataPropConceptMapping(ide1, this.getDataPropMappings().get(ide1)));
        }
        for (int ide1 : this.getObjectPropMappings().keySet()) {
            owlformat.addObjPropMapping2Output(this.getIRI4ObjectPropIdentifier(ide1), this.getIRI4ObjectPropIdentifier(this.getObjectPropMappings().get(ide1)), -2, this.getConfidence4ObjectPropConceptMapping(ide1, this.getObjectPropMappings().get(ide1)));
        }
        if (Parameters.perform_instance_matching) {
            for (int ide1 : this.getInstanceMappings().keySet()) {
                for (int ide2 : this.getInstanceMappings().get(ide1)) {
                    owlformat.addInstanceMapping2Output(this.getIRI4InstanceIdentifier(ide1), this.getIRI4InstanceIdentifier(ide2), this.getConfidence4InstanceMapping(ide1, ide2));
                }
            }
        }
        return owlformat.getOWLOntology();
    }

    private boolean areAnchorsdAmbiguous() {
        for (int ide : this.mapping_extractor.getLogMapMappings().keySet()) {
            if (this.mapping_extractor.getLogMapMappings().get(ide).size() <= 1) continue;
            LogOutput.print(ide + "  " + this.mapping_extractor.getLogMapMappings().get(ide));
            return true;
        }
        return false;
    }

    private void InitLogMap() throws Exception {
        LogOutput.showOutpuLog(Parameters.print_output);
        LogOutput.showOutpuLogAlways(Parameters.print_output || Parameters.print_output_always);
        this.lexicalUtilities.loadStopWords();
        this.lexicalUtilities.loadStopWordsExtended();
        if (Parameters.use_umls_lexicon) {
            this.lexicalUtilities.loadUMLSLexiconResources();
        }
        this.lexicalUtilities.setStemmer();
        LogOutput.print("Time initializing lexical utilities (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        StatisticsTimeMappings.addUpperbound_mappings_time(StatisticsTimeMappings.getRunningTime(this.init));
    }

    private void OverlappingEstimation(String iri1_str, String iri2_str) throws Exception {
        LogOutput.print("OVERLAPPING");
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.overlappingExtractor = !Parameters.use_overlapping ? new NoOverlappingExtractor() : new LexicalOverlappingExtractor(this.lexicalUtilities, true);
        this.overlappingExtractor.createOverlapping(iri1_str, iri2_str);
        LogOutput.printAlways("Entities ontology 1: " + this.overlappingExtractor.getBaseOverlappedEntities1().size());
        LogOutput.printAlways("Entities ontology 2: " + this.overlappingExtractor.getBaseOverlappedEntities2().size());
        LogOutput.print("Time extracting overlapping (s): " + StatisticsTimeMappings.getRunningTime(this.init));
    }

    private void OverlappingEstimation(OWLOntology onto1, OWLOntology onto2) throws Exception {
        LogOutput.print("OVERLAPPING");
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.overlappingExtractor = !Parameters.use_overlapping ? new NoOverlappingExtractor() : new LexicalOverlappingExtractor(this.lexicalUtilities, true);
        this.overlappingExtractor.createOverlapping(onto1, onto2);
        LogOutput.print("Time extracting overlapping (s): " + StatisticsTimeMappings.getRunningTime(this.init));
    }

    private void IndexLexiconAndStructure() throws Exception {
        this.IndexLexiconAndStructure(new HashSet<MappingObjectStr>());
    }

    private void IndexLexiconAndStructure(Set<MappingObjectStr> input_mappings) throws Exception {
        this.index = new JointIndexManager();
        this.onto_process1 = new OntologyProcessing(this.overlappingExtractor.getOverlappingOnto1(), this.index, this.lexicalUtilities);
        this.onto_process2 = new OntologyProcessing(this.overlappingExtractor.getOverlappingOnto2(), this.index, this.lexicalUtilities);
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.onto_process1.precessLexicon();
        this.onto_process2.precessLexicon();
        LogOutput.print("Time extracting lexicon and IF (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        this.lexicalUtilities.clearStructures();
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.mapping_extractor = new CandidateMappingManager(this.index, this.onto_process1, this.onto_process2);
        StatisticsManager.reInitValues();
        StatisticsManager.setMappingManager(this.mapping_extractor);
        this.categoryMappingsLoader.loadMappings(Parameters.path_mappings_categories);
        this.mapping_extractor.setCategoryMappings(this.categoryMappingsLoader.getCategoryMappings());
        this.mapping_extractor.processInputMappings(input_mappings);
        this.mapping_extractor.intersectInvertedFiles();
        LogOutput.print("Time intersecting IF and extracting IF weak (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        this.onto_process1.clearStemmedLabels();
        this.onto_process2.clearStemmedLabels();
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.onto_process1.setTaxonomicData();
        this.onto_process2.setTaxonomicData();
        LogOutput.print("Time extracting structural information (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        if (this.logmap_mappings_path.equals("")) {
            if (!this.evaluate_impact) {
                this.overlappingExtractor.clearModulesOverlapping();
            }
        } else {
            this.overlappingExtractor.keepOnlyTBOXOverlapping(!this.evaluate_impact);
        }
        this.onto_process1.clearOntologyRelatedInfo();
        this.onto_process2.clearOntologyRelatedInfo();
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.mapping_extractor.extractAllWeakMappings();
        LogOutput.print("Time creating all weak anchors (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.mapping_extractor.extractCandidatesSubsetFromWeakMappings();
        LogOutput.print("Time creating candidate subset of weak anchors (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        this.onto_process1.clearFrequencyRelatedStructures();
        this.onto_process2.clearFrequencyRelatedStructures();
        this.index.clearSingleWordInvertedIndex();
        this.index.clearStemmedAlternativeLabels4Classes();
    }

    private void createAndCleanAnchors() throws Exception {
        this.createAndCleanAnchors(false);
    }

    private void createAndCleanAnchors(boolean are_input_mapping_validated) throws Exception {
        LogOutput.printAlways("\nANCHOR DIAGNOSIS ");
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.mapping_extractor.createAnchors(are_input_mapping_validated);
        LogOutput.printAlways("Time creating anchors (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        this.countAnchors();
        this.mappings_assessment = new AnchorAssessment(this.index, this.mapping_extractor);
        if (Parameters.cleanD_G) {
            if (Parameters.extractGlobal_D_G_Info) {
                this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
                this.mappings_assessment.CountSatisfiabilityOfIntegration_DandG(this.mapping_extractor.getLogMapMappings());
                LogOutput.printAlways("Time checking satisfiability D&G (s): " + StatisticsTimeMappings.getRunningTime(this.init));
            }
            this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
            this.mappings_assessment.CheckSatisfiabilityOfIntegration_DandG(this.mapping_extractor.getLogMapMappings());
            LogOutput.printAlways("Time cleaning anchors D&G (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        }
        this.mapping_extractor.setExactAsFixed(true);
        this.mapping_extractor.saveAnchors();
        this.countAnchors();
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.index.setIntervalLabellingIndex(this.mapping_extractor.getFixedMappings());
        this.index.clearAuxStructuresforLabellingSchema();
        LogOutput.printAlways("Time indexing hierarchy + anchors (ILS) (s): " + StatisticsTimeMappings.getRunningTime(this.init));
    }

    private void countAnchors() {
        int numMappings = 0;
        for (int ide1 : this.mapping_extractor.getLogMapMappings().keySet()) {
            for (int ide2 : this.mapping_extractor.getLogMapMappings().get(ide1)) {
                if (ide1 >= ide2) continue;
                ++numMappings;
            }
        }
        LogOutput.print("\nNum Anchors: " + numMappings + "\n");
    }

    private void createCandidateMappings() throws Exception {
        LogOutput.printAlways("\nCANDIDATE DIAGNOSIS 1");
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.mapping_extractor.createCandidates();
        LogOutput.printAlways("Time creating candidates (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        if (Parameters.cleanD_G) {
            if (Parameters.extractGlobal_D_G_Info) {
                this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
                this.mappings_assessment.CountSatisfiabilityOfIntegration_DandG(this.mapping_extractor.getMappings2Review());
                LogOutput.printAlways("Time checking satisfiability D&G (s): " + StatisticsTimeMappings.getRunningTime(this.init));
            }
            this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
            this.mappings_assessment.CheckSatisfiabilityOfIntegration_DandG(this.mapping_extractor.getMappings2Review());
            LogOutput.printAlways("Time cleaning new candidates D&G (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        }
        this.mapping_extractor.moveMappingsToReview2AnchorList();
        this.countAnchors();
        this.mapping_extractor.getMappings2Review().clear();
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.index.setIntervalLabellingIndex(this.mapping_extractor.getLogMapMappings());
        this.index.clearAuxStructuresforLabellingSchema();
        LogOutput.printAlways("Time indexing hierarchy + anchors and candidates I (ILS) (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        this.mapping_extractor.assessMappings2AskUser();
        StatisticsManager.extractStatisticsAnchors();
    }

    private void createCandidateMappingsInteractiveProcess2() {
        boolean useThreshold = false;
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        this.interactiveProcessManager = !useThreshold ? new InteractiveProcessAmbiguity(this.index, this.mapping_extractor, this.useHeuristics, this.orderQuestions, this.error_user, this.ask_everything, this.record_interactivity, this.logmap_mappings_path + "SimulationInteractivity_" + this.useInteractivity + "_" + this.useHeuristics + "_" + this.orderQuestions + ".txt") : new InteractiveProcessThreshold(this.index, this.mapping_extractor);
        if (this.useInteractivity) {
            this.interactiveProcessManager.startInteractiveProcess();
        }
        this.interactiveProcessManager.endInteractiveProcess(this.mapping_extractor.isFilterWithHeuristicsSecondLevelMappings());
        LogOutput.print("Time interactive process (s): " + StatisticsTimeMappings.getRunningTime(this.init));
    }

    private void createCandidateMappingsInteractiveProcess() {
        InteractiveProcessOAEI interactivityOAEI = new InteractiveProcessOAEI(this.index, this.mapping_extractor, true, false);
        interactivityOAEI.startInteractiveProcess();
        interactivityOAEI.endInteractiveProcess();
    }

    private void askAll2AOracle() {
        for (MappingObjectInteractivity mapping : this.mapping_extractor.getListOfMappingsToAskUser()) {
            if (!OracleManager.isMappingValid(this.index.getIRIStr4ConceptIndex(mapping.getIdentifierOnto1()), this.index.getIRIStr4ConceptIndex(mapping.getIdentifierOnto2()))) continue;
            if (mapping.getDirMapping() == -2 || mapping.getDirMapping() == 0) {
                this.mapping_extractor.addSubMapping2Mappings2Review(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2());
            }
            if (mapping.getDirMapping() != -2 && mapping.getDirMapping() != -1) continue;
            this.mapping_extractor.addSubMapping2Mappings2Review(mapping.getIdentifierOnto2(), mapping.getIdentifierOnto1());
        }
    }

    private boolean hasScopeAll(MappingObjectInteractivity m) {
        return this.mapping_extractor.extractScopeAll4Mapping(m.getIdentifierOnto1(), m.getIdentifierOnto2()) > Parameters.bad_score_scope;
    }

    private boolean hasGoodConfidence(MappingObjectInteractivity m) {
        return this.mapping_extractor.getConfidence4Mapping(m.getIdentifierOnto1(), m.getIdentifierOnto2()) > Parameters.good_confidence;
    }

    private void performAutomaticDecisions() {
        for (MappingObjectInteractivity mapping : this.mapping_extractor.getListOfMappingsToAskUser()) {
            if (this.mapping_extractor.isFilterWithHeuristicsSecondLevelMappings() && (!this.hasScopeAll(mapping) || !this.hasGoodConfidence(mapping))) continue;
            if (mapping.getDirMapping() == -2 || mapping.getDirMapping() == 0) {
                this.mapping_extractor.addSubMapping2Mappings2Review(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2());
            }
            if (mapping.getDirMapping() != -2 && mapping.getDirMapping() != -1) continue;
            this.mapping_extractor.addSubMapping2Mappings2Review(mapping.getIdentifierOnto2(), mapping.getIdentifierOnto1());
        }
    }

    private void createCandidateMappingsLevel2() throws Exception {
        LogOutput.printAlways("\nCANDIDATE DIAGNOSIS 2");
        if (OracleManager.isActive()) {
            LogOutput.printAlways("Oracle is active for interactivity.");
            this.createCandidateMappingsInteractiveProcess();
        } else {
            LogOutput.printAlways("Oracle is not active. Performing automatic decisions.");
            this.performAutomaticDecisions();
        }
        if (Parameters.second_chance_conflicts) {
            this.secondChanceConflictiveMappingsD_G();
        }
        this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
        if (Parameters.cleanD_G) {
            if (Parameters.extractGlobal_D_G_Info) {
                this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
                this.mappings_assessment.CountSatisfiabilityOfIntegration_DandG(this.mapping_extractor.getMappings2Review());
                LogOutput.printAlways("Time checking satisfiability D&G (s): " + StatisticsTimeMappings.getRunningTime(this.init));
            }
            this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
            this.mappings_assessment.CheckSatisfiabilityOfIntegration_DandG(this.mapping_extractor.getMappings2Review());
            LogOutput.printAlways("Time cleaning interactive mappings D&G (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        }
        this.mapping_extractor.moveMappingsToReview2AnchorList();
        this.mapping_extractor.getMappings2Review().clear();
    }

    private void secondChanceConflictiveMappingsD_G() {
        LogOutput.print("Second chance to mappings discarded by Dowling and Gallier.");
        int second_chance = 0;
        int good_second_chance = 0;
        HashMap toDelete = new HashMap();
        for (int ide1 : this.mapping_extractor.getConflictiveMappings_D_G().keySet()) {
            for (int ide2 : this.mapping_extractor.getConflictiveMappings_D_G().get(ide1)) {
                if (!this.mapping_extractor.isMappingInConflictWithFixedMappings(ide1, ide2)) continue;
                if (!toDelete.containsKey(ide1)) {
                    toDelete.put(ide1, new HashSet());
                }
                ((Set)toDelete.get(ide1)).add(ide2);
            }
        }
        for (int ide1 : toDelete.keySet()) {
            for (int ide2 : (Set)toDelete.get(ide1)) {
                this.mapping_extractor.addSubMapping2ConflictiveAnchors(ide1, ide2);
                this.mapping_extractor.removeSubMappingFromConflictive_D_G(ide1, ide2);
            }
        }
        toDelete.clear();
        for (int ide1 : this.mapping_extractor.getConflictiveMappings_D_G().keySet()) {
            for (int ide2 : this.mapping_extractor.getConflictiveMappings_D_G().get(ide1)) {
                for (int ideA : this.mapping_extractor.getConflictiveMappings_D_G().keySet()) {
                    for (int ideB : this.mapping_extractor.getConflictiveMappings_D_G().get(ideA)) {
                        if (ide1 == ideA && ide2 == ideB || !this.mapping_extractor.areMappingsInConflict(ide1, ide2, ideA, ideB)) continue;
                        if (this.mapping_extractor.getConfidence4Mapping(ide1, ide2) >= this.mapping_extractor.getConfidence4Mapping(ideA, ideB)) {
                            if (!toDelete.containsKey(ideA)) {
                                toDelete.put(ideA, new HashSet());
                            }
                            ((Set)toDelete.get(ideA)).add(ideB);
                            continue;
                        }
                        if (!toDelete.containsKey(ide1)) {
                            toDelete.put(ide1, new HashSet());
                        }
                        ((Set)toDelete.get(ide1)).add(ide2);
                    }
                }
            }
        }
        for (int ide1 : toDelete.keySet()) {
            for (int ide2 : (Set)toDelete.get(ide1)) {
                this.mapping_extractor.addSubMapping2ConflictiveAnchors(ide1, ide2);
                this.mapping_extractor.removeSubMappingFromConflictive_D_G(ide1, ide2);
            }
        }
        toDelete.clear();
        for (int ide1 : this.mapping_extractor.getConflictiveMappings_D_G().keySet()) {
            for (int ide2 : this.mapping_extractor.getConflictiveMappings_D_G().get(ide1)) {
                for (int ideA : this.mapping_extractor.getMappings2Review().keySet()) {
                    for (int ideB : this.mapping_extractor.getMappings2Review().get(ideA)) {
                        if (!this.mapping_extractor.areMappingsInConflict(ide1, ide2, ideA, ideB)) continue;
                        if (!toDelete.containsKey(ideA)) {
                            toDelete.put(ideA, new HashSet());
                        }
                        ((Set)toDelete.get(ideA)).add(ideB);
                    }
                }
                for (int ideA : toDelete.keySet()) {
                    for (int ideB : (Set)toDelete.get(ideA)) {
                        this.mapping_extractor.removeSubMappingFromMappings2Review(ideA, ideB);
                    }
                }
                this.mapping_extractor.addSubMapping2Mappings2Review(ide1, ide2);
                if (this.mapping_extractor.isMappingInGoldStandard(ide1, ide2)) {
                    ++good_second_chance;
                }
                ++second_chance;
            }
        }
        LogOutput.print("Mappings with second chance: " + second_chance + " in GS: " + good_second_chance);
    }

    private void lastLogicalCleaning() {
        if (Parameters.cleanD_G) {
            this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
            this.mapping_extractor.setExactAsFixed(false);
            this.mappings_assessment.CheckSatisfiabilityOfIntegration_DandG(this.mapping_extractor.getLogMapMappings());
            this.mapping_extractor.setExactAsFixed(true);
            LogOutput.printAlways("LAST CLEANING MAPPINGS D&G (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        }
    }

    private void createAndAssessPropertyMappings() {
        this.mapping_extractor.createObjectPropertyAnchors();
        this.mapping_extractor.createDataPropertyAnchors();
        this.onto_process1.clearInvertedFiles4properties();
        this.onto_process2.clearInvertedFiles4properties();
    }

    private void createAndAssessInstanceMappings() {
        for (String uri : Parameters.allowed_instance_types) {
            int type_id = this.onto_process1.getIdentifier4ConceptIRI(uri);
            if (type_id >= 0) {
                this.index.addAllowedInstanceType(type_id);
            }
            if ((type_id = this.onto_process2.getIdentifier4ConceptIRI(uri)) < 0) continue;
            this.index.addAllowedInstanceType(type_id);
        }
        this.mapping_extractor.createInstanceAnchors();
        if (this.mapping_extractor.getInstanceMappings().size() > 0 && Parameters.cleanD_G) {
            this.init = StatisticsTimeMappings.getCurrentTimeInMillis();
            this.mappings_assessment.CheckSatisfiabilityOfIntegration_DandG_Individuals(this.mapping_extractor.getInstanceMappings());
            LogOutput.printAlways("Time cleaning instance mappings D&G (s): " + StatisticsTimeMappings.getRunningTime(this.init));
        }
        this.onto_process1.clearInvertedFiles4Individuals();
        this.onto_process2.clearInvertedFiles4Individuals();
    }

    private void createSignatureFromMappings(Map<Integer, Set<Integer>> mappings) {
        for (int idea : mappings.keySet()) {
            for (int ideb : mappings.get(idea)) {
                if (this.mapping_extractor.isId1SmallerThanId2(idea, ideb)) {
                    this.signature_onto1.add((OWLEntity)this.dataFactory.getOWLClass(this.index.getIRI4ConceptIndex(idea)));
                    this.signature_onto2.add((OWLEntity)this.dataFactory.getOWLClass(this.index.getIRI4ConceptIndex(ideb)));
                    continue;
                }
                if (this.mapping_extractor.isMappingAlreadyInList(ideb, idea)) continue;
                this.signature_onto1.add((OWLEntity)this.dataFactory.getOWLClass(this.index.getIRI4ConceptIndex(ideb)));
                this.signature_onto2.add((OWLEntity)this.dataFactory.getOWLClass(this.index.getIRI4ConceptIndex(idea)));
            }
        }
    }

    private void createOutput4Overlapping(boolean use_discarded) {
        this.createSignatureFromMappings(this.mapping_extractor.getLogMapMappings());
        if (use_discarded) {
            this.createSignatureFromMappings(this.mapping_extractor.getDiscardedMappings());
        }
        ModuleExtractor module_extractor1 = new ModuleExtractor(this.overlappingExtractor.getTBOXOverlappingOnto1(), false, false, true, true, false);
        module_extractor1.getLocalityModuleForSignatureGroup(this.signature_onto1, this.onto_process1.getOntoIRI());
        module_extractor1.saveExtractedModule(this.prefix4IRIs + this.logmap_mappings_path + "/module1_overlapping_logmap2.owl");
        module_extractor1.clearStrutures();
        this.overlappingExtractor.getTBOXOverlappingOnto1().clear();
        this.signature_onto1.clear();
        ModuleExtractor module_extractor2 = new ModuleExtractor(this.overlappingExtractor.getTBOXOverlappingOnto2(), false, false, true, true, false);
        module_extractor2.getLocalityModuleForSignatureGroup(this.signature_onto2, this.onto_process2.getOntoIRI());
        module_extractor2.saveExtractedModule(this.prefix4IRIs + this.logmap_mappings_path + "/module2_overlapping_logmap2.owl");
        module_extractor2.clearStrutures();
        this.overlappingExtractor.getTBOXOverlappingOnto2().clear();
        this.signature_onto2.clear();
    }

    private void saveExtractedMappings(String file_name) {
        OutPutFilesManager outPutFilesManager = new OutPutFilesManager();
        try {
            outPutFilesManager.createOutFiles(this.logmap_mappings_path + "/" + file_name, 4, this.onto_process1.getOntoIRI(), this.onto_process1.getOntoIRI());
            if (Parameters.output_class_mappings) {
                for (int idea : this.mapping_extractor.getLogMapMappings().keySet()) {
                    for (int ideb : this.mapping_extractor.getLogMapMappings().get(idea)) {
                        if (this.mapping_extractor.isId1SmallerThanId2(idea, ideb)) {
                            int dirMapping = this.mapping_extractor.isMappingAlreadyInList(ideb, idea) ? -2 : 0;
                            outPutFilesManager.addClassMapping2Files(this.index.getIRIStr4ConceptIndex(idea), this.index.getIRIStr4ConceptIndex(ideb), dirMapping, this.mapping_extractor.getConfidence4Mapping(idea, ideb));
                            continue;
                        }
                        if (this.mapping_extractor.isMappingAlreadyInList(ideb, idea)) continue;
                        outPutFilesManager.addClassMapping2Files(this.index.getIRIStr4ConceptIndex(ideb), this.index.getIRIStr4ConceptIndex(idea), -1, this.mapping_extractor.getConfidence4Mapping(idea, ideb));
                    }
                }
            }
            if (Parameters.output_prop_mappings) {
                for (int ide1 : this.getDataPropMappings().keySet()) {
                    outPutFilesManager.addDataPropMapping2Files(this.getIRI4DataPropIdentifier(ide1), this.getIRI4DataPropIdentifier(this.getDataPropMappings().get(ide1)), -2, this.getConfidence4DataPropConceptMapping(ide1, this.getDataPropMappings().get(ide1)));
                }
                for (int ide1 : this.getObjectPropMappings().keySet()) {
                    outPutFilesManager.addObjPropMapping2Files(this.getIRI4ObjectPropIdentifier(ide1), this.getIRI4ObjectPropIdentifier(this.getObjectPropMappings().get(ide1)), -2, this.getConfidence4ObjectPropConceptMapping(ide1, this.getObjectPropMappings().get(ide1)));
                }
            }
            if (Parameters.perform_instance_matching && Parameters.output_instance_mappings) {
                for (int ide1 : this.getInstanceMappings().keySet()) {
                    for (int ide2 : this.getInstanceMappings().get(ide1)) {
                        outPutFilesManager.addInstanceMapping2Files(this.getIRI4InstanceIdentifier(ide1), this.getIRI4InstanceIdentifier(ide2), this.getConfidence4InstanceMapping(ide1, ide2));
                    }
                }
            }
            outPutFilesManager.closeAndSaveFiles();
        }
        catch (Exception e) {
            System.err.println("Error saving mappings...");
            e.printStackTrace();
        }
    }

    private void loadMappingsGS() throws Exception {
        ReadFile reader = new ReadFile(this.gs_mappings);
        String line = reader.readLine();
        int wrong = 0;
        while (line != null) {
            if (line.indexOf("|") < 0 && line.indexOf("\t") < 0) {
                line = reader.readLine();
                continue;
            }
            String[] elements = line.indexOf("|") >= 0 ? line.split("\\|") : line.split("\\t");
            int index1 = this.onto_process1.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(elements[0]));
            int index2 = this.onto_process2.getIdentifier4ConceptName(Utilities.getEntityLabelFromURI(elements[1]));
            if (index1 > 0 && index2 > 0) {
                this.mapping_extractor.addMapping2GoldStandardAnchors(index1, index2);
            }
            this.mappings_gs.add(new MappingObjectStr(elements[0], elements[1]));
            this.mapping_extractor.getStringGoldStandardAnchors().add(new MappingObjectStr(elements[0], elements[1]));
            line = reader.readLine();
        }
        reader.closeBuffer();
        LogOutput.printAlways("Wrong mappings: " + wrong);
        LogOutput.printAlways("Gold Standard:" + this.mappings_gs.size());
    }

    public double getPrecision() {
        return this.precision;
    }

    public double getRecall() {
        return this.recall;
    }

    public double getFmeasure() {
        return this.fmeasure;
    }

    public Set<MappingObjectStr> getLogMapMappings() {
        this.mapping_extractor.setStringAnchors(Parameters.output_class_mappings, Parameters.output_prop_mappings, Parameters.output_instance_mappings);
        return this.mapping_extractor.getStringLogMapMappings();
    }

    private void getPrecisionAndRecallMappings() throws Exception {
        this.mapping_extractor.setStringAnchors(Parameters.output_class_mappings, Parameters.output_prop_mappings, Parameters.output_instance_mappings);
        StatisticsManager.setMFinal(this.mapping_extractor.getStringLogMapMappings().size());
        LogOutput.printAlways("MAPPINGS: " + this.mapping_extractor.getStringLogMapMappings().size());
        HashSet<MappingObjectStr> intersection = new HashSet<MappingObjectStr>(this.mapping_extractor.getStringLogMapMappings());
        intersection.retainAll(this.mappings_gs);
        StatisticsManager.setGoodMFinal(intersection.size());
        this.precision = (double)intersection.size() / (double)this.mapping_extractor.getStringLogMapMappings().size();
        this.recall = (double)intersection.size() / (double)this.mappings_gs.size();
        this.fmeasure = 2.0 * this.recall * this.precision / (this.precision + this.recall);
        System.out.println("WRT GS MAPPINGS");
        System.out.println("\tPrecision Mappings: " + this.precision);
        System.out.println("\tRecall Mapping: " + this.recall);
        System.out.println("\tF measure: " + 2.0 * this.recall * this.precision / (this.precision + this.recall));
        LogOutput.print("WRT GS MAPPINGS");
        LogOutput.print("\tPrecision Mappings: " + this.precision);
        LogOutput.print("\tRecall Mapping: " + this.recall);
        LogOutput.print("\tF measure: " + 2.0 * this.recall * this.precision / (this.precision + this.recall));
        HashSet<MappingObjectStr> difference = new HashSet<MappingObjectStr>(this.mappings_gs);
        difference.removeAll(this.mapping_extractor.getStringLogMapMappings());
        LogOutput.printAlways("Difference in GS: " + difference.size());
        LogOutput.printAlways("\tPrinting only the first 250");
        int max_print = 250;
        int prints = 0;
        for (MappingObjectStr mapping : difference) {
            if (++prints < max_print) continue;
            break;
        }
        HashSet<MappingObjectStr> difference2 = new HashSet<MappingObjectStr>(this.mapping_extractor.getStringLogMapMappings());
        difference2.removeAll(this.mappings_gs);
        LogOutput.printAlways("Difference in Candidates: " + difference2.size());
        LogOutput.printAlways("\tPrinting only the first 100");
        max_print = 100;
        prints = 0;
        for (MappingObjectStr mapping : difference2) {
            if (++prints < max_print) continue;
            break;
        }
        StatisticsManager.setMMissing(difference.size());
    }

    private void clearStructures() {
    }

    private void outputInstaceMappings4Evaluation() throws Exception {
        FlatAlignmentFormat good_file = new FlatAlignmentFormat(this.logmap_mappings_path + "/logmap_instance_mappings.txt");
        FlatAlignmentFormat disc1_file = new FlatAlignmentFormat(this.logmap_mappings_path + "/discarded1_instance_mappings.txt");
        FlatAlignmentFormat disc2_file = new FlatAlignmentFormat(this.logmap_mappings_path + "/discarded2_instance_mappings.txt");
        FlatAlignmentFormat incomp_file = new FlatAlignmentFormat(this.logmap_mappings_path + "/incompatible_instance_mappings.txt");
        for (int ide1 : this.mapping_extractor.getInstanceMappings4OutputType().keySet()) {
            for (int ide2 : this.mapping_extractor.getInstanceMappings4OutputType().get(ide1).keySet()) {
                int type = this.mapping_extractor.getInstanceMappings4OutputType().get(ide1).get(ide2);
                if (type == 0) {
                    good_file.addInstanceMapping2Output(this.index.getIRIStr4IndividualIndex(ide1), this.index.getIRIStr4IndividualIndex(ide2), "=", this.mapping_extractor.getISUB4InstanceMapping(ide1, ide2), this.mapping_extractor.getCompFactor4InstanceMapping(ide1, ide2), this.mapping_extractor.getScope4InstanceMapping(ide1, ide2));
                    continue;
                }
                if (type == 1) {
                    disc1_file.addInstanceMapping2Output(this.index.getIRIStr4IndividualIndex(ide1), this.index.getIRIStr4IndividualIndex(ide2), "=", this.mapping_extractor.getISUB4InstanceMapping(ide1, ide2), this.mapping_extractor.getCompFactor4InstanceMapping(ide1, ide2), this.mapping_extractor.getScope4InstanceMapping(ide1, ide2));
                    continue;
                }
                if (type == 2) {
                    disc2_file.addInstanceMapping2Output(this.index.getIRIStr4IndividualIndex(ide1), this.index.getIRIStr4IndividualIndex(ide2), "=", this.mapping_extractor.getISUB4InstanceMapping(ide1, ide2), this.mapping_extractor.getCompFactor4InstanceMapping(ide1, ide2), this.mapping_extractor.getScope4InstanceMapping(ide1, ide2));
                    continue;
                }
                if (type != 3) continue;
                incomp_file.addInstanceMapping2Output(this.index.getIRIStr4IndividualIndex(ide1), this.index.getIRIStr4IndividualIndex(ide2), "=", this.mapping_extractor.getISUB4InstanceMapping(ide1, ide2), this.mapping_extractor.getCompFactor4InstanceMapping(ide1, ide2), this.mapping_extractor.getScope4InstanceMapping(ide1, ide2));
            }
        }
        good_file.saveOutputFile();
        disc1_file.saveOutputFile();
        disc2_file.saveOutputFile();
        incomp_file.saveOutputFile();
    }

    private void outputMappings(Map<Integer, Set<Integer>> mappings, String fileName) throws Exception {
        FlatAlignmentFormat outputFile = new FlatAlignmentFormat(fileName);
        LogOutput.print(fileName);
        for (int idea : mappings.keySet()) {
            for (int ideb : mappings.get(idea)) {
                if (idea >= ideb) continue;
                String inGS = this.mapping_extractor.isMappingInGoldStandard(idea, ideb) ? "YES" : "NO";
                outputFile.addClassMapping2Output(this.index.getName4ConceptIndex(idea), this.index.getName4ConceptIndex(ideb), -2, this.mapping_extractor.getSimWeak4Mapping2(idea, ideb), this.mapping_extractor.extractScopeAll4Mapping(idea, ideb) + "|" + this.mapping_extractor.extractISUB4Mapping(idea, ideb) + "|" + inGS);
            }
        }
        outputFile.saveOutputFile();
    }

    private void orderedOutputMappings(boolean include_discarded) throws Exception {
        String inGS;
        MappingObjectInteractivity mapping;
        TreeSet<MappingObjectInteractivity> ordered_output_mappings = new TreeSet<MappingObjectInteractivity>(new ComparatorConfidence());
        for (int idea : this.mapping_extractor.getLogMapMappings().keySet()) {
            for (int ideb : this.mapping_extractor.getLogMapMappings().get(idea)) {
                if (idea >= ideb) continue;
                ordered_output_mappings.add(new MappingObjectInteractivity(idea, ideb));
            }
        }
        WriteFile writer = new WriteFile("/usr/local/data/DataUMLS/UMLS_Onto_Versions/LUCADA/ordered_output_mappings_NCI2LUCADA.txt");
        writer.writeLine("Label 1|Label 2|IRI 1|IRI 2|Confidence|ISUB (Lex. Sim.)|Scope|IN GS");
        Iterator<MappingObjectInteractivity> it = ordered_output_mappings.descendingIterator();
        while (it.hasNext()) {
            mapping = it.next();
            inGS = this.mapping_extractor.isMappingInGoldStandard(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2()) ? "YES" : "NO";
            writer.writeLine(this.index.getLabel4ConceptIndex(mapping.getIdentifierOnto1()) + "|" + this.index.getLabel4ConceptIndex(mapping.getIdentifierOnto2()) + "|" + this.index.getIRIStr4ConceptIndex(mapping.getIdentifierOnto1()) + "|" + this.index.getIRIStr4ConceptIndex(mapping.getIdentifierOnto2()) + "|" + this.getConfidence(mapping) + "|" + this.mapping_extractor.extractISUB4Mapping(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2()) + "|" + this.mapping_extractor.extractScopeAnchors4Mapping(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2()) + "|" + inGS);
        }
        writer.closeBuffer();
        ordered_output_mappings.clear();
        if (include_discarded) {
            for (int idea : this.mapping_extractor.getHardDiscardedMappings().keySet()) {
                for (int ideb : this.mapping_extractor.getHardDiscardedMappings().get(idea)) {
                    if (idea >= ideb) continue;
                    ordered_output_mappings.add(new MappingObjectInteractivity(idea, ideb));
                }
            }
            writer = new WriteFile("/usr/local/data/DataUMLS/UMLS_Onto_Versions/LUCADA/ordered_harddiscarded_mappings_NCI2LUCADA.txt");
            it = ordered_output_mappings.descendingIterator();
            writer.writeLine("Label 1|Label 2|IRI 1|IRI 2|Confidence|ISUB (Lex. Sim.)|Scope|IN GS");
            while (it.hasNext()) {
                mapping = it.next();
                inGS = this.mapping_extractor.isMappingInGoldStandard(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2()) ? "YES" : "NO";
                writer.writeLine(this.index.getLabel4ConceptIndex(mapping.getIdentifierOnto1()) + "|" + this.index.getLabel4ConceptIndex(mapping.getIdentifierOnto2()) + "|" + this.index.getIRIStr4ConceptIndex(mapping.getIdentifierOnto1()) + "|" + this.index.getIRIStr4ConceptIndex(mapping.getIdentifierOnto2()) + "|" + this.getConfidence(mapping) + "|" + this.mapping_extractor.extractISUB4Mapping(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2()) + "|" + this.mapping_extractor.extractScopeAnchors4Mapping(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2()) + "|" + inGS);
            }
            writer.closeBuffer();
            ordered_output_mappings.clear();
        }
    }

    public Map<Integer, Set<Integer>> getClassMappings() {
        return this.mapping_extractor.getLogMapMappings();
    }

    public Map<Integer, Set<Integer>> getDiscardedClassMappings() {
        return this.mapping_extractor.getDiscardedMappings();
    }

    public Map<Integer, Set<Integer>> getHardDiscardedClassMappings() {
        return this.mapping_extractor.getHardDiscardedMappings();
    }

    public Map<Integer, Set<Integer>> getConflictiveAnchors() {
        return this.mapping_extractor.getConflictiveMappings();
    }

    public Map<Integer, Set<Integer>> getAnchors() {
        return this.mapping_extractor.getAnchors();
    }

    public Map<Integer, Set<Integer>> getLogMapMappings1N() {
        return this.mapping_extractor.getLogMapMappings();
    }

    public int getDirClassMapping(int ide1, int ide2) {
        return this.mapping_extractor.getDirMapping(ide1, ide2);
    }

    public String getIRIOntology1() {
        return this.onto_process1.getOntoIRI();
    }

    public String getIRIOntology2() {
        return this.onto_process2.getOntoIRI();
    }

    public Map<Integer, Integer> getDataPropMappings() {
        return this.mapping_extractor.getDataPropertyAnchors();
    }

    public Map<Integer, Integer> getObjectPropMappings() {
        return this.mapping_extractor.getObjectPropertyAnchors();
    }

    public Map<Integer, Set<Integer>> getInstanceMappings() {
        return this.mapping_extractor.getInstanceMappings();
    }

    public Map<Integer, Map<Integer, Integer>> getInstanceMappings4OutputType() {
        return this.mapping_extractor.getInstanceMappings4OutputType();
    }

    public double getLexicalScore4ConceptMapping(int ide1, int ide2) {
        return this.mapping_extractor.extractISUB4Mapping(ide1, ide2);
    }

    public double getStrutcuralScore4ConceptMapping(int ide1, int ide2) {
        return this.mapping_extractor.extractScopeAnchors4Mapping(ide1, ide2);
    }

    public double getConfidence4ConceptMapping(int ide1, int ide2) {
        return this.mapping_extractor.getConfidence4Mapping(ide1, ide2);
    }

    public double getConfidence4DataPropConceptMapping(int ide1, int ide2) {
        return this.mapping_extractor.getConfidence4DataPropertyAnchor(ide1, ide2);
    }

    public double getConfidence4ObjectPropConceptMapping(int ide1, int ide2) {
        return this.mapping_extractor.getConfidence4ObjectPropertyAnchor(ide1, ide2);
    }

    public double getConfidence4InstanceMapping(int ide1, int ide2) {
        return this.mapping_extractor.getConfidence4InstanceMapping(ide1, ide2);
    }

    public double getLexicalScore4InstanceMapping(int ide1, int ide2) {
        return this.mapping_extractor.extractISUB4InstanceMapping(ide1, ide2);
    }

    public double getStructuralScore4InstanceMapping(int ide1, int ide2) {
        return this.mapping_extractor.extractScope4InstanceMapping(ide1, ide2);
    }

    public String getIRI4ConceptIdentifier(int ide) {
        return this.index.getIRIStr4ConceptIndex(ide);
    }

    public String getLabel4ConceptIdentifier(int ide) {
        return this.index.getLabel4ConceptIndex(ide);
    }

    public String getIRI4DataPropIdentifier(int ide) {
        return this.index.getIRIStr4DataPropIndex(ide);
    }

    public String getIRI4ObjectPropIdentifier(int ide) {
        return this.index.getIRIStr4ObjPropIndex(ide);
    }

    public String getIRI4InstanceIdentifier(int ide) {
        return this.index.getIRIStr4IndividualIndex(ide);
    }

    public void clearIndexStructures() {
        this.index.clearAlternativeLabels4Classes();
        this.index.clearTaxonomicalStructures();
    }

    private double getConfidence(MappingObjectInteractivity m) {
        return this.mapping_extractor.getConfidence4Mapping(m.getIdentifierOnto1(), m.getIdentifierOnto2());
    }

    private class ComparatorConfidence
    implements Comparator<MappingObjectInteractivity> {
        private ComparatorConfidence() {
        }

        @Override
        public int compare(MappingObjectInteractivity m1, MappingObjectInteractivity m2) {
            if (LogMap2Core.this.getConfidence(m1) < LogMap2Core.this.getConfidence(m2)) {
                return -1;
            }
            return 1;
        }
    }
}

