# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by `Samarkand Global <https://samarkand.global>`_ in partnership with `SF Express <https://www.sf- express.com/cn/sc/>`_, `eSinotrans <http://www.esinotrans.com/haitao.html>`_. Read the documentation online at `Nomad API Suite <https://api.samarkand.io/>`_ and Check out the detailed `changelog <https://gitlab.com/samarkand-nomad/nomad_readme/-/raw/master/history/nomad_pilot.md>`_. - Install for node with ``npm install nomad_pilot_cli`` - Install for python with ``pip install nomad-pilot-cli``  # noqa: E501

    The version of the OpenAPI document: 1.31.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class ApiResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'code': 'int',
        'message': 'str',
        'data': 'ApiResponseData',
        'connector_responses': 'list[ApiResponseConnectorResponse]',
        'response_time': 'int'
    }

    attribute_map = {
        'code': 'code',
        'message': 'message',
        'data': 'data',
        'connector_responses': 'connectorResponses',
        'response_time': 'responseTime'
    }

    def __init__(self, code=None, message=None, data=None, connector_responses=None, response_time=None, local_vars_configuration=None):  # noqa: E501
        """ApiResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._code = None
        self._message = None
        self._data = None
        self._connector_responses = None
        self._response_time = None
        self.discriminator = None

        if code is not None:
            self.code = code
        if message is not None:
            self.message = message
        if data is not None:
            self.data = data
        if connector_responses is not None:
            self.connector_responses = connector_responses
        if response_time is not None:
            self.response_time = response_time

    @property
    def code(self):
        """Gets the code of this ApiResponse.  # noqa: E501


        :return: The code of this ApiResponse.  # noqa: E501
        :rtype: int
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this ApiResponse.


        :param code: The code of this ApiResponse.  # noqa: E501
        :type: int
        """

        self._code = code

    @property
    def message(self):
        """Gets the message of this ApiResponse.  # noqa: E501


        :return: The message of this ApiResponse.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this ApiResponse.


        :param message: The message of this ApiResponse.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def data(self):
        """Gets the data of this ApiResponse.  # noqa: E501


        :return: The data of this ApiResponse.  # noqa: E501
        :rtype: ApiResponseData
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this ApiResponse.


        :param data: The data of this ApiResponse.  # noqa: E501
        :type: ApiResponseData
        """

        self._data = data

    @property
    def connector_responses(self):
        """Gets the connector_responses of this ApiResponse.  # noqa: E501


        :return: The connector_responses of this ApiResponse.  # noqa: E501
        :rtype: list[ApiResponseConnectorResponse]
        """
        return self._connector_responses

    @connector_responses.setter
    def connector_responses(self, connector_responses):
        """Sets the connector_responses of this ApiResponse.


        :param connector_responses: The connector_responses of this ApiResponse.  # noqa: E501
        :type: list[ApiResponseConnectorResponse]
        """

        self._connector_responses = connector_responses

    @property
    def response_time(self):
        """Gets the response_time of this ApiResponse.  # noqa: E501

        The response time of current NomadOperation request, including sub-NomadOperation. The time unit is millisecond.  # noqa: E501

        :return: The response_time of this ApiResponse.  # noqa: E501
        :rtype: int
        """
        return self._response_time

    @response_time.setter
    def response_time(self, response_time):
        """Sets the response_time of this ApiResponse.

        The response time of current NomadOperation request, including sub-NomadOperation. The time unit is millisecond.  # noqa: E501

        :param response_time: The response_time of this ApiResponse.  # noqa: E501
        :type: int
        """

        self._response_time = response_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApiResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApiResponse):
            return True

        return self.to_dict() != other.to_dict()
