# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by `Samarkand Global <https://samarkand.global>`_ in partnership with `SF Express <https://www.sf- express.com/cn/sc/>`_, `eSinotrans <http://www.esinotrans.com/haitao.html>`_. Read the documentation online at `Nomad API Suite <https://api.samarkand.io/>`_ and Check out the detailed `changelog <https://gitlab.com/samarkand-nomad/nomad_readme/-/raw/master/history/nomad_pilot.md>`_. - Install for node with ``npm install nomad_pilot_cli`` - Install for python with ``pip install nomad-pilot-cli``  # noqa: E501

    The version of the OpenAPI document: 1.31.0
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from nomad_pilot_cli.api_client import ApiClient
from nomad_pilot_cli.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ShipApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_ship(self, carrier, order_ref, **kwargs):  # noqa: E501
        """cancelShip  # noqa: E501

        Attempts to cancel a created waybill, success will depend on carrier support.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_ship(carrier, order_ref, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: String name of carrier (required)
        :param str order_ref: String name of order ref (by Odoo) (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.cancel_ship_with_http_info(carrier, order_ref, **kwargs)  # noqa: E501

    def cancel_ship_with_http_info(self, carrier, order_ref, **kwargs):  # noqa: E501
        """cancelShip  # noqa: E501

        Attempts to cancel a created waybill, success will depend on carrier support.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_ship_with_http_info(carrier, order_ref, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: String name of carrier (required)
        :param str order_ref: String name of order ref (by Odoo) (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['carrier', 'order_ref']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_ship" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'carrier' is set
        if self.api_client.client_side_validation and ('carrier' not in local_var_params or  # noqa: E501
                                                        local_var_params['carrier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `carrier` when calling `cancel_ship`")  # noqa: E501
        # verify the required parameter 'order_ref' is set
        if self.api_client.client_side_validation and ('order_ref' not in local_var_params or  # noqa: E501
                                                        local_var_params['order_ref'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order_ref` when calling `cancel_ship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier' in local_var_params:
            path_params['carrier'] = local_var_params['carrier']  # noqa: E501
        if 'order_ref' in local_var_params:
            path_params['order_ref'] = local_var_params['order_ref']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key']  # noqa: E501

        return self.api_client.call_api(
            '/ship/{carrier}/order/{order_ref}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_ship(self, carrier, package_put, **kwargs):  # noqa: E501
        """ship  # noqa: E501

        Update waybill details for specified carrier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_ship(carrier, package_put, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: Carrier to ship with (required)
        :param PackagePut package_put: Package to ship (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_ship_with_http_info(carrier, package_put, **kwargs)  # noqa: E501

    def put_ship_with_http_info(self, carrier, package_put, **kwargs):  # noqa: E501
        """ship  # noqa: E501

        Update waybill details for specified carrier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_ship_with_http_info(carrier, package_put, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: Carrier to ship with (required)
        :param PackagePut package_put: Package to ship (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['carrier', 'package_put']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_ship" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'carrier' is set
        if self.api_client.client_side_validation and ('carrier' not in local_var_params or  # noqa: E501
                                                        local_var_params['carrier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `carrier` when calling `put_ship`")  # noqa: E501
        # verify the required parameter 'package_put' is set
        if self.api_client.client_side_validation and ('package_put' not in local_var_params or  # noqa: E501
                                                        local_var_params['package_put'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `package_put` when calling `put_ship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier' in local_var_params:
            path_params['carrier'] = local_var_params['carrier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'package_put' in local_var_params:
            body_params = local_var_params['package_put']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key']  # noqa: E501

        return self.api_client.call_api(
            '/ship/{carrier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_ship(self, carrier, order_ref, **kwargs):  # noqa: E501
        """queryShip  # noqa: E501

        Query the status of an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_ship(carrier, order_ref, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: String name of carrier (required)
        :param str order_ref: order ref (by Odoo) (required)
        :param str seller_order_ref: order ref (by third party retailers, e.g. Youzan)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_ship_with_http_info(carrier, order_ref, **kwargs)  # noqa: E501

    def query_ship_with_http_info(self, carrier, order_ref, **kwargs):  # noqa: E501
        """queryShip  # noqa: E501

        Query the status of an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_ship_with_http_info(carrier, order_ref, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: String name of carrier (required)
        :param str order_ref: order ref (by Odoo) (required)
        :param str seller_order_ref: order ref (by third party retailers, e.g. Youzan)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['carrier', 'order_ref', 'seller_order_ref']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_ship" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'carrier' is set
        if self.api_client.client_side_validation and ('carrier' not in local_var_params or  # noqa: E501
                                                        local_var_params['carrier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `carrier` when calling `query_ship`")  # noqa: E501
        # verify the required parameter 'order_ref' is set
        if self.api_client.client_side_validation and ('order_ref' not in local_var_params or  # noqa: E501
                                                        local_var_params['order_ref'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order_ref` when calling `query_ship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier' in local_var_params:
            path_params['carrier'] = local_var_params['carrier']  # noqa: E501
        if 'order_ref' in local_var_params:
            path_params['order_ref'] = local_var_params['order_ref']  # noqa: E501

        query_params = []
        if 'seller_order_ref' in local_var_params and local_var_params['seller_order_ref'] is not None:  # noqa: E501
            query_params.append(('seller_order_ref', local_var_params['seller_order_ref']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key']  # noqa: E501

        return self.api_client.call_api(
            '/ship/{carrier}/order/{order_ref}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ship(self, carrier, package, **kwargs):  # noqa: E501
        """ship  # noqa: E501

        Requests waybill creation from specified carrier. Receives waybill details in return, most carriers provide id and PDF packing label  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ship(carrier, package, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: Carrier to ship (required)
        :param Package package: Package to ship (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.ship_with_http_info(carrier, package, **kwargs)  # noqa: E501

    def ship_with_http_info(self, carrier, package, **kwargs):  # noqa: E501
        """ship  # noqa: E501

        Requests waybill creation from specified carrier. Receives waybill details in return, most carriers provide id and PDF packing label  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ship_with_http_info(carrier, package, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str carrier: Carrier to ship (required)
        :param Package package: Package to ship (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApiResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['carrier', 'package']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ship" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'carrier' is set
        if self.api_client.client_side_validation and ('carrier' not in local_var_params or  # noqa: E501
                                                        local_var_params['carrier'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `carrier` when calling `ship`")  # noqa: E501
        # verify the required parameter 'package' is set
        if self.api_client.client_side_validation and ('package' not in local_var_params or  # noqa: E501
                                                        local_var_params['package'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `package` when calling `ship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'carrier' in local_var_params:
            path_params['carrier'] = local_var_params['carrier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'package' in local_var_params:
            body_params = local_var_params['package']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ca_key']  # noqa: E501

        return self.api_client.call_api(
            '/ship/{carrier}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
