use pyo3::prelude::*;
use windows::Win32::Graphics::DirectWrite::{
    DWRITE_FONT_STYLE_ITALIC, DWRITE_FONT_STYLE_NORMAL, DWRITE_FONT_STYLE_OBLIQUE,
    DWRITE_FONT_WEIGHT_BLACK, DWRITE_FONT_WEIGHT_BOLD, DWRITE_FONT_WEIGHT_EXTRA_BLACK,
    DWRITE_FONT_WEIGHT_EXTRA_BOLD, DWRITE_FONT_WEIGHT_LIGHT, DWRITE_FONT_WEIGHT_MEDIUM,
    DWRITE_FONT_WEIGHT_REGULAR, DWRITE_FONT_WEIGHT_SEMI_BOLD, DWRITE_FONT_WEIGHT_SEMI_LIGHT,
    DWRITE_FONT_WEIGHT_ULTRA_LIGHT,
};

#[pyclass]
#[allow(non_camel_case_types, clippy::upper_case_acronyms)]
#[repr(i32)]
#[derive(PartialEq, Eq, PartialOrd)]
pub enum Weight {
    ULTRA_LIGHT = DWRITE_FONT_WEIGHT_ULTRA_LIGHT.0,
    LIGHT = DWRITE_FONT_WEIGHT_LIGHT.0,
    SEMI_LIGHT = DWRITE_FONT_WEIGHT_SEMI_LIGHT.0,
    REGULAR = DWRITE_FONT_WEIGHT_REGULAR.0,
    MEDIUM = DWRITE_FONT_WEIGHT_MEDIUM.0,
    SEMI_BOLD = DWRITE_FONT_WEIGHT_SEMI_BOLD.0,
    BOLD = DWRITE_FONT_WEIGHT_BOLD.0,
    EXTRA_BOLD = DWRITE_FONT_WEIGHT_EXTRA_BOLD.0,
    BLACK = DWRITE_FONT_WEIGHT_BLACK.0,
    EXTRA_BLACK = DWRITE_FONT_WEIGHT_EXTRA_BLACK.0,
}

#[pyclass]
#[allow(non_camel_case_types, clippy::upper_case_acronyms)]
#[repr(i32)]
#[derive(PartialEq, Eq)]
pub enum Style {
    NORMAL = DWRITE_FONT_STYLE_NORMAL.0,
    ITALIIC = DWRITE_FONT_STYLE_ITALIC.0,
    OBLIQUE = DWRITE_FONT_STYLE_OBLIQUE.0,
}
