# Copyright (C) 2025 Bloomberg LP
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#  <http://www.apache.org/licenses/LICENSE-2.0>
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Add assigner_name to jobs

Revision ID: d850621a10d8
Revises: fb8afebee8e6
Create Date: 2025-08-25 16:24:59.351051

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "d850621a10d8"
down_revision = "fb8afebee8e6"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.add_column(sa.Column("assigner_name", sa.String(), nullable=True))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_column("assigner_name")

    # ### end Alembic commands ###
