# Copyright (C) 2025 Bloomberg LP
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#  <http://www.apache.org/licenses/LICENSE-2.0>
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Add instance_quotas table

Revision ID: 22cc661efef9
Revises: bde0df23383b
Create Date: 2025-09-15 14:13:24.343839

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "22cc661efef9"
down_revision = "bde0df23383b"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "instance_quotas",
        sa.Column("bot_cohort", sa.String(), nullable=False),
        sa.Column("instance_name", sa.String(), nullable=False),
        sa.Column("min_quota", sa.Integer(), server_default=sa.text("0"), nullable=False),
        sa.Column("max_quota", sa.Integer(), server_default=sa.text("0"), nullable=False),
        sa.Column("current_usage", sa.Integer(), server_default=sa.text("0"), nullable=False),
        sa.PrimaryKeyConstraint("bot_cohort", "instance_name"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("instance_quotas")
    # ### end Alembic commands ###
