# Copyright (C) 2025 Bloomberg LP
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#  <http://www.apache.org/licenses/LICENSE-2.0>
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Add bot_locality_hints table and locality_hint to jobs table

Revision ID: 0596ea8f5c61
Revises: 5745d1f0e537
Create Date: 2025-07-09 09:35:29.046848

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "0596ea8f5c61"
down_revision = "5745d1f0e537"
branch_labels = None
depends_on = None

bot_locality_hints_sequence = sa.Sequence(
    "bot_locality_hints_sequence", start=1, increment=1, data_type=sa.BigInteger, cycle=True
)


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(sa.schema.CreateSequence(bot_locality_hints_sequence))

    op.create_table(
        "bot_locality_hints",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("bot_name", sa.String(), nullable=False),
        sa.Column("locality_hint", sa.String(), nullable=False),
        sa.Column(
            "sequence_number",
            sa.BigInteger(),
            nullable=False,
            server_default=sa.text("nextval('bot_locality_hints_sequence')"),
        ),
        sa.ForeignKeyConstraint(["bot_name"], ["bots.name"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("bot_locality_hints", schema=None) as batch_op:
        batch_op.create_index(
            "ix_bot_locality_hints_bot_name_sequence_number", ["bot_name", "sequence_number"], unique=False
        )
        batch_op.create_index(batch_op.f("ix_bot_locality_hints_locality_hint"), ["locality_hint"], unique=False)

    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.add_column(sa.Column("locality_hint", sa.String(), nullable=True))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_column("locality_hint")

    with op.batch_alter_table("bot_locality_hints", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_bot_locality_hints_locality_hint"))
        batch_op.drop_index("ix_bot_locality_hints_bot_name_sequence_number")

    op.drop_table("bot_locality_hints")

    op.execute(sa.schema.DropSequence(bot_locality_hints_sequence))
    # ### end Alembic commands ###
