"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2018 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import buildgrid._protos.google.rpc.status_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Task(google.protobuf.message.Message):
    """DEPRECATED - use Lease.payload instead.
    A Task represents a unit of work. Its result and logs are defined as
    subresources.

    If all the `Any` fields are populated, this can be a very large message, and
    clients may not want the entire message returned on every call to every
    method. Such clients should request partial responses
    (https://cloud.google.com/apis/design/design_patterns#partial_response) and
    servers should implement partial responses in order to reduce unnecessry
    overhead.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class LogsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LOGS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of this task. Output only."""
    @property
    def description(self) -> google.protobuf.any_pb2.Any:
        """The actual task to perform. For example, this could be CommandTask to run a
        command line.
        """
    @property
    def logs(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Handles to logs. The key is a human-readable name like `stdout`, and the
        handle is a resource name that can be passed to ByteStream or other
        accessors.

        An implementation may define some logs by default (like `stdout`), and may
        allow clients to add new logs via AddTaskLog.
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: google.protobuf.any_pb2.Any | None = ...,
        logs: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["description", b"description"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "logs", b"logs", "name", b"name"]) -> None: ...

global___Task = Task

@typing_extensions.final
class TaskResult(google.protobuf.message.Message):
    """DEPRECATED - use Lease.assignment_result instead.
    The result and metadata of the task.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    COMPLETE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    OUTPUT_FIELD_NUMBER: builtins.int
    META_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the task result; must be a name of a `Task` followed by
    `/result`.
    """
    complete: builtins.bool
    """The result may be updated several times; the client must only set
    `complete` to true to indicate that no further updates are allowed.
    If this is not true, the `status` field must not be examined since its zero
    value is equivalent to `OK`.

    Once a task is completed, it must not be updated with further results,
    though the implementation may choose to continue to receive logs.
    """
    @property
    def status(self) -> buildgrid._protos.google.rpc.status_pb2.Status:
        """The final status of the task itself. For example, if task.description
        included a timeout which was violated, status.code may be
        DEADLINE_EXCEEDED. This field can only be read if `complete` is true.
        """
    @property
    def output(self) -> google.protobuf.any_pb2.Any:
        """Any non-log output, such as output files and exit codes. See
        CommandResult as an example.
        """
    @property
    def meta(self) -> google.protobuf.any_pb2.Any:
        """Any information about how the command was executed, eg runtime. See
        CommandOverhead as an example.
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        complete: builtins.bool = ...,
        status: buildgrid._protos.google.rpc.status_pb2.Status | None = ...,
        output: google.protobuf.any_pb2.Any | None = ...,
        meta: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["meta", b"meta", "output", b"output", "status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["complete", b"complete", "meta", b"meta", "name", b"name", "output", b"output", "status", b"status"]) -> None: ...

global___TaskResult = TaskResult

@typing_extensions.final
class GetTaskRequest(google.protobuf.message.Message):
    """Request message for `GetTask`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The task name."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetTaskRequest = GetTaskRequest

@typing_extensions.final
class UpdateTaskResultRequest(google.protobuf.message.Message):
    """Request message for `UpdateTaskResult`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    RESULT_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    SOURCE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The task result name; must match `result.name`."""
    @property
    def result(self) -> global___TaskResult:
        """The result being updated."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The fields within `result` that are specified."""
    source: builtins.str
    """If this is being updated by a bot from BotManager, the source should be
    bot.session_id. That way, if two bots accidentally get the same name, we'll
    know to reject updates from the older one.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        result: global___TaskResult | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        source: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["result", b"result", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "result", b"result", "source", b"source", "update_mask", b"update_mask"]) -> None: ...

global___UpdateTaskResultRequest = UpdateTaskResultRequest

@typing_extensions.final
class AddTaskLogRequest(google.protobuf.message.Message):
    """Request message for `AddTaskLog`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    LOG_ID_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the task that will own the new log."""
    log_id: builtins.str
    """The human-readable name of the log, like `stdout` or a relative file path."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        log_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["log_id", b"log_id", "name", b"name"]) -> None: ...

global___AddTaskLogRequest = AddTaskLogRequest

@typing_extensions.final
class AddTaskLogResponse(google.protobuf.message.Message):
    """Response message for `AddTaskLog`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HANDLE_FIELD_NUMBER: builtins.int
    handle: builtins.str
    """The handle for the new log, as would be returned in Task.logs."""
    def __init__(
        self,
        *,
        handle: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["handle", b"handle"]) -> None: ...

global___AddTaskLogResponse = AddTaskLogResponse
