"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2018 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import buildgrid._protos.google.devtools.remoteworkers.v1test2.worker_pb2
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import buildgrid._protos.google.rpc.status_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _BotStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BotStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BotStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BOT_STATUS_UNSPECIFIED: _BotStatus.ValueType  # 0
    """Default value; do not use."""
    OK: _BotStatus.ValueType  # 1
    """The bot is healthy, and will accept leases as normal."""
    UNHEALTHY: _BotStatus.ValueType  # 2
    """The bot is unhealthy and will not accept new leases. For example, the bot
    may have detected that available disk space is too low. This situation may
    resolve itself, but will typically require human intervention.
    """
    HOST_REBOOTING: _BotStatus.ValueType  # 3
    """The bot has been asked to reboot the host. The bot will not accept new
    leases; once all leases are complete, this session will no longer be
    updated but the bot will be expected to establish a new session after the
    reboot completes.
    """
    BOT_TERMINATING: _BotStatus.ValueType  # 4
    """The bot has been asked to shut down. As with HOST_REBOOTING, once all
    leases are completed, the session will no longer be updated and the bot
    will not be expected to establish a new session.

    Bots are typically only asked to shut down if its host computer will be
    modified in some way, such as deleting a VM.
    """

class BotStatus(_BotStatus, metaclass=_BotStatusEnumTypeWrapper):
    """A coarse description of the status of the bot that the server uses to
    determine whether to assign the bot new leases.
    """

BOT_STATUS_UNSPECIFIED: BotStatus.ValueType  # 0
"""Default value; do not use."""
OK: BotStatus.ValueType  # 1
"""The bot is healthy, and will accept leases as normal."""
UNHEALTHY: BotStatus.ValueType  # 2
"""The bot is unhealthy and will not accept new leases. For example, the bot
may have detected that available disk space is too low. This situation may
resolve itself, but will typically require human intervention.
"""
HOST_REBOOTING: BotStatus.ValueType  # 3
"""The bot has been asked to reboot the host. The bot will not accept new
leases; once all leases are complete, this session will no longer be
updated but the bot will be expected to establish a new session after the
reboot completes.
"""
BOT_TERMINATING: BotStatus.ValueType  # 4
"""The bot has been asked to shut down. As with HOST_REBOOTING, once all
leases are completed, the session will no longer be updated and the bot
will not be expected to establish a new session.

Bots are typically only asked to shut down if its host computer will be
modified in some way, such as deleting a VM.
"""
global___BotStatus = BotStatus

class _LeaseState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LeaseStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LeaseState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LEASE_STATE_UNSPECIFIED: _LeaseState.ValueType  # 0
    """Default value; do not use."""
    PENDING: _LeaseState.ValueType  # 1
    """Pending: the server expects the bot to accept this lease. This may only be
    set by the server.
    """
    ACTIVE: _LeaseState.ValueType  # 2
    """Active: the bot has accepted this lease. This may only be set by the bot."""
    COMPLETED: _LeaseState.ValueType  # 4
    """Completed: the bot is no longer leased. This may only be set by the bot,
    and the status field must be populated iff the state is COMPLETED.
    """
    CANCELLED: _LeaseState.ValueType  # 5
    """Cancelled: The bot should immediately release all resources associated with
    the lease. This may only be set by the server.
    """

class LeaseState(_LeaseState, metaclass=_LeaseStateEnumTypeWrapper):
    """The state of the lease. All leases start in the PENDING state. A bot can
    change PENDING to ACTIVE or (in the case of an error) COMPLETED, or from
    ACTIVE to COMPLETED. The server can change PENDING or ACTIVE to CANCELLED if
    it wants the bot to release its resources - for example, if the bot needs to
    be quarantined (it's producing bad output) or a cell needs to be drained.
    """

LEASE_STATE_UNSPECIFIED: LeaseState.ValueType  # 0
"""Default value; do not use."""
PENDING: LeaseState.ValueType  # 1
"""Pending: the server expects the bot to accept this lease. This may only be
set by the server.
"""
ACTIVE: LeaseState.ValueType  # 2
"""Active: the bot has accepted this lease. This may only be set by the bot."""
COMPLETED: LeaseState.ValueType  # 4
"""Completed: the bot is no longer leased. This may only be set by the bot,
and the status field must be populated iff the state is COMPLETED.
"""
CANCELLED: LeaseState.ValueType  # 5
"""Cancelled: The bot should immediately release all resources associated with
the lease. This may only be set by the server.
"""
global___LeaseState = LeaseState

@typing_extensions.final
class BotSession(google.protobuf.message.Message):
    """A bot session represents the state of a bot while in continuous contact with
    the server for a period of time. The session includes information about the
    worker - that is, the *worker* (the physical or virtual hardware) is
    considered to be a property of the bot (the software agent running on that
    hardware), which is the reverse of real life, but more natural from the point
    of the view of this API, which communicates solely with the bot and not
    directly with the underlying worker.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    BOT_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    WORKER_FIELD_NUMBER: builtins.int
    LEASES_FIELD_NUMBER: builtins.int
    EXPIRE_TIME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The bot session name, as selected by the server. Output only during a call
    to CreateBotSession.
    """
    bot_id: builtins.str
    """A unique bot ID within the farm used to persistently identify this bot over
    time (i.e., over multiple sessions). This ID must be unique within a
    farm. Typically, the bot ID will be the same as the name of the primary
    device in the worker (e.g., what you'd get from typing `uname -n` on *nix),
    but this is not required since a single device may allow multiple bots to
    run on it, each with access to different resources. What is important is
    that this ID is meaningful to humans, who might need to hunt a physical
    machine down to fix it.

    When CreateBotSession is successfully called with a bot_id, all prior
    sessions with the same ID are invalidated. If a bot attempts to update an
    invalid session, the server must reject that request, and may also
    quarantine the other bot with the same bot IDs (ie, stop sending it new
    leases and alert an admin).
    """
    status: global___BotStatus.ValueType
    """The status of the bot. This must be populated in every call to
    UpdateBotSession.
    """
    @property
    def worker(self) -> buildgrid._protos.google.devtools.remoteworkers.v1test2.worker_pb2.Worker:
        """A description of the worker hosting this bot. The Worker message is used
        here in the Status context (see Worker for more information).  If multiple
        bots are running on the worker, this field should only describe the
        resources accessible from this bot.

        During the call to CreateBotSession, the server may make arbitrary changes
        to the worker's `server_properties` field (see that field for more
        information). Otherwise, this field is input-only.
        """
    @property
    def leases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Lease]:
        """A list of all leases that are a part of this session. See the Lease message
        for details.
        """
    @property
    def expire_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which this bot session will expire, unless the bot calls
        UpdateBotSession again. Output only.
        """
    version: builtins.str
    """The version of the bot code currently running. The server may use this
    information to issue an admin action to tell the bot to update itself.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        bot_id: builtins.str = ...,
        status: global___BotStatus.ValueType = ...,
        worker: buildgrid._protos.google.devtools.remoteworkers.v1test2.worker_pb2.Worker | None = ...,
        leases: collections.abc.Iterable[global___Lease] | None = ...,
        expire_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["expire_time", b"expire_time", "worker", b"worker"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bot_id", b"bot_id", "expire_time", b"expire_time", "leases", b"leases", "name", b"name", "status", b"status", "version", b"version", "worker", b"worker"]) -> None: ...

global___BotSession = BotSession

@typing_extensions.final
class Lease(google.protobuf.message.Message):
    """A Lease is a lease that the scheduler has assigned to this bot. If the bot
    notices (by UpdateBotSession) that it has any leases in the PENDING state, it
    should call UpdateBotSession to put the leases into the ACTIVE state and
    start executing their assignments.

    All fields in this message are output-only, *except* the `state` and `status`
    fields. Note that repeated fields can only be updated as a unit, so on every
    update the bot must provide an update for *all* the leases the server expects
    it to report on.

    The scheduler *should* ensure that all leases scheduled to a bot can actually
    be accepted, but race conditions may occur. In such cases, the bot should
    attempt to accept the leases in the order they are listed by the server, to
    allow the server to control priorities.

    The server will remove COMPLETED leases from time to time, after which the
    bot shouldn't report on them any more (the server will ignore superfluous
    COMPLETED records).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    RESULT_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    REQUIREMENTS_FIELD_NUMBER: builtins.int
    EXPIRE_TIME_FIELD_NUMBER: builtins.int
    ASSIGNMENT_FIELD_NUMBER: builtins.int
    INLINE_ASSIGNMENT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """A short string uniquely identifing the lease within this bot session."""
    @property
    def payload(self) -> google.protobuf.any_pb2.Any:
        """The actual work to be performed, if any. May be omitted by the server if
        the lease is not in the `PENDING` state. The message must be meaningful to
        the bot. Output only (must only be set by the server).
        """
    @property
    def result(self) -> google.protobuf.any_pb2.Any:
        """Any result the bot wishes to provide about the lease. Must not be changed
        after the first call with the lease in the `COMPLETED` or `CANCELLED`
        state. Input only (must only be set by the bot, will not be echoed by the
        server).
        """
    state: global___LeaseState.ValueType
    """The state of the lease. See LeaseState for more information."""
    @property
    def status(self) -> buildgrid._protos.google.rpc.status_pb2.Status:
        """The final status of the lease (should be populated by the bot if the state
        is completed). This is the status of the lease, not of any task represented
        by the lease. For example, if the bot could not accept the lease because it
        asked for some resource the bot didn't have, this status will be
        FAILED_PRECONDITION. But if the assignment in the lease didn't execute
        correctly, this field will be `OK` while the failure of the assignment must
        communicated via the `result` field.
        """
    @property
    def requirements(self) -> buildgrid._protos.google.devtools.remoteworkers.v1test2.worker_pb2.Worker:
        """The requirements that are being claimed by this lease. This field may be
        omitted by the server if the lease is not pending.
        """
    @property
    def expire_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which this lease expires. The server *may* extend this over
        time, but due to race conditions, the bot is not *required* to respect any
        expiry date except the first one.
        """
    assignment: builtins.str
    """DEPRECATED. The assignment should be provided to the bot via the `payload`
    field. Clients that wish to use a simple name (such as a queue of work
    provided elsewhere) should define a custom message type and encode it into
    `payload`.
    """
    @property
    def inline_assignment(self) -> google.protobuf.any_pb2.Any:
        """DEPRECATED. Use `payload` instead."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        payload: google.protobuf.any_pb2.Any | None = ...,
        result: google.protobuf.any_pb2.Any | None = ...,
        state: global___LeaseState.ValueType = ...,
        status: buildgrid._protos.google.rpc.status_pb2.Status | None = ...,
        requirements: buildgrid._protos.google.devtools.remoteworkers.v1test2.worker_pb2.Worker | None = ...,
        expire_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        assignment: builtins.str = ...,
        inline_assignment: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["expire_time", b"expire_time", "inline_assignment", b"inline_assignment", "payload", b"payload", "requirements", b"requirements", "result", b"result", "status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["assignment", b"assignment", "expire_time", b"expire_time", "id", b"id", "inline_assignment", b"inline_assignment", "payload", b"payload", "requirements", b"requirements", "result", b"result", "state", b"state", "status", b"status"]) -> None: ...

global___Lease = Lease

@typing_extensions.final
class AdminTemp(google.protobuf.message.Message):
    """AdminTemp is a prelimiary set of administration tasks. It's called "Temp"
    because we do not yet know the best way to represent admin tasks; it's
    possible that this will be entirely replaced in later versions of this API.
    If this message proves to be sufficient, it will be renamed in the alpha or
    beta release of this API.

    This message (suitably marshalled into a protobuf.Any) can be used as the
    inline_assignment field in a lease; the lease assignment field should simply
    be `"admin"` in these cases.

    This message is heavily based on Swarming administration tasks from the LUCI
    project (http://github.com/luci/luci-py/appengine/swarming).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Command:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _CommandEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AdminTemp._Command.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: AdminTemp._Command.ValueType  # 0
        """Illegal value."""
        BOT_UPDATE: AdminTemp._Command.ValueType  # 1
        """Download and run a new version of the bot. `arg` will be a resource
        accessible via `ByteStream.Read` to obtain the new bot code.
        """
        BOT_RESTART: AdminTemp._Command.ValueType  # 2
        """Restart the bot without downloading a new version. `arg` will be a
        message to log.
        """
        BOT_TERMINATE: AdminTemp._Command.ValueType  # 3
        """Shut down the bot. `arg` will be a task resource name (similar to those
        in tasks.proto) that the bot can use to tell the server that it is
        terminating.
        """
        HOST_RESTART: AdminTemp._Command.ValueType  # 4
        """Restart the host computer. `arg` will be a message to log."""

    class Command(_Command, metaclass=_CommandEnumTypeWrapper):
        """Possible administration actions."""

    UNSPECIFIED: AdminTemp.Command.ValueType  # 0
    """Illegal value."""
    BOT_UPDATE: AdminTemp.Command.ValueType  # 1
    """Download and run a new version of the bot. `arg` will be a resource
    accessible via `ByteStream.Read` to obtain the new bot code.
    """
    BOT_RESTART: AdminTemp.Command.ValueType  # 2
    """Restart the bot without downloading a new version. `arg` will be a
    message to log.
    """
    BOT_TERMINATE: AdminTemp.Command.ValueType  # 3
    """Shut down the bot. `arg` will be a task resource name (similar to those
    in tasks.proto) that the bot can use to tell the server that it is
    terminating.
    """
    HOST_RESTART: AdminTemp.Command.ValueType  # 4
    """Restart the host computer. `arg` will be a message to log."""

    COMMAND_FIELD_NUMBER: builtins.int
    ARG_FIELD_NUMBER: builtins.int
    command: global___AdminTemp.Command.ValueType
    """The admin action; see `Command` for legal values."""
    arg: builtins.str
    """The argument to the admin action; see `Command` for semantics."""
    def __init__(
        self,
        *,
        command: global___AdminTemp.Command.ValueType = ...,
        arg: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["arg", b"arg", "command", b"command"]) -> None: ...

global___AdminTemp = AdminTemp

@typing_extensions.final
class CreateBotSessionRequest(google.protobuf.message.Message):
    """Request message for CreateBotSession."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    BOT_SESSION_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """The farm resource."""
    @property
    def bot_session(self) -> global___BotSession:
        """The bot session to create. Server-assigned fields like name must be unset."""
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
        bot_session: global___BotSession | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bot_session", b"bot_session"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bot_session", b"bot_session", "parent", b"parent"]) -> None: ...

global___CreateBotSessionRequest = CreateBotSessionRequest

@typing_extensions.final
class UpdateBotSessionRequest(google.protobuf.message.Message):
    """Request message for UpdateBotSession."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    BOT_SESSION_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The bot session name. Must match bot_session.name."""
    @property
    def bot_session(self) -> global___BotSession:
        """The bot session resource to update."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The fields on the bot that should be updated. See the BotSession resource
        for which fields are updatable by which caller.
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        bot_session: global___BotSession | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bot_session", b"bot_session", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bot_session", b"bot_session", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateBotSessionRequest = UpdateBotSessionRequest

@typing_extensions.final
class PostBotEventTempRequest(google.protobuf.message.Message):
    """Request message for PostBotEventTemp"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PostBotEventTempRequest._Type.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: PostBotEventTempRequest._Type.ValueType  # 0
        """Illegal value."""
        INFO: PostBotEventTempRequest._Type.ValueType  # 1
        """Interesting but harmless event."""
        ERROR: PostBotEventTempRequest._Type.ValueType  # 2
        """Error condition."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper):
        """Types of bot events."""

    UNSPECIFIED: PostBotEventTempRequest.Type.ValueType  # 0
    """Illegal value."""
    INFO: PostBotEventTempRequest.Type.ValueType  # 1
    """Interesting but harmless event."""
    ERROR: PostBotEventTempRequest.Type.ValueType  # 2
    """Error condition."""

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    MSG_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The bot session name."""
    type: global___PostBotEventTempRequest.Type.ValueType
    """The type of bot event."""
    msg: builtins.str
    """A human-readable message."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: global___PostBotEventTempRequest.Type.ValueType = ...,
        msg: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["msg", b"msg", "name", b"name", "type", b"type"]) -> None: ...

global___PostBotEventTempRequest = PostBotEventTempRequest
