"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import abc
import collections.abc
import buildgrid._protos.google.devtools.build.v1.publish_build_event_pb2
import google.protobuf.empty_pb2
import grpc.aio as grpc
import typing

class PublishBuildEventStub:
    """A service for publishing BuildEvents. BuildEvents are generated by Build
    Systems to record actions taken during a Build. Events occur in streams,
    are identified by a StreamId, and ordered by sequence number in a stream.

    A Build may contain several streams of BuildEvents, depending on the systems
    that are involved in the Build. Some BuildEvents are used to declare the
    beginning and end of major portions of a Build; these are called
    LifecycleEvents, and are used (for example) to indicate the beginning or end
    of a Build, and the beginning or end of an Invocation attempt (there can be
    more than 1 Invocation in a Build if, for example, a failure occurs somewhere
    and it needs to be retried).

    Other, build-tool events represent actions taken by the Build tool, such as
    target objects produced via compilation, tests run, et cetera. There could be
    more than one build tool stream for an invocation attempt of a build.
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    PublishLifecycleEvent: grpc.UnaryUnaryMultiCallable[
        buildgrid._protos.google.devtools.build.v1.publish_build_event_pb2.PublishLifecycleEventRequest,
        google.protobuf.empty_pb2.Empty,
    ]
    """Publish a build event stating the new state of a build (typically from the
    build queue). The BuildEnqueued event must be publishd before all other
    events for the same build ID.

    The backend will persist the event and deliver it to registered frontend
    jobs immediately without batching.

    The commit status of the request is reported by the RPC's util_status()
    function. The error code is the canoncial error code defined in
    //util/task/codes.proto.
    """
    PublishBuildToolEventStream: grpc.StreamStreamMultiCallable[
        buildgrid._protos.google.devtools.build.v1.publish_build_event_pb2.PublishBuildToolEventStreamRequest,
        buildgrid._protos.google.devtools.build.v1.publish_build_event_pb2.PublishBuildToolEventStreamResponse,
    ]
    """Publish build tool events belonging to the same stream to a backend job
    using bidirectional streaming.
    """

class PublishBuildEventServicer(metaclass=abc.ABCMeta):
    """A service for publishing BuildEvents. BuildEvents are generated by Build
    Systems to record actions taken during a Build. Events occur in streams,
    are identified by a StreamId, and ordered by sequence number in a stream.

    A Build may contain several streams of BuildEvents, depending on the systems
    that are involved in the Build. Some BuildEvents are used to declare the
    beginning and end of major portions of a Build; these are called
    LifecycleEvents, and are used (for example) to indicate the beginning or end
    of a Build, and the beginning or end of an Invocation attempt (there can be
    more than 1 Invocation in a Build if, for example, a failure occurs somewhere
    and it needs to be retried).

    Other, build-tool events represent actions taken by the Build tool, such as
    target objects produced via compilation, tests run, et cetera. There could be
    more than one build tool stream for an invocation attempt of a build.
    """

    @abc.abstractmethod
    async def PublishLifecycleEvent(
        self,
        request: buildgrid._protos.google.devtools.build.v1.publish_build_event_pb2.PublishLifecycleEventRequest,
        context: grpc.ServicerContext[typing.Any, typing.Any],
    ) -> google.protobuf.empty_pb2.Empty:
        """Publish a build event stating the new state of a build (typically from the
        build queue). The BuildEnqueued event must be publishd before all other
        events for the same build ID.

        The backend will persist the event and deliver it to registered frontend
        jobs immediately without batching.

        The commit status of the request is reported by the RPC's util_status()
        function. The error code is the canoncial error code defined in
        //util/task/codes.proto.
        """
    @abc.abstractmethod
    async def PublishBuildToolEventStream(
        self,
        request_iterator: collections.abc.Iterator[buildgrid._protos.google.devtools.build.v1.publish_build_event_pb2.PublishBuildToolEventStreamRequest],
        context: grpc.ServicerContext[typing.Any, typing.Any],
    ) -> collections.abc.Iterator[buildgrid._protos.google.devtools.build.v1.publish_build_event_pb2.PublishBuildToolEventStreamResponse]:
        """Publish build tool events belonging to the same stream to a backend job
        using bidirectional streaming.
        """

def add_PublishBuildEventServicer_to_server(servicer: PublishBuildEventServicer, server: grpc.Server) -> None: ...
