"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright (C) 2021 Bloomberg LP

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class ExecutionStatistics(google.protobuf.message.Message):
    """Message containing metrics about the execution of a command. To be attached
    to `build.bazel.remote.execution.v2.ExecutedActionMetadata.auxiliary_metadata`.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ProcessResourceUsage(google.protobuf.message.Message):
        """Values gathered from `getrusage(2)`."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        UTIME_FIELD_NUMBER: builtins.int
        STIME_FIELD_NUMBER: builtins.int
        MAXRSS_FIELD_NUMBER: builtins.int
        MINFLT_FIELD_NUMBER: builtins.int
        MAJFLT_FIELD_NUMBER: builtins.int
        INBLOCK_FIELD_NUMBER: builtins.int
        OUBLOCK_FIELD_NUMBER: builtins.int
        NVCSW_FIELD_NUMBER: builtins.int
        NIVCSW_FIELD_NUMBER: builtins.int
        @property
        def utime(self) -> google.protobuf.duration_pb2.Duration:
            """User CPU time used"""
        @property
        def stime(self) -> google.protobuf.duration_pb2.Duration:
            """System CPU time used"""
        maxrss: builtins.int
        """Maximum resident set size used [kb]"""
        minflt: builtins.int
        """Number of page faults serviced without I/O activity (reclaims)"""
        majflt: builtins.int
        """Number of page faults serviced that required I/O activity (faults)"""
        inblock: builtins.int
        """Number of times the filesystem performed inputs/outputs"""
        oublock: builtins.int
        nvcsw: builtins.int
        """Number of voluntary/involuntary context switches"""
        nivcsw: builtins.int
        def __init__(
            self,
            *,
            utime: google.protobuf.duration_pb2.Duration | None = ...,
            stime: google.protobuf.duration_pb2.Duration | None = ...,
            maxrss: builtins.int = ...,
            minflt: builtins.int = ...,
            majflt: builtins.int = ...,
            inblock: builtins.int = ...,
            oublock: builtins.int = ...,
            nvcsw: builtins.int = ...,
            nivcsw: builtins.int = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["stime", b"stime", "utime", b"utime"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["inblock", b"inblock", "majflt", b"majflt", "maxrss", b"maxrss", "minflt", b"minflt", "nivcsw", b"nivcsw", "nvcsw", b"nvcsw", "oublock", b"oublock", "stime", b"stime", "utime", b"utime"]) -> None: ...

    COMMAND_RUSAGE_FIELD_NUMBER: builtins.int
    @property
    def command_rusage(self) -> global___ExecutionStatistics.ProcessResourceUsage:
        """`getrusage()` measurements from the command's execution"""
    def __init__(
        self,
        *,
        command_rusage: global___ExecutionStatistics.ProcessResourceUsage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["command_rusage", b"command_rusage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["command_rusage", b"command_rusage"]) -> None: ...

global___ExecutionStatistics = ExecutionStatistics
