import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::RUM::AppMonitor`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html
 */
export interface CfnAppMonitorProps {
    /**
     * `AWS::RUM::AppMonitor.AppMonitorConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-appmonitorconfiguration
     */
    readonly appMonitorConfiguration?: CfnAppMonitor.AppMonitorConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::RUM::AppMonitor.CwLogEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-cwlogenabled
     */
    readonly cwLogEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::RUM::AppMonitor.Domain`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-domain
     */
    readonly domain?: string;
    /**
     * `AWS::RUM::AppMonitor.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-name
     */
    readonly name?: string;
    /**
     * `AWS::RUM::AppMonitor.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RUM::AppMonitor`.
 *
 * @external
 * @cloudformationResource AWS::RUM::AppMonitor
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html
 */
export declare class CfnAppMonitor extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RUM::AppMonitor";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAppMonitor;
    /**
     * `AWS::RUM::AppMonitor.AppMonitorConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-appmonitorconfiguration
     */
    appMonitorConfiguration: CfnAppMonitor.AppMonitorConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::RUM::AppMonitor.CwLogEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-cwlogenabled
     */
    cwLogEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RUM::AppMonitor.Domain`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-domain
     */
    domain: string | undefined;
    /**
     * `AWS::RUM::AppMonitor.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-name
     */
    name: string | undefined;
    /**
     * `AWS::RUM::AppMonitor.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html#cfn-rum-appmonitor-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RUM::AppMonitor`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnAppMonitorProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RUM::AppMonitor`.
 *
 * @external
 * @cloudformationResource AWS::RUM::AppMonitor
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rum-appmonitor.html
 */
export declare namespace CfnAppMonitor {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html
     */
    interface AppMonitorConfigurationProperty {
        /**
         * `CfnAppMonitor.AppMonitorConfigurationProperty.AllowCookies`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-allowcookies
         */
        readonly allowCookies?: boolean | cdk.IResolvable;
        /**
         * `CfnAppMonitor.AppMonitorConfigurationProperty.EnableXRay`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-enablexray
         */
        readonly enableXRay?: boolean | cdk.IResolvable;
        /**
         * `CfnAppMonitor.AppMonitorConfigurationProperty.ExcludedPages`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-excludedpages
         */
        readonly excludedPages?: string[];
        /**
         * `CfnAppMonitor.AppMonitorConfigurationProperty.FavoritePages`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-favoritepages
         */
        readonly favoritePages?: string[];
        /**
         * `CfnAppMonitor.AppMonitorConfigurationProperty.GuestRoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-guestrolearn
         */
        readonly guestRoleArn?: string;
        /**
         * `CfnAppMonitor.AppMonitorConfigurationProperty.IdentityPoolId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-identitypoolid
         */
        readonly identityPoolId?: string;
        /**
         * `CfnAppMonitor.AppMonitorConfigurationProperty.IncludedPages`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-includedpages
         */
        readonly includedPages?: string[];
        /**
         * `CfnAppMonitor.AppMonitorConfigurationProperty.SessionSampleRate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-sessionsamplerate
         */
        readonly sessionSampleRate?: number;
        /**
         * `CfnAppMonitor.AppMonitorConfigurationProperty.Telemetries`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rum-appmonitor-appmonitorconfiguration.html#cfn-rum-appmonitor-appmonitorconfiguration-telemetries
         */
        readonly telemetries?: string[];
    }
}
