"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceFactory = void 0;
const cloudform_types_1 = require("cloudform-types");
const graphql_mapping_template_1 = require("graphql-mapping-template");
const graphql_transformer_common_1 = require("graphql-transformer-common");
const graphQlApi_1 = __importStar(require("cloudform-types/types/appSync/graphQlApi"));
const constants_1 = require("./constants");
function replaceIfUsername(identityClaim) {
    return identityClaim === 'username' ? 'cognito:username' : identityClaim;
}
function isUsername(identityClaim) {
    return identityClaim === 'username';
}
class ResourceFactory {
    constructor() {
        this.getSourceMapper = (includeVersion) => {
            if (includeVersion) {
                return [
                    graphql_mapping_template_1.set(graphql_mapping_template_1.ref('row'), graphql_mapping_template_1.methodCall(graphql_mapping_template_1.ref('entry.get'), graphql_mapping_template_1.str('_source'))),
                    graphql_mapping_template_1.qref('$row.put("_version", $entry.get("_version"))'),
                    graphql_mapping_template_1.qref('$es_items.add($row)'),
                ];
            }
            return [graphql_mapping_template_1.qref('$es_items.add($entry.get("_source"))')];
        };
    }
    makeParams() {
        return {
            [graphql_transformer_common_1.ResourceConstants.PARAMETERS.AppSyncApiName]: new cloudform_types_1.StringParameter({
                Description: 'The name of the AppSync API',
                Default: 'AppSyncSimpleTransform',
            }),
            [graphql_transformer_common_1.ResourceConstants.PARAMETERS.APIKeyExpirationEpoch]: new cloudform_types_1.NumberParameter({
                Description: 'The epoch time in seconds when the API Key should expire.' +
                    ' Setting this to 0 will default to 7 days from the deployment date.' +
                    ' Setting this to -1 will not create an API Key.',
                Default: 0,
                MinValue: -1,
            }),
            [graphql_transformer_common_1.ResourceConstants.PARAMETERS.CreateAPIKey]: new cloudform_types_1.NumberParameter({
                Description: 'The boolean value to control if an API Key will be created or not.' +
                    ' The value of the property is automatically set by the CLI.' +
                    ' If the value is set to 0 no API Key will be created.',
                Default: 0,
                MinValue: 0,
                MaxValue: 1,
            }),
            [graphql_transformer_common_1.ResourceConstants.PARAMETERS.AuthCognitoUserPoolId]: new cloudform_types_1.StringParameter({
                Description: 'The id of an existing User Pool to connect. If this is changed, a user pool will not be created for you.',
                Default: graphql_transformer_common_1.ResourceConstants.NONE,
            }),
        };
    }
    initTemplate(apiKeyConfig) {
        return {
            Parameters: this.makeParams(),
            Resources: {
                [graphql_transformer_common_1.ResourceConstants.RESOURCES.APIKeyLogicalID]: this.makeAppSyncApiKey(apiKeyConfig),
            },
            Outputs: {
                [graphql_transformer_common_1.ResourceConstants.OUTPUTS.GraphQLAPIApiKeyOutput]: this.makeApiKeyOutput(),
            },
            Conditions: {
                [graphql_transformer_common_1.ResourceConstants.CONDITIONS.ShouldCreateAPIKey]: cloudform_types_1.Fn.Equals(cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.CreateAPIKey), 1),
                [graphql_transformer_common_1.ResourceConstants.CONDITIONS.APIKeyExpirationEpochIsPositive]: cloudform_types_1.Fn.And([
                    cloudform_types_1.Fn.Not(cloudform_types_1.Fn.Equals(cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.APIKeyExpirationEpoch), -1)),
                    cloudform_types_1.Fn.Not(cloudform_types_1.Fn.Equals(cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.APIKeyExpirationEpoch), 0)),
                ]),
            },
        };
    }
    makeAppSyncApiKey(apiKeyConfig) {
        let expirationDays = 7;
        if (apiKeyConfig && apiKeyConfig.apiKeyExpirationDays) {
            expirationDays = apiKeyConfig.apiKeyExpirationDays;
        }
        let expirationDateInSeconds = 60 * 60 * 24 * expirationDays;
        if (expirationDays === 1)
            expirationDateInSeconds += 60 * 2;
        const nowEpochTime = Math.floor(Date.now() / 1000);
        return new cloudform_types_1.AppSync.ApiKey({
            ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
            Description: apiKeyConfig && apiKeyConfig.description ? apiKeyConfig.description : undefined,
            Expires: cloudform_types_1.Fn.If(graphql_transformer_common_1.ResourceConstants.CONDITIONS.APIKeyExpirationEpochIsPositive, cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.APIKeyExpirationEpoch), nowEpochTime + expirationDateInSeconds),
        }).condition(graphql_transformer_common_1.ResourceConstants.CONDITIONS.ShouldCreateAPIKey);
    }
    makeApiKeyOutput() {
        return {
            Description: "Your GraphQL API key. Provide via 'x-api-key' header.",
            Value: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.APIKeyLogicalID, 'ApiKey'),
            Export: {
                Name: cloudform_types_1.Fn.Join(':', [cloudform_types_1.Refs.StackName, 'GraphQLApiKey']),
            },
            Condition: graphql_transformer_common_1.ResourceConstants.CONDITIONS.ShouldCreateAPIKey,
        };
    }
    updateGraphQLAPIWithAuth(apiRecord, authConfig) {
        let properties = {
            ...apiRecord.Properties,
            Name: apiRecord.Properties.Name,
            AuthenticationType: authConfig.defaultAuthentication.authenticationType,
            UserPoolConfig: undefined,
            OpenIDConnectConfig: undefined,
        };
        switch (authConfig.defaultAuthentication.authenticationType) {
            case 'AMAZON_COGNITO_USER_POOLS':
                properties.UserPoolConfig = new graphQlApi_1.UserPoolConfig({
                    UserPoolId: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.AuthCognitoUserPoolId),
                    AwsRegion: cloudform_types_1.Refs.Region,
                    DefaultAction: 'ALLOW',
                });
                break;
            case 'OPENID_CONNECT':
                if (!authConfig.defaultAuthentication.openIDConnectConfig) {
                    throw new Error('openIDConnectConfig is not configured for defaultAuthentication');
                }
                properties.OpenIDConnectConfig = this.assignOpenIDConnectConfig(authConfig.defaultAuthentication.openIDConnectConfig);
                break;
        }
        if (authConfig.additionalAuthenticationProviders && authConfig.additionalAuthenticationProviders.length > 0) {
            const additionalAuthenticationProviders = new Array();
            for (const sourceProvider of authConfig.additionalAuthenticationProviders) {
                let provider;
                switch (sourceProvider.authenticationType) {
                    case 'AMAZON_COGNITO_USER_POOLS':
                        provider = {
                            AuthenticationType: 'AMAZON_COGNITO_USER_POOLS',
                            UserPoolConfig: new graphQlApi_1.UserPoolConfig({
                                UserPoolId: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.AuthCognitoUserPoolId),
                                AwsRegion: cloudform_types_1.Refs.Region,
                            }),
                        };
                        break;
                    case 'API_KEY':
                        provider = {
                            AuthenticationType: 'API_KEY',
                        };
                        break;
                    case 'AWS_IAM':
                        provider = {
                            AuthenticationType: 'AWS_IAM',
                        };
                        break;
                    case 'OPENID_CONNECT':
                        if (!sourceProvider.openIDConnectConfig) {
                            throw new Error('openIDConnectConfig is not configured for provider');
                        }
                        provider = {
                            AuthenticationType: 'OPENID_CONNECT',
                            OpenIDConnectConfig: this.assignOpenIDConnectConfig(sourceProvider.openIDConnectConfig),
                        };
                        break;
                }
                additionalAuthenticationProviders.push(provider);
            }
            properties.AdditionalAuthenticationProviders = additionalAuthenticationProviders;
        }
        return new graphQlApi_1.default(properties);
    }
    assignOpenIDConnectConfig(config) {
        return new graphQlApi_1.OpenIDConnectConfig({
            Issuer: config.issuerUrl,
            ClientId: config.clientId,
            IatTTL: config.iatTTL,
            AuthTTL: config.authTTL,
        });
    }
    blankResolver(type, field) {
        return new cloudform_types_1.AppSync.Resolver({
            ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
            DataSourceName: 'NONE',
            FieldName: field,
            TypeName: type,
            RequestMappingTemplate: graphql_mapping_template_1.print(graphql_mapping_template_1.obj({
                version: graphql_mapping_template_1.str(graphql_mapping_template_1.RESOLVER_VERSION_ID),
                payload: graphql_mapping_template_1.obj({}),
            })),
            ResponseMappingTemplate: graphql_mapping_template_1.print(graphql_mapping_template_1.ref(`util.toJson($context.source.${field})`)),
        });
    }
    noneDataSource() {
        return new cloudform_types_1.AppSync.DataSource({
            ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
            Name: 'NONE',
            Type: 'NONE',
        });
    }
    staticGroupAuthorizationExpression(rules, field) {
        if (!rules || rules.length === 0) {
            return graphql_mapping_template_1.comment(`No Static Group Authorization Rules`);
        }
        const variableToSet = this.getStaticAuthorizationVariable(field);
        let groupAuthorizationExpressions = [];
        for (const rule of rules) {
            const groups = rule.groups;
            const groupClaimAttribute = rule.groupClaim || constants_1.DEFAULT_GROUP_CLAIM;
            if (groups) {
                groupAuthorizationExpressions = groupAuthorizationExpressions.concat(graphql_mapping_template_1.comment(`Authorization rule: { allow: groups, groups: ${JSON.stringify(groups)}, groupClaim: "${groupClaimAttribute}" }`), this.setUserGroups(rule.groupClaim), graphql_mapping_template_1.set(graphql_mapping_template_1.ref('allowedGroups'), graphql_mapping_template_1.list(groups.map(s => graphql_mapping_template_1.str(s)))), graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('userGroup'), graphql_mapping_template_1.ref('userGroups'), [
                    graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$allowedGroups.contains($userGroup)`), graphql_mapping_template_1.compoundExpression([graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true')), graphql_mapping_template_1.raw('#break')])),
                ]));
            }
        }
        const staticGroupAuthorizedVariable = this.getStaticAuthorizationVariable(field);
        return graphql_mapping_template_1.block('Static Group Authorization Checks', [
            graphql_mapping_template_1.raw(`#set($${staticGroupAuthorizedVariable} = $util.defaultIfNull(
            $${staticGroupAuthorizedVariable}, false))`),
            ...groupAuthorizationExpressions,
        ]);
    }
    dynamicGroupAuthorizationExpressionForCreateOperations(rules, variableToCheck = 'ctx.args.input', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsDynamicGroupAuthorizedVariable) {
        if (!rules || rules.length === 0) {
            return graphql_mapping_template_1.comment(`No Dynamic Group Authorization Rules`);
        }
        return graphql_mapping_template_1.block('Dynamic Group Authorization Checks', [
            this.dynamicAuthorizationExpressionForCreate(rules, variableToCheck, variableToSet),
        ]);
    }
    dynamicGroupAuthorizationExpressionForCreateOperationsByField(rules, fieldToCheck, variableToCheck = 'ctx.args.input', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsDynamicGroupAuthorizedVariable) {
        if (!rules || rules.length === 0) {
            return graphql_mapping_template_1.comment(`No dynamic group authorization rules for field "${fieldToCheck}"`);
        }
        let groupAuthorizationExpression = this.dynamicAuthorizationExpressionForCreate(rules, variableToCheck, variableToSet, rule => `Authorization rule on field "${fieldToCheck}": { allow: ${rule.allow}, \
groupsField: "${rule.groupsField || constants_1.DEFAULT_GROUPS_FIELD}", groupClaim: "${rule.groupClaim || constants_1.DEFAULT_GROUP_CLAIM}" }`);
        return graphql_mapping_template_1.block(`Dynamic group authorization rules for field "${fieldToCheck}"`, [groupAuthorizationExpression]);
    }
    dynamicAuthorizationExpressionForCreate(rules, variableToCheck = 'ctx.args.input', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsDynamicGroupAuthorizedVariable, formatComment) {
        let groupAuthorizationExpressions = [];
        for (const rule of rules) {
            const groupsAttribute = rule.groupsField || constants_1.DEFAULT_GROUPS_FIELD;
            const groupClaimAttribute = rule.groupClaim || constants_1.DEFAULT_GROUP_CLAIM;
            groupAuthorizationExpressions = groupAuthorizationExpressions.concat(formatComment
                ? graphql_mapping_template_1.comment(formatComment(rule))
                : graphql_mapping_template_1.comment(`Authorization rule: { allow: ${rule.allow}, groupsField: "${groupsAttribute}", groupClaim: "${groupClaimAttribute}"`), this.setUserGroups(rule.groupClaim), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw(`$util.defaultIfNull($${variableToSet}, false)`)), graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('userGroup'), graphql_mapping_template_1.ref('userGroups'), [
                graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$util.isList($ctx.args.input.${groupsAttribute})`), graphql_mapping_template_1.iff(graphql_mapping_template_1.ref(`${variableToCheck}.${groupsAttribute}.contains($userGroup)`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true')))),
                graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$util.isString($ctx.args.input.${groupsAttribute})`), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$ctx.args.input.${groupsAttribute} == $userGroup`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true')))),
            ]));
        }
        return graphql_mapping_template_1.compoundExpression(groupAuthorizationExpressions);
    }
    ownerAuthorizationExpressionForCreateOperations(rules, fieldIsList, variableToCheck = 'ctx.args.input', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsOwnerAuthorizedVariable) {
        if (!rules || rules.length === 0) {
            return graphql_mapping_template_1.comment(`No Owner Authorization Rules`);
        }
        return graphql_mapping_template_1.block('Owner Authorization Checks', [
            this.ownershipAuthorizationExpressionForCreate(rules, fieldIsList, variableToCheck, variableToSet),
        ]);
    }
    ownerAuthorizationExpressionForSubscriptions(rules, variableToCheck = 'ctx.args', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsOwnerAuthorizedVariable) {
        if (!rules || rules.length === 0) {
            return graphql_mapping_template_1.comment(`No Owner Authorization Rules`);
        }
        return graphql_mapping_template_1.block('Owner Authorization Checks', [
            this.ownershipAuthorizationExpressionForSubscriptions(rules, variableToCheck, variableToSet),
        ]);
    }
    ownershipAuthorizationExpressionForSubscriptions(rules, variableToCheck = 'ctx.args', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsOwnerAuthorizedVariable, formatComment) {
        let ownershipAuthorizationExpressions = [];
        let ruleNumber = 0;
        for (const rule of rules) {
            const ownerAttribute = rule.ownerField || constants_1.DEFAULT_OWNER_FIELD;
            const rawUsername = rule.identityField || rule.identityClaim || constants_1.DEFAULT_IDENTITY_FIELD;
            const isUser = isUsername(rawUsername);
            const identityAttribute = replaceIfUsername(rawUsername);
            const allowedOwnersVariable = `allowedOwners${ruleNumber}`;
            ownershipAuthorizationExpressions = ownershipAuthorizationExpressions.concat(formatComment
                ? graphql_mapping_template_1.comment(formatComment(rule))
                : graphql_mapping_template_1.comment(`Authorization rule: { allow: ${rule.allow}, ownerField: "${ownerAttribute}", identityClaim: "${identityAttribute}" }`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(allowedOwnersVariable), graphql_mapping_template_1.raw(`$util.defaultIfNull($${variableToCheck}.${ownerAttribute}, null)`)), isUser
                ?
                    graphql_mapping_template_1.set(graphql_mapping_template_1.ref('identityValue'), graphql_mapping_template_1.raw(`$util.defaultIfNull($ctx.identity.claims.get("${rawUsername}"),
                        $util.defaultIfNull($ctx.identity.claims.get("${identityAttribute}"), "${graphql_transformer_common_1.NONE_VALUE}"))`))
                : graphql_mapping_template_1.set(graphql_mapping_template_1.ref('identityValue'), graphql_mapping_template_1.raw(`$util.defaultIfNull($ctx.identity.claims.get("${identityAttribute}"), "${graphql_transformer_common_1.NONE_VALUE}")`)), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$util.isList($${allowedOwnersVariable})`), graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('allowedOwner'), graphql_mapping_template_1.ref(allowedOwnersVariable), [
                graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$allowedOwner == $identityValue`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true'))),
            ])), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$util.isString($${allowedOwnersVariable})`), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$${allowedOwnersVariable} == $identityValue`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true')))));
            ruleNumber++;
        }
        return graphql_mapping_template_1.compoundExpression([graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw(`false`)), ...ownershipAuthorizationExpressions]);
    }
    ownerAuthorizationExpressionForCreateOperationsByField(rules, fieldToCheck, fieldIsList, variableToCheck = 'ctx.args.input', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsOwnerAuthorizedVariable) {
        if (!rules || rules.length === 0) {
            return graphql_mapping_template_1.comment(`No Owner Authorization Rules`);
        }
        return graphql_mapping_template_1.block(`Owner authorization rules for field "${fieldToCheck}"`, [
            this.ownershipAuthorizationExpressionForCreate(rules, fieldIsList, variableToCheck, variableToSet, rule => `Authorization rule: { allow: ${rule.allow}, \
ownerField: "${rule.ownerField || constants_1.DEFAULT_OWNER_FIELD}", \
identityClaim: "${rule.identityField || rule.identityClaim || constants_1.DEFAULT_IDENTITY_FIELD}" }`),
        ]);
    }
    ownershipAuthorizationExpressionForCreate(rules, fieldIsList, variableToCheck = 'ctx.args.input', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsOwnerAuthorizedVariable, formatComment) {
        let ownershipAuthorizationExpressions = [];
        let ruleNumber = 0;
        for (const rule of rules) {
            const ownerAttribute = rule.ownerField || constants_1.DEFAULT_OWNER_FIELD;
            const rawUsername = rule.identityField || rule.identityClaim || constants_1.DEFAULT_IDENTITY_FIELD;
            const isUser = isUsername(rawUsername);
            const identityAttribute = replaceIfUsername(rawUsername);
            const ownerFieldIsList = fieldIsList(ownerAttribute);
            const allowedOwnersVariable = `allowedOwners${ruleNumber}`;
            ownershipAuthorizationExpressions = ownershipAuthorizationExpressions.concat(formatComment
                ? graphql_mapping_template_1.comment(formatComment(rule))
                : graphql_mapping_template_1.comment(`Authorization rule: { allow: ${rule.allow}, ownerField: "${ownerAttribute}", identityClaim: "${identityAttribute}" }`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(allowedOwnersVariable), graphql_mapping_template_1.raw(`$util.defaultIfNull($${variableToCheck}.${ownerAttribute}, null)`)), isUser
                ?
                    graphql_mapping_template_1.set(graphql_mapping_template_1.ref('identityValue'), graphql_mapping_template_1.raw(`$util.defaultIfNull($ctx.identity.claims.get("${rawUsername}"), $util.defaultIfNull($ctx.identity.claims.get("${identityAttribute}"), "${graphql_transformer_common_1.NONE_VALUE}"))`))
                : graphql_mapping_template_1.set(graphql_mapping_template_1.ref('identityValue'), graphql_mapping_template_1.raw(`$util.defaultIfNull($ctx.identity.claims.get("${identityAttribute}"), "${graphql_transformer_common_1.NONE_VALUE}")`)), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$util.isList($${allowedOwnersVariable})`), graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('allowedOwner'), graphql_mapping_template_1.ref(allowedOwnersVariable), [
                graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$allowedOwner == $identityValue`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true'))),
            ])), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$util.isString($${allowedOwnersVariable})`), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$${allowedOwnersVariable} == $identityValue`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true')))));
            if (!ownerFieldIsList) {
                ownershipAuthorizationExpressions.push(graphql_mapping_template_1.iff(graphql_mapping_template_1.and([graphql_mapping_template_1.raw(`$util.isNull($${allowedOwnersVariable})`), graphql_mapping_template_1.parens(graphql_mapping_template_1.raw(`! $${variableToCheck}.containsKey("${ownerAttribute}")`))]), graphql_mapping_template_1.compoundExpression([
                    graphql_mapping_template_1.qref(`$${variableToCheck}.put("${ownerAttribute}", $identityValue)`),
                    graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true')),
                ])));
            }
            else {
                ownershipAuthorizationExpressions.push(graphql_mapping_template_1.iff(graphql_mapping_template_1.and([graphql_mapping_template_1.raw(`$util.isNull($${allowedOwnersVariable})`), graphql_mapping_template_1.parens(graphql_mapping_template_1.raw(`! $${variableToCheck}.containsKey("${ownerAttribute}")`))]), graphql_mapping_template_1.compoundExpression([
                    graphql_mapping_template_1.qref(`$${variableToCheck}.put("${ownerAttribute}", ["$identityValue"])`),
                    graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true')),
                ])));
            }
            ruleNumber++;
        }
        return graphql_mapping_template_1.compoundExpression([graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw(`false`)), ...ownershipAuthorizationExpressions]);
    }
    dynamicGroupAuthorizationExpressionForUpdateOrDeleteOperations(rules, fieldIsList, fieldBeingProtected, variableToCheck = 'ctx.args.input', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsDynamicGroupAuthorizedVariable) {
        const fieldMention = fieldBeingProtected ? ` for field "${fieldBeingProtected}"` : '';
        if (!rules || rules.length === 0) {
            return graphql_mapping_template_1.comment(`No dynamic group authorization rules${fieldMention}`);
        }
        let groupAuthorizationExpressions = [];
        let ruleNumber = 0;
        for (const rule of rules) {
            const groupsAttribute = rule.groupsField || constants_1.DEFAULT_GROUPS_FIELD;
            const groupsAttributeName = fieldBeingProtected
                ? `${fieldBeingProtected}_groupsAttribute${ruleNumber}`
                : `groupsAttribute${ruleNumber}`;
            const groupName = fieldBeingProtected ? `${fieldBeingProtected}_group${ruleNumber}` : `group${ruleNumber}`;
            const groupClaimAttribute = rule.groupClaim || constants_1.DEFAULT_GROUP_CLAIM;
            const groupsFieldIsList = fieldIsList(groupsAttribute);
            groupAuthorizationExpressions = groupAuthorizationExpressions.concat(graphql_mapping_template_1.comment(`Authorization rule${fieldMention}: { allow: ${rule.allow}, groupsField: "${groupsAttribute}", groupClaim: "${groupClaimAttribute}"}`), this.setUserGroups(rule.groupClaim), graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('userGroup'), graphql_mapping_template_1.ref('userGroups'), [
                groupsFieldIsList
                    ? graphql_mapping_template_1.raw(`$util.qr($groupAuthExpressions.add("contains(#${groupsAttributeName}, :${groupName}$foreach.count)"))`)
                    : graphql_mapping_template_1.raw(`$util.qr($groupAuthExpressions.add("#${groupsAttributeName} = :${groupName}$foreach.count"))`),
                graphql_mapping_template_1.raw(`$util.qr($groupAuthExpressionValues.put(":${groupName}$foreach.count", { "S": $userGroup }))`),
            ]), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw('$userGroups.size() > 0'), graphql_mapping_template_1.raw(`$util.qr($groupAuthExpressionNames.put("#${groupsAttributeName}", "${groupsAttribute}"))`)));
            ruleNumber++;
        }
        return graphql_mapping_template_1.block('Dynamic group authorization checks', [
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('groupAuthExpressions'), graphql_mapping_template_1.list([])),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('groupAuthExpressionValues'), graphql_mapping_template_1.obj({})),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('groupAuthExpressionNames'), graphql_mapping_template_1.obj({})),
            ...groupAuthorizationExpressions,
        ]);
    }
    ownerAuthorizationExpressionForUpdateOrDeleteOperations(rules, fieldIsList, fieldBeingProtected, variableToCheck = 'ctx.args.input', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsOwnerAuthorizedVariable) {
        const fieldMention = fieldBeingProtected ? ` for field "${fieldBeingProtected}"` : '';
        if (!rules || rules.length === 0) {
            return graphql_mapping_template_1.comment(`No owner authorization rules${fieldMention}`);
        }
        let ownerAuthorizationExpressions = [];
        let ruleNumber = 0;
        for (const rule of rules) {
            const ownerAttribute = rule.ownerField || constants_1.DEFAULT_OWNER_FIELD;
            const rawUsername = rule.identityField || rule.identityClaim || constants_1.DEFAULT_IDENTITY_FIELD;
            const isUser = isUsername(rawUsername);
            const identityAttribute = replaceIfUsername(rawUsername);
            const ownerFieldIsList = fieldIsList(ownerAttribute);
            const ownerName = fieldBeingProtected ? `${fieldBeingProtected}_owner${ruleNumber}` : `owner${ruleNumber}`;
            const identityName = fieldBeingProtected ? `${fieldBeingProtected}_identity${ruleNumber}` : `identity${ruleNumber}`;
            ownerAuthorizationExpressions.push(graphql_mapping_template_1.comment(`Authorization rule${fieldMention}: { allow: ${rule.allow}, ownerField: "${ownerAttribute}", identityClaim: "${identityAttribute}" }`));
            if (ownerFieldIsList) {
                ownerAuthorizationExpressions.push(graphql_mapping_template_1.raw(`$util.qr($ownerAuthExpressions.add("contains(#${ownerName}, :${identityName})"))`));
            }
            else {
                ownerAuthorizationExpressions.push(graphql_mapping_template_1.raw(`$util.qr($ownerAuthExpressions.add("#${ownerName} = :${identityName}"))`));
            }
            ownerAuthorizationExpressions = ownerAuthorizationExpressions.concat(graphql_mapping_template_1.raw(`$util.qr($ownerAuthExpressionNames.put("#${ownerName}", "${ownerAttribute}"))`), isUser
                ? graphql_mapping_template_1.raw(`$util.qr($ownerAuthExpressionValues.put(":${identityName}", $util.dynamodb.toDynamoDB($util.defaultIfNull($ctx.identity.claims.get("${rawUsername}"), $util.defaultIfNull($ctx.identity.claims.get("${identityAttribute}"), "${graphql_transformer_common_1.NONE_VALUE}")))))`)
                : graphql_mapping_template_1.raw(`$util.qr($ownerAuthExpressionValues.put(":${identityName}", $util.dynamodb.toDynamoDB($util.defaultIfNull($ctx.identity.claims.get("${identityAttribute}"), "${graphql_transformer_common_1.NONE_VALUE}"))))`));
            ruleNumber++;
        }
        return graphql_mapping_template_1.block('Owner Authorization Checks', [
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('ownerAuthExpressions'), graphql_mapping_template_1.list([])),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('ownerAuthExpressionValues'), graphql_mapping_template_1.obj({})),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('ownerAuthExpressionNames'), graphql_mapping_template_1.obj({})),
            ...ownerAuthorizationExpressions,
        ]);
    }
    dynamicGroupAuthorizationExpressionForReadOperations(rules, variableToCheck = 'ctx.result', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsDynamicGroupAuthorizedVariable, defaultValue = graphql_mapping_template_1.raw(`$util.defaultIfNull($${variableToSet}, false)`)) {
        if (!rules || rules.length === 0) {
            return graphql_mapping_template_1.comment(`No Dynamic Group Authorization Rules`);
        }
        let groupAuthorizationExpressions = [];
        for (const rule of rules) {
            const groupsAttribute = rule.groupsField || constants_1.DEFAULT_GROUPS_FIELD;
            const groupClaimAttribute = rule.groupClaim || constants_1.DEFAULT_GROUP_CLAIM;
            groupAuthorizationExpressions = groupAuthorizationExpressions.concat(graphql_mapping_template_1.comment(`Authorization rule: { allow: ${rule.allow}, groupsField: "${groupsAttribute}", groupClaim: "${groupClaimAttribute}" }`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref('allowedGroups'), graphql_mapping_template_1.ref(`util.defaultIfNull($${variableToCheck}.${groupsAttribute}, [])`)), this.setUserGroups(rule.groupClaim), graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('userGroup'), graphql_mapping_template_1.ref('userGroups'), [
                graphql_mapping_template_1.iff(graphql_mapping_template_1.raw('$util.isList($allowedGroups)'), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$allowedGroups.contains($userGroup)`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true')))),
                graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$util.isString($allowedGroups)`), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$allowedGroups == $userGroup`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true')))),
            ]));
        }
        return graphql_mapping_template_1.block('Dynamic Group Authorization Checks', [graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), defaultValue), ...groupAuthorizationExpressions]);
    }
    ownerAuthorizationExpressionForReadOperations(rules, variableToCheck = 'ctx.result', variableToSet = graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsOwnerAuthorizedVariable, defaultValue = graphql_mapping_template_1.raw(`$util.defaultIfNull($${variableToSet}, false)`)) {
        if (!rules || rules.length === 0) {
            return graphql_mapping_template_1.comment(`No Owner Authorization Rules`);
        }
        let ownerAuthorizationExpressions = [];
        let ruleNumber = 0;
        for (const rule of rules) {
            const ownerAttribute = rule.ownerField || constants_1.DEFAULT_OWNER_FIELD;
            const rawUsername = rule.identityField || rule.identityClaim || constants_1.DEFAULT_IDENTITY_FIELD;
            const isUser = isUsername(rawUsername);
            const identityAttribute = replaceIfUsername(rawUsername);
            const allowedOwnersVariable = `allowedOwners${ruleNumber}`;
            ownerAuthorizationExpressions = ownerAuthorizationExpressions.concat(graphql_mapping_template_1.comment(`Authorization rule: { allow: ${rule.allow}, ownerField: "${ownerAttribute}", identityClaim: "${identityAttribute}" }`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(allowedOwnersVariable), graphql_mapping_template_1.ref(`util.defaultIfNull($${variableToCheck}.${ownerAttribute}, [])`)), isUser
                ?
                    graphql_mapping_template_1.set(graphql_mapping_template_1.ref('identityValue'), graphql_mapping_template_1.raw(`$util.defaultIfNull($ctx.identity.claims.get("${rawUsername}"), $util.defaultIfNull($ctx.identity.claims.get("${identityAttribute}"), "${graphql_transformer_common_1.NONE_VALUE}"))`))
                : graphql_mapping_template_1.set(graphql_mapping_template_1.ref('identityValue'), graphql_mapping_template_1.raw(`$util.defaultIfNull($ctx.identity.claims.get("${identityAttribute}"), "${graphql_transformer_common_1.NONE_VALUE}")`)), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$util.isList($${allowedOwnersVariable})`), graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('allowedOwner'), graphql_mapping_template_1.ref(allowedOwnersVariable), [
                graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$allowedOwner == $identityValue`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true'))),
            ])), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$util.isString($${allowedOwnersVariable})`), graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$${allowedOwnersVariable} == $identityValue`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), graphql_mapping_template_1.raw('true')))));
            ruleNumber++;
        }
        return graphql_mapping_template_1.block('Owner Authorization Checks', [graphql_mapping_template_1.set(graphql_mapping_template_1.ref(variableToSet), defaultValue), ...ownerAuthorizationExpressions]);
    }
    throwIfSubscriptionUnauthorized() {
        const ifUnauthThrow = graphql_mapping_template_1.iff(graphql_mapping_template_1.not(graphql_mapping_template_1.parens(graphql_mapping_template_1.or([
            graphql_mapping_template_1.equals(graphql_mapping_template_1.ref(graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsStaticGroupAuthorizedVariable), graphql_mapping_template_1.raw('true')),
            graphql_mapping_template_1.equals(graphql_mapping_template_1.ref(graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsOwnerAuthorizedVariable), graphql_mapping_template_1.raw('true')),
        ]))), graphql_mapping_template_1.raw('$util.unauthorized()'));
        return graphql_mapping_template_1.block('Throw if unauthorized', [ifUnauthThrow]);
    }
    throwIfUnauthorized(field) {
        const staticGroupAuthorizedVariable = this.getStaticAuthorizationVariable(field);
        const ifUnauthThrow = graphql_mapping_template_1.iff(graphql_mapping_template_1.not(graphql_mapping_template_1.parens(graphql_mapping_template_1.or([
            graphql_mapping_template_1.equals(graphql_mapping_template_1.ref(staticGroupAuthorizedVariable), graphql_mapping_template_1.raw('true')),
            graphql_mapping_template_1.equals(graphql_mapping_template_1.ref(graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsDynamicGroupAuthorizedVariable), graphql_mapping_template_1.raw('true')),
            graphql_mapping_template_1.equals(graphql_mapping_template_1.ref(graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsOwnerAuthorizedVariable), graphql_mapping_template_1.raw('true')),
        ]))), graphql_mapping_template_1.raw('$util.unauthorized()'));
        return graphql_mapping_template_1.block('Throw if unauthorized', [ifUnauthThrow]);
    }
    returnIfEmpty(objectPath) {
        return graphql_mapping_template_1.iff(graphql_mapping_template_1.isNullOrEmpty(graphql_mapping_template_1.ref(objectPath)), graphql_mapping_template_1.ret());
    }
    throwIfStaticGroupUnauthorized(field) {
        const staticGroupAuthorizedVariable = this.getStaticAuthorizationVariable(field);
        const ifUnauthThrow = graphql_mapping_template_1.iff(graphql_mapping_template_1.equals(graphql_mapping_template_1.ref(staticGroupAuthorizedVariable), graphql_mapping_template_1.raw('false')), graphql_mapping_template_1.raw('$util.unauthorized()'));
        return graphql_mapping_template_1.block('Throw if unauthorized', [ifUnauthThrow]);
    }
    throwIfNotStaticGroupAuthorizedOrAuthConditionIsEmpty(field) {
        const staticGroupAuthorizedVariable = this.getStaticAuthorizationVariable(field);
        const ifUnauthThrow = graphql_mapping_template_1.iff(graphql_mapping_template_1.not(graphql_mapping_template_1.parens(graphql_mapping_template_1.or([graphql_mapping_template_1.equals(graphql_mapping_template_1.ref(staticGroupAuthorizedVariable), graphql_mapping_template_1.raw('true')), graphql_mapping_template_1.parens(graphql_mapping_template_1.raw('$totalAuthExpression != ""'))]))), graphql_mapping_template_1.raw('$util.unauthorized()'));
        return graphql_mapping_template_1.block('Throw if unauthorized', [ifUnauthThrow]);
    }
    collectAuthCondition() {
        return graphql_mapping_template_1.block('Collect Auth Condition', [
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref(graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthCondition), graphql_mapping_template_1.raw(`$util.defaultIfNull($authCondition, ${graphql_mapping_template_1.print(graphql_mapping_template_1.obj({
                expression: graphql_mapping_template_1.str(''),
                expressionNames: graphql_mapping_template_1.obj({}),
                expressionValues: graphql_mapping_template_1.obj({}),
            }))})`)),
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('totalAuthExpression'), graphql_mapping_template_1.str('')),
            graphql_mapping_template_1.comment('Add dynamic group auth conditions if they exist'),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('groupAuthExpressions'), graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('authExpr'), graphql_mapping_template_1.ref('groupAuthExpressions'), [
                graphql_mapping_template_1.set(graphql_mapping_template_1.ref('totalAuthExpression'), graphql_mapping_template_1.str(`$totalAuthExpression $authExpr`)),
                graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('foreach.hasNext'), graphql_mapping_template_1.set(graphql_mapping_template_1.ref('totalAuthExpression'), graphql_mapping_template_1.str(`$totalAuthExpression OR`))),
            ])),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('groupAuthExpressionNames'), graphql_mapping_template_1.raw(`$util.qr($${graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthCondition}.expressionNames.putAll($groupAuthExpressionNames))`)),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('groupAuthExpressionValues'), graphql_mapping_template_1.raw(`$util.qr($${graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthCondition}.expressionValues.putAll($groupAuthExpressionValues))`)),
            graphql_mapping_template_1.comment('Add owner auth conditions if they exist'),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$totalAuthExpression != "" && $ownerAuthExpressions && $ownerAuthExpressions.size() > 0`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref('totalAuthExpression'), graphql_mapping_template_1.str(`$totalAuthExpression OR`))),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('ownerAuthExpressions'), graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('authExpr'), graphql_mapping_template_1.ref('ownerAuthExpressions'), [
                graphql_mapping_template_1.set(graphql_mapping_template_1.ref('totalAuthExpression'), graphql_mapping_template_1.str(`$totalAuthExpression $authExpr`)),
                graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('foreach.hasNext'), graphql_mapping_template_1.set(graphql_mapping_template_1.ref('totalAuthExpression'), graphql_mapping_template_1.str(`$totalAuthExpression OR`))),
            ])),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('ownerAuthExpressionNames'), graphql_mapping_template_1.raw(`$util.qr($${graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthCondition}.expressionNames.putAll($ownerAuthExpressionNames))`)),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.ref('ownerAuthExpressionValues'), graphql_mapping_template_1.raw(`$util.qr($${graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthCondition}.expressionValues.putAll($ownerAuthExpressionValues))`)),
            graphql_mapping_template_1.comment('Set final expression if it has changed.'),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.raw(`$totalAuthExpression != ""`), graphql_mapping_template_1.ifElse(graphql_mapping_template_1.raw(`$util.isNullOrEmpty($${graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthCondition}.expression)`), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthCondition}.expression`), graphql_mapping_template_1.str(`($totalAuthExpression)`)), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(`${graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthCondition}.expression`), graphql_mapping_template_1.str(`$${graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthCondition}.expression AND ($totalAuthExpression)`)))),
        ]);
    }
    appendItemIfLocallyAuthorized() {
        return graphql_mapping_template_1.iff(graphql_mapping_template_1.parens(graphql_mapping_template_1.or([
            graphql_mapping_template_1.equals(graphql_mapping_template_1.ref(graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsLocalDynamicGroupAuthorizedVariable), graphql_mapping_template_1.raw('true')),
            graphql_mapping_template_1.equals(graphql_mapping_template_1.ref(graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsLocalOwnerAuthorizedVariable), graphql_mapping_template_1.raw('true')),
        ])), graphql_mapping_template_1.qref('$items.add($item)'));
    }
    setUserGroups(customGroup) {
        if (customGroup) {
            return graphql_mapping_template_1.compoundExpression([
                graphql_mapping_template_1.set(graphql_mapping_template_1.ref('userGroups'), graphql_mapping_template_1.raw(`$util.defaultIfNull($ctx.identity.claims.get("${customGroup}"), [])`)),
                graphql_mapping_template_1.iff(graphql_mapping_template_1.raw('$util.isString($userGroups)'), graphql_mapping_template_1.ifElse(graphql_mapping_template_1.raw('$util.isList($util.parseJson($userGroups))'), graphql_mapping_template_1.set(graphql_mapping_template_1.ref('userGroups'), graphql_mapping_template_1.raw('$util.parseJson($userGroups)')), graphql_mapping_template_1.set(graphql_mapping_template_1.ref('userGroups'), graphql_mapping_template_1.raw('[$userGroups]')))),
            ]);
        }
        return graphql_mapping_template_1.set(graphql_mapping_template_1.ref('userGroups'), graphql_mapping_template_1.raw(`$util.defaultIfNull($ctx.identity.claims.get("${constants_1.DEFAULT_GROUP_CLAIM}"), [])`));
    }
    generateSubscriptionResolver(fieldName, subscriptionTypeName = 'Subscription') {
        return new cloudform_types_1.AppSync.Resolver({
            ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
            DataSourceName: 'NONE',
            FieldName: fieldName,
            TypeName: subscriptionTypeName,
            RequestMappingTemplate: graphql_mapping_template_1.print(graphql_mapping_template_1.raw(`{
    "version": "${graphql_mapping_template_1.RESOLVER_VERSION_ID}",
    "payload": {}
}`)),
            ResponseMappingTemplate: graphql_mapping_template_1.print(graphql_mapping_template_1.raw(`$util.toJson(null)`)),
        });
    }
    operationCheckExpression(operation, field) {
        return graphql_mapping_template_1.block('Checking for allowed operations which can return this field', [
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('operation'), graphql_mapping_template_1.raw('$util.defaultIfNull($context.source.operation, "null")')),
            graphql_mapping_template_1.ifElse(graphql_mapping_template_1.raw(`$operation == "${operation}"`), graphql_mapping_template_1.ref('util.toJson(null)'), graphql_mapping_template_1.ref(`util.toJson($context.source.${field})`)),
        ]);
    }
    setOperationExpression(operation) {
        return graphql_mapping_template_1.print(graphql_mapping_template_1.block('Setting the operation', [graphql_mapping_template_1.qref(graphql_mapping_template_1.print(graphql_mapping_template_1.methodCall(graphql_mapping_template_1.ref('ctx.result.put'), graphql_mapping_template_1.str('operation'), graphql_mapping_template_1.str(operation))))]));
    }
    getAuthModeCheckWrappedExpression(expectedAuthModes, expression) {
        if (!expectedAuthModes || expectedAuthModes.size === 0) {
            return expression;
        }
        const conditions = [];
        for (const expectedAuthMode of expectedAuthModes) {
            conditions.push(graphql_mapping_template_1.equals(graphql_mapping_template_1.ref(graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthMode), graphql_mapping_template_1.str(`${expectedAuthMode}`)));
        }
        return graphql_mapping_template_1.block('Check authMode and execute owner/group checks', [
            graphql_mapping_template_1.iff(conditions.length === 1 ? conditions[0] : graphql_mapping_template_1.or(conditions), expression),
        ]);
    }
    getAuthModeDeterminationExpression(authProviders, isUserPoolTheDefault) {
        if (!authProviders || authProviders.size === 0) {
            return graphql_mapping_template_1.comment(`No authentication mode determination needed`);
        }
        const expressions = [];
        for (const authProvider of authProviders) {
            if (authProvider === 'userPools') {
                const statements = [
                    graphql_mapping_template_1.raw(`$util.isNullOrEmpty($${graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthMode})`),
                    graphql_mapping_template_1.not(graphql_mapping_template_1.raw(`$util.isNull($ctx.identity)`)),
                    graphql_mapping_template_1.not(graphql_mapping_template_1.raw(`$util.isNull($ctx.identity.sub)`)),
                    graphql_mapping_template_1.not(graphql_mapping_template_1.raw(`$util.isNull($ctx.identity.issuer)`)),
                    graphql_mapping_template_1.not(graphql_mapping_template_1.raw(`$util.isNull($ctx.identity.username)`)),
                    graphql_mapping_template_1.not(graphql_mapping_template_1.raw(`$util.isNull($ctx.identity.claims)`)),
                    graphql_mapping_template_1.not(graphql_mapping_template_1.raw(`$util.isNull($ctx.identity.sourceIp)`)),
                ];
                if (isUserPoolTheDefault === true) {
                    statements.push(graphql_mapping_template_1.not(graphql_mapping_template_1.raw(`$util.isNull($ctx.identity.defaultAuthStrategy)`)));
                }
                const userPoolsExpression = graphql_mapping_template_1.iff(graphql_mapping_template_1.and(statements), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthMode), graphql_mapping_template_1.str(`userPools`)));
                expressions.push(userPoolsExpression);
            }
            else if (authProvider === 'oidc') {
                const oidcExpression = graphql_mapping_template_1.iff(graphql_mapping_template_1.and([
                    graphql_mapping_template_1.raw(`$util.isNullOrEmpty($${graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthMode})`),
                    graphql_mapping_template_1.not(graphql_mapping_template_1.raw(`$util.isNull($ctx.identity)`)),
                    graphql_mapping_template_1.not(graphql_mapping_template_1.raw(`$util.isNull($ctx.identity.sub)`)),
                    graphql_mapping_template_1.not(graphql_mapping_template_1.raw(`$util.isNull($ctx.identity.issuer)`)),
                    graphql_mapping_template_1.not(graphql_mapping_template_1.raw(`$util.isNull($ctx.identity.claims)`)),
                    graphql_mapping_template_1.raw(`$util.isNull($ctx.identity.username)`),
                    graphql_mapping_template_1.raw(`$util.isNull($ctx.identity.sourceIp)`),
                ]), graphql_mapping_template_1.set(graphql_mapping_template_1.ref(graphql_transformer_common_1.ResourceConstants.SNIPPETS.AuthMode), graphql_mapping_template_1.str(`oidc`)));
                if (expressions.length > 0) {
                    expressions.push(graphql_mapping_template_1.newline());
                }
                expressions.push(oidcExpression);
            }
        }
        return graphql_mapping_template_1.block('Determine request authentication mode', expressions);
    }
    getStaticAuthorizationVariable(field) {
        return field
            ? `${field.name.value}_${graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsStaticGroupAuthorizedVariable}`
            : graphql_transformer_common_1.ResourceConstants.SNIPPETS.IsStaticGroupAuthorizedVariable;
    }
    makeIAMPolicyForRole(isAuthPolicy, resources) {
        const policies = new Array();
        const authPiece = isAuthPolicy ? 'auth' : 'unauth';
        let policyResources = [];
        let resourceSize = 0;
        const MAX_BUILT_SIZE_BYTES = 6000;
        const RESOURCE_OVERHEAD = 100;
        const createPolicy = newPolicyResources => new cloudform_types_1.IAM.ManagedPolicy({
            Roles: [
                { Ref: `${authPiece}RoleName` },
            ],
            PolicyDocument: {
                Version: '2012-10-17',
                Statement: [
                    {
                        Effect: 'Allow',
                        Action: ['appsync:GraphQL'],
                        Resource: newPolicyResources,
                    },
                ],
            },
        });
        for (const resource of resources) {
            const resourceParts = resource.split('/');
            if (resourceParts[1] !== 'null') {
                policyResources.push(cloudform_types_1.Fn.Sub('arn:aws:appsync:${AWS::Region}:${AWS::AccountId}:apis/${apiId}/types/${typeName}/fields/${fieldName}', {
                    apiId: {
                        'Fn::GetAtt': ['GraphQLAPI', 'ApiId'],
                    },
                    typeName: resourceParts[0],
                    fieldName: resourceParts[1],
                }));
                resourceSize += RESOURCE_OVERHEAD + resourceParts[0].length + resourceParts[1].length;
            }
            else {
                policyResources.push(cloudform_types_1.Fn.Sub('arn:aws:appsync:${AWS::Region}:${AWS::AccountId}:apis/${apiId}/types/${typeName}/*', {
                    apiId: {
                        'Fn::GetAtt': ['GraphQLAPI', 'ApiId'],
                    },
                    typeName: resourceParts[0],
                }));
                resourceSize += RESOURCE_OVERHEAD + resourceParts[0].length;
            }
            if (resourceSize > MAX_BUILT_SIZE_BYTES) {
                const policy = createPolicy(policyResources.slice(0, policyResources.length - 1));
                policies.push(policy);
                policyResources = policyResources.slice(-1);
                resourceSize = 0;
            }
        }
        if (policyResources.length > 0) {
            const policy = createPolicy(policyResources);
            policies.push(policy);
        }
        return policies;
    }
    makeESItemsExpression(includeVersion) {
        return graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('es_items'), graphql_mapping_template_1.list([])),
            graphql_mapping_template_1.forEach(graphql_mapping_template_1.ref('entry'), graphql_mapping_template_1.ref('context.result.hits.hits'), [
                graphql_mapping_template_1.iff(graphql_mapping_template_1.raw('!$foreach.hasNext'), graphql_mapping_template_1.set(graphql_mapping_template_1.ref('nextToken'), graphql_mapping_template_1.ref('entry.sort.get(0)'))),
                ...this.getSourceMapper(includeVersion),
            ]),
        ]);
    }
    makeESToGQLExpression() {
        return graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.set(graphql_mapping_template_1.ref('es_response'), graphql_mapping_template_1.obj({
                items: graphql_mapping_template_1.ref('es_items'),
            })),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.raw('$es_items.size() > 0'), graphql_mapping_template_1.compoundExpression([graphql_mapping_template_1.qref('$es_response.put("nextToken", $nextToken)'), graphql_mapping_template_1.qref('$es_response.put("total", $es_items.size())')])),
            graphql_mapping_template_1.toJson(graphql_mapping_template_1.ref('es_response')),
        ]);
    }
}
exports.ResourceFactory = ResourceFactory;
//# sourceMappingURL=resources.js.map