import dataclasses
from ..shared import error as shared_error
from typing import Optional


@dataclasses.dataclass
class DeleteAPIPathParams:
    api_id: str = dataclasses.field(metadata={'path_param': { 'field_name': 'apiID', 'style': 'simple', 'explode': False }})
    version_id: str = dataclasses.field(metadata={'path_param': { 'field_name': 'versionID', 'style': 'simple', 'explode': False }})
    

@dataclasses.dataclass
class DeleteAPIRequest:
    path_params: DeleteAPIPathParams = dataclasses.field()
    

@dataclasses.dataclass
class DeleteAPIResponse:
    content_type: str = dataclasses.field()
    status_code: int = dataclasses.field()
    error: Optional[shared_error.Error] = dataclasses.field(default=None)
    