"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniRunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const index_1 = require("./index");
class AttiniRunner extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.runnerName = id;
        let copy = { ...props };
        if (props.awsVpcConfiguration?.subnets) {
            copy.awsVpcConfiguration.subnets = props.awsVpcConfiguration.subnets.join(',');
        }
        if (props.awsVpcConfiguration?.securityGroups) {
            copy.awsVpcConfiguration.securityGroups = props.awsVpcConfiguration.securityGroups.join(',');
        }
        if (props.awsVpcConfiguration?.assignPublicIp) {
            copy.awsVpcConfiguration.assignPublicIp = props.awsVpcConfiguration?.assignPublicIp ? 'ENABLED' : 'DISABLED';
        }
        if (props.awsVpcConfiguration) {
            copy.awsVpcConfiguration = index_1.PropsUtil.fixCase(copy.awsVpcConfiguration);
        }
        if (props.runnerConfiguration) {
            copy.runnerConfiguration = index_1.PropsUtil.fixCase(copy.runnerConfiguration);
        }
        if (props.startup) {
            copy.startup = index_1.PropsUtil.fixCase(props.startup);
        }
        new aws_cdk_lib_1.CfnResource(this, id, {
            type: 'Attini::Deploy::Runner',
            properties: index_1.PropsUtil.fixCase(copy),
        });
    }
}
exports.AttiniRunner = AttiniRunner;
_a = JSII_RTTI_SYMBOL_1;
AttiniRunner[_a] = { fqn: "@attini/cdk.AttiniRunner", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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