import { Construct } from 'constructs';
export interface AttiniRunnerProps {
    readonly taskDefinitionArn?: string;
    readonly containerName?: string;
    readonly ecsCluster?: string;
    readonly roleArn?: string;
    readonly image?: string;
    readonly runnerConfiguration?: RunnerConfiguration;
    readonly awsVpcConfiguration?: AwsVpcConfiguration;
    readonly startup?: Startup;
}
export interface RunnerConfiguration {
    readonly maxConcurrentJobs?: number;
    readonly idleTimeToLive?: number;
    readonly jobTimeout?: number;
    readonly logLevel?: string;
}
export interface AwsVpcConfiguration {
    readonly subnets?: Array<string>;
    readonly securityGroups?: Array<string>;
    readonly assignPublicIp?: boolean;
}
export interface Startup {
    readonly commands?: Array<string>;
    readonly commandsTimeout?: number;
}
export declare class AttiniRunner extends Construct {
    readonly runnerName: string;
    constructor(scope: Construct, id: string, props: AttiniRunnerProps);
}
