# SSH-Config Settings

# License {{{1
# Copyright (C) 2018-2020 Kenneth S. Kundert
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/.

# Imports {{{1
from textwrap import dedent

from appdirs import user_config_dir, user_data_dir

# Preferences {{{1
# Program defaults {{{2
PROGRAM_NAME = "sshconfig"
DEFAULT_COMMAND = "create"
ENCODING = "utf-8"
INDENT = "    "
ARP = "/sbin/arp -a".split()
UNKNOWN_NETWORK_NAME = "unknown"
DEFAULT_NETWORK_NAME = "default"
DATE_FORMAT = "H:mm A on D MMMM YYYY"


# Paths {{{2
CONFIG_DIR = user_config_dir(PROGRAM_NAME)
DATA_DIR = user_data_dir(PROGRAM_NAME)
LOG_FILE = "sshconfig.log"
SSH_CONFIG_FILE = "~/.ssh/config"

# Config file components {{{2
SSH_HEADER = dedent(
    """
    # SSH Configuration for {network!s}
    # Generated at {time!s}
    #
    # DO NOT EDIT THIS FILE
    #
    # It is automatically generated by sshconfig.
    # To make changes in this file, edit files in {config_dir!s} and run:
    #
    #     sshconfig create
    #
    """
).strip()

SSH_DEFAULTS = dedent(
    """
    #
    # GLOBAL DEFAULTS
    #

    {defaults}
    """
).strip()


SSH_HOSTS = dedent(
    """
    #
    # HOSTS
    #

    {hosts}
    """
).strip()

SSH_OVERRIDES = dedent(
    """
    #
    # GLOBAL OVERRIDES
    #

    {overrides}
    """
).strip()

# SSH Settings {{{1
# ssh_settings {{{2
ssh_settings = """
     Host
     Match
     AddKeysToAgent
     AddressFamily
     BatchMode
     BindAddress
     BindInterface
     CanonicalDomains
     CanonicalizeFallbackLocal
     CanonicalizeHostname
     CanonicalizeMaxDots
     CanonicalizePermittedCNAMEs
     CASignatureAlgorithms
     CertificateFile
     ChallengeResponseAuthentication
     CheckHostIP
     Ciphers
     ClearAllForwardings
     Compression
     ConnectionAttempts
     ConnectTimeout
     ControlMaster
     ControlPath
     ControlPersist
     DynamicForward
     EnableSSHKeysign
     EscapeChar
     ExitOnForwardFailure
     FingerprintHash
     ForwardAgent
     ForwardX11
     ForwardX11Timeout
     ForwardX11Trusted
     GatewayPorts
     GlobalKnownHostsFile
     GSSAPIAuthentication
     GSSAPIClientIdentity
     GSSAPIDelegateCredentials
     GSSAPIKeyExchange
     GSSAPIRenewalForcesRekey
     GSSAPIServerIdentity
     GSSAPITrustDns
     GSSAPIKexAlgorithms
     HashKnownHosts
     HostbasedAuthentication
     HostbasedKeyTypes
     HostKeyAlgorithms
     HostKeyAlias
     Hostname
     IdentitiesOnly
     IdentityAgent
     IdentityFile
     IgnoreUnknown
     Include
     IPQoS
     KbdInteractiveAuthentication
     KbdInteractiveDevices
     KexAlgorithms
     LocalCommand
     LocalForward
     LogLevel
     MACs
     NoHostAuthenticationForLocalhost
     NumberOfPasswordPrompts
     PasswordAuthentication
     PermitLocalCommand
     PKCS11Provider
     Port
     ProxyCommand
     ProxyJump
     ProxyUseFdpass
     PubkeyAcceptedKeyTypes
     PubkeyAuthentication
     RekeyLimit
     RemoteCommand
     RemoteForward
     RequestTTY
     RevokedHostKeys
     SendEnv
     ServerAliveCountMax
     ServerAliveInterval
     SetEnv
     StreamLocalBindMask
     StreamLocalBindUnlink
     StrictHostKeyChecking
     SyslogFacility
     TCPKeepAlive
     Tunnel
     TunnelDevice
     UpdateHostKeys
     User
     UserKnownHostsFile
     VerifyHostKeyDNS
     VisualHostKey
     XAuthLocation
""".split()

# SSH_SETTINGS {{{2
SSH_SETTINGS = {o.lower(): o for o in ssh_settings}
