# -*- coding: utf-8 -*-
from distutils.core import setup

packages = \
['dndice', 'dndice.lib']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['roll = dndice:roller.main']}

setup_kwargs = {
    'name': 'dndice',
    'version': '2.8.0',
    'description': 'An engine to parse and evaluate D&D-inspired roll expressions',
    'long_description': '# DnDice\n\n[![PyPI version](https://badge.fury.io/py/dndice.svg)](https://badge.fury.io/py/dndice)\n[![Documentation Status](https://readthedocs.org/projects/rolling/badge/?version=latest)](https://rolling.readthedocs.io/en/latest/?badge=latest)\n[![Coverage Status](https://coveralls.io/repos/github/the-nick-of-time/dndice/badge.svg?branch=master)](https://coveralls.io/github/the-nick-of-time/dndice?branch=master)\n[![Build Status](https://travis-ci.org/the-nick-of-time/dndice.svg?branch=master)](https://travis-ci.org/the-nick-of-time/dndice)\n\nThis package deals with roll expressions, which are inspired by the syntax D&D uses.\nAt the most basic, there are expressions like `1d20` which means "roll one 20-sided die".\nD&D stops around when modifiers are added, like `1d6+2`.\nThis package runs with it and introduces these dice expressions to an entire arithmetic framework.\nYou can add, subtract, multiply, even exponentiate rolls together, not to mention all of the roll-specific operations like taking the highest or lowest rolls or rerolling given a condition.\nAs these are mathematical expressions just like normal ones, note that they can get arbitrarily complicated.\nThe only limit is how much resources Python can bring to bear calculating your `(9^9^9^9^9)d10000` or similar ridiculous expression.  \n\nThe full specification of what operators are supported and what they do is below.\n\n| Operator | Format          | Meaning\n| :------- | :-------------- | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n| !        | *x*__!__        | Calculate the factorial of _x_.\n| d        | *x*__d__*y*     | Take a _y_-sided die and roll _x_ of them. _y_ can be an integer, and works just as you would expect. It can also be a list of arbitrary numbers (delineated by `[]` and separated with commas), in which case it works as a die with one side labeled with each number in the list.\n| da       | *x*__da__*y*    | Take a _y_-sided die and return the average as if _x_ of them had been rolled. This returns an unrounded number.\n| dc       | *x*__dc__*y*    | Roll a critical hit, where the number of dice rolled is doubled.\n| dm       | *x*__dm__*y*    | Roll the maximum on every die rolled.\n| h        | *ROLL*__h__*n*  | After making a roll, discard all but the highest _n_ of the rolls. Hint: 2d20h1 is advantage.\n| l        | *ROLL*__l__*n*  | After making a roll, discard all but the lowest _n_ of the rolls. Hint: 2d20l1 is disadvantage.\n| f        | *ROLL*__f__*n*  | After making a roll, treat any value that is less than _n_ as _n_.\n| c        | *ROLL*__c__*n*  | After making a roll, treat any value that is greater than _n_ as _n_.\n| r or ro  | *ROLL*__ro__*n* | After making a roll, look at all of them and reroll any that are equal to _n_, reroll those, and take the result.\n| R or Ro  | *ROLL*__Ro__*n* | After making a roll, look at all of them and reroll any that are equal to _n_ and reroll those. If that number comes up again, continue rerolling until you get something different.\n| r> or rh | *ROLL*__rh__*n* | After making a roll, look at all of them and reroll any that are strictly greater than _n_, reroll those, and take the result.\n| R> or Rh | *ROLL*__Rh__*n* | After making a roll, look at all of them and reroll any that are greater than _n_ and reroll those. If a number greater than _n_ comes up again, continue rerolling until you get something different.\n| r< or rl | *ROLL*__rl__*n* | After making a roll, look at all of them and reroll any that are strictly less than _n_, reroll those, and take the result.\n| R< or Rl | *ROLL*__Rl__*n* | After making a roll, look at all of them and reroll any that are less than _n_ and reroll those. If a number less than _n_ comes up again, continue rerolling until you get something different.\n| t        | *ROLL*__t__*n*  | After making the roll, count the number of rolls that were at least _n_.\n| T        | *ROLL*__T__*n*  | After making the roll, count the number of rolls that were at most _n_.\n| ^        | *x*__^__*y*     | Raise _x_ to the _y_ power. This operation is right-associative, meaning that the right side of the expression is evaluated before the left. This really only comes up when chained, for example in `2^3^2`. This would not be `(2^3)^2=8^2=64`, but rather `2^(3^2)=2^9=512`.\n| *        | *x*__*__*y*     | _x_ times _y_.\n| /        | *x*__/__*y*     | _x_ divided by _y_. This returns an unrounded number.\n| %        | *x*__%__*y*     | _x_ modulo _y_. That is, the remainder after _x_ is divided by _y_.\n| +        | *x*__+__*y*     | _x_ plus _y_.\n| -        | *x*__-__*y*     | _x_ minus _y_.\n| > or gt  | *x*__>__*y*     | Check if _x_ is greater than _y_. Returns a 1 for yes and 0 for no.\n| >= or ge | *x*__>=__*y*    | Check if _x_ is greater than or equal to _y_. Returns a 1 for yes and 0 for no.\n| < or lt  | *x*__<__*y*     | Check if _x_ is less than _y_. Returns a 1 for yes and 0 for no.\n| <= or le | *x*__<=__*y*    | Check if _x_ is less than or equal to _y_. Returns a 1 for yes and 0 for no.\n| =        | *x*__=__*y*     | Check if _x_ is equal to _y_. Returns a 1 for yes and 0 for no.\n| &        | *x*__&__*y*     | Check if _x_ and _y_ are both nonzero.\n| \\|       | *x*__\\|__*y*    | Check if at least one of _x_ or _y_ is nonzero.\n\n\n\n## Using this package\n\n### As a user or player\n\nInstalling this package from PyPI will also install the script `roll` to your path. This is a simple command-line script that allows you to exercise all the powers of this package.\nFor a GUI that does the same, check out my repository [DnD](https://github.com/the-nick-of-time/DnD) which is a larger project focused around D&D 5e, allowing you to track your characters and monsters.\n\n\n### As a developer\n\nIf you just want to use this in an application, install it through PyPI and import it as `dndice`. The main function you want is `basic`, which will simply evaluate an expression and return the final number. `verbose` is useful for giving a more detailed look at what was actually rolled, targeted at direct display to a user. `compile` can be used to precompile expressions for quick evaluation of the same expression many times. For a complete view, see [the docs](https://rolling.readthedocs.io/en/latest/).\n\nTo modify this package, first install [poetry](https://github.com/sdispater/poetry) for dependency management. There are no runtime dependencies, and the only development dependencies are [sphinx](http://www.sphinx-doc.org/en/master/) for documentation and [nose2](https://nose2.readthedocs.io/en/latest/index.html) for testing.\nYou probably also want GNU make because I have a number of tasks scripted in the Makefile at the project root.\n',
    'author': 'Nick Thurmes',
    'author_email': 'nthurmes@gmail.com',
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
