# Generated by Django 3.1.13 on 2021-09-06 14:47

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import enumfields.fields
import security.enums


class Migration(migrations.Migration):
    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CeleryTaskInvocationLog',
            fields=[
                ('id', models.UUIDField(primary_key=True, serialize=False, verbose_name='log ID')),
                ('extra_data',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True,
                                  verbose_name='response headers')),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='slug')),
                ('start', models.DateTimeField(editable=False, verbose_name='start')),
                ('stop', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='stop')),
                ('time', models.FloatField(blank=True, null=True, verbose_name='response time')),
                ('celery_task_id', models.UUIDField(blank=True, db_index=True, null=True,
                                                    verbose_name='invocation ID')),
                ('name', models.CharField(db_index=True, max_length=250, verbose_name='task name')),
                ('queue_name', models.CharField(blank=True, max_length=250, null=True, verbose_name='queue name')),
                ('applied_at', models.DateTimeField(verbose_name='applied at')),
                ('triggered_at', models.DateTimeField(blank=True, null=True, verbose_name='triggered at')),
                ('is_unique', models.BooleanField(verbose_name='is unique')),
                ('is_async', models.BooleanField(verbose_name='is async')),
                ('is_duplicate', models.BooleanField(blank=True, null=True, verbose_name='is duplicate')),
                ('is_on_commit', models.BooleanField(verbose_name='is on commit')),
                ('input', models.TextField(blank=True, editable=False, null=True, verbose_name='input')),
                ('task_args',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True, verbose_name='task args')),
                ('task_kwargs',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True, verbose_name='task kwargs')),
                ('estimated_time_of_first_arrival',
                 models.DateTimeField(blank=True, null=True, verbose_name='estimated time of first arrival')),
                ('expires_at', models.DateTimeField(blank=True, null=True, verbose_name='time of expiration')),
                ('stale_at', models.DateTimeField(blank=True, null=True, verbose_name='stale task time')),
                ('state', enumfields.fields.NumEnumField(db_index=True, default=1,
                                                         enum=security.enums.CeleryTaskInvocationLogState,
                                                         verbose_name='state')),
            ],
            options={
                'verbose_name': 'celery task',
                'verbose_name_plural': 'celery tasks',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='CeleryTaskRunLog',
            fields=[
                ('id', models.UUIDField(primary_key=True, serialize=False, verbose_name='log ID')),
                ('extra_data',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True,
                                  verbose_name='response headers')),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='slug')),
                ('start', models.DateTimeField(editable=False, verbose_name='start')),
                ('stop', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='stop')),
                ('time', models.FloatField(blank=True, null=True, verbose_name='response time')),
                ('celery_task_id', models.UUIDField(blank=True, db_index=True, null=True,
                                                    verbose_name='invocation ID')),
                ('name', models.CharField(db_index=True, max_length=250, verbose_name='task name')),
                ('queue_name', models.CharField(blank=True, max_length=250, null=True, verbose_name='queue name')),
                ('input', models.TextField(blank=True, editable=False, null=True, verbose_name='input')),
                ('task_args',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True, verbose_name='task args')),
                ('task_kwargs',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True, verbose_name='task kwargs')),
                ('state',
                 enumfields.fields.NumEnumField(db_index=True, default=1, enum=security.enums.CeleryTaskRunLogState,
                                                verbose_name='state')),
                ('result',
                 models.JSONField(blank=True, editable=False, encoder=django.core.serializers.json.DjangoJSONEncoder,
                                  null=True, verbose_name='result')),
                ('error_message', models.TextField(blank=True, null=True, verbose_name='error message')),
                ('output', models.TextField(blank=True, editable=False, null=True, verbose_name='output')),
                ('retries', models.PositiveSmallIntegerField(default=0, verbose_name='retries')),
                ('estimated_time_of_next_retry',
                 models.DateTimeField(blank=True, null=True, verbose_name='estimated time of arrival')),
            ],
            options={
                'verbose_name': 'celery task run',
                'verbose_name_plural': 'celery tasks run',
                'ordering': ('created_at',),
            },
        ),
        migrations.CreateModel(
            name='CommandLog',
            fields=[
                ('id', models.UUIDField(primary_key=True, serialize=False, verbose_name='log ID')),
                ('extra_data',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True,
                                  verbose_name='response headers')),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='slug')),
                ('start', models.DateTimeField(editable=False, verbose_name='start')),
                ('stop', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='stop')),
                ('time', models.FloatField(blank=True, null=True, verbose_name='response time')),
                ('name', models.CharField(db_index=True, editable=False, max_length=250, verbose_name='name')),
                ('input', models.TextField(editable=False, verbose_name='input')),
                ('is_executed_from_command_line',
                 models.BooleanField(default=False, editable=False, verbose_name='is executed from command line')),
                ('output', models.TextField(blank=True, editable=False, null=True, verbose_name='output')),
                ('state', enumfields.fields.NumEnumField(db_index=True, default=1, enum=security.enums.CommandState,
                                                         verbose_name='state')),
                ('error_message', models.TextField(blank=True, editable=False, null=True,
                                                   verbose_name='error message')),
            ],
            options={
                'verbose_name': 'command log',
                'verbose_name_plural': 'command logs',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='InputRequestLog',
            fields=[
                ('id', models.UUIDField(primary_key=True, serialize=False, verbose_name='log ID')),
                ('extra_data',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True,
                                  verbose_name='response headers')),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='slug')),
                ('start', models.DateTimeField(editable=False, verbose_name='start')),
                ('stop', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='stop')),
                ('time', models.FloatField(blank=True, null=True, verbose_name='response time')),
                ('host', models.CharField(db_index=True, max_length=255, verbose_name='host')),
                ('method', models.SlugField(max_length=7, verbose_name='method')),
                ('path', models.CharField(blank=True, db_index=True, max_length=2000, verbose_name='URL path')),
                ('queries',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True,
                                  verbose_name='queries')),
                ('is_secure', models.BooleanField(default=False, verbose_name='HTTPS connection')),
                ('request_headers',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True,
                                  verbose_name='request headers')),
                ('request_body', models.TextField(null=True, blank=True, verbose_name='request body')),
                ('response_code', models.PositiveSmallIntegerField(blank=True, null=True,
                                                                   verbose_name='response code')),
                ('response_headers',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True,
                                  verbose_name='response headers')),
                ('response_body', models.TextField(blank=True, null=True, verbose_name='response body')),
                ('state',
                 enumfields.fields.NumEnumField(default=0, enum=security.enums.RequestLogState, verbose_name='state')),
                ('error_message', models.TextField(blank=True, null=True, verbose_name='error description')),
                ('user_id', models.TextField(blank=True, db_index=True, null=True, verbose_name='user ID')),
                ('ip', models.GenericIPAddressField(db_index=True, verbose_name='IP address')),
                ('view_slug',
                 models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='view slug')),
            ],
            options={
                'verbose_name': 'input logged request',
                'verbose_name_plural': 'input logged requests',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='OutputRequestLog',
            fields=[
                ('id', models.UUIDField(primary_key=True, serialize=False, verbose_name='log ID')),
                ('extra_data',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True,
                                  verbose_name='response headers')),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='slug')),
                ('start', models.DateTimeField(editable=False, verbose_name='start')),
                ('stop', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='stop')),
                ('time', models.FloatField(blank=True, null=True, verbose_name='response time')),
                ('host', models.CharField(db_index=True, max_length=255, verbose_name='host')),
                ('method', models.SlugField(max_length=7, verbose_name='method')),
                ('path', models.CharField(blank=True, db_index=True, max_length=2000, verbose_name='URL path')),
                ('queries',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True,
                                  verbose_name='queries')),
                ('is_secure', models.BooleanField(default=False, verbose_name='HTTPS connection')),
                ('request_headers',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True,
                                  verbose_name='request headers')),
                ('request_body', models.TextField(null=True, blank=True, verbose_name='request body')),
                ('response_code', models.PositiveSmallIntegerField(blank=True, null=True,
                                                                   verbose_name='response code')),
                ('response_headers',
                 models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True,
                                  verbose_name='response headers')),
                ('response_body', models.TextField(blank=True, null=True, verbose_name='response body')),
                ('state',
                 enumfields.fields.NumEnumField(default=0, enum=security.enums.RequestLogState, verbose_name='state')),
                ('error_message', models.TextField(blank=True, null=True, verbose_name='error description')),
            ],
            options={
                'verbose_name': 'output logged request',
                'verbose_name_plural': 'output logged requests',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='OutputRequestLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_ct_id',
                 models.PositiveSmallIntegerField(db_index=True, verbose_name='content type of the related object')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('output_request_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security_backends_sql.outputrequestlog')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('output_request_log', 'object_ct_id', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='InputRequestLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_ct_id',
                 models.PositiveSmallIntegerField(db_index=True, verbose_name='content type of the related object')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('input_request_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security_backends_sql.inputrequestlog')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('input_request_log', 'object_ct_id', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='CommandLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_ct_id',
                 models.PositiveSmallIntegerField(db_index=True, verbose_name='content type of the related object')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('command_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security_backends_sql.commandlog')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('command_log', 'object_ct_id', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='CeleryTaskRunLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_ct_id',
                 models.PositiveSmallIntegerField(db_index=True, verbose_name='content type of the related object')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('celery_task_run_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security_backends_sql.celerytaskrunlog')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('celery_task_run_log', 'object_ct_id', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='CeleryTaskInvocationLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_ct_id',
                 models.PositiveSmallIntegerField(db_index=True, verbose_name='content type of the related object')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('celery_task_invocation_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects',
                                   to='security_backends_sql.celerytaskinvocationlog')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('celery_task_invocation_log', 'object_ct_id', 'object_id')},
            },
        ),
    ]
