# Generated by Django 3.2.12 on 2022-03-20 04:37

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields
import polymorphic_tree.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Attribute',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('key', models.CharField(max_length=255)),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_crunch.attribute_set+', to='contenttypes.contenttype')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Item',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('name', models.CharField(max_length=1023, unique=True)),
                ('description', models.CharField(blank=True, default='', help_text='A short description in a sentence or more of this item.', max_length=1023)),
                ('details', models.TextField(blank=True, default='', help_text='A detailed description of this item (written in Markdown).')),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='name', unique=True)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', polymorphic_tree.models.PolymorphicTreeForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_DEFAULT, related_name='children', to='crunch.item')),
                ('polymorphic_ctype', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='polymorphic_crunch.item_set+', to='contenttypes.contenttype')),
            ],
            options={
                'ordering': ('tree_id', 'lft'),
                'abstract': False,
                'base_manager_name': 'objects',
                'unique_together': {('parent', 'slug')},
            },
        ),
        migrations.CreateModel(
            name='CharAttribute',
            fields=[
                ('attribute_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crunch.attribute')),
                ('value', models.CharField(max_length=1023)),
            ],
            options={
                'abstract': False,
            },
            bases=('crunch.attribute',),
        ),
        migrations.CreateModel(
            name='Dataset',
            fields=[
                ('item_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crunch.item')),
            ],
            options={
                'abstract': False,
            },
            bases=('crunch.item',),
        ),
        migrations.CreateModel(
            name='DateTimeAttribute',
            fields=[
                ('attribute_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crunch.attribute')),
                ('value', models.DateTimeField()),
            ],
            options={
                'abstract': False,
            },
            bases=('crunch.attribute',),
        ),
        migrations.CreateModel(
            name='FloatAttribute',
            fields=[
                ('attribute_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crunch.attribute')),
                ('value', models.FloatField()),
            ],
            options={
                'abstract': False,
            },
            bases=('crunch.attribute',),
        ),
        migrations.CreateModel(
            name='IntegerAttribute',
            fields=[
                ('attribute_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crunch.attribute')),
                ('value', models.IntegerField()),
            ],
            options={
                'abstract': False,
            },
            bases=('crunch.attribute',),
        ),
        migrations.CreateModel(
            name='LatLongAttribute',
            fields=[
                ('attribute_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crunch.attribute')),
                ('latitude', models.DecimalField(decimal_places=9, help_text='The latitude of this location in decimal degrees.', max_digits=12)),
                ('longitude', models.DecimalField(decimal_places=9, help_text='The longitude of this location in decimal degrees.', max_digits=12)),
            ],
            options={
                'abstract': False,
            },
            bases=('crunch.attribute',),
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('item_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crunch.item')),
                ('workflow', models.TextField(blank=True, default='', help_text='URL to snakemake repository or text of snakefile.')),
            ],
            options={
                'abstract': False,
            },
            bases=('crunch.item',),
        ),
        migrations.CreateModel(
            name='URLAttribute',
            fields=[
                ('attribute_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crunch.attribute')),
                ('value', models.URLField(max_length=1023)),
            ],
            options={
                'abstract': False,
            },
            bases=('crunch.attribute',),
        ),
        migrations.CreateModel(
            name='Status',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('stage', models.IntegerField(choices=[(1, 'Setup'), (2, 'Workflow'), (3, 'Upload')])),
                ('state', models.IntegerField(choices=[(1, 'Start'), (2, 'Success'), (3, 'Fail')])),
                ('note', models.TextField(blank=True, default='')),
                ('agent_user', models.CharField(blank=True, default='', help_text='The name of the user running the agent (see https://docs.python.org/3/library/getpass.html).', max_length=255)),
                ('version', models.CharField(blank=True, default='', help_text='The django-crunch version number of the agent.', max_length=255)),
                ('revision', models.CharField(blank=True, default='', help_text='The django-crunch git revision hash of the agent.', max_length=255)),
                ('system', models.CharField(blank=True, default='', help_text="Returns the system/OS name, such as 'Linux', 'Darwin', 'Java', 'Windows' (see https://docs.python.org/3/library/platform.html).", max_length=255)),
                ('system_release', models.CharField(blank=True, default='', help_text="Returns the system’s release, e.g. '2.2.0' or 'NT' (see https://docs.python.org/3/library/platform.html).", max_length=255)),
                ('system_version', models.CharField(blank=True, default='', help_text="Returns the system’s release version, e.g. '#3 on degas' (see https://docs.python.org/3/library/platform.html).", max_length=255)),
                ('machine', models.CharField(blank=True, default='', help_text="Returns the machine type, e.g. 'i386' (see https://docs.python.org/3/library/platform.html).", max_length=255)),
                ('hostname', models.CharField(blank=True, default='', help_text='The hostname of the machine where the agent was running (see https://docs.python.org/3/library/socket.html).', max_length=255)),
                ('ip_address', models.CharField(blank=True, default='', help_text='The hostname in IPv4 address format (see https://docs.python.org/3/library/socket.html).', max_length=255)),
                ('mac_address', models.CharField(blank=True, default='', help_text='The hardware address  (see https://docs.python.org/3/library/uuid.html).', max_length=255)),
                ('memory_total', models.PositiveIntegerField(blank=True, default=None, help_text='See https://psutil.readthedocs.io/en/latest/', null=True)),
                ('memory_free', models.PositiveIntegerField(blank=True, default=None, help_text='See https://psutil.readthedocs.io/en/latest/', null=True)),
                ('disk_total', models.PositiveIntegerField(blank=True, default=None, help_text='See https://psutil.readthedocs.io/en/latest/', null=True)),
                ('disk_free', models.PositiveIntegerField(blank=True, default=None, help_text='See https://psutil.readthedocs.io/en/latest/', null=True)),
                ('site_user', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_DEFAULT, to=settings.AUTH_USER_MODEL)),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='statuses', to='crunch.dataset')),
            ],
            options={
                'verbose_name_plural': 'statuses',
            },
        ),
        migrations.AddField(
            model_name='attribute',
            name='dataset',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attributes', to='crunch.dataset'),
        ),
    ]
