# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 mac: pulumi.Input[str],
                 allow_existing: Optional[pulumi.Input[bool]] = None,
                 blocked: Optional[pulumi.Input[bool]] = None,
                 dev_id_override: Optional[pulumi.Input[int]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 note: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 skip_forget_on_destroy: Optional[pulumi.Input[bool]] = None,
                 user_group_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] mac: The MAC address of the user.
        :param pulumi.Input[bool] allow_existing: Specifies whether this resource should just take over control of an existing user. Defaults to `true`.
        :param pulumi.Input[bool] blocked: Specifies whether this user should be blocked from the network.
        :param pulumi.Input[int] dev_id_override: Override the device fingerprint.
        :param pulumi.Input[str] fixed_ip: A fixed IPv4 address for this user.
        :param pulumi.Input[str] name: The name of the user.
        :param pulumi.Input[str] network_id: The network ID for this user.
        :param pulumi.Input[str] note: A note with additional information for the user.
        :param pulumi.Input[str] site: The name of the site to associate the user with.
        :param pulumi.Input[bool] skip_forget_on_destroy: Specifies whether this resource should tell the controller to "forget" the user on destroy. Defaults to `false`.
        :param pulumi.Input[str] user_group_id: The user group ID for the user.
        """
        pulumi.set(__self__, "mac", mac)
        if allow_existing is not None:
            pulumi.set(__self__, "allow_existing", allow_existing)
        if blocked is not None:
            pulumi.set(__self__, "blocked", blocked)
        if dev_id_override is not None:
            pulumi.set(__self__, "dev_id_override", dev_id_override)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if skip_forget_on_destroy is not None:
            pulumi.set(__self__, "skip_forget_on_destroy", skip_forget_on_destroy)
        if user_group_id is not None:
            pulumi.set(__self__, "user_group_id", user_group_id)

    @property
    @pulumi.getter
    def mac(self) -> pulumi.Input[str]:
        """
        The MAC address of the user.
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: pulumi.Input[str]):
        pulumi.set(self, "mac", value)

    @property
    @pulumi.getter(name="allowExisting")
    def allow_existing(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether this resource should just take over control of an existing user. Defaults to `true`.
        """
        return pulumi.get(self, "allow_existing")

    @allow_existing.setter
    def allow_existing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_existing", value)

    @property
    @pulumi.getter
    def blocked(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether this user should be blocked from the network.
        """
        return pulumi.get(self, "blocked")

    @blocked.setter
    def blocked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocked", value)

    @property
    @pulumi.getter(name="devIdOverride")
    def dev_id_override(self) -> Optional[pulumi.Input[int]]:
        """
        Override the device fingerprint.
        """
        return pulumi.get(self, "dev_id_override")

    @dev_id_override.setter
    def dev_id_override(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dev_id_override", value)

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[str]]:
        """
        A fixed IPv4 address for this user.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The network ID for this user.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[str]]:
        """
        A note with additional information for the user.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "note", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the site to associate the user with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter(name="skipForgetOnDestroy")
    def skip_forget_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether this resource should tell the controller to "forget" the user on destroy. Defaults to `false`.
        """
        return pulumi.get(self, "skip_forget_on_destroy")

    @skip_forget_on_destroy.setter
    def skip_forget_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_forget_on_destroy", value)

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The user group ID for the user.
        """
        return pulumi.get(self, "user_group_id")

    @user_group_id.setter
    def user_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_group_id", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 allow_existing: Optional[pulumi.Input[bool]] = None,
                 blocked: Optional[pulumi.Input[bool]] = None,
                 dev_id_override: Optional[pulumi.Input[int]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 mac: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 note: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 skip_forget_on_destroy: Optional[pulumi.Input[bool]] = None,
                 user_group_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[bool] allow_existing: Specifies whether this resource should just take over control of an existing user. Defaults to `true`.
        :param pulumi.Input[bool] blocked: Specifies whether this user should be blocked from the network.
        :param pulumi.Input[int] dev_id_override: Override the device fingerprint.
        :param pulumi.Input[str] fixed_ip: A fixed IPv4 address for this user.
        :param pulumi.Input[str] hostname: The hostname of the user.
        :param pulumi.Input[str] ip: The IP address of the user.
        :param pulumi.Input[str] mac: The MAC address of the user.
        :param pulumi.Input[str] name: The name of the user.
        :param pulumi.Input[str] network_id: The network ID for this user.
        :param pulumi.Input[str] note: A note with additional information for the user.
        :param pulumi.Input[str] site: The name of the site to associate the user with.
        :param pulumi.Input[bool] skip_forget_on_destroy: Specifies whether this resource should tell the controller to "forget" the user on destroy. Defaults to `false`.
        :param pulumi.Input[str] user_group_id: The user group ID for the user.
        """
        if allow_existing is not None:
            pulumi.set(__self__, "allow_existing", allow_existing)
        if blocked is not None:
            pulumi.set(__self__, "blocked", blocked)
        if dev_id_override is not None:
            pulumi.set(__self__, "dev_id_override", dev_id_override)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if site is not None:
            pulumi.set(__self__, "site", site)
        if skip_forget_on_destroy is not None:
            pulumi.set(__self__, "skip_forget_on_destroy", skip_forget_on_destroy)
        if user_group_id is not None:
            pulumi.set(__self__, "user_group_id", user_group_id)

    @property
    @pulumi.getter(name="allowExisting")
    def allow_existing(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether this resource should just take over control of an existing user. Defaults to `true`.
        """
        return pulumi.get(self, "allow_existing")

    @allow_existing.setter
    def allow_existing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_existing", value)

    @property
    @pulumi.getter
    def blocked(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether this user should be blocked from the network.
        """
        return pulumi.get(self, "blocked")

    @blocked.setter
    def blocked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "blocked", value)

    @property
    @pulumi.getter(name="devIdOverride")
    def dev_id_override(self) -> Optional[pulumi.Input[int]]:
        """
        Override the device fingerprint.
        """
        return pulumi.get(self, "dev_id_override")

    @dev_id_override.setter
    def dev_id_override(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dev_id_override", value)

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[str]]:
        """
        A fixed IPv4 address for this user.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_ip", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of the user.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the user.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def mac(self) -> Optional[pulumi.Input[str]]:
        """
        The MAC address of the user.
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The network ID for this user.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[str]]:
        """
        A note with additional information for the user.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "note", value)

    @property
    @pulumi.getter
    def site(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the site to associate the user with.
        """
        return pulumi.get(self, "site")

    @site.setter
    def site(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site", value)

    @property
    @pulumi.getter(name="skipForgetOnDestroy")
    def skip_forget_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether this resource should tell the controller to "forget" the user on destroy. Defaults to `false`.
        """
        return pulumi.get(self, "skip_forget_on_destroy")

    @skip_forget_on_destroy.setter
    def skip_forget_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_forget_on_destroy", value)

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The user group ID for the user.
        """
        return pulumi.get(self, "user_group_id")

    @user_group_id.setter
    def user_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_group_id", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_existing: Optional[pulumi.Input[bool]] = None,
                 blocked: Optional[pulumi.Input[bool]] = None,
                 dev_id_override: Optional[pulumi.Input[int]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 mac: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 note: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 skip_forget_on_destroy: Optional[pulumi.Input[bool]] = None,
                 user_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        `iam.User` manages a user (or "client" in the UI) of the network, these are identified by unique MAC addresses.

        Users are created in the controller when observed on the network, so the resource defaults to allowing itself to just take over management of a MAC address, but this can be turned off.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_unifi as unifi

        test = unifi.iam.User("test",
            mac="01:23:45:67:89:AB",
            note="my note",
            fixed_ip="10.0.0.50",
            network_id=unifi_network["my_vlan"]["id"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_existing: Specifies whether this resource should just take over control of an existing user. Defaults to `true`.
        :param pulumi.Input[bool] blocked: Specifies whether this user should be blocked from the network.
        :param pulumi.Input[int] dev_id_override: Override the device fingerprint.
        :param pulumi.Input[str] fixed_ip: A fixed IPv4 address for this user.
        :param pulumi.Input[str] mac: The MAC address of the user.
        :param pulumi.Input[str] name: The name of the user.
        :param pulumi.Input[str] network_id: The network ID for this user.
        :param pulumi.Input[str] note: A note with additional information for the user.
        :param pulumi.Input[str] site: The name of the site to associate the user with.
        :param pulumi.Input[bool] skip_forget_on_destroy: Specifies whether this resource should tell the controller to "forget" the user on destroy. Defaults to `false`.
        :param pulumi.Input[str] user_group_id: The user group ID for the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        `iam.User` manages a user (or "client" in the UI) of the network, these are identified by unique MAC addresses.

        Users are created in the controller when observed on the network, so the resource defaults to allowing itself to just take over management of a MAC address, but this can be turned off.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_unifi as unifi

        test = unifi.iam.User("test",
            mac="01:23:45:67:89:AB",
            note="my note",
            fixed_ip="10.0.0.50",
            network_id=unifi_network["my_vlan"]["id"])
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_existing: Optional[pulumi.Input[bool]] = None,
                 blocked: Optional[pulumi.Input[bool]] = None,
                 dev_id_override: Optional[pulumi.Input[int]] = None,
                 fixed_ip: Optional[pulumi.Input[str]] = None,
                 mac: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 note: Optional[pulumi.Input[str]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 skip_forget_on_destroy: Optional[pulumi.Input[bool]] = None,
                 user_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["allow_existing"] = allow_existing
            __props__.__dict__["blocked"] = blocked
            __props__.__dict__["dev_id_override"] = dev_id_override
            __props__.__dict__["fixed_ip"] = fixed_ip
            if mac is None and not opts.urn:
                raise TypeError("Missing required property 'mac'")
            __props__.__dict__["mac"] = mac
            __props__.__dict__["name"] = name
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["note"] = note
            __props__.__dict__["site"] = site
            __props__.__dict__["skip_forget_on_destroy"] = skip_forget_on_destroy
            __props__.__dict__["user_group_id"] = user_group_id
            __props__.__dict__["hostname"] = None
            __props__.__dict__["ip"] = None
        super(User, __self__).__init__(
            'unifi:iam/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_existing: Optional[pulumi.Input[bool]] = None,
            blocked: Optional[pulumi.Input[bool]] = None,
            dev_id_override: Optional[pulumi.Input[int]] = None,
            fixed_ip: Optional[pulumi.Input[str]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            ip: Optional[pulumi.Input[str]] = None,
            mac: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            note: Optional[pulumi.Input[str]] = None,
            site: Optional[pulumi.Input[str]] = None,
            skip_forget_on_destroy: Optional[pulumi.Input[bool]] = None,
            user_group_id: Optional[pulumi.Input[str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_existing: Specifies whether this resource should just take over control of an existing user. Defaults to `true`.
        :param pulumi.Input[bool] blocked: Specifies whether this user should be blocked from the network.
        :param pulumi.Input[int] dev_id_override: Override the device fingerprint.
        :param pulumi.Input[str] fixed_ip: A fixed IPv4 address for this user.
        :param pulumi.Input[str] hostname: The hostname of the user.
        :param pulumi.Input[str] ip: The IP address of the user.
        :param pulumi.Input[str] mac: The MAC address of the user.
        :param pulumi.Input[str] name: The name of the user.
        :param pulumi.Input[str] network_id: The network ID for this user.
        :param pulumi.Input[str] note: A note with additional information for the user.
        :param pulumi.Input[str] site: The name of the site to associate the user with.
        :param pulumi.Input[bool] skip_forget_on_destroy: Specifies whether this resource should tell the controller to "forget" the user on destroy. Defaults to `false`.
        :param pulumi.Input[str] user_group_id: The user group ID for the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["allow_existing"] = allow_existing
        __props__.__dict__["blocked"] = blocked
        __props__.__dict__["dev_id_override"] = dev_id_override
        __props__.__dict__["fixed_ip"] = fixed_ip
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ip"] = ip
        __props__.__dict__["mac"] = mac
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["note"] = note
        __props__.__dict__["site"] = site
        __props__.__dict__["skip_forget_on_destroy"] = skip_forget_on_destroy
        __props__.__dict__["user_group_id"] = user_group_id
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowExisting")
    def allow_existing(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether this resource should just take over control of an existing user. Defaults to `true`.
        """
        return pulumi.get(self, "allow_existing")

    @property
    @pulumi.getter
    def blocked(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether this user should be blocked from the network.
        """
        return pulumi.get(self, "blocked")

    @property
    @pulumi.getter(name="devIdOverride")
    def dev_id_override(self) -> pulumi.Output[Optional[int]]:
        """
        Override the device fingerprint.
        """
        return pulumi.get(self, "dev_id_override")

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> pulumi.Output[Optional[str]]:
        """
        A fixed IPv4 address for this user.
        """
        return pulumi.get(self, "fixed_ip")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The hostname of the user.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[str]:
        """
        The IP address of the user.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def mac(self) -> pulumi.Output[str]:
        """
        The MAC address of the user.
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[Optional[str]]:
        """
        The network ID for this user.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def note(self) -> pulumi.Output[Optional[str]]:
        """
        A note with additional information for the user.
        """
        return pulumi.get(self, "note")

    @property
    @pulumi.getter
    def site(self) -> pulumi.Output[str]:
        """
        The name of the site to associate the user with.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter(name="skipForgetOnDestroy")
    def skip_forget_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether this resource should tell the controller to "forget" the user on destroy. Defaults to `false`.
        """
        return pulumi.get(self, "skip_forget_on_destroy")

    @property
    @pulumi.getter(name="userGroupId")
    def user_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The user group ID for the user.
        """
        return pulumi.get(self, "user_group_id")

