# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'test2.ui'
#
# Created by: PyQt5 UI code generator 5.15.4
#
# WARNING: Any manual changes made to this file will be lost when pyuic5 is
# run again.  Do not edit this file unless you know what you are doing.


from PyQt5 import QtCore, QtGui, QtWidgets
from PyQt5.QtWidgets import QDialog, QApplication, QFileDialog
from PyQt5.uic import loadUi
import sys
import os
import glob
import matplotlib.pyplot as plt
import matplotlib
import numpy as np
from time import sleep          #REMOVE LATER
from datetime import datetime   #REMOVE LATER
import astropy.io.fits as pyfits
from astropy.time import Time
from fermipy.gtanalysis import GTAnalysis
from fermipy.plotting import ROIPlotter
matplotlib.interactive(True)

Version = '1.0.0'
os.environ["LANG"] = 'C'

class Worker(QtCore.QObject):
    starting = QtCore.pyqtSignal()
    finished = QtCore.pyqtSignal()
    progress = QtCore.pyqtSignal(int)
    
    
    def run_gtsetup(self):
        """Long-running task."""
        self.starting.emit()
        ui.setFermipy()
        self.progress.emit(0) 
        ui.gta.setup()
        self.progress.emit(1)
        ui.analysisBasics() 
        self.progress.emit(2)
        ui.analysis_advanced()
        self.progress.emit(3)
        self.finished.emit()



class Ui_mainWindow(QDialog):
    def setupUi(self, mainWindow):
        mainWindow.setObjectName("mainWindow")
        mainWindow.resize(870, 595)
        mainWindow.setWindowOpacity(1.0)
        self.centralwidget = QtWidgets.QWidget(mainWindow)
        self.centralwidget.setObjectName("centralwidget")
        self.pushButton = QtWidgets.QPushButton(self.centralwidget)
        self.pushButton.setGeometry(QtCore.QRect(670, 480, 191, 41))
        self.pushButton.setObjectName("pushButton")
        self.progressBar = QtWidgets.QProgressBar(self.centralwidget)
        self.progressBar.setGeometry(QtCore.QRect(10, 530, 851, 20))
        self.progressBar.setProperty("value", 0)
        self.progressBar.setObjectName("progressBar")
        self.label_2 = QtWidgets.QLabel(self.centralwidget)
        self.label_2.setGeometry(QtCore.QRect(520, 190, 71, 20))
        self.label_2.setObjectName("label_2")
        self.picture = QtWidgets.QLabel(self.centralwidget)
        self.picture.setEnabled(True)
        self.picture.setGeometry(QtCore.QRect(560, 210, 251, 251))
        font = QtGui.QFont()
        font.setBold(False)
        font.setWeight(50)
        self.picture.setFont(font)
        self.picture.setMouseTracking(False)
        self.picture.setAutoFillBackground(False)
        self.picture.setText("")
        self.picture.setPixmap(QtGui.QPixmap("fermi.png"))
        self.picture.setScaledContents(True)
        self.picture.setWordWrap(False)
        self.picture.setObjectName("picture")
        self.groupBox_2 = QtWidgets.QGroupBox(self.centralwidget)
        self.groupBox_2.setGeometry(QtCore.QRect(300, 190, 211, 331))
        self.groupBox_2.setObjectName("groupBox_2")
        self.radioButton = QtWidgets.QRadioButton(self.groupBox_2)
        self.radioButton.setEnabled(False)
        self.radioButton.setGeometry(QtCore.QRect(40, 170, 61, 23))
        self.radioButton.setChecked(True)
        self.radioButton.setAutoExclusive(True)
        self.radioButton.setObjectName("radioButton")
        self.label_4 = QtWidgets.QLabel(self.groupBox_2)
        self.label_4.setEnabled(False)
        self.label_4.setGeometry(QtCore.QRect(100, 40, 121, 21))
        self.label_4.setObjectName("label_4")
        self.checkBox_3 = QtWidgets.QCheckBox(self.groupBox_2)
        self.checkBox_3.setGeometry(QtCore.QRect(10, 150, 131, 23))
        self.checkBox_3.setObjectName("checkBox_3")
        self.label_9 = QtWidgets.QLabel(self.groupBox_2)
        self.label_9.setEnabled(False)
        self.label_9.setGeometry(QtCore.QRect(100, 70, 81, 21))
        self.label_9.setObjectName("label_9")
        self.label_10 = QtWidgets.QLabel(self.groupBox_2)
        self.label_10.setGeometry(QtCore.QRect(100, 120, 121, 21))
        self.label_10.setObjectName("label_10")
        self.checkBox = QtWidgets.QCheckBox(self.groupBox_2)
        self.checkBox.setGeometry(QtCore.QRect(10, 20, 131, 23))
        self.checkBox.setObjectName("checkBox")
        self.spinBox_3 = QtWidgets.QSpinBox(self.groupBox_2)
        self.spinBox_3.setGeometry(QtCore.QRect(40, 120, 48, 26))
        self.spinBox_3.setMinimum(3)
        self.spinBox_3.setProperty("value", 10)
        self.spinBox_3.setObjectName("spinBox_3")
        self.doubleSpinBox = QtWidgets.QDoubleSpinBox(self.groupBox_2)
        self.doubleSpinBox.setEnabled(False)
        self.doubleSpinBox.setGeometry(QtCore.QRect(40, 215, 69, 21))
        self.doubleSpinBox.setProperty("value", 1.0)
        self.doubleSpinBox.setObjectName("doubleSpinBox")
        self.label_5 = QtWidgets.QLabel(self.groupBox_2)
        self.label_5.setEnabled(False)
        self.label_5.setGeometry(QtCore.QRect(120, 210, 81, 31))
        self.label_5.setObjectName("label_5")
        self.spinBox_2 = QtWidgets.QSpinBox(self.groupBox_2)
        self.spinBox_2.setEnabled(False)
        self.spinBox_2.setGeometry(QtCore.QRect(40, 70, 48, 26))
        self.spinBox_2.setMinimum(1)
        self.spinBox_2.setProperty("value", 1)
        self.spinBox_2.setObjectName("spinBox_2")
        self.checkBox_2 = QtWidgets.QCheckBox(self.groupBox_2)
        self.checkBox_2.setGeometry(QtCore.QRect(10, 100, 131, 23))
        self.checkBox_2.setChecked(True)
        self.checkBox_2.setObjectName("checkBox_2")
        self.spinBox = QtWidgets.QSpinBox(self.groupBox_2)
        self.spinBox.setEnabled(False)
        self.spinBox.setGeometry(QtCore.QRect(40, 40, 48, 26))
        self.spinBox.setMinimum(3)
        self.spinBox.setProperty("value", 20)
        self.spinBox.setObjectName("spinBox")
        self.radioButton_2 = QtWidgets.QRadioButton(self.groupBox_2)
        self.radioButton_2.setEnabled(False)
        self.radioButton_2.setGeometry(QtCore.QRect(40, 190, 91, 23))
        self.radioButton_2.setChecked(False)
        self.radioButton_2.setAutoExclusive(True)
        self.radioButton_2.setObjectName("radioButton_2")
        self.checkBox_6 = QtWidgets.QCheckBox(self.groupBox_2)
        self.checkBox_6.setGeometry(QtCore.QRect(40, 310, 131, 23))
        self.checkBox_6.setChecked(True)
        self.checkBox_6.setObjectName("checkBox_6")
        self.doubleSpinBox_2 = QtWidgets.QDoubleSpinBox(self.groupBox_2)
        self.doubleSpinBox_2.setGeometry(QtCore.QRect(40, 280, 69, 26))
        self.doubleSpinBox_2.setMinimum(0.5)
        self.doubleSpinBox_2.setProperty("value", 2.0)
        self.doubleSpinBox_2.setObjectName("doubleSpinBox_2")
        self.checkBox_5 = QtWidgets.QCheckBox(self.groupBox_2)
        self.checkBox_5.setGeometry(QtCore.QRect(10, 260, 131, 23))
        self.checkBox_5.setChecked(True)
        self.checkBox_5.setObjectName("checkBox_5")
        self.checkBox_4 = QtWidgets.QCheckBox(self.groupBox_2)
        self.checkBox_4.setGeometry(QtCore.QRect(10, 240, 131, 23))
        self.checkBox_4.setObjectName("checkBox_4")
        self.label_11 = QtWidgets.QLabel(self.groupBox_2)
        self.label_11.setGeometry(QtCore.QRect(120, 280, 101, 21))
        self.label_11.setObjectName("label_11")
        self.groupBox_3 = QtWidgets.QGroupBox(self.centralwidget)
        self.groupBox_3.setGeometry(QtCore.QRect(10, 190, 281, 331))
        self.groupBox_3.setObjectName("groupBox_3")
        self.label_15 = QtWidgets.QLabel(self.groupBox_3)
        self.label_15.setEnabled(False)
        self.label_15.setGeometry(QtCore.QRect(30, 30, 121, 17))
        self.label_15.setObjectName("label_15")
        self.lineEdit_6 = QtWidgets.QLineEdit(self.groupBox_3)
        self.lineEdit_6.setEnabled(False)
        self.lineEdit_6.setGeometry(QtCore.QRect(30, 50, 101, 21))
        self.lineEdit_6.setObjectName("lineEdit_6")
        self.label_22 = QtWidgets.QLabel(self.groupBox_3)
        self.label_22.setEnabled(False)
        self.label_22.setGeometry(QtCore.QRect(30, 160, 181, 17))
        self.label_22.setObjectName("label_22")
        self.checkBox_11 = QtWidgets.QCheckBox(self.groupBox_3)
        self.checkBox_11.setGeometry(QtCore.QRect(10, 140, 231, 23))
        self.checkBox_11.setObjectName("checkBox_11")
        self.comboBox_2 = QtWidgets.QComboBox(self.groupBox_3)
        self.comboBox_2.setEnabled(False)
        self.comboBox_2.setGeometry(QtCore.QRect(30, 100, 111, 25))
        self.comboBox_2.setObjectName("comboBox_2")
        self.comboBox_2.addItem("")
        self.comboBox_2.addItem("")
        self.comboBox_2.addItem("")
        self.lineEdit_9 = QtWidgets.QLineEdit(self.groupBox_3)
        self.lineEdit_9.setEnabled(False)
        self.lineEdit_9.setGeometry(QtCore.QRect(30, 180, 191, 21))
        self.lineEdit_9.setObjectName("lineEdit_9")
        self.checkBox_10 = QtWidgets.QCheckBox(self.groupBox_3)
        self.checkBox_10.setGeometry(QtCore.QRect(10, 290, 171, 23))
        self.checkBox_10.setChecked(True)
        self.checkBox_10.setObjectName("checkBox_10")
        self.label_21 = QtWidgets.QLabel(self.groupBox_3)
        self.label_21.setGeometry(QtCore.QRect(110, 260, 101, 17))
        self.label_21.setObjectName("label_21")
        self.doubleSpinBox_3 = QtWidgets.QDoubleSpinBox(self.groupBox_3)
        self.doubleSpinBox_3.setEnabled(True)
        self.doubleSpinBox_3.setGeometry(QtCore.QRect(30, 230, 69, 21))
        self.doubleSpinBox_3.setMinimum(1.0)
        self.doubleSpinBox_3.setProperty("value", 4.0)
        self.doubleSpinBox_3.setObjectName("doubleSpinBox_3")
        self.doubleSpinBox_4 = QtWidgets.QDoubleSpinBox(self.groupBox_3)
        self.doubleSpinBox_4.setEnabled(True)
        self.doubleSpinBox_4.setGeometry(QtCore.QRect(30, 260, 69, 21))
        self.doubleSpinBox_4.setMinimum(0.1)
        self.doubleSpinBox_4.setProperty("value", 0.5)
        self.doubleSpinBox_4.setObjectName("doubleSpinBox_4")
        self.checkBox_8 = QtWidgets.QCheckBox(self.groupBox_3)
        self.checkBox_8.setGeometry(QtCore.QRect(10, 210, 221, 23))
        self.checkBox_8.setChecked(True)
        self.checkBox_8.setObjectName("checkBox_8")
        self.label_20 = QtWidgets.QLabel(self.groupBox_3)
        self.label_20.setGeometry(QtCore.QRect(110, 230, 71, 17))
        self.label_20.setObjectName("label_20")
        self.checkBox_12 = QtWidgets.QCheckBox(self.groupBox_3)
        self.checkBox_12.setGeometry(QtCore.QRect(10, 80, 191, 21))
        self.checkBox_12.setObjectName("checkBox_12")
        self.plainTextEdit = QtWidgets.QPlainTextEdit(self.centralwidget)
        self.plainTextEdit.setGeometry(QtCore.QRect(520, 210, 341, 261))
        self.plainTextEdit.setObjectName("plainTextEdit")
        self.toolButton_10 = QtWidgets.QToolButton(self.centralwidget)
        self.toolButton_10.setEnabled(False)
        self.toolButton_10.setGeometry(QtCore.QRect(650, 110, 26, 24))
        self.toolButton_10.setObjectName("toolButton_10")
        self.lineEdit_7 = QtWidgets.QLineEdit(self.centralwidget)
        self.lineEdit_7.setEnabled(False)
        self.lineEdit_7.setGeometry(QtCore.QRect(510, 110, 131, 25))
        self.lineEdit_7.setObjectName("lineEdit_7")
        self.lineEdit_4 = QtWidgets.QLineEdit(self.centralwidget)
        self.lineEdit_4.setGeometry(QtCore.QRect(490, 60, 151, 25))
        self.lineEdit_4.setObjectName("lineEdit_4")
        self.toolButton_4 = QtWidgets.QToolButton(self.centralwidget)
        self.toolButton_4.setGeometry(QtCore.QRect(650, 60, 26, 24))
        self.toolButton_4.setObjectName("toolButton_4")
        self.label_14 = QtWidgets.QLabel(self.centralwidget)
        self.label_14.setGeometry(QtCore.QRect(490, 40, 151, 17))
        self.label_14.setObjectName("label_14")
        self.checkBox_9 = QtWidgets.QCheckBox(self.centralwidget)
        self.checkBox_9.setGeometry(QtCore.QRect(490, 90, 161, 23))
        self.checkBox_9.setObjectName("checkBox_9")
        self.line_2 = QtWidgets.QFrame(self.centralwidget)
        self.line_2.setGeometry(QtCore.QRect(670, 40, 20, 101))
        self.line_2.setFrameShape(QtWidgets.QFrame.VLine)
        self.line_2.setFrameShadow(QtWidgets.QFrame.Sunken)
        self.line_2.setObjectName("line_2")
        self.line_3 = QtWidgets.QFrame(self.centralwidget)
        self.line_3.setGeometry(QtCore.QRect(470, 40, 20, 101))
        self.line_3.setFrameShape(QtWidgets.QFrame.VLine)
        self.line_3.setFrameShadow(QtWidgets.QFrame.Sunken)
        self.line_3.setObjectName("line_3")
        self.dateTimeEdit_2 = QtWidgets.QDateTimeEdit(self.centralwidget)
        self.dateTimeEdit_2.setGeometry(QtCore.QRect(690, 110, 171, 21))
        self.dateTimeEdit_2.setDateTime(QtCore.QDateTime(QtCore.QDate(2008, 10, 14), QtCore.QTime(15, 43, 0)))
        self.dateTimeEdit_2.setMinimumDateTime(QtCore.QDateTime(QtCore.QDate(2008, 8, 14), QtCore.QTime(15, 43, 37)))
        self.dateTimeEdit_2.setCalendarPopup(False)
        self.dateTimeEdit_2.setObjectName("dateTimeEdit_2")
        self.dateTimeEdit = QtWidgets.QDateTimeEdit(self.centralwidget)
        self.dateTimeEdit.setGeometry(QtCore.QRect(690, 60, 171, 21))
        self.dateTimeEdit.setDateTime(QtCore.QDateTime(QtCore.QDate(2008, 8, 4), QtCore.QTime(15, 43, 36)))
        self.dateTimeEdit.setDate(QtCore.QDate(2008, 8, 4))
        self.dateTimeEdit.setTime(QtCore.QTime(15, 43, 36))
        self.dateTimeEdit.setMinimumDateTime(QtCore.QDateTime(QtCore.QDate(2008, 8, 4), QtCore.QTime(15, 43, 36)))
        self.dateTimeEdit.setObjectName("dateTimeEdit")
        self.label_7 = QtWidgets.QLabel(self.centralwidget)
        self.label_7.setGeometry(QtCore.QRect(690, 40, 111, 17))
        self.label_7.setObjectName("label_7")
        self.label_8 = QtWidgets.QLabel(self.centralwidget)
        self.label_8.setGeometry(QtCore.QRect(690, 90, 111, 17))
        self.label_8.setObjectName("label_8")
        self.line = QtWidgets.QFrame(self.centralwidget)
        self.line.setGeometry(QtCore.QRect(290, 40, 20, 101))
        self.line.setFrameShape(QtWidgets.QFrame.VLine)
        self.line.setFrameShadow(QtWidgets.QFrame.Sunken)
        self.line.setObjectName("line")
        self.toolButton_5 = QtWidgets.QToolButton(self.centralwidget)
        self.toolButton_5.setGeometry(QtCore.QRect(610, 490, 26, 24))
        self.toolButton_5.setObjectName("toolButton_5")
        self.lineEdit_10 = QtWidgets.QLineEdit(self.centralwidget)
        self.lineEdit_10.setGeometry(QtCore.QRect(520, 490, 81, 25))
        self.lineEdit_10.setObjectName("lineEdit_10")
        self.lineEdit_5 = QtWidgets.QLineEdit(self.centralwidget)
        self.lineEdit_5.setGeometry(QtCore.QRect(310, 110, 131, 25))
        self.lineEdit_5.setObjectName("lineEdit_5")
        self.lineEdit_3 = QtWidgets.QLineEdit(self.centralwidget)
        self.lineEdit_3.setGeometry(QtCore.QRect(310, 60, 131, 25))
        self.lineEdit_3.setObjectName("lineEdit_3")
        self.label_6 = QtWidgets.QLabel(self.centralwidget)
        self.label_6.setGeometry(QtCore.QRect(310, 90, 131, 20))
        self.label_6.setObjectName("label_6")
        self.label = QtWidgets.QLabel(self.centralwidget)
        self.label.setGeometry(QtCore.QRect(310, 40, 111, 17))
        self.label.setObjectName("label")
        self.label_12 = QtWidgets.QLabel(self.centralwidget)
        self.label_12.setGeometry(QtCore.QRect(520, 470, 131, 20))
        self.label_12.setObjectName("label_12")
        self.toolButton = QtWidgets.QToolButton(self.centralwidget)
        self.toolButton.setGeometry(QtCore.QRect(450, 60, 26, 24))
        self.toolButton.setWhatsThis("")
        self.toolButton.setObjectName("toolButton")
        self.toolButton_2 = QtWidgets.QToolButton(self.centralwidget)
        self.toolButton_2.setGeometry(QtCore.QRect(450, 110, 26, 24))
        self.toolButton_2.setObjectName("toolButton_2")
        self.toolButton_3 = QtWidgets.QToolButton(self.centralwidget)
        self.toolButton_3.setEnabled(False)
        self.toolButton_3.setGeometry(QtCore.QRect(260, 160, 26, 24))
        self.toolButton_3.setObjectName("toolButton_3")
        self.label_17 = QtWidgets.QLabel(self.centralwidget)
        self.label_17.setGeometry(QtCore.QRect(180, 90, 111, 17))
        self.label_17.setObjectName("label_17")
        self.lineEdit_2 = QtWidgets.QLineEdit(self.centralwidget)
        self.lineEdit_2.setGeometry(QtCore.QRect(180, 110, 111, 25))
        self.lineEdit_2.setObjectName("lineEdit_2")
        self.label_18 = QtWidgets.QLabel(self.centralwidget)
        self.label_18.setGeometry(QtCore.QRect(40, 40, 61, 21))
        self.label_18.setObjectName("label_18")
        self.label_16 = QtWidgets.QLabel(self.centralwidget)
        self.label_16.setGeometry(QtCore.QRect(180, 40, 81, 17))
        self.label_16.setObjectName("label_16")
        self.comboBox = QtWidgets.QComboBox(self.centralwidget)
        self.comboBox.setGeometry(QtCore.QRect(40, 60, 71, 25))
        self.comboBox.setObjectName("comboBox")
        self.comboBox.addItem("")
        self.comboBox.addItem("")
        self.lineEdit_8 = QtWidgets.QLineEdit(self.centralwidget)
        self.lineEdit_8.setEnabled(False)
        self.lineEdit_8.setGeometry(QtCore.QRect(40, 160, 211, 25))
        self.lineEdit_8.setObjectName("lineEdit_8")
        self.lineEdit = QtWidgets.QLineEdit(self.centralwidget)
        self.lineEdit.setGeometry(QtCore.QRect(180, 60, 111, 25))
        self.lineEdit.setObjectName("lineEdit")
        self.radioButton_3 = QtWidgets.QRadioButton(self.centralwidget)
        self.radioButton_3.setEnabled(True)
        self.radioButton_3.setGeometry(QtCore.QRect(20, 20, 91, 23))
        self.radioButton_3.setChecked(True)
        self.radioButton_3.setAutoExclusive(True)
        self.radioButton_3.setObjectName("radioButton_3")
        self.radioButton_4 = QtWidgets.QRadioButton(self.centralwidget)
        self.radioButton_4.setEnabled(True)
        self.radioButton_4.setGeometry(QtCore.QRect(20, 140, 91, 23))
        self.radioButton_4.setChecked(False)
        self.radioButton_4.setAutoExclusive(True)
        self.radioButton_4.setObjectName("radioButton_4")
        self.label_25 = QtWidgets.QLabel(self.centralwidget)
        self.label_25.setGeometry(QtCore.QRect(10, 0, 91, 21))
        self.label_25.setObjectName("label_25")
        self.label_23 = QtWidgets.QLabel(self.centralwidget)
        self.label_23.setGeometry(QtCore.QRect(40, 90, 131, 21))
        self.label_23.setObjectName("label_23")
        self.comboBox_4 = QtWidgets.QComboBox(self.centralwidget)
        self.comboBox_4.setGeometry(QtCore.QRect(40, 110, 71, 25))
        self.comboBox_4.setObjectName("comboBox_4")
        self.comboBox_4.addItem("")
        self.comboBox_4.addItem("")
        self.line_5 = QtWidgets.QFrame(self.centralwidget)
        self.line_5.setGeometry(QtCore.QRect(160, 40, 20, 101))
        self.line_5.setFrameShape(QtWidgets.QFrame.VLine)
        self.line_5.setFrameShadow(QtWidgets.QFrame.Sunken)
        self.line_5.setObjectName("line_5")
        self.lineEdit_11 = QtWidgets.QLineEdit(self.centralwidget)
        self.lineEdit_11.setEnabled(False)
        self.lineEdit_11.setGeometry(QtCore.QRect(310, 160, 131, 25))
        self.lineEdit_11.setText("")
        self.lineEdit_11.setObjectName("lineEdit_11")
        self.toolButton_6 = QtWidgets.QToolButton(self.centralwidget)
        self.toolButton_6.setEnabled(False)
        self.toolButton_6.setGeometry(QtCore.QRect(450, 160, 26, 24))
        self.toolButton_6.setObjectName("toolButton_6")
        self.label_13 = QtWidgets.QLabel(self.centralwidget)
        self.label_13.setEnabled(False)
        self.label_13.setGeometry(QtCore.QRect(310, 140, 131, 20))
        self.label_13.setObjectName("label_13")
        self.pushButton.raise_()
        self.progressBar.raise_()
        self.label_2.raise_()
        self.groupBox_2.raise_()
        self.groupBox_3.raise_()
        self.plainTextEdit.raise_()
        self.toolButton_10.raise_()
        self.lineEdit_7.raise_()
        self.lineEdit_4.raise_()
        self.toolButton_4.raise_()
        self.label_14.raise_()
        self.checkBox_9.raise_()
        self.line_2.raise_()
        self.line_3.raise_()
        self.dateTimeEdit_2.raise_()
        self.dateTimeEdit.raise_()
        self.label_7.raise_()
        self.label_8.raise_()
        self.line.raise_()
        self.toolButton_5.raise_()
        self.lineEdit_10.raise_()
        self.lineEdit_5.raise_()
        self.lineEdit_3.raise_()
        self.label_6.raise_()
        self.label.raise_()
        self.label_12.raise_()
        self.toolButton.raise_()
        self.toolButton_2.raise_()
        self.toolButton_3.raise_()
        self.label_17.raise_()
        self.lineEdit_2.raise_()
        self.label_18.raise_()
        self.label_16.raise_()
        self.comboBox.raise_()
        self.lineEdit_8.raise_()
        self.lineEdit.raise_()
        self.label_25.raise_()
        self.picture.raise_()
        self.label_23.raise_()
        self.comboBox_4.raise_()
        self.line_5.raise_()
        self.lineEdit_11.raise_()
        self.toolButton_6.raise_()
        self.label_13.raise_()
        mainWindow.setCentralWidget(self.centralwidget)
        self.menubar = QtWidgets.QMenuBar(mainWindow)
        self.menubar.setGeometry(QtCore.QRect(0, 0, 870, 22))
        self.menubar.setObjectName("menubar")
        self.menuTutorial = QtWidgets.QMenu(self.menubar)
        self.menuTutorial.setObjectName("menuTutorial")
        self.menuCredits = QtWidgets.QMenu(self.menubar)
        self.menuCredits.setObjectName("menuCredits")
        mainWindow.setMenuBar(self.menubar)
        self.statusbar = QtWidgets.QStatusBar(mainWindow)
        self.statusbar.setObjectName("statusbar")
        mainWindow.setStatusBar(self.statusbar)
        self.actionOpen = QtWidgets.QAction(mainWindow)
        self.actionOpen.setShortcut("")
        self.actionOpen.setObjectName("actionOpen")
        self.actionSave = QtWidgets.QAction(mainWindow)
        self.actionSave.setObjectName("actionSave")
        self.actionCopy = QtWidgets.QAction(mainWindow)
        self.actionCopy.setObjectName("actionCopy")
        self.actionPaste = QtWidgets.QAction(mainWindow)
        self.actionPaste.setObjectName("actionPaste")
        self.actionOpen_Tutorial = QtWidgets.QAction(mainWindow)
        self.actionOpen_Tutorial.setObjectName("actionOpen_Tutorial")
        self.actionSee_credits = QtWidgets.QAction(mainWindow)
        self.actionSee_credits.setObjectName("actionSee_credits")
        self.menuTutorial.addAction(self.actionOpen_Tutorial)
        self.menuCredits.addAction(self.actionSee_credits)
        self.menubar.addAction(self.menuTutorial.menuAction())
        self.menubar.addAction(self.menuCredits.menuAction())

        self.retranslateUi(mainWindow)
        QtCore.QMetaObject.connectSlotsByName(mainWindow)
        
        #Click GO!
        self.pushButton.setToolTip('Click to start the analysis')
        self.pushButton.clicked.connect(self.runLongTask)
        #self.actionOpen_Tutorial.connect(self.popup_tutorial)
        self.actionOpen_Tutorial.triggered.connect(self.popup_tutorial)
        self.actionSee_credits.triggered.connect(self.popup_credits)
            
        ############ Loading main files:
        self.toolButton.setCheckable(True)
        self.toolButton.setToolTip('You can download the spacecraft file from https://fermi.gsfc.nasa.gov/cgi-bin/ssc/LAT/LATDataQuery.cgi')
        self.toolButton.clicked.connect(self.browsefiles)
        self.toolButton_2.setCheckable(True)
        self.toolButton_2.setToolTip('You can download the photon files from https://fermi.gsfc.nasa.gov/cgi-bin/ssc/LAT/LATDataQuery.cgi')
        self.toolButton_2.clicked.connect(self.browsefiles)
        self.toolButton_3.setCheckable(True)
        self.toolButton_3.setToolTip('Please upload your own config.yaml file')
        self.toolButton_3.clicked.connect(self.browsefiles)
        self.toolButton_4.setCheckable(True)
        self.toolButton_4.setToolTip('You can download the background files from https://fermi.gsfc.nasa.gov/ssc/data/access/lat/BackgroundModels.html')
        self.toolButton_4.clicked.connect(self.browsefiles)
        self.toolButton_5.setCheckable(True)
        self.toolButton_5.clicked.connect(self.browsefiles)
        self.toolButton_6.setCheckable(True)
        self.toolButton_6.setToolTip('You can download the photon files from https://fermi.gsfc.nasa.gov/cgi-bin/ssc/LAT/LATDataQuery.cgi')
        self.toolButton_6.clicked.connect(self.browsefiles)
        self.toolButton_10.setCheckable(True)
        self.toolButton_10.clicked.connect(self.browsefiles)
        
        self.lineEdit_9.setToolTip("Please don't use spaces before or after the commas")
        
        
        ###### Activating/deactivating options
        self.checkBox.clicked.connect(self.activate)
        self.checkBox_2.clicked.connect(self.activate)
        self.checkBox_3.clicked.connect(self.activate)
        self.checkBox_5.clicked.connect(self.activate)
        self.checkBox_8.clicked.connect(self.activate)
        self.checkBox_9.clicked.connect(self.activate)
        self.checkBox_11.clicked.connect(self.activate)
        self.checkBox_12.clicked.connect(self.activate)
        self.radioButton.clicked.connect(self.activate)
        self.radioButton_2.clicked.connect(self.activate)
        self.radioButton_3.clicked.connect(self.activate)
        self.radioButton_4.clicked.connect(self.activate)

        self.comboBox_4.activated.connect(self.activate)
        self.comboBox_4.setToolTip("Is your target listed in the catalog selected above?")

    def retranslateUi(self, mainWindow):
        _translate = QtCore.QCoreApplication.translate
        mainWindow.setWindowIcon(QtGui.QIcon('easyFermiIcon.png'))
        mainWindow.setWindowTitle(_translate("mainWindow", "easyFermi"))
        self.pushButton.setText(_translate("mainWindow", "Go!"))
        self.label_2.setText(_translate("mainWindow", "Log:"))
        self.groupBox_2.setTitle(_translate("mainWindow", "Science:"))
        self.radioButton.setText(_translate("mainWindow", "Disk"))
        self.label_4.setText(_translate("mainWindow", "N⁰ of time bins"))
        self.checkBox_3.setText(_translate("mainWindow", "Extension"))
        self.label_9.setText(_translate("mainWindow", "N⁰ of cores"))
        self.label_10.setText(_translate("mainWindow", "N⁰ of energy bins"))
        self.checkBox.setText(_translate("mainWindow", "Light curve"))
        self.label_5.setText(_translate("mainWindow", "Max. size"))
        self.checkBox_2.setText(_translate("mainWindow", "SED"))
        self.radioButton_2.setText(_translate("mainWindow", "2D-Gauss"))
        self.checkBox_6.setText(_translate("mainWindow", "Remove target"))
        self.checkBox_5.setText(_translate("mainWindow", "TS map"))
        self.checkBox_4.setText(_translate("mainWindow", "Re-localize"))
        self.label_11.setText(_translate("mainWindow", "Photon index"))
        self.groupBox_3.setTitle(_translate("mainWindow", "Advanced configuration:"))
        self.label_15.setText(_translate("mainWindow", "Target name/tag:"))
        self.label_22.setText(_translate("mainWindow", "Comma separated names:"))
        self.checkBox_11.setText(_translate("mainWindow", "Delete sources"))
        self.comboBox_2.setAccessibleName(_translate("mainWindow", "4FGL"))
        self.comboBox_2.setAccessibleDescription(_translate("mainWindow", "4FGL"))
        self.comboBox_2.setItemText(0, _translate("mainWindow", "Power-law"))
        self.comboBox_2.setItemText(1, _translate("mainWindow", "LogPar"))
        self.comboBox_2.setItemText(2, _translate("mainWindow", "PLEC"))
        self.lineEdit_9.setText(_translate("mainWindow", "4FGL J0112.1+2245,4FGL ..."))
        self.checkBox_10.setText(_translate("mainWindow", "Do diagnostic plots"))
        self.label_21.setText(_translate("mainWindow", "Min. sep. (⁰)"))
        self.checkBox_8.setText(_translate("mainWindow", "Find extra sources in the ROI"))
        self.label_20.setText(_translate("mainWindow", "Min. sig."))
        self.checkBox_12.setText(_translate("mainWindow", "Change spectral model:"))
        self.plainTextEdit.setPlainText(_translate("mainWindow", "\n"
""))
        self.toolButton_10.setText(_translate("mainWindow", "..."))
        self.toolButton_4.setText(_translate("mainWindow", "..."))
        self.label_14.setText(_translate("mainWindow", "Dir. of diff. emission:"))
        self.checkBox_9.setText(_translate("mainWindow", "Use external ltcube"))
        self.dateTimeEdit_2.setDisplayFormat(_translate("mainWindow", "dd/MM/yyyy HH:mm:ss"))
        self.dateTimeEdit.setDisplayFormat(_translate("mainWindow", "dd/MM/yyyy HH:mm:ss"))
        self.label_7.setText(_translate("mainWindow", "Start:"))
        self.label_8.setText(_translate("mainWindow", "Stop:"))
        self.toolButton_5.setText(_translate("mainWindow", "..."))
        self.lineEdit_10.setText(_translate("mainWindow", "."))
        self.label_6.setText(_translate("mainWindow", "Dir. of photon files:"))
        self.label.setText(_translate("mainWindow", "Spacecraft file:"))
        self.label_12.setText(_translate("mainWindow", "Output directory:"))
        self.toolButton.setAccessibleDescription(_translate("mainWindow", "spacecraft mission file"))
        self.toolButton.setText(_translate("mainWindow", "..."))
        self.toolButton_2.setText(_translate("mainWindow", "..."))
        self.toolButton_3.setText(_translate("mainWindow", "..."))
        self.label_17.setText(_translate("mainWindow", "<html><head/><body><p>E<span style=\" vertical-align:sub;\">min</span>, E<span style=\" vertical-align:sub;\">max</span> (MeV):</p></body></html>"))
        self.lineEdit_2.setText(_translate("mainWindow", "100, 300000"))
        self.label_18.setText(_translate("mainWindow", "Catalog:"))
        self.label_16.setText(_translate("mainWindow", "RA, Dec (⁰):"))
        self.comboBox.setAccessibleName(_translate("mainWindow", "4FGL"))
        self.comboBox.setAccessibleDescription(_translate("mainWindow", "4FGL"))
        self.comboBox.setItemText(0, _translate("mainWindow", "4FGL"))
        self.comboBox.setItemText(1, _translate("mainWindow", "3FGL"))
        self.lineEdit_8.setText(_translate("mainWindow", "Configuration file (yaml)"))
        self.radioButton_3.setText(_translate("mainWindow", "Standard"))
        self.radioButton_4.setText(_translate("mainWindow", "Custom"))
        self.label_25.setText(_translate("mainWindow", "Config. file:"))
        self.label_23.setText(_translate("mainWindow", "Target cataloged?"))
        self.comboBox_4.setAccessibleName(_translate("mainWindow", "4FGL"))
        self.comboBox_4.setAccessibleDescription(_translate("mainWindow", "4FGL"))
        self.comboBox_4.setItemText(0, _translate("mainWindow", "Yes"))
        self.comboBox_4.setItemText(1, _translate("mainWindow", "No"))
        self.toolButton_6.setText(_translate("mainWindow", "..."))
        self.label_13.setText(_translate("mainWindow", "Dir. of photon files:"))
        self.menuTutorial.setTitle(_translate("mainWindow", "Tutorial"))
        self.menuCredits.setTitle(_translate("mainWindow", "Credits"))
        self.actionOpen.setText(_translate("mainWindow", "Open..."))
        self.actionSave.setText(_translate("mainWindow", "Save"))
        self.actionSave.setIconText(_translate("mainWindow", "Save"))
        self.actionSave.setShortcut(_translate("mainWindow", "Ctrl+S"))
        self.actionCopy.setText(_translate("mainWindow", "Copy"))
        self.actionCopy.setShortcut(_translate("mainWindow", "Ctrl+C"))
        self.actionPaste.setText(_translate("mainWindow", "Paste"))
        self.actionPaste.setStatusTip(_translate("mainWindow", "Paste a file"))
        self.actionPaste.setShortcut(_translate("mainWindow", "Ctrl+V"))
        self.actionOpen_Tutorial.setText(_translate("mainWindow", "Open Tutorial"))
        self.actionSee_credits.setText(_translate("mainWindow", "See credits"))

    def reportProgress(self, n):
        if n == 0:
            self.progressBar.setProperty("value", 5)
            self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Running gtselect, gtbin, etc.\n")
            if (self.IsThereLtcube is None) & (self.IsThereLtcube3==0):
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- It will take ~"+str(int(self.Time_intervMJD*206/(30.0*60)))+" min to run the ltcube\n")
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"(Don't worry, it really takes some time...)\n")
            else:
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Using precomputed ltcube.\n")
        
        if n == 1:
            if self.checkBox_11.isChecked():
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Deleting source(s): "+self.lineEdit_9.text()+".\n")
            self.progressBar.setProperty("value", 25)
            self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Setup finished.\n")
            self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Computing flux, spectral index, TS, etc.\n")
            
        if n == 2:
            self.progressBar.setProperty("value", 50)
            self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+self.fitquality+"\n")
            self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Main results saved in General_results.txt\n")
            if self.checkBox_4.isChecked():
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Re-localizing target...\n")
            if self.checkBox_5.isChecked():
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Computing TS map.\n")
            if self.checkBox_2.isChecked():
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Computing SED.\n")
            if self.checkBox_3.isChecked():
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Computing extension.\n")
            if self.checkBox.isChecked():
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Computing light curve.\n")
                
        if n == 3:
            self.progressBar.setProperty("value", 75)
            if self.checkBox_4.isChecked():
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- New position: RA = "+str(round(self.locRA,3))+", Dec = "+str(round(self.locDec,3))+", r_95 = "+str(round(self.locr95,3))+"\n")
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Localization results saved in "+self.sourcename+"_loc.fits\n")        
            if self.checkBox_5.isChecked():
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- TS map saved as .png and .fits files.\n")
            if self.checkBox_2.isChecked():
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- SED data saved in "+self.sourcename+"_sed.fits\n")
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Preliminar SED shown in Quickplot_SED.png\n")
            if self.checkBox_3.isChecked():
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Extension data saved in "+self.sourcename+"_ext.fits\n")
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Extension is shown in Quickplot_extension.png\n")
            if self.checkBox.isChecked():
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- LC saved in file "+self.sourcename+"_lightcurve.fits\n")
                self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- LC is shown in Quickplot_LC.png\n")
            
            
    def runLongTask(self):
        self.thread = QtCore.QThread()
        self.worker = Worker()
        self.worker.moveToThread(self.thread)
        
        # Step 5: Connect signals and slots
        self.thread.started.connect(self.worker.run_gtsetup)
        self.worker.finished.connect(self.thread.quit)
        self.worker.finished.connect(self.worker.deleteLater)
        self.thread.finished.connect(self.thread.deleteLater)
        self.worker.starting.connect(self.readytogo)
        self.worker.progress.connect(self.reportProgress)
        
        # Step 6: Start the thread
        self.thread.start()
        
        # Final reset
        self.thread.finished.connect(  lambda: self.pushButton.setEnabled(True)  )
        _translate = QtCore.QCoreApplication.translate
        
        self.thread.finished.connect(  lambda: self.pushButton.setText(_translate("MainWindow", "Go!"))  )
        
        self.thread.finished.connect(  lambda: self.progressBar.setProperty("value", 100)  )
    
    
    def readytogo(self):
        _translate = QtCore.QCoreApplication.translate
        self.pushButton.setEnabled(False)
        self.pushButton.setText(_translate("MainWindow", "Running..."))
        self.progressBar.setProperty("value", 0)
        
        #Making Fermi logo transparent:
        new_pix = QtGui.QPixmap("fermi.png")
        new_pix.fill(QtCore.Qt.transparent)
        painter = QtGui.QPainter(new_pix)
        painter.setOpacity(0.2)
        painter.drawPixmap(QtCore.QPoint(), QtGui.QPixmap("fermi.png"))
        painter.end()
        self.picture.setPixmap(new_pix)
        self.picture.setGeometry(QtCore.QRect(560, 210, 251, 251))
        
        
        
    def setFermipy(self):
        
        #self.readytogo()
        
        self.OutputDir = self.lineEdit_10.text()+'/'
        
        self.plainTextEdit.setPlainText("")
        
        """
        contador = 0
        #REMOVE:
        now = datetime.now()
        current_time = now.strftime("%H:%M:%S")
        print("Current Time =", current_time,', ',contador)
        contador = contador + 1
        """
        
              
        
        if self.radioButton_4.isChecked(): 
            self.gta = GTAnalysis(self.lineEdit_8.text(),logging={'verbosity': 3})
            self.roiwidth = self.gta.config.get('binning').get('roiwidth')
            self.Emin = self.gta.config.get('selection').get('emin')
            self.Emax = self.gta.config.get('selection').get('emax')
            self.RA = self.gta.config.get('selection').get('ra')
            self.Dec = self.gta.config.get('selection').get('dec')
            photonList = os.system('ls '+self.lineEdit_11.text()+'/*PH*.fits > '+self.OutputDir+'list.txt')
            self.evfile = self.gta.config.get('data')['evfile'] = self.OutputDir+'list.txt'
            self.Time_intervMJD = (self.gta.config.get('selection').get('tmax') - self.gta.config.get('selection').get('tmin'))/86400
            os.system('cp '+self.lineEdit_8.text()+' '+self.OutputDir)
            
        else:
            self.generateConfig()
            #print('Generaring automatic config. file...')
            #self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"Generaring automatic configuration file.\n")
            self.gta = GTAnalysis(self.OutputDir+'config.yaml',logging={'verbosity': 2})
        
        
        
        #Get target name:
        for n,s in enumerate(self.gta.roi.sources):
            if n == 0:
                self.sourcename = s.name

                
        #Change model if requested:
        if self.checkBox_12.isChecked():
            self.gta.delete_source(self.sourcename)
            aux = self.comboBox_2.currentText()
            if aux == 'Power-law':
                aux = 'PowerLaw'
            elif aux == 'LogPar':
                aux = 'LogParabola'
            elif aux == 'PLEC':
                aux = 'PLSuperExpCutoff2'
            self.gta.add_source(self.sourcename, src_dict={'ra' : float(self.RA), 'dec' : float(self.Dec) , 'SpatialModel' : 'PointSource', 'SpectrumType' : aux})
            self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"- Changing target spectral model.\n")
        
        
        #Checking for ltcube:
        self.IsThereLtcube = self.gta.config.get('data').get('ltcube')
        self.IsThereLtcube2 = glob.glob(self.OutputDir+'*.fits')  
        self.IsThereLtcube3 = 0
        if self.OutputDir+'ltcube_00.fits' in self.IsThereLtcube2:
            self.IsThereLtcube3 = 1
        """
        if (self.IsThereLtcube is None) & (self.IsThereLtcube3==0):
            self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"It will take ~"+str(int(self.Time_intervMJD*206/(30.0*60)))+" min to run the ltcube\n")
            self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"(Don't worry, it really takes some time...)\n")
    
        """

        
        
    def generateConfig(self):
        
        date = self.dateTimeEdit.text()
        date2 = self.dateTimeEdit_2.text()
        timeStart = ['2008-08-04T15:43:36']
        tStart = Time(timeStart)
        tStartMJD = tStart.mjd[0]
        METStart = 239557417
        times = [str(date[6:10])+'-'+str(date[3:5])+'-'+str(date[:2])+'T'+str(date[11:19]),    str(date2[6:10])+'-'+str(date2[3:5])+'-'+str(date2[:2])+'T'+str(date2[11:19])              ]
        t = Time(times)
        t0 = t.mjd[0]
        t1 = t.mjd[1]
        tmin = (t0-tStartMJD)*86400 + METStart
        tmax = (t1-tStartMJD)*86400 + METStart
        
        self.Time_intervMJD = t1-t0 
        
        catalog = self.comboBox.currentText()
        
        f = open(self.OutputDir+'config.yaml','w')
        f.write('data:\n')
        photonList = os.system('ls '+self.lineEdit_5.text()+'/*PH*.fits > '+self.OutputDir+'list.txt')
        f.write('  evfile : '+self.OutputDir+'list.txt\n')   
        f.write('  scfile : '+self.lineEdit_3.text()+'\n')
        if self.checkBox_9.isChecked():
            f.write('  ltcube : '+self.lineEdit_7.text()+'\n')
        
        
        Coords = self.lineEdit.text()
        aux = Coords.find(',')
        self.RA = Coords[0:aux]
        self.Dec = Coords[aux+1:]
        
        Energies = self.lineEdit_2.text().split(',')
        
        self.Emin = float(Energies[0])
        self.Emax = float(Energies[1])
        if self.Emin < 500:
            zmax = 90
            self.roiwidth = 15
        elif 500 <= self.Emin < 1000:
            zmax = 100
            self.roiwidth = 12
        else:
            zmax = 105
            self.roiwidth = 10
        
        f.write('\nbinning:\n')
        f.write('  roiwidth   : '+str(self.roiwidth)+'\n')
        f.write('  binsz      : 0.1\n')
        f.write('  binsperdec : 8\n\n')
        f.write('selection :\n')
        f.write('  emin : '+str(self.Emin)+'\n')
        f.write('  emax : '+str(self.Emax)+'\n')
        f.write('  zmax    : '+str(zmax)+'\n')
        f.write('  evclass : 128\n')
        f.write('  evtype  : 3\n')
        f.write('  ra: '+self.RA+'\n')
        f.write('  dec: '+self.Dec+'\n')
        f.write('  tmin: '+str(int(tmin))+'\n')
        f.write('  tmax: '+str(int(tmax))+'\n\n')
        f.write('gtlike:\n')
        f.write('  edisp : True\n')
        f.write("  irfs : 'P8R3_SOURCE_V3'\n")
        f.write("  edisp_disable : ['isodiff']\n")
        f.write('  edisp_bins : -2\n\n')
        f.write('model:\n')
        f.write('  src_roiwidth : '+str(self.roiwidth+10)+'\n')
        f.write("  galdiff  : '"+self.lineEdit_4.text()+"/gll_iem_v07.fits'\n")
        f.write("  isodiff  : '"+self.lineEdit_4.text()+"/iso_P8R3_SOURCE_V3_v1.txt'\n")
        f.write("  catalogs : ['"+catalog+"']\n")
        
        
        
        if self.lineEdit_6.isEnabled():
            f.write("  sources  :\n")
            n = self.lineEdit.text().split(',')
            f.write("    - { name: '"+self.lineEdit_6.text()+"', ra : "+n[0]+", dec : "+n[1]+", SpectrumType : '"+self.comboBox_2.currentText()+"', SpatialModel: 'PointSource' }")
        
        f.close()
        
        
        
    def popup_tutorial(self):
        msg = QtWidgets.QMessageBox()
        msg.setWindowTitle("Quick tutorial")
        msg.setText("Please check the tutorial on YouTube:\n<a href='https://www.youtube.com/channel/UCeLCfEoWasUKky6CPNN_opQ'>Video tutorial</a>")
        msg.setTextFormat(QtCore.Qt.RichText)
               
        msg.setIcon(QtWidgets.QMessageBox.Information) #Information, Critical, Warning
        
        
        x = msg.exec_()
        
        
    def popup_credits(self):
        msg = QtWidgets.QMessageBox()
        msg.setWindowTitle("Credits")
        msg.setText("######################################################################################\n")
        msg.setInformativeText("- To acknowledge easyFermi, please cite 'de Menezes, R (2022)'.\n- Since easyFermi relies on Fermipy, please cite 'Wood et al. 2017'.\n\n######################################################################################\n\n- I would like to thank Clodomir Vianna and Lucas Costa Campos for their help and strong support in this project.")
        msg.setIcon(QtWidgets.QMessageBox.Information) #Information, Critical, Warning
        
        
        x = msg.exec_()
    
        
    def browsefiles(self):
        if self.toolButton.isChecked():
            fname = QFileDialog.getOpenFileName(self, 'Open file', '', '(*.fits)')
            self.lineEdit_3.setText(fname[0])
            self.toolButton.setChecked(False)
        if self.toolButton_2.isChecked():
            #fname = QFileDialog.getOpenFileName(self, 'Open file', './', '(*.txt *.list *.dat)')
            dir_ = QFileDialog.getExistingDirectory(self, 'Open directory:', './', QtWidgets.QFileDialog.ShowDirsOnly)
            self.lineEdit_5.setText(dir_)
            self.toolButton_2.setChecked(False)
        if self.toolButton_4.isChecked():
            dir_ = QFileDialog.getExistingDirectory(self, 'Open directory:', '', QtWidgets.QFileDialog.ShowDirsOnly)
            self.lineEdit_4.setText(dir_)
            self.toolButton_4.setChecked(False)
        if self.toolButton_5.isChecked():
            dir_ = QFileDialog.getExistingDirectory(self, 'Open directory:', '', QtWidgets.QFileDialog.ShowDirsOnly)
            self.lineEdit_10.setText(dir_)
            self.toolButton_5.setChecked(False)
        if self.toolButton_10.isChecked():
            fname = QFileDialog.getOpenFileName(self, 'Open file', '', '(*.fits)')
            self.lineEdit_7.setText(fname[0])
            self.toolButton_10.setChecked(False)
        if self.toolButton_3.isChecked():
            fname = QFileDialog.getOpenFileName(self, 'Open file', './', '(*.yaml)')
            self.lineEdit_8.setText(fname[0])
            self.toolButton_3.setChecked(False)
        if self.toolButton_6.isChecked():
            dir_ = QFileDialog.getExistingDirectory(self, 'Open directory:', '', QtWidgets.QFileDialog.ShowDirsOnly)
            self.lineEdit_11.setText(dir_)
            self.toolButton_6.setChecked(False)
        
       
    def activate(self):
        """ This function activates/deactivates the entries in the main window"""
        if self.checkBox.isChecked():
            self.spinBox.setEnabled(True)
            self.spinBox_2.setEnabled(True)
            self.label_4.setEnabled(True)
            self.label_9.setEnabled(True)
        else:
            self.spinBox.setEnabled(False)
            self.spinBox_2.setEnabled(False)
            self.label_4.setEnabled(False)
            self.label_9.setEnabled(False)
            
        if self.checkBox_2.isChecked():
            self.spinBox_3.setEnabled(True)
            self.label_10.setEnabled(True)
        else:
            self.spinBox_3.setEnabled(False)
            self.label_10.setEnabled(False)
            
        if self.checkBox_3.isChecked():
            self.doubleSpinBox.setEnabled(True)
            self.radioButton.setEnabled(True)
            self.radioButton_2.setEnabled(True)
            self.label_5.setEnabled(True)
        else:
            self.doubleSpinBox.setEnabled(False)
            self.radioButton.setEnabled(False)
            self.radioButton_2.setEnabled(False)
            self.label_5.setEnabled(False)
            
        if self.checkBox_5.isChecked():
            self.doubleSpinBox_2.setEnabled(True)
            self.checkBox_6.setEnabled(True)
            self.label_11.setEnabled(True)
        else:
            self.doubleSpinBox_2.setEnabled(False)
            self.checkBox_6.setEnabled(False)
            self.label_11.setEnabled(False)
        
                
        if self.checkBox_8.isChecked():
            self.doubleSpinBox_3.setEnabled(True)
            self.doubleSpinBox_4.setEnabled(True)
            self.label_20.setEnabled(True)
            self.label_21.setEnabled(True)
        else:
            self.doubleSpinBox_3.setEnabled(False)
            self.doubleSpinBox_4.setEnabled(False)
            self.label_20.setEnabled(False)
            self.label_21.setEnabled(False)
            
        if self.checkBox_9.isChecked():
            self.lineEdit_7.setEnabled(True)
            self.toolButton_10.setEnabled(True)
        else:
            self.lineEdit_7.setEnabled(False)
            self.toolButton_10.setEnabled(False)
        
        if self.checkBox_11.isChecked():
            self.label_22.setEnabled(True)
            self.lineEdit_9.setEnabled(True)
        else:
            self.label_22.setEnabled(False)
            self.lineEdit_9.setEnabled(False)
            
        if self.checkBox_12.isChecked():
            self.comboBox_2.setEnabled(True)
        else:
            self.comboBox_2.setEnabled(False)
            
        if self.radioButton_4.isChecked():
            self.toolButton_3.setEnabled(True)
            self.lineEdit_8.setEnabled(True)
            self.toolButton_6.setEnabled(True)
            self.lineEdit_11.setEnabled(True)
            self.label_13.setEnabled(True)
            
        else:
            self.toolButton_3.setEnabled(False)
            self.lineEdit_8.setEnabled(False)
            self.toolButton_6.setEnabled(False)
            self.lineEdit_11.setEnabled(False)
            self.label_13.setEnabled(False)
            
        if self.radioButton_3.isChecked():
            self.toolButton.setEnabled(True)
            self.toolButton_2.setEnabled(True)
            self.toolButton_4.setEnabled(True)
            self.lineEdit.setEnabled(True)
            self.lineEdit_2.setEnabled(True)
            self.lineEdit_3.setEnabled(True)
            self.lineEdit_4.setEnabled(True)
            self.lineEdit_5.setEnabled(True)
            self.label.setEnabled(True)
            self.label_6.setEnabled(True)
            self.label_7.setEnabled(True)
            self.label_8.setEnabled(True)
            self.label_14.setEnabled(True)
            self.label_16.setEnabled(True)
            self.label_17.setEnabled(True)
            self.label_18.setEnabled(True)
            self.label_23.setEnabled(True)
            self.comboBox.setEnabled(True)
            self.comboBox_4.setEnabled(True)
            self.dateTimeEdit.setEnabled(True)
            self.dateTimeEdit_2.setEnabled(True)
            self.checkBox_9.setEnabled(True)
        else:
            self.toolButton.setEnabled(False)
            self.toolButton_2.setEnabled(False)
            self.toolButton_4.setEnabled(False)
            self.lineEdit.setEnabled(False)
            self.lineEdit_2.setEnabled(False)
            self.lineEdit_3.setEnabled(False)
            self.lineEdit_4.setEnabled(False)
            self.lineEdit_5.setEnabled(False)
            self.label.setEnabled(False)
            self.label_6.setEnabled(False)
            self.label_7.setEnabled(False)
            self.label_8.setEnabled(False)
            self.label_14.setEnabled(False)
            self.label_16.setEnabled(False)
            self.label_17.setEnabled(False)
            self.label_18.setEnabled(False)
            self.label_23.setEnabled(False)
            self.comboBox.setEnabled(False)
            self.comboBox_4.setEnabled(False)
            self.dateTimeEdit.setEnabled(False)
            self.dateTimeEdit_2.setEnabled(False)
            self.checkBox_9.setEnabled(False)
            if self.checkBox_9.isChecked():
                self.lineEdit_7.setEnabled(False)
                self.toolButton_10.setEnabled(False)
            

        if self.comboBox_4.currentText() == 'Yes':
            self.label_15.setEnabled(False)
            self.lineEdit_6.setEnabled(False)
        elif self.radioButton_3.isChecked():
            self.label_15.setEnabled(True)
            self.lineEdit_6.setEnabled(True)
        else:
            self.label_15.setEnabled(False)
            self.lineEdit_6.setEnabled(False)
    
    
    def analysisBasics(self):
        #Cmap:
        h = pyfits.open(self.OutputDir+'ccube.fits')
        counts = h[0].data
        counts.shape
        h[0].data = np.sum(counts,axis=0)
        h.writeto(self.OutputDir+'cmap.fits',clobber=True)
        
        self.gta.optimize()
        
        if self.checkBox_8.isChecked():
            srcs = self.gta.find_sources(sqrt_ts_threshold=self.doubleSpinBox_3.value(), min_separation=self.doubleSpinBox_4.value(), multithread=True)
        
        #Delete sources:
        if self.checkBox_11.isChecked():
            a = self.lineEdit_9.text().split(',')
            for i in a:
                self.gta.delete_source(i)
        
        self.gta.free_sources(distance=self.roiwidth/2,pars='norm')
        self.gta.free_source('galdiff')
        self.gta.free_source('isodiff')
        self.gta.free_source(self.sourcename)
        
        fit_results = self.gta.fit(optimizer='MINUIT')
        
        if fit_results['fit_quality'] == 3:
            self.fitquality = '- Fit quality: 3. Excelent fit. Full accurate covariance matrix.'
        elif fit_results['fit_quality'] == 2:
            self.fitquality = '- Fit quality: 2. Reasonable fit. Full matrix, but forced positive-definite (i.e. not accurate).'
        elif fit_results['fit_quality'] == 1:
            self.fitquality = '- Fit quality: 1. Poor fit. Diagonal approximation only, not accurate.'
        else:
            self.fitquality = '- Fit quality: 0. Bad fit. Error matrix not calculated.'
        
        #Do plots:
        if self.checkBox_10.isChecked():
            self.gta.write_roi(self.OutputDir+'Results',make_plots=True)
        else:
            self.gta.write_roi(self.OutputDir+'Results',make_plots=False)
        
        #Saving results
        f = open(self.OutputDir+'General_results.txt','w')
        f.write(str(self.gta.roi[self.sourcename]))
        f.write('\nEnergy flux upper limit (MeV cm-2 s-1): '+str(self.gta.roi.sources[0]['eflux_ul95']))
        f.write('\nPhoton flux upper limit (cm-2 s-1): '+str(self.gta.roi.sources[0]['flux_ul95']))
        f.close()
    
    def analysis_advanced(self):
        
        #Relocalize:    
        if self.checkBox_4.isChecked():
            loc = self.gta.localize(self.sourcename, make_plots=True,update=True)
            self.locRA = loc['ra']
            self.locDec = loc['dec']
            self.locr68 = loc['pos_r68']
            self.locr95 = loc['pos_r95']
            #print("New position. RA = ",self.locRA,", Dec = ",self.locDec,", r_68 = ",self.locr68,", r_95 = ",self.locr95)
            #self.plainTextEdit.setPlainText(self.plainTextEdit.toPlainText()+"Localization results saved in the file "+self.sourcename+"_loc.fits\n")
        
        #TSmap:    
        if self.checkBox_5.isChecked():
            model = {'Index' : self.doubleSpinBox_2.value(), 'SpatialModel' : 'PointSource'}
            if self.checkBox_6.isChecked():
                TSmap = self.gta.tsmap(self.OutputDir+'Residuals_TS_map_', model=model, exclude=self.sourcename)
            else:
                TSmap = self.gta.tsmap(self.OutputDir+'Source_TS_map_', model=model)

            fig = plt.figure(figsize=(8,8))
            ROIPlotter(TSmap['sqrt_ts'],roi=self.gta.roi).plot(vmin=0,vmax=5,levels=[3,5,7,9],subplot=111,cmap='magma')
            plt.gca().set_title('sqrt(TS)')
            plt.savefig(self.OutputDir+'TSmap.png',bbox_inches='tight')
        
        #SED:    
        if self.checkBox_2.isChecked():
            c = np.load(self.OutputDir+'Results.npy',allow_pickle=True).flat[0]
            E = np.array(c['sources'][self.sourcename]['model_flux']['energies'])
            dnde = np.array(c['sources'][self.sourcename]['model_flux']['dnde'])
            dnde_hi = np.array(c['sources'][self.sourcename]['model_flux']['dnde_hi'])
            dnde_lo = np.array(c['sources'][self.sourcename]['model_flux']['dnde_lo'])
            
            
            Nbins = self.spinBox_3.value() + 1
            ebins = np.linspace(np.log10(self.Emin),np.log10(self.Emax),num=Nbins)
            ebins = ebins.tolist()
            
            sed = self.gta.sed(self.sourcename,loge_bins=ebins)
            
            plt.figure()
            plt.loglog(E, (E**2)*dnde, 'k--')
            plt.loglog(E, (E**2)*dnde_hi, 'k')
            plt.loglog(E, (E**2)*dnde_lo, 'k')
            plt.errorbar(sed['e_ctr'][sed['ts']>9], sed['e2dnde'][sed['ts']>9], yerr=sed['e2dnde_err'][sed['ts']>9], fmt ='o')
            plt.errorbar(sed['e_ctr'][sed['ts']<=9], sed['e2dnde_ul95'][sed['ts']<=9], yerr=0.3*sed['e2dnde_ul95'][sed['ts']<=9], fmt='o', uplims=True,color='orange')
            plt.xlabel('E [MeV]')
            plt.ylabel(r'E$^{2}$ dN/dE [MeV cm$^{-2}$ s$^{-1}$]')
            plt.tight_layout()
            plt.savefig(self.OutputDir+'Quickplot_SED.png')
            

        
        #Extension:    
        if self.checkBox_3.isChecked():
            import pprint
            self.gta.config['extension']['width_min'] = 0.01
            if self.radioButton.isChecked(): 
                exten = self.gta.extension(self.sourcename,width=np.linspace(0.01,self.doubleSpinBox_2.value(),20).tolist(), spatial_model='RadialDisk')
            else:
                exten = self.gta.extension(self.sourcename,width=np.linspace(0.01,self.doubleSpinBox_2.value(),20).tolist(), spatial_model='RadialGaussian')
                
            self.gta.write_roi('ext_gauss_fit')
            plt.figure(figsize=(8,6))
            plt.plot(exten['width'],exten['dloglike'],marker='o')
            plt.gca().set_xlabel('Width [deg]')
            plt.gca().set_ylabel('Delta Log-Likelihood')
            plt.gca().axvline(exten['ext'], label='Extension radius')
            plt.gca().axvspan(exten['ext']-exten['ext_err_lo'],exten['ext']+exten['ext_err_hi'], alpha=0.2,color='b')

            plt.annotate('TS$_{\mathrm{ext}}$ = %.2f\nR$_{68}$ = %.3f $\pm$ %.3f'%
                (exten['ts_ext'],exten['ext'],exten['ext_err']),xy=(0.05,0.05),xycoords='axes fraction')
            plt.gca().legend(frameon=False)
            plt.savefig(self.OutputDir+'Quickplot_extension.png',bbox_inches='tight')
            
            
            
        #LC:    
        if self.checkBox.isChecked():
            lc = self.gta.lightcurve(self.sourcename, nbins=self.spinBox.value(), free_radius=self.roiwidth/2,use_local_ltcube=True, use_scaled_srcmap=True, free_params=['norm'], shape_ts_threshold=9, multithread=True, nthread=self.spinBox_2.value())
            plt.figure(figsize=(8,4))
            scale = int(np.log10(lc['eflux'][lc['ts']>9].max())) -2
            tmean = (lc['tmin'] + lc['tmax'])/2
            plt.errorbar(tmean[lc['ts']>9], (10**-scale)*lc['eflux'][lc['ts']>9],yerr=(10**-scale)*lc['eflux_err'][lc['ts']>9],fmt='o')
            plt.errorbar(tmean[lc['ts']<=9], (10**-scale)*lc['eflux'][lc['ts']<=9],yerr=5*np.ones(len(lc['eflux_err'][lc['ts']<=9])),fmt='o', uplims=True, color='orange')
            plt.ylabel(r'Energy flux ($10^{'+str(scale)+'}$ MeV cm$^{-2}$ s$^{-1}$)')
            plt.xlabel('Time MET (s)')
            plt.ylim(-10,(10**-scale)*lc['eflux'][lc['ts']>9].max() + 0.5*(10**-scale)*lc['eflux'][lc['ts']>9].max())
            plt.savefig(self.OutputDir+'Quickplot_eLC.png',bbox_inches='tight')
            
            plt.figure(figsize=(8,4))
            scale = int(np.log10(lc['flux'][lc['ts']>9].max())) -2
            plt.errorbar(tmean[lc['ts']>9], (10**-scale)*lc['flux'][lc['ts']>9],yerr=(10**-scale)*lc['flux_err'][lc['ts']>9],fmt='o')
            plt.errorbar(tmean[lc['ts']<=9], (10**-scale)*lc['flux'][lc['ts']<=9],yerr=5*np.ones(len(lc['flux_err'][lc['ts']<=9])),fmt='o', uplims=True, color='orange')
            plt.ylabel(r'Flux ($10^{'+str(scale)+'}$ cm$^{-2}$ s$^{-1}$)')
            plt.xlabel('Time MET (s)')
            plt.ylim(-10,(10**-scale)*lc['flux'][lc['ts']>9].max() + 0.5*(10**-scale)*lc['flux'][lc['ts']>9].max())
            plt.savefig(self.OutputDir+'Quickplot_LC.png',bbox_inches='tight')
            

        #Saving results
        f = open(self.OutputDir+'General_results.txt','w')
        f.write(str(self.gta.roi[self.sourcename]))
        f.write('\nEnergy flux upper limit (MeV cm-2 s-1): '+str(self.gta.roi.sources[0]['eflux_ul95']))
        f.write('\nPhoton flux upper limit (cm-2 s-1): '+str(self.gta.roi.sources[0]['flux_ul95']))
        f.close()



if __name__ == "__main__":
    import sys
    app = QtWidgets.QApplication(sys.argv)
    mainWindow = QtWidgets.QMainWindow()
    ui = Ui_mainWindow()
    ui.setupUi(mainWindow)
    mainWindow.show()
    sys.exit(app.exec_())
