"""
Standards
=========

The standards module provides implementations of standards.

.. toctree::
    :maxdepth: 2

    
.. automodule:: acoustics.standards.iso_tr_25417_2007

.. automodule:: acoustics.standards.iso_9613_1_1993

.. automodule:: acoustics.standards.iso_1996_1_2003

.. automodule:: acoustics.standards.iso_1996_2_2007

.. automodule:: acoustics.standards.iec_61672_1_2013

.. automodule:: acoustics.standards.iec_61260_1_2014

"""
from acoustics.standards import (
    iso_tr_25417_2007,
    iec_61672_1_2013,
    iec_61260_1_2014,
    iso_9613_1_1993,
    iso_1996_1_2003,
    iso_1996_2_2007,
)
