"""
This file contains the fields mapping for each endpoint and version related to SECRETS.

More info for the fields included in each version:
- https://docs.beyondtrust.com/bips/docs/passwordsafe-api
- https://docs.beyondtrust.com/bips/docs/secrets-safe-api
"""

from secrets_safe_library.constants.endpoints import (
    GET_SECRETS_SAFE_SECRETS,
    GET_SECRETS_SAFE_SECRETS_SECRETID,
    GET_SECRETS_SAFE_SECRETS_SECRETID_FILE,
    GET_SECRETS_SAFE_SECRETS_SECRETID_TEXT,
    POST_SECRETS_SAFE_FOLDERS_FOLDERID,
    POST_SECRETS_SAFE_FOLDERS_FOLDERID_FILE,
    POST_SECRETS_SAFE_FOLDERS_FOLDERID_TEXT,
    PUT_SECRETS_SAFE_SECRETS_SECRETID,
    PUT_SECRETS_SAFE_SECRETS_SECRETID_FILE,
    PUT_SECRETS_SAFE_SECRETS_SECRETID_TEXT,
)
from secrets_safe_library.constants.versions import Version

fields = {
    GET_SECRETS_SAFE_SECRETS: {
        Version.V3_0.value: [
            "Id",
            "Title",
            "Description",
            "Username",
            "Password",
            "FileName",
            "FileHash",
            "Text",
            "SecretType",
            "OwnerId",
            "FolderId",
            "CreatedOn",
            "CreatedBy",
            "ModifiedOn",
            "ModifiedBy",
            "Owner",
            "Folder",
            "FolderPath",
            "Owners",
            "OwnerType",
            "Notes",
            "Urls",
        ],
        Version.V3_1.value: [
            "Id",
            "Title",
            "Description",
            "Username",
            "Password",
            "FileName",
            "FileHash",
            "Text",
            "SecretType",
            "FolderId",
            "CreatedOn",
            "CreatedBy",
            "ModifiedOn",
            "ModifiedBy",
            "Folder",
            "FolderPath",
            "Owners",
            "Notes",
            "Urls",
        ],
    },
    GET_SECRETS_SAFE_SECRETS_SECRETID: {
        Version.V3_0.value: [
            "Id",
            "Title",
            "Description",
            "Username",
            "Password",
            "OwnerId",
            "FolderId",
            "CreatedOn",
            "CreatedBy",
            "ModifiedOn",
            "ModifiedBy",
            "Owner",
            "Folder",
            "FolderPath",
            "Owners",
            "Notes",
            "Urls",
        ],
        Version.V3_1.value: [
            "Id",
            "Title",
            "Description",
            "Username",
            "Password",
            "FolderId",
            "CreatedOn",
            "CreatedBy",
            "ModifiedOn",
            "ModifiedBy",
            "Folder",
            "FolderPath",
            "Owners",
            "Notes",
            "Urls",
        ],
    },
    GET_SECRETS_SAFE_SECRETS_SECRETID_TEXT: {
        Version.V3_0.value: [
            "Id",
            "Title",
            "Description",
            "Text",
            "OwnerId",
            "FolderId",
            "CreatedOn",
            "CreatedBy",
            "ModifiedOn",
            "ModifiedBy",
            "Owner",
            "Folder",
            "FolderPath",
            "Owners",
            "OwnerType",
            "Notes",
            "Urls",
        ],
        Version.V3_1.value: [
            "Id",
            "Title",
            "Description",
            "Text",
            "FolderId",
            "CreatedOn",
            "CreatedBy",
            "ModifiedOn",
            "ModifiedBy",
            "Folder",
            "FolderPath",
            "Owners",
            "Notes",
            "Urls",
        ],
    },
    GET_SECRETS_SAFE_SECRETS_SECRETID_FILE: {
        Version.V3_0.value: [
            "Id",
            "Title",
            "Description",
            "OwnerId",
            "FolderId",
            "CreatedOn",
            "CreatedBy",
            "ModifiedOn",
            "ModifiedBy",
            "Owner",
            "Folder",
            "FolderPath",
            "Owners",
            "OwnerType",
            "Notes",
            "FileName",
            "FileHash",
            "Urls",
        ],
        Version.V3_1.value: [
            "Id",
            "Title",
            "Description",
            "FolderId",
            "CreatedOn",
            "CreatedBy",
            "ModifiedOn",
            "ModifiedBy",
            "Folder",
            "FolderPath",
            "Owners",
            "Notes",
            "FileName",
            "FileHash",
            "Urls",
        ],
    },
    POST_SECRETS_SAFE_FOLDERS_FOLDERID: {
        Version.V3_0.value: {
            "Title": str,
            "Description": str,
            "Username": str,
            "Password": str,
            "OwnerId": int,
            "OwnerType": str,
            "Owners": [{"OwnerId": int, "Owner": str, "Email": str}],
            "PasswordRuleID": int,
            "Notes": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
        Version.V3_1.value: {
            "Title": str,
            "Description": str,
            "Username": str,
            "Password": str,
            "Owners": [{"GroupId": int, "UserId": int, "Name": str, "Email": str}],
            "PasswordRuleID": int,
            "Notes": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
    },
    POST_SECRETS_SAFE_FOLDERS_FOLDERID_TEXT: {
        Version.V3_0.value: {
            "Title": str,
            "Description": str,
            "Text": str,
            "OwnerId": int,
            "OwnerType": str,
            "Owners": [{"OwnerId": int, "Owner": str, "Email": str}],
            "Notes": str,
            "FolderId": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
        Version.V3_1.value: {
            "Title": str,
            "Description": str,
            "Text": str,
            "Owners": [{"GroupId": int, "UserId": int, "Name": str, "Email": str}],
            "Notes": str,
            "FolderId": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
    },
    POST_SECRETS_SAFE_FOLDERS_FOLDERID_FILE: {
        Version.V3_0.value: {
            "Title": str,
            "Description": str,
            "OwnerId": int,
            "OwnerType": str,
            "Owners": [{"OwnerId": int, "Owner": str, "Email": str}],
            "Notes": str,
            "FileName": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
        Version.V3_1.value: {
            "Title": str,
            "Description": str,
            "Owners": [{"GroupId": int, "UserId": int, "Name": str, "Email": str}],
            "Notes": str,
            "FileName": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
    },
    PUT_SECRETS_SAFE_SECRETS_SECRETID: {
        Version.V3_0.value: {
            "FolderId": str,
            "Title": str,
            "Description": str,
            "Username": str,
            "Password": str,
            "OwnerId": int,
            "OwnerType": str,
            "Owners": [{"OwnerId": int, "Owner": str, "Email": str}],
            "PasswordRuleID": int,
            "Notes": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
        Version.V3_1.value: {
            "FolderId": str,
            "Title": str,
            "Description": str,
            "Username": str,
            "Password": str,
            "Owners": [{"GroupId": int, "UserId": int, "Name": str, "Email": str}],
            "PasswordRuleID": int,
            "Notes": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
    },
    PUT_SECRETS_SAFE_SECRETS_SECRETID_TEXT: {
        Version.V3_0.value: {
            "FolderId": str,
            "Title": str,
            "Description": str,
            "OwnerId": int,
            "OwnerType": str,
            "Owners": [{"OwnerId": int, "Owner": str, "Email": str}],
            "Notes": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
        Version.V3_1.value: {
            "FolderId": str,
            "Title": str,
            "Description": str,
            "Text": str,
            "Owners": [{"GroupId": int, "UserId": int, "Name": str, "Email": str}],
            "Notes": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
    },
    PUT_SECRETS_SAFE_SECRETS_SECRETID_FILE: {
        Version.V3_0.value: {
            "FolderId": str,
            "Title": str,
            "Description": str,
            "OwnerId": int,
            "OwnerType": str,
            "Owners": [{"OwnerId": int, "Owner": str, "Email": str}],
            "Notes": str,
            "FileName": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
        Version.V3_1.value: {
            "FolderId": str,
            "Title": str,
            "Description": str,
            "Owners": [{"GroupId": int, "UserId": int, "Name": str, "Email": str}],
            "Notes": str,
            "FileName": str,
            "Urls": [{"Id": str, "CredentialId": str, "Url": str}],
        },
    },
}
