"""
This file contains the fields mapping for each endpoint and version related to
MANAGED SYSTEMS.

More info for the fields included in each endpoint and version:
- https://docs.beyondtrust.com/bips/docs/passwordsafe-api
- https://docs.beyondtrust.com/bips/docs/secrets-safe-api
"""

from secrets_safe_library.constants.endpoints import (
    GET_MANAGED_SYSTEMS,
    GET_MANAGED_SYSTEMS_ASSETID,
    GET_MANAGED_SYSTEMS_DATABASEID,
    GET_MANAGED_SYSTEMS_FUNCTIONALACCOUNTID,
    GET_MANAGED_SYSTEMS_MANAGEDSYSTEMID,
    GET_MANAGED_SYSTEMS_WORKGROUPID,
    POST_MANAGED_SYSTEMS_ASSETID,
    POST_MANAGED_SYSTEMS_DATABASEID,
    POST_MANAGED_SYSTEMS_WORKGROUPID,
    PUT_MANAGED_SYSTEMS_MANAGEDSYSTEMID,
)
from secrets_safe_library.constants.versions import Version

fields = {
    GET_MANAGED_SYSTEMS: {
        Version.DEFAULT.value: [
            "ManagedSystemID",
            "EntityTypeID",
            "AssetID",
            "DatabaseID",
            "CloudID",
            "DirectoryID",
            "WorkgroupID",
            "HostName",
            "DnsName",
            "IPAddress",
            "InstanceName",
            "IsDefaultInstance",
            "Template",
            "ForestName",
            "UseSSL",
            "OracleInternetDirectoryID",
            "OracleInternetDirectoryServiceName",
            "SystemName",
            "PlatformID",
            "NetBiosName",
            "Port",
            "Timeout",
            "Description",
            "ContactEmail",
            "PasswordRuleID",
            "DSSKeyRuleID",
            "ReleaseDuration",
            "MaxReleaseDuration",
            "ISAReleaseDuration",
            "AutoManagementFlag",
            "FunctionalAccountID",
            "LoginAccountID",
            "ElevationCommand",
            "SshKeyEnforcementMode",
            "CheckPasswordFlag",
            "ChangePasswordAfterAnyReleaseFlag",
            "ResetPasswordOnMismatchFlag",
            "ChangeFrequencyType",
            "ChangeFrequencyDays",
            "ChangeTime",
            "AccountNameFormat",
            "RemoteClientType",
            "ApplicationHostID",
            "IsApplicationHost",
            "AccessURL",
        ],
    },
    GET_MANAGED_SYSTEMS_MANAGEDSYSTEMID: {
        Version.DEFAULT.value: [
            "ManagedSystemID",
            "EntityTypeID",
            "AssetID",
            "DatabaseID",
            "DirectoryID",
            "CloudID",
            "WorkgroupID",
            "HostName",
            "IPAddress",
            "DnsName",
            "InstanceName",
            "IsDefaultInstance",
            "Template",
            "ForestName",
            "UseSSL",
            "OracleInternetDirectoryID",
            "OracleInternetDirectoryServiceName",
            "SystemName",
            "PlatformID",
            "NetBiosName",
            "Port",
            "Timeout",
            "Description",
            "ContactEmail",
            "PasswordRuleID",
            "DSSKeyRuleID",
            "ReleaseDuration",
            "MaxReleaseDuration",
            "ISAReleaseDuration",
            "AutoManagementFlag",
            "FunctionalAccountID",
            "LoginAccountID",
            "ElevationCommand",
            "SshKeyEnforcementMode",
            "CheckPasswordFlag",
            "ChangePasswordAfterAnyReleaseFlag",
            "ResetPasswordOnMismatchFlag",
            "ChangeFrequencyType",
            "ChangeFrequencyDays",
            "ChangeTime",
            "AccountNameFormat",
            "RemoteClientType",
            "ApplicationHostID",
            "IsApplicationHost",
            "AccessURL",
        ],
    },
    GET_MANAGED_SYSTEMS_ASSETID: {
        Version.DEFAULT.value: [
            "ManagedSystemID",
            "EntityTypeID",
            "AssetID",
            "DirectoryID",
            "DatabaseID",
            "CloudID",
            "WorkgroupID",
            "HostName",
            "DnsName",
            "IPAddress",
            "InstanceName",
            "IsDefaultInstance",
            "Template",
            "ForestName",
            "UseSSL",
            "OracleInternetDirectoryID",
            "OracleInternetDirectoryServiceName",
            "SystemName",
            "PlatformID",
            "NetBiosName",
            "Port",
            "Timeout",
            "Description",
            "ContactEmail",
            "PasswordRuleID",
            "DSSKeyRuleID",
            "ReleaseDuration",
            "MaxReleaseDuration",
            "ISAReleaseDuration",
            "AutoManagementFlag",
            "FunctionalAccountID",
            "LoginAccountID",
            "ElevationCommand",
            "SshKeyEnforcementMode",
            "CheckPasswordFlag",
            "ChangePasswordAfterAnyReleaseFlag",
            "ResetPasswordOnMismatchFlag",
            "ChangeFrequencyType",
            "ChangeFrequencyDays",
            "ChangeTime",
            "AccountNameFormat",
            "RemoteClientType",
            "ApplicationHostID",
            "IsApplicationHost",
            "AccessURL",
        ],
    },
    GET_MANAGED_SYSTEMS_DATABASEID: {
        Version.DEFAULT.value: [
            "ManagedSystemID",
            "EntityTypeID",
            "AssetID",
            "DatabaseID",
            "DirectoryID",
            "WorkgroupID",
            "CloudID",
            "HostName",
            "DnsName",
            "IPAddress",
            "InstanceName",
            "IsDefaultInstance",
            "Template",
            "ForestName",
            "UseSSL",
            "OracleInternetDirectoryID",
            "OracleInternetDirectoryServiceName",
            "SystemName",
            "PlatformID",
            "NetBiosName",
            "Port",
            "Timeout",
            "Description",
            "ContactEmail",
            "PasswordRuleID",
            "DSSKeyRuleID",
            "ReleaseDuration",
            "MaxReleaseDuration",
            "ISAReleaseDuration",
            "AutoManagementFlag",
            "FunctionalAccountID",
            "LoginAccountID",
            "ElevationCommand",
            "SshKeyEnforcementMode",
            "CheckPasswordFlag",
            "ChangePasswordAfterAnyReleaseFlag",
            "ResetPasswordOnMismatchFlag",
            "ChangeFrequencyType",
            "ChangeFrequencyDays",
            "ChangeTime",
            "AccountNameFormat",
            "RemoteClientType",
            "ApplicationHostID",
            "IsApplicationHost",
            "AccessURL",
        ],
    },
    GET_MANAGED_SYSTEMS_FUNCTIONALACCOUNTID: {
        Version.DEFAULT.value: [
            "ManagedSystemID",
            "EntityTypeID",
            "AssetID",
            "DatabaseID",
            "DirectoryID",
            "CloudID",
            "WorkgroupID",
            "HostName",
            "DnsName",
            "IPAddress",
            "InstanceName",
            "IsDefaultInstance",
            "Template",
            "ForestName",
            "UseSSL",
            "OracleInternetDirectoryID",
            "OracleInternetDirectoryServiceName",
            "SystemName",
            "PlatformID",
            "NetBiosName",
            "Port",
            "Timeout",
            "Description",
            "ContactEmail",
            "PasswordRuleID",
            "DSSKeyRuleID",
            "ReleaseDuration",
            "MaxReleaseDuration",
            "ISAReleaseDuration",
            "AutoManagementFlag",
            "FunctionalAccountID",
            "LoginAccountID",
            "ElevationCommand",
            "SshKeyEnforcementMode",
            "CheckPasswordFlag",
            "ChangePasswordAfterAnyReleaseFlag",
            "ResetPasswordOnMismatchFlag",
            "ChangeFrequencyType",
            "ChangeFrequencyDays",
            "ChangeTime",
            "AccountNameFormat",
            "RemoteClientType",
            "ApplicationHostID",
            "IsApplicationHost",
            "AccessURL",
        ],
    },
    GET_MANAGED_SYSTEMS_WORKGROUPID: {
        Version.DEFAULT.value: [
            "ManagedSystemID",
            "EntityTypeID",
            "AssetID",
            "DatabaseID",
            "DirectoryID",
            "WorkgroupID",
            "CloudID",
            "HostName",
            "DnsName",
            "IPAddress",
            "InstanceName",
            "IsDefaultInstance",
            "Template",
            "ForestName",
            "UseSSL",
            "OracleInternetDirectoryID",
            "OracleInternetDirectoryServiceName",
            "SystemName",
            "PlatformID",
            "NetBiosName",
            "Port",
            "Timeout",
            "Description",
            "ContactEmail",
            "PasswordRuleID",
            "DSSKeyRuleID",
            "ReleaseDuration",
            "MaxReleaseDuration",
            "ISAReleaseDuration",
            "AutoManagementFlag",
            "FunctionalAccountID",
            "LoginAccountID",
            "ElevationCommand",
            "SshKeyEnforcementMode",
            "CheckPasswordFlag",
            "ChangePasswordAfterAnyReleaseFlag",
            "ResetPasswordOnMismatchFlag",
            "ChangeFrequencyType",
            "ChangeFrequencyDays",
            "ChangeTime",
            "AccountNameFormat",
            "RemoteClientType",
            "ApplicationHostID",
            "IsApplicationHost",
            "AccessURL",
        ],
    },
    POST_MANAGED_SYSTEMS_ASSETID: {
        Version.V3_0.value: {
            "PlatformID": int,
            "ContactEmail": str,
            "Description": str,
            "Port": int,
            "Timeout": int,
            "SshKeyEnforcementMode": int,
            "DSSKeyRuleID": int,
            "PasswordRuleID": int,
            "LoginAccountID": int,
            "ReleaseDuration": int,
            "MaxReleaseDuration": int,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
            "ElevationCommand": str,
            "CheckPasswordFlag": bool,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
        },
        Version.V3_1.value: {
            "PlatformID": int,
            "ContactEmail": str,
            "Description": str,
            "Port": int,
            "Timeout": int,
            "PasswordRuleID": int,
            "SshKeyEnforcementMode": int,
            "DSSKeyRuleID": int,
            "LoginAccountID": int,
            "ReleaseDuration": int,
            "MaxReleaseDuration": int,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
            "ElevationCommand": str,
            "CheckPasswordFlag": bool,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
            "RemoteClientType": str,
        },
        Version.V3_2.value: {
            "PlatformID": int,
            "ContactEmail": str,
            "Description": str,
            "Port": int,
            "Timeout": int,
            "SshKeyEnforcementMode": int,
            "PasswordRuleID": int,
            "DSSKeyRuleID": int,
            "LoginAccountID": int,
            "ReleaseDuration": int,
            "MaxReleaseDuration": int,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
            "ElevationCommand": str,
            "CheckPasswordFlag": bool,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
            "RemoteClientType": str,
            "ApplicationHostID": int,
            "IsApplicationHost": bool,
        },
    },
    POST_MANAGED_SYSTEMS_DATABASEID: {
        Version.DEFAULT.value: {
            "ContactEmail": str,
            "Description": str,
            "Timeout": int,
            "PasswordRuleID": int,
            "ReleaseDuration": int,
            "MaxReleaseDuration": int,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
            "CheckPasswordFlag": bool,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
        },
    },
    POST_MANAGED_SYSTEMS_WORKGROUPID: {
        Version.V3_0.value: {
            "EntityTypeID": int,
            "HostName": str,
            "IPAddress": str,
            "DnsName": str,
            "InstanceName": str,
            "IsDefaultInstance": bool,
            "Template": str,
            "ForestName": str,
            "UseSSL": bool,
            "PlatformID": int,
            "NetBiosName": str,
            "ContactEmail": str,
            "Description": str,
            "Port": int,
            "Timeout": int,
            "SshKeyEnforcementMode": int,
            "PasswordRuleID": int,
            "ElevationCommand": str,
            "CheckPasswordFlag": bool,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
            "AccessURL": str,
            "DSSKeyRuleID": int,
            "LoginAccountID": int,
            "AccountNameFormat": int,
            "OracleInternetDirectoryID": int,
            "OracleInternetDirectoryServiceName": str,
            "ReleaseDuration": int,
            "MaxReleaseDuration": int,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
        },
        Version.V3_1.value: {
            "EntityTypeID": int,
            "HostName": str,
            "IPAddress": str,
            "DnsName": str,
            "InstanceName": str,
            "IsDefaultInstance": bool,
            "Template": str,
            "ForestName": str,
            "UseSSL": bool,
            "ElevationCommand": str,
            "CheckPasswordFlag": bool,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
            "RemoteClientType": str,
            "PlatformID": int,
            "NetBiosName": str,
            "ContactEmail": str,
            "Description": str,
            "Port": int,
            "Timeout": int,
            "SshKeyEnforcementMode": int,
            "PasswordRuleID": int,
            "DSSKeyRuleID": int,
            "LoginAccountID": int,
            "AccountNameFormat": int,
            "OracleInternetDirectoryID": int,
            "OracleInternetDirectoryServiceName": str,
            "ReleaseDuration": int,
            "MaxReleaseDuration": int,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
            "AccessURL": str,
        },
        Version.V3_2.value: {
            "EntityTypeID": int,
            "HostName": str,
            "IPAddress": str,
            "DnsName": str,
            "InstanceName": str,
            "IsDefaultInstance": bool,
            "Template": str,
            "ForestName": str,
            "UseSSL": bool,
            "PlatformID": int,
            "DSSKeyRuleID": int,
            "LoginAccountID": int,
            "AccountNameFormat": int,
            "OracleInternetDirectoryID": int,
            "OracleInternetDirectoryServiceName": str,
            "ReleaseDuration": int,
            "MaxReleaseDuration": int,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
            "ElevationCommand": str,
            "CheckPasswordFlag": bool,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
            "ApplicationHostID": int,
            "NetBiosName": str,
            "ContactEmail": str,
            "Description": str,
            "Port": int,
            "Timeout": int,
            "SshKeyEnforcementMode": int,
            "PasswordRuleID": int,
            "IsApplicationHost": bool,
            "RemoteClientType": str,
            "AccessURL": str,
        },
        Version.V3_3.value: {
            "EntityTypeID": int,
            "HostName": str,
            "IPAddress": str,
            "DnsName": str,
            "InstanceName": str,
            "IsDefaultInstance": bool,
            "Template": str,
            "ForestName": str,
            "UseSSL": bool,
            "OracleInternetDirectoryID": int,
            "OracleInternetDirectoryServiceName": str,
            "ReleaseDuration": int,
            "MaxReleaseDuration": int,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
            "ElevationCommand": str,
            "CheckPasswordFlag": bool,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
            "RemoteClientType": str,
            "ApplicationHostID": int,
            "PlatformID": int,
            "NetBiosName": str,
            "ContactEmail": str,
            "Description": str,
            "Port": int,
            "Timeout": int,
            "SshKeyEnforcementMode": int,
            "PasswordRuleID": int,
            "DSSKeyRuleID": int,
            "LoginAccountID": int,
            "AccountNameFormat": int,
            "IsApplicationHost": bool,
            "AccessURL": str,
        },
    },
    PUT_MANAGED_SYSTEMS_MANAGEDSYSTEMID: {
        Version.V3_0.value: {
            "WorkgroupID": int,
            "HostName": str,
            "IPAddress": str,
            "DnsName": str,
            "InstanceName": str,
            "IsDefaultInstance": bool,
            "Template": str,
            "ForestName": str,
            "UseSSL": bool,
            "PlatformID": int,
            "NetBiosName": str,
            "ContactEmail": str,
            "Description": str,
            "Port": int,
            "Timeout": int,
            "SshKeyEnforcementMode": int,
            "PasswordRuleID": int,
            "DSSKeyRuleID": int,
            "LoginAccountID": int,
            "ReleaseDuration": int,
            "MaxReleaseDuration": int,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
            "AccessURL": str,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
            "ElevationCommand": str,
            "CheckPasswordFlag": bool,
        },
        Version.V3_1.value: {
            "WorkgroupID": int,
            "HostName": str,
            "IPAddress": str,
            "DnsName": str,
            "InstanceName": str,
            "IsDefaultInstance": bool,
            "Template": str,
            "ForestName": str,
            "UseSSL": bool,
            "PlatformID": int,
            "NetBiosName": str,
            "ContactEmail": str,
            "Description": str,
            "Port": int,
            "Timeout": int,
            "SshKeyEnforcementMode": int,
            "PasswordRuleID": int,
            "DSSKeyRuleID": int,
            "LoginAccountID": int,
            "ReleaseDuration": int,
            "ElevationCommand": str,
            "CheckPasswordFlag": bool,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "MaxReleaseDuration": int,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
            "RemoteClientType": str,
            "AccessURL": str,
        },
        Version.V3_2.value: {
            "WorkgroupID": int,
            "HostName": str,
            "IPAddress": str,
            "DnsName": str,
            "InstanceName": str,
            "IsDefaultInstance": bool,
            "Template": str,
            "ForestName": str,
            "UseSSL": bool,
            "PlatformID": int,
            "NetBiosName": str,
            "Timeout": int,
            "SshKeyEnforcementMode": int,
            "PasswordRuleID": int,
            "DSSKeyRuleID": int,
            "ContactEmail": str,
            "Description": str,
            "Port": int,
            "LoginAccountID": int,
            "ReleaseDuration": int,
            "MaxReleaseDuration": int,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
            "ElevationCommand": str,
            "CheckPasswordFlag": bool,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
            "RemoteClientType": str,
            "ApplicationHostID": int,
            "IsApplicationHost": bool,
            "AccessURL": str,
        },
        Version.V3_3.value: {
            "WorkgroupID": int,
            "HostName": str,
            "ForestName": str,
            "UseSSL": bool,
            "PlatformID": int,
            "NetBiosName": str,
            "ContactEmail": str,
            "IPAddress": str,
            "DnsName": str,
            "InstanceName": str,
            "IsDefaultInstance": bool,
            "Template": str,
            "Description": str,
            "Port": int,
            "Timeout": int,
            "SshKeyEnforcementMode": int,
            "PasswordRuleID": int,
            "DSSKeyRuleID": int,
            "LoginAccountID": int,
            "ReleaseDuration": int,
            "MaxReleaseDuration": int,
            "ISAReleaseDuration": int,
            "AutoManagementFlag": bool,
            "FunctionalAccountID": int,
            "ElevationCommand": str,
            "CheckPasswordFlag": bool,
            "ChangePasswordAfterAnyReleaseFlag": bool,
            "ResetPasswordOnMismatchFlag": bool,
            "ChangeFrequencyType": str,
            "ChangeFrequencyDays": int,
            "ChangeTime": str,
            "RemoteClientType": str,
            "ApplicationHostID": int,
            "IsApplicationHost": bool,
            "AccessURL": str,
        },
    },
}
