/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModsScreen;
import io.github.prospector.modmenu.gui.entries.ChildEntry;
import io.github.prospector.modmenu.gui.entries.IndependentEntry;
import io.github.prospector.modmenu.gui.entries.ParentEntry;
import io.github.prospector.modmenu.mixin.EntryListWidgetAccessor;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.ModListSearch;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1043;
import net.minecraft.class_1159;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModListWidget
extends class_4280<ModListEntry>
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
    private final Map<Path, class_1043> modIconsCache = new HashMap<Path, class_1043>();
    private final ModsScreen parent;
    private List<ModContainer> modContainerList = null;
    private Set<ModContainer> addedMods = new HashSet<ModContainer>();
    private String selectedModId = null;
    private boolean scrolling;

    public ModListWidget(class_310 client, int width, int height, int y1, int y2, int entryHeight, String searchTerm, ModListWidget list, ModsScreen parent) {
        super(client, width, height, y1, y2, entryHeight);
        this.parent = parent;
        if (list != null) {
            this.modContainerList = list.modContainerList;
        }
        this.filter(searchTerm, false);
        this.method_25307(parent.getScrollPercent() * (double)Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)));
    }

    public void method_25307(double amount) {
        super.method_25307(amount);
        int denominator = Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4));
        if (denominator <= 0) {
            this.parent.updateScrollPercent(0.0);
        } else {
            this.parent.updateScrollPercent(this.method_25341() / (double)Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)));
        }
    }

    protected boolean method_25316() {
        return this.parent.method_25399() == this;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
        if (entry != null) {
            ModMetadata metadata = entry.getMetadata();
            class_333.field_2054.method_19788(new class_2588("narrator.select", new Object[]{HardcodedUtil.formatFabricModuleName(metadata.getName())}).getString());
        }
    }

    public void setSelected(ModListEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.selectedModId = entry.getMetadata().getId();
        this.parent.updateSelectedEntry((ModListEntry)this.method_25334());
    }

    protected boolean method_25332(int index) {
        ModListEntry selected = (ModListEntry)this.method_25334();
        return selected != null && selected.getMetadata().getId().equals(((ModListEntry)this.method_25326(index)).getMetadata().getId());
    }

    public int addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.container)) {
            return 0;
        }
        this.addedMods.add(entry.container);
        int i = super.method_25321((class_350.class_351)entry);
        if (entry.getMetadata().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
        return i;
    }

    protected boolean removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.container);
        return super.method_25330((class_350.class_351)entry);
    }

    protected ModListEntry remove(int index) {
        this.addedMods.remove(((ModListEntry)this.method_25326((int)index)).container);
        return (ModListEntry)super.method_25338(index);
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.method_25339();
        this.addedMods.clear();
        ArrayList mods = FabricLoader.getInstance().getAllMods();
        if (DEBUG) {
            mods = new ArrayList(mods);
        }
        if (this.modContainerList == null || refresh) {
            this.modContainerList = new ArrayList<ModContainer>();
            this.modContainerList.addAll(mods);
            this.modContainerList.sort(ModMenuConfigManager.getConfig().getSorting().getComparator());
        }
        boolean validSearch = ModListSearch.validSearchQuery(searchTerm);
        List<ModContainer> matched = ModListSearch.search(this.parent, searchTerm, this.modContainerList);
        for (ModContainer container : matched) {
            ModMetadata metadata = container.getMetadata();
            String modId = metadata.getId();
            boolean library = ModMenu.LIBRARY_MODS.contains(modId);
            if (library && !ModMenuConfigManager.getConfig().showLibraries() || ModMenu.PARENT_MAP.values().contains(container)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(container)) {
                List children = ModMenu.PARENT_MAP.get((Object)container);
                children.sort(ModMenuConfigManager.getConfig().getSorting().getComparator());
                ParentEntry parent = new ParentEntry(container, children, this);
                this.addEntry(parent);
                if (!this.parent.showModChildren.contains(modId)) continue;
                List<ModContainer> validChildren = ModListSearch.search(this.parent, searchTerm, children);
                for (ModContainer child : validChildren) {
                    this.addEntry(new ChildEntry(child, parent, this, validChildren.indexOf(child) == validChildren.size() - 1));
                }
                continue;
            }
            this.addEntry(new IndependentEntry(container, this));
        }
        if (this.parent.getSelectedEntry() != null && !this.method_25396().isEmpty() || this.method_25334() != null && ((ModListEntry)this.method_25334()).getMetadata() != this.parent.getSelectedEntry().getMetadata()) {
            for (ModListEntry entry : this.method_25396()) {
                if (!entry.getMetadata().equals(this.parent.getSelectedEntry().getMetadata())) continue;
                this.setSelected(entry);
            }
        } else if (this.method_25334() == null && !this.method_25396().isEmpty() && this.method_25326(0) != null) {
            this.setSelected((ModListEntry)this.method_25326(0));
        }
        if (this.method_25341() > (double)Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4))) {
            this.method_25307(Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)));
        }
    }

    protected void method_25311(class_4587 matrices, int x, int y, int mouseX, int mouseY, float delta) {
        int itemCount = this.method_25340();
        class_289 tessellator_1 = class_289.method_1348();
        class_287 buffer = tessellator_1.method_1349();
        for (int index = 0; index < itemCount; ++index) {
            int entryLeft;
            int entryTop = this.method_25337(index) + 2;
            int entryBottom = this.method_25337(index) + this.field_22741;
            if (entryBottom < this.field_19085 || entryTop > this.field_19086) continue;
            int entryHeight = this.field_22741 - 4;
            ModListEntry entry = (ModListEntry)this.method_25326(index);
            int rowWidth = this.method_25322();
            if (((EntryListWidgetAccessor)((Object)this)).isRenderSelection() && this.method_25332(index)) {
                entryLeft = this.method_25342() - 2 + entry.getXOffset();
                int selectionRight = x + rowWidth + 2;
                RenderSystem.disableTexture();
                float float_2 = this.method_25316() ? 1.0f : 0.5f;
                RenderSystem.color4f((float)float_2, (float)float_2, (float)float_2, (float)1.0f);
                class_1159 matrix = matrices.method_23760().method_23761();
                buffer.method_1328(7, class_290.field_1592);
                buffer.method_22918(matrix, (float)entryLeft, (float)(entryTop + entryHeight + 2), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)selectionRight, (float)(entryTop + entryHeight + 2), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)selectionRight, (float)(entryTop - 2), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)entryLeft, (float)(entryTop - 2), 0.0f).method_1344();
                tessellator_1.method_1350();
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.method_1328(7, class_290.field_1592);
                buffer.method_22918(matrix, (float)(entryLeft + 1), (float)(entryTop + entryHeight + 1), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)(selectionRight - 1), (float)(entryTop + entryHeight + 1), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)(selectionRight - 1), (float)(entryTop - 1), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)(entryLeft + 1), (float)(entryTop - 1), 0.0f).method_1344();
                tessellator_1.method_1350();
                RenderSystem.enableTexture();
            }
            entryLeft = this.method_25342();
            entry.method_25343(matrices, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, this.method_25405(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry), delta);
        }
    }

    protected void method_25318(double double_1, double double_2, int int_1) {
        super.method_25318(double_1, double_2, int_1);
        this.scrolling = int_1 == 0 && double_1 >= (double)this.method_25329() && double_1 < (double)(this.method_25329() + 6);
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        this.method_25318(double_1, double_2, int_1);
        if (!this.method_25405(double_1, double_2)) {
            return false;
        }
        ModListEntry entry = this.getEntryAtPos(double_1, double_2);
        if (entry != null) {
            if (entry.method_25402(double_1, double_2, int_1)) {
                this.method_25395((class_364)entry);
                this.method_25398(true);
                return true;
            }
        } else if (int_1 == 0) {
            this.method_25310((int)(double_1 - (double)(this.field_19088 + this.field_22742 / 2 - this.method_25322() / 2)), (int)(double_2 - (double)this.field_19085) + (int)this.method_25341() - 4);
            return true;
        }
        return this.scrolling;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = class_3532.method_15357((double)(y - (double)this.field_19085)) - this.field_22748 + (int)this.method_25341() - 4;
        int index = int_5 / this.field_22741;
        return x < (double)this.method_25329() && x >= (double)this.method_25342() && x <= (double)(this.method_25342() + this.method_25322()) && index >= 0 && int_5 >= 0 && index < this.method_25340() ? (ModListEntry)((Object)this.method_25396().get(index)) : null;
    }

    protected int method_25329() {
        return this.field_22742 - 6;
    }

    public int method_25322() {
        return this.field_22742 - (Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)) > 0 ? 18 : 12);
    }

    public int method_25342() {
        return this.field_19088 + 6;
    }

    public int getWidth() {
        return this.field_22742;
    }

    public int getTop() {
        return this.field_19085;
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    protected int method_25317() {
        return super.method_25317() + 4;
    }

    public int getDisplayedCount() {
        return this.method_25396().size();
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.method_25396()) {
            if (!set.contains(c.getMetadata().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
        for (class_1043 tex : this.modIconsCache.values()) {
            tex.close();
        }
    }

    class_1043 getCachedModIcon(Path path) {
        return this.modIconsCache.get(path);
    }

    void cacheModIcon(Path path, class_1043 tex) {
        this.modIconsCache.put(path, tex);
    }

    public Set<ModContainer> getCurrentModSet() {
        return this.addedMods;
    }
}

