/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.Tokenizer;
import carpet.script.argument.FunctionArgument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ReturnStatement;
import carpet.script.language.Operators;
import carpet.script.value.FunctionAnnotationValue;
import carpet.script.value.FunctionSignatureValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.Collectors;

public class Functions {
    public static void apply(Expression expression) {
        expression.addLazyFunction("import", -1, (c, t, lv) -> {
            if (lv.size() < 1) {
                throw new InternalExpressionException("'import' needs at least a module name to import, and list of values to import");
            }
            String moduleName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            c.host.importModule((Context)c, moduleName);
            moduleName = moduleName.toLowerCase(Locale.ROOT);
            if (lv.size() > 1) {
                c.host.importNames((Context)c, expression.module, moduleName, lv.subList(1, lv.size()).stream().map(l -> l.evalValue((Context)c).getString()).collect(Collectors.toList()));
            }
            if (t == 1) {
                return LazyValue.NULL;
            }
            ListValue list = ListValue.wrap(c.host.availableImports(moduleName).map(StringValue::new).collect(Collectors.toList()));
            return (cc, tt) -> list;
        });
        expression.addLazyFunctionWithDelegation("call", -1, (c, t, expr, tok, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'call' expects at least function name to call");
            }
            if (t != 7) {
                FunctionArgument functionArgument = FunctionArgument.findIn(c, expression.module, lv, 0, false, false, true);
                FunctionValue fun = functionArgument.function;
                Value retval = fun.callInContext((Expression)expr, (Context)c, (Integer)t, fun.getExpression(), fun.getToken(), functionArgument.args).evalValue((Context)c);
                return (cc, tt) -> retval;
            }
            String name = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            ArrayList<String> args = new ArrayList<String>();
            ArrayList<String> globals = new ArrayList<String>();
            String varArgs = null;
            for (int i = 1; i < lv.size(); ++i) {
                Value v = ((LazyValue)lv.get(i)).evalValue((Context)c, 8);
                if (!v.isBound()) {
                    throw new InternalExpressionException("Only variables can be used in function signature, not  " + v.getString());
                }
                if (v instanceof FunctionAnnotationValue) {
                    if (((FunctionAnnotationValue)v).type == 0) {
                        globals.add(v.boundVariable);
                        continue;
                    }
                    if (varArgs != null) {
                        throw new InternalExpressionException("Variable argument identifier is already defined as " + varArgs + ", trying to overwrite with " + v.boundVariable);
                    }
                    varArgs = v.boundVariable;
                    continue;
                }
                args.add(v.boundVariable);
            }
            FunctionSignatureValue retval = new FunctionSignatureValue(name, args, varArgs, globals);
            return (cc, tt) -> retval;
        });
        expression.addLazyFunction("outer", 1, (c, t, lv) -> {
            if (t != 8) {
                throw new InternalExpressionException("Outer scoping of variables is only possible in function signatures");
            }
            return (cc, tt) -> new FunctionAnnotationValue(((LazyValue)lv.get(0)).evalValue((Context)c), 0);
        });
        expression.addLazyUnaryOperator("...", Operators.precedence.get("def->..."), false, (c, t, lv) -> {
            if (t != 8) {
                throw new InternalExpressionException("Outer scoping of variables is only possible in function signatures");
            }
            return (cc, tt) -> new FunctionAnnotationValue(lv.evalValue((Context)c), 1);
        });
        expression.addLazyBinaryOperatorWithDelegation("->", Operators.precedence.get("def->..."), false, (c, type, e, t, lv1, lv2) -> {
            if (type == 10) {
                ListValue result = ListValue.of(lv1.evalValue((Context)c), lv2.evalValue((Context)c));
                return (cc, tt) -> result;
            }
            Value v1 = lv1.evalValue((Context)c, 7);
            if (!(v1 instanceof FunctionSignatureValue)) {
                throw new InternalExpressionException("'->' operator requires a function signature on the LHS");
            }
            FunctionSignatureValue sign = (FunctionSignatureValue)v1;
            FunctionValue result = expression.createUserDefinedFunction((Context)c, sign.getName(), (Expression)e, (Tokenizer.Token)t, sign.getArgs(), sign.getVarArgs(), sign.getGlobals(), (LazyValue)lv2);
            return (cc, tt) -> result;
        });
        expression.addFunction("return", lv -> {
            throw new ReturnStatement(lv.size() == 0 ? Value.NULL : (Value)lv.get(0));
        });
    }
}

