/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.bundled;

import carpet.script.bundled.Module;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_4615;

public class FileModule
extends Module {
    private String name;
    private String code;
    private boolean library;

    public FileModule(File sourceFile) {
        this.library = sourceFile.getName().endsWith(".scl");
        try {
            this.name = sourceFile.getName().replaceFirst("\\.scl?", "").toLowerCase(Locale.ROOT);
            this.code = new String(Files.readAllBytes(sourceFile.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.name = null;
            this.code = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public boolean isLibrary() {
        return this.library;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static class_2520 read(File file) {
        try (DataInputStream dataInput_1 = new DataInputStream(new FileInputStream(file));){
            byte byte_1 = dataInput_1.readByte();
            if (byte_1 == 0) {
                class_2520 class_25203 = null;
                return class_25203;
            }
            dataInput_1.readUTF();
            class_2520 class_25202 = class_4615.method_23265((int)byte_1).method_23262((DataInput)dataInput_1, 0, class_2505.field_11556);
            return class_25202;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean write(class_2520 tag_1, File file) {
        File file_2 = new File(file.getAbsolutePath() + "_tmp");
        if (file_2.exists()) {
            file_2.delete();
        }
        try (DataOutputStream dataOutputStream_1 = new DataOutputStream(new FileOutputStream(file_2));){
            dataOutputStream_1.writeByte(tag_1.method_10711());
            if (tag_1.method_10711() != 0) {
                dataOutputStream_1.writeUTF("");
                tag_1.method_10713((DataOutput)dataOutputStream_1);
            }
        }
        catch (IOException e) {
            return false;
        }
        if (file.exists()) {
            file.delete();
        }
        if (!file.exists()) {
            file_2.renameTo(file);
        }
        return true;
    }

    public static boolean appendText(File filePath, boolean addNewLines, List<String> data) {
        try {
            OutputStream out = Files.newOutputStream(filePath.toPath(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));){
                for (String line : data) {
                    writer.append(line);
                    if (!addNewLines) continue;
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listFileContent(File filePath) {
        try (BufferedReader reader = Files.newBufferedReader(filePath.toPath(), StandardCharsets.UTF_8);){
            ArrayList<String> result = new ArrayList<String>();
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    ArrayList<String> arrayList = result;
                    return arrayList;
                }
                result.add(line.replaceAll("[\n\r]+", ""));
            }
        }
        catch (IOException e) {
            return null;
        }
    }
}

