/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetScriptHost;
import carpet.script.ScriptHost;
import carpet.script.bundled.BundledModule;
import carpet.script.bundled.FileModule;
import carpet.script.bundled.Module;
import carpet.script.command.CommandArgument;
import carpet.script.exception.InvalidCallbackException;
import carpet.script.value.FunctionValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.utils.Messenger;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2585;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class CarpetScriptServer {
    public final MinecraftServer server;
    public CarpetScriptHost globalHost;
    public Map<String, CarpetScriptHost> modules;
    public Set<String> unloadableModules;
    public long tickStart;
    public boolean stopAll;
    private Set<String> holyMoly;
    public CarpetEventServer events;
    private static final List<Module> bundledModuleData = new ArrayList<Module>();
    private static final List<Module> ruleModuleData = new ArrayList<Module>();

    public static void registerBuiltInScript(BundledModule app) {
        bundledModuleData.add(app);
    }

    public static void registerSettingsApp(BundledModule app) {
        ruleModuleData.add(app);
    }

    public CarpetScriptServer(MinecraftServer server) {
        this.server = server;
        this.init();
    }

    private void init() {
        ScriptHost.systemGlobals.clear();
        this.events = new CarpetEventServer(this.server);
        this.modules = new HashMap<String, CarpetScriptHost>();
        this.unloadableModules = new HashSet<String>();
        this.tickStart = 0L;
        this.stopAll = false;
        this.holyMoly = this.server.method_3734().method_9235().getRoot().getChildren().stream().map(CommandNode::getName).collect(Collectors.toSet());
        this.globalHost = CarpetScriptHost.create(this, null, false, null);
    }

    public void initializeForWorld() {
        CarpetServer.settingsManager.initializeScarpetRules();
        CarpetServer.extensions.forEach(e -> {
            if (e.customSettingsManager() != null) {
                e.customSettingsManager().initializeScarpetRules();
            }
        });
        if (CarpetSettings.scriptsAutoload) {
            Messenger.m(this.server.method_3739(), "Auto-loading world scarpet apps");
            for (String moduleName : this.listAvailableModules(false)) {
                this.addScriptHost(this.server.method_3739(), moduleName, true, true, false);
            }
        }
    }

    public Module getModule(String name, boolean allowLibraries) {
        File folder = this.server.method_27050(class_5218.field_24188).resolve("scripts").toFile();
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (File script : listOfFiles) {
                if (script.getName().equalsIgnoreCase(name + ".sc")) {
                    return new FileModule(script);
                }
                if (!allowLibraries || !script.getName().equalsIgnoreCase(name + ".scl")) continue;
                return new FileModule(script);
            }
        }
        for (Module moduleData : bundledModuleData) {
            if (!moduleData.getName().equalsIgnoreCase(name) || !allowLibraries && moduleData.isLibrary()) continue;
            return moduleData;
        }
        return null;
    }

    public Module getRuleModule(String name) {
        for (Module moduleData : ruleModuleData) {
            if (!moduleData.getName().equalsIgnoreCase(name)) continue;
            return moduleData;
        }
        return null;
    }

    public List<String> listAvailableModules(boolean includeBuiltIns) {
        File folder;
        File[] listOfFiles;
        ArrayList<String> moduleNames = new ArrayList<String>();
        if (includeBuiltIns) {
            for (Module mi : bundledModuleData) {
                if (mi.isLibrary()) continue;
                moduleNames.add(mi.getName());
            }
        }
        if ((listOfFiles = (folder = this.server.method_27050(class_5218.field_24188).resolve("scripts").toFile()).listFiles()) == null) {
            return moduleNames;
        }
        for (File script : listOfFiles) {
            if (!script.getName().endsWith(".sc")) continue;
            String name = script.getName().replaceFirst("\\.sc", "").toLowerCase(Locale.ROOT);
            moduleNames.add(name);
        }
        return moduleNames;
    }

    public ScriptHost getHostByName(String name) {
        if (name == null) {
            return this.globalHost;
        }
        return this.modules.get(name);
    }

    public boolean addScriptHost(class_2168 source, String name, boolean perPlayer, boolean autoload, boolean isRuleApp) {
        Module module;
        long start = System.nanoTime();
        name = name.toLowerCase(Locale.ROOT);
        boolean reload = false;
        if (this.modules.containsKey(name)) {
            if (isRuleApp) {
                return false;
            }
            this.removeScriptHost(source, name, false, isRuleApp);
            reload = true;
        }
        Module module2 = module = isRuleApp ? this.getRuleModule(name) : this.getModule(name, false);
        if (module == null) {
            Messenger.m(source, "r Failed to add " + name + " app");
            return false;
        }
        CarpetScriptHost newHost = CarpetScriptHost.create(this, module, perPlayer, source);
        if (newHost == null) {
            Messenger.m(source, "r Failed to add " + name + " app");
            return false;
        }
        if (module == null) {
            Messenger.m(source, "r Unable to locate the app, but created empty " + name + " app instead");
            this.modules.put(name, newHost);
            return true;
        }
        String code = module.getCode();
        if (module.getCode() == null) {
            Messenger.m(source, "r Unable to load " + name + " app - not found");
            return false;
        }
        this.modules.put(name, newHost);
        if (!isRuleApp) {
            this.unloadableModules.add(name);
        }
        if (autoload && !newHost.persistenceRequired) {
            this.removeScriptHost(source, name, false, false);
            return false;
        }
        this.addLegacyCommand(source, name, reload, !isRuleApp);
        long end = System.nanoTime();
        CarpetSettings.LOG.info("App " + name + " loaded in " + (end - start) / 1000000L + " ms");
        return true;
    }

    private void addLegacyCommand(class_2168 source, String hostName, boolean isReload, boolean notifySource) {
        String loaded;
        CarpetScriptHost host = this.modules.get(hostName);
        String string = loaded = isReload ? "reloaded" : "loaded";
        if (host == null) {
            return;
        }
        if (host.getFunction("__command") == null) {
            if (notifySource) {
                Messenger.m(source, "gi " + hostName + " app " + loaded + ".");
            }
            return;
        }
        if (this.holyMoly.contains(hostName)) {
            Messenger.m(source, "gi " + hostName + " app " + loaded + " with no command.");
            Messenger.m(source, "gi Tried to mask vanilla command.");
            return;
        }
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)hostName).requires(player -> this.modules.containsKey(hostName))).executes(c -> {
            Value response = this.modules.get(hostName).retrieveForExecution((class_2168)c.getSource()).handleCommandLegacy((class_2168)c.getSource(), "__command", null, "");
            if (!response.isNull()) {
                Messenger.m((class_2168)c.getSource(), "gi " + response.getString());
            }
            return (int)response.readInteger();
        });
        for (String function : host.globaFunctionNames(host.main, s -> !s.startsWith("_")).sorted().collect(Collectors.toList())) {
            if (host.appConfig.containsKey(StringValue.of("legacy_command_type_support"))) {
                command = this.getFancyCommand((LiteralArgumentBuilder<class_2168>)command, host, host.getFunction(function));
                continue;
            }
            command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)function).requires(player -> this.modules.containsKey(hostName) && this.modules.get(hostName).getFunction(function) != null)).executes(c -> {
                Value response = this.modules.get(hostName).retrieveForExecution((class_2168)c.getSource()).handleCommandLegacy((class_2168)c.getSource(), function, null, "");
                if (!response.isNull()) {
                    Messenger.m((class_2168)c.getSource(), "gi " + response.getString());
                }
                return (int)response.readInteger();
            })).then(class_2170.method_9244((String)"args...", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
                Value response = this.modules.get(hostName).retrieveForExecution((class_2168)c.getSource()).handleCommandLegacy((class_2168)c.getSource(), function, null, StringArgumentType.getString((CommandContext)c, (String)"args..."));
                if (!response.isNull()) {
                    Messenger.m((class_2168)c.getSource(), "gi " + response.getString());
                }
                return (int)response.readInteger();
            })));
        }
        if (notifySource) {
            Messenger.m(source, "gi " + hostName + " app " + loaded + " with /" + hostName + " command");
        }
        this.server.method_3734().method_9235().register(command);
        CarpetServer.settingsManager.notifyPlayersCommandsChanged();
    }

    private int execute(CommandContext<class_2168> ctx, String hostName, FunctionValue function, List<String> paramNames) throws CommandSyntaxException {
        CarpetScriptHost cHost = this.modules.get(hostName).retrieveForExecution((class_2168)ctx.getSource());
        List<String> argNames = function.getArguments();
        if (argNames.size() != paramNames.size()) {
            throw new SimpleCommandExceptionType((Message)new class_2585("Target function " + function.getPrettyString() + " as wrong number of arguments, required " + paramNames.size() + ", found " + argNames.size())).create();
        }
        ArrayList<Value> args = new ArrayList<Value>(argNames.size());
        for (String s : paramNames) {
            args.add(CommandArgument.getValue(ctx, s, cHost));
        }
        Value response = cHost.handleCommand((class_2168)ctx.getSource(), function, args);
        if (!response.isNull()) {
            Messenger.m((class_2168)ctx.getSource(), "gi " + response.getString());
        }
        return (int)response.readInteger();
    }

    private LiteralArgumentBuilder<class_2168> getFancyCommand(LiteralArgumentBuilder<class_2168> command, CarpetScriptHost host, FunctionValue function) {
        List<String> argNames = function.getArguments();
        String hostName = host.getName();
        if (argNames.size() == 0) {
            return (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)class_2170.method_9247((String)function.getString()).requires(player -> this.modules.containsKey(hostName))).executes(c -> this.execute((CommandContext<class_2168>)c, hostName, function, Collections.emptyList())));
        }
        ArrayList<String> reversedArgs = new ArrayList<String>(argNames);
        Collections.reverse(reversedArgs);
        RequiredArgumentBuilder argChain = (RequiredArgumentBuilder)CommandArgument.argumentNode((String)reversedArgs.get(0), host).executes(c -> this.execute((CommandContext<class_2168>)c, hostName, function, argNames));
        for (int i = 1; i < reversedArgs.size(); ++i) {
            argChain = (RequiredArgumentBuilder)CommandArgument.argumentNode((String)reversedArgs.get(i), host).then((ArgumentBuilder)argChain);
        }
        return (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)class_2170.method_9247((String)function.getString()).requires(player -> this.modules.containsKey(hostName))).then((ArgumentBuilder)argChain));
    }

    public boolean removeScriptHost(class_2168 source, String name, boolean notifySource, boolean isRuleApp) {
        if (!this.modules.containsKey(name = name.toLowerCase(Locale.ROOT)) || !isRuleApp && !this.unloadableModules.contains(name)) {
            if (notifySource) {
                Messenger.m(source, "r No such app found: ", "wb  " + name);
            }
            return false;
        }
        this.events.removeAllHostEvents(name);
        this.modules.get(name).onClose();
        this.modules.remove(name);
        if (!isRuleApp) {
            this.unloadableModules.remove(name);
        }
        CarpetServer.settingsManager.notifyPlayersCommandsChanged();
        if (notifySource) {
            Messenger.m(source, "gi Removed " + name + " app");
        }
        return true;
    }

    public boolean runas(class_2168 source, String hostname, FunctionValue udf, List<Value> argv) {
        return this.runas(class_2338.field_10980, source, hostname, udf, argv);
    }

    public boolean runas(class_2338 origin, class_2168 source, String hostname, FunctionValue udf, List<Value> argv) {
        CarpetScriptHost host = this.globalHost;
        try {
            if (hostname != null) {
                host = this.modules.get(hostname).retrieveForExecution(source);
            }
            host.callUDF(origin, source, udf, argv);
        }
        catch (InvalidCallbackException | NullPointerException npe) {
            return false;
        }
        return true;
    }

    public void tick() {
        this.events.tick();
        for (CarpetScriptHost host : this.modules.values()) {
            host.tick();
        }
    }

    public void onClose() {
        for (ScriptHost scriptHost : this.modules.values()) {
            scriptHost.onClose();
        }
    }

    public void reload(MinecraftServer server) {
        HashMap<String, Boolean> apps = new HashMap<String, Boolean>();
        this.modules.forEach((s, h) -> apps.put((String)s, h.perUser));
        apps.keySet().forEach(s -> this.removeScriptHost(server.method_3739(), (String)s, false, false));
        this.events.clearAll();
        this.init();
        apps.forEach((s, pp) -> this.addScriptHost(server.method_3739(), (String)s, (boolean)pp, false, false));
    }

    static {
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("camera", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("overlay", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("event_test", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("stats_test", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("math", true));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("chunk_display", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("ai_tracker", false));
    }
}

