/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.script.CarpetContext;
import carpet.script.ScriptHost;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BlockValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.settings.ParsedRule;
import carpet.utils.Messenger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class CarpetEventServer {
    public final List<ScheduledCall> scheduledCalls = new LinkedList<ScheduledCall>();
    public final MinecraftServer server;
    private static final List<Value> NOARGS = Collections.emptyList();

    public CarpetEventServer(MinecraftServer server) {
        this.server = server;
        for (Event e : Event.byName.values()) {
            e.handler.callList.clear();
        }
    }

    public void tick() {
        Iterator<ScheduledCall> eventIterator = this.scheduledCalls.iterator();
        ArrayList<ScheduledCall> currentCalls = new ArrayList<ScheduledCall>();
        while (eventIterator.hasNext()) {
            ScheduledCall call = eventIterator.next();
            --call.dueTime;
            if (call.dueTime > 0L) continue;
            currentCalls.add(call);
            eventIterator.remove();
        }
        for (ScheduledCall call : currentCalls) {
            call.execute();
        }
    }

    public void scheduleCall(CarpetContext context, FunctionValue function, List<Value> args, long due) {
        this.scheduledCalls.add(new ScheduledCall(context, function, args, due));
    }

    public boolean addEvent(class_2168 source, String event, String host, String funName) {
        if (!Event.byName.containsKey(event)) {
            return false;
        }
        Event ev = Event.byName.get(event);
        boolean added = ev.handler.addEventCall(source, host, funName, h -> this.canAddEvent(ev, (ScriptHost)h));
        if (added) {
            Messenger.m(source, "gi Added " + funName + " to " + event);
        }
        return added;
    }

    public void addEventDirectly(String event, ScriptHost host, FunctionValue function, List<Value> args) {
        Event ev = Event.byName.get(event);
        if (!this.canAddEvent(ev, host)) {
            throw new InternalExpressionException("Global event " + event + " can only be added to apps with global scope");
        }
        boolean success = ev.handler.addEventCallInternal(host, function, args == null ? NOARGS : args);
        if (!success) {
            throw new InternalExpressionException("Global event " + event + " requires " + ev.handler.reqArgs + ", not " + (function.getNumParams() - (args == null ? 0 : args.size())));
        }
    }

    private boolean canAddEvent(Event event, ScriptHost host) {
        return !event.globalOnly || !host.perUser && host.parent == null;
    }

    public boolean removeEvent(class_2168 source, String event, String funName) {
        if (!Event.byName.containsKey(event)) {
            Messenger.m(source, "r Unknown event: " + event);
            return false;
        }
        Pair<String, String> call = this.decodeCallback(funName);
        Event.byName.get((Object)event).handler.removeEventCall((String)call.getLeft(), (String)call.getRight());
        Messenger.m(source, "gi Removed event: " + funName + " from " + event);
        return true;
    }

    public boolean removeEventDirectly(String event, ScriptHost host) {
        if (!Event.byName.containsKey(event)) {
            return false;
        }
        Event.byName.get((Object)event).handler.removeAllCalls(host.getName());
        return true;
    }

    public void removeEventDirectly(String event, ScriptHost host, String funName) {
        Event.byName.get((Object)event).handler.removeEventCall(host.getName(), funName);
    }

    public void removeAllHostEvents(String hostName) {
        Event.byName.values().forEach(e -> e.handler.removeAllCalls(hostName));
        this.scheduledCalls.removeIf(sc -> sc.host != null && sc.host.equals(hostName));
    }

    public void clearAll() {
        Event.byName.values().forEach(e -> e.handler.clearEverything());
    }

    private Pair<String, String> decodeCallback(String funName) {
        Pattern find = Pattern.compile("(\\w+)\\(from (\\w+)\\)");
        Matcher matcher = find.matcher(funName);
        if (matcher.matches()) {
            return Pair.of((Object)matcher.group(2), (Object)matcher.group(1));
        }
        return Pair.of(null, (Object)funName);
    }

    public static class Event {
        public static final Map<String, Event> byName = new HashMap<String, Event>();
        public static final Event TICK = new Event("tick", 0, true){

            @Override
            public void onTick() {
                this.handler.call(Collections::emptyList, () -> CarpetServer.minecraft_server.method_3739().method_9227(CarpetServer.minecraft_server.method_3847(class_1937.field_25179)));
            }
        };
        public static final Event NETHER_TICK = new Event("tick_nether", 0, true){

            @Override
            public void onTick() {
                this.handler.call(Collections::emptyList, () -> CarpetServer.minecraft_server.method_3739().method_9227(CarpetServer.minecraft_server.method_3847(class_1937.field_25180)));
            }
        };
        public static final Event ENDER_TICK = new Event("tick_ender", 0, true){

            @Override
            public void onTick() {
                this.handler.call(Collections::emptyList, () -> CarpetServer.minecraft_server.method_3739().method_9227(CarpetServer.minecraft_server.method_3847(class_1937.field_25181)));
            }
        };
        public static final Event CHUNK_GENERATED = new Event("chunk_generated", 2, true){

            @Override
            public void onChunkGenerated(class_3218 world, class_2791 chunk) {
                this.handler.call(() -> {
                    class_1923 pos = chunk.method_12004();
                    return Arrays.asList(new NumericValue(pos.field_9181 << 4), new NumericValue(pos.field_9180 << 4));
                }, () -> CarpetServer.minecraft_server.method_3739().method_9227(world));
            }
        };
        public static final Event PLAYER_JUMPS = new Event("player_jumps", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_DEPLOYS_ELYTRA = new Event("player_deploys_elytra", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_WAKES_UP = new Event("player_wakes_up", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_RIDES = new Event("player_rides", 5, false){

            @Override
            public void onMountControls(class_3222 player, float strafeSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new NumericValue(forwardSpeed), new NumericValue(strafeSpeed), new NumericValue(jumping), new NumericValue(sneaking)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_USES_ITEM = new Event("player_uses_item", 3, false){

            @Override
            public void onItemAction(class_3222 player, class_1268 enumhand, class_1799 itemstack) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), ListValue.fromItemStack(itemstack), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand")), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_CLICKS_BLOCK = new Event("player_clicks_block", 3, false){

            @Override
            public void onBlockAction(class_3222 player, class_2338 blockpos, class_2350 facing) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new BlockValue(null, player.method_14220(), blockpos), StringValue.of(facing.method_10151())), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_RIGHT_CLICKS_BLOCK = new Event("player_right_clicks_block", 6, false){

            @Override
            public void onBlockHit(class_3222 player, class_1268 enumhand, class_3965 hitRes) {
                this.handler.call(() -> {
                    class_1799 itemstack = player.method_5998(enumhand);
                    class_2338 blockpos = hitRes.method_17777();
                    class_2350 enumfacing = hitRes.method_17780();
                    class_243 vec3d = hitRes.method_17784().method_1023((double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260());
                    return Arrays.asList(new EntityValue((class_1297)player), ListValue.fromItemStack(itemstack), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand"), new BlockValue(null, player.method_14220(), blockpos), StringValue.of(enumfacing.method_10151()), ListValue.of(new NumericValue(vec3d.field_1352), new NumericValue(vec3d.field_1351), new NumericValue(vec3d.field_1350)));
                }, () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_INTERACTS_WITH_BLOCK = new Event("player_interacts_with_block", 5, false){

            @Override
            public void onBlockHit(class_3222 player, class_1268 enumhand, class_3965 hitRes) {
                this.handler.call(() -> {
                    class_2338 blockpos = hitRes.method_17777();
                    class_2350 enumfacing = hitRes.method_17780();
                    class_243 vec3d = hitRes.method_17784().method_1023((double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260());
                    return Arrays.asList(new EntityValue((class_1297)player), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand"), new BlockValue(null, player.method_14220(), blockpos), StringValue.of(enumfacing.method_10151()), ListValue.of(new NumericValue(vec3d.field_1352), new NumericValue(vec3d.field_1351), new NumericValue(vec3d.field_1350)));
                }, () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_PLACES_BLOCK = new Event("player_places_block", 4, false){

            @Override
            public void onBlockPlaced(class_3222 player, class_2338 pos, class_1268 enumhand, class_1799 itemstack) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), ListValue.fromItemStack(itemstack), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand"), new BlockValue(null, player.method_14220(), pos)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_BREAK_BLOCK = new Event("player_breaks_block", 2, false){

            @Override
            public void onBlockBroken(class_3222 player, class_2338 pos, class_2680 previousBS) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new BlockValue(previousBS, player.method_14220(), pos)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_INTERACTS_WITH_ENTITY = new Event("player_interacts_with_entity", 3, false){

            @Override
            public void onEntityHandAction(class_3222 player, class_1297 entity, class_1268 enumhand) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new EntityValue(entity), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand")), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_PICKS_UP_ITEM = new Event("player_picks_up_item", 2, false){

            @Override
            public void onItemAction(class_3222 player, class_1268 enumhand, class_1799 itemstack) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), ListValue.fromItemStack(itemstack)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_ATTACKS_ENTITY = new Event("player_attacks_entity", 2, false){

            @Override
            public void onEntityHandAction(class_3222 player, class_1297 entity, class_1268 enumhand) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new EntityValue(entity)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_STARTS_SNEAKING = new Event("player_starts_sneaking", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_STOPS_SNEAKING = new Event("player_stops_sneaking", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_STARTS_SPRINTING = new Event("player_starts_sprinting", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_STOPS_SPRINTING = new Event("player_stops_sprinting", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_RELEASED_ITEM = new Event("player_releases_item", 3, false){

            @Override
            public void onItemAction(class_3222 player, class_1268 enumhand, class_1799 itemstack) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), ListValue.fromItemStack(itemstack), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand")), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_FINISHED_USING_ITEM = new Event("player_finishes_using_item", 3, false){

            @Override
            public void onItemAction(class_3222 player, class_1268 enumhand, class_1799 itemstack) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), ListValue.fromItemStack(itemstack), new StringValue(enumhand == class_1268.field_5808 ? "mainhand" : "offhand")), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_DROPS_ITEM = new Event("player_drops_item", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_DROPS_STACK = new Event("player_drops_stack", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_CHOOSES_RECIPE = new Event("player_chooses_recipe", 3, false){

            @Override
            public void onRecipeSelected(class_3222 player, class_2960 recipe, boolean fullStack) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), StringValue.of(NBTSerializableValue.nameFromRegistryId(recipe)), new NumericValue(fullStack)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_SWITCHES_SLOT = new Event("player_switches_slot", 3, false){

            @Override
            public void onSlotSwitch(class_3222 player, int from, int to) {
                if (from == to) {
                    return;
                }
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new NumericValue(from), new NumericValue(to)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_SWAPS_HANDS = new Event("player_swaps_hands", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_TAKES_DAMAGE = new Event("player_takes_damage", 4, false){

            @Override
            public void onDamage(class_1297 target, float amount, class_1282 source) {
                this.handler.call(() -> Arrays.asList(new EntityValue(target), new NumericValue(amount), StringValue.of(source.method_5525()), source.method_5529() == null ? Value.NULL : new EntityValue(source.method_5529())), () -> ((class_1297)target).method_5671());
            }
        };
        public static final Event PLAYER_DEALS_DAMAGE = new Event("player_deals_damage", 3, false){

            @Override
            public void onDamage(class_1297 target, float amount, class_1282 source) {
                this.handler.call(() -> Arrays.asList(new EntityValue(source.method_5529()), new NumericValue(amount), new EntityValue(target)), () -> source.method_5529().method_5671());
            }
        };
        public static final Event PLAYER_COLLIDES_WITH_ENTITY = new Event("player_collides_with_entity", 2, false){

            @Override
            public void onEntityHandAction(class_3222 player, class_1297 entity, class_1268 enumhand) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new EntityValue(entity)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_DIES = new Event("player_dies", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_RESPAWNS = new Event("player_respawns", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_CHANGES_DIMENSION = new Event("player_changes_dimension", 5, false){

            @Override
            public void onDimensionChange(class_3222 player, class_243 from, class_243 to, class_5321<class_1937> fromDim, class_5321<class_1937> dimTo) {
                Value fromValue = ListValue.fromTriple(from.field_1352, from.field_1351, from.field_1350);
                Value toValue = to == null ? Value.NULL : ListValue.fromTriple(to.field_1352, to.field_1351, to.field_1350);
                StringValue fromDimStr = new StringValue(NBTSerializableValue.nameFromRegistryId(fromDim.method_29177()));
                StringValue toDimStr = new StringValue(NBTSerializableValue.nameFromRegistryId(dimTo.method_29177()));
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), fromValue, fromDimStr, toValue, toDimStr), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_CONNECTS = new Event("player_connects", 1, false){

            @Override
            public void onPlayerEvent(class_3222 player) {
                this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event PLAYER_DISCONNECTS = new Event("player_disconnects", 2, false){

            @Override
            public void onPlayerMessage(class_3222 player, String message) {
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new StringValue(message)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event STATISTICS = new Event("statistic", 4, false){
            private final Set<class_2960> skippedStats = new HashSet<class_2960>(){
                {
                    this.add(class_3468.field_15400);
                    this.add(class_3468.field_15429);
                    this.add(class_3468.field_15417);
                }
            };

            private <T> class_2960 getStatId(class_3445<T> stat) {
                return stat.method_14949().method_14959().method_10221(stat.method_14951());
            }

            @Override
            public void onPlayerStatistic(class_3222 player, class_3445<?> stat, int amount) {
                class_2960 id = this.getStatId(stat);
                if (this.skippedStats.contains(id)) {
                    return;
                }
                this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), StringValue.of(NBTSerializableValue.nameFromRegistryId(class_2378.field_11152.method_10221((Object)stat.method_14949()))), StringValue.of(NBTSerializableValue.nameFromRegistryId(id)), new NumericValue(amount)), () -> ((class_3222)player).method_5671());
            }
        };
        public static final Event LIGHTNING = new Event("lightning", 2, true){

            @Override
            public void onWorldEventFlag(class_3218 world, class_2338 pos, int flag) {
                this.handler.call(() -> Arrays.asList(new BlockValue(null, world, pos), flag > 0 ? Value.TRUE : Value.FALSE), () -> CarpetServer.minecraft_server.method_3739().method_9227(world));
            }
        };
        public static final Event CARPET_RULE_CHANGES = new Event("carpet_rule_changes", 2, true){

            @Override
            public void onCarpetRuleChanges(ParsedRule<?> rule, class_2168 source) {
                String identifier = rule.settingsManager.getIdentifier();
                String namespace = !identifier.equals("carpet") ? identifier + ":" : "";
                this.handler.call(() -> Arrays.asList(new StringValue(namespace + rule.name), new StringValue(rule.getAsString())), () -> source);
            }
        };
        public static final Map<class_1299<? extends class_1297>, Event> ENTITY_LOAD = new HashMap<class_1299<? extends class_1297>, Event>(){
            {
                class_1299.method_5898((String)"zombie");
                class_2378.field_11145.forEach(et -> this.put(et, new Event(Event.getLoadEvent((class_1299<? extends class_1297>)et), 1, true, false){

                    @Override
                    public void onEntityAction(class_1297 entity) {
                        this.handler.call(() -> Collections.singletonList(new EntityValue(entity)), () -> CarpetServer.minecraft_server.method_3739().method_9227((class_3218)entity.field_6002).method_9206(CarpetSettings.runPermissionLevel));
                    }
                }));
            }
        };
        public final String name;
        public final CallbackList handler;
        public final boolean globalOnly;
        public final boolean isPublic;

        public static List<String> publicEvents() {
            return byName.entrySet().stream().filter(e -> ((Event)e.getValue()).isPublic).map(Map.Entry::getKey).collect(Collectors.toList());
        }

        public static String getLoadEvent(class_1299<? extends class_1297> et) {
            return "entity_loaded_" + class_2378.field_11145.method_10221(et);
        }

        public Event(String name, int reqArgs, boolean isGlobalOnly) {
            this(name, reqArgs, isGlobalOnly, true);
        }

        public Event(String name, int reqArgs, boolean isGlobalOnly, boolean isPublic) {
            this.name = name;
            this.handler = new CallbackList(reqArgs);
            this.globalOnly = isGlobalOnly;
            this.isPublic = isPublic;
            byName.put(name, this);
        }

        public boolean isNeeded() {
            return this.handler.callList.size() > 0;
        }

        public void onTick() {
        }

        public void onChunkGenerated(class_3218 world, class_2791 chunk) {
        }

        public void onPlayerEvent(class_3222 player) {
        }

        public void onPlayerMessage(class_3222 player, String message) {
        }

        public void onPlayerStatistic(class_3222 player, class_3445<?> stat, int amount) {
        }

        public void onMountControls(class_3222 player, float strafeSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
        }

        public void onItemAction(class_3222 player, class_1268 enumhand, class_1799 itemstack) {
        }

        public void onBlockAction(class_3222 player, class_2338 blockpos, class_2350 facing) {
        }

        public void onBlockHit(class_3222 player, class_1268 enumhand, class_3965 hitRes) {
        }

        public void onBlockBroken(class_3222 player, class_2338 pos, class_2680 previousBS) {
        }

        public void onBlockPlaced(class_3222 player, class_2338 pos, class_1268 enumhand, class_1799 itemstack) {
        }

        public void onEntityHandAction(class_3222 player, class_1297 entity, class_1268 enumhand) {
        }

        public void onEntityAction(class_1297 entity) {
        }

        public void onDimensionChange(class_3222 player, class_243 from, class_243 to, class_5321<class_1937> fromDim, class_5321<class_1937> dimTo) {
        }

        public void onDamage(class_1297 target, float amount, class_1282 source) {
        }

        public void onRecipeSelected(class_3222 player, class_2960 recipe, boolean fullStack) {
        }

        public void onSlotSwitch(class_3222 player, int from, int to) {
        }

        public void onWorldEvent(class_3218 world, class_2338 pos) {
        }

        public void onWorldEventFlag(class_3218 world, class_2338 pos, int flag) {
        }

        public void onCarpetRuleChanges(ParsedRule<?> rule, class_2168 source) {
        }
    }

    public static class CallbackList {
        public final List<Callback> callList = new ArrayList<Callback>();
        public final int reqArgs;

        public CallbackList(int reqArgs) {
            this.reqArgs = reqArgs;
        }

        public void call(Supplier<List<Value>> argumentSupplier, Supplier<class_2168> cmdSourceSupplier) {
            if (this.callList.size() > 0) {
                List<Value> argv = argumentSupplier.get();
                class_2168 source = cmdSourceSupplier.get();
                assert (argv.size() == this.reqArgs);
                ArrayList<Callback> fails = new ArrayList<Callback>();
                for (Callback call : this.callList) {
                    if (call.execute(source, argv)) continue;
                    fails.add(call);
                }
                for (Callback call : fails) {
                    this.callList.remove(call);
                }
            }
        }

        public boolean addEventCall(class_2168 source, String hostName, String funName, Function<ScriptHost, Boolean> verifier) {
            ScriptHost host = CarpetServer.scriptServer.getHostByName(hostName);
            if (host == null) {
                Messenger.m(source, "r Unknown app " + hostName);
                return false;
            }
            if (!verifier.apply(host).booleanValue()) {
                Messenger.m(source, "r Global event can only be added to apps with global scope");
                return false;
            }
            FunctionValue udf = host.getFunction(funName);
            if (udf == null || udf.getArguments().size() != this.reqArgs) {
                Messenger.m(source, "r Callback doesn't expect required number of arguments: " + this.reqArgs);
                return false;
            }
            this.removeEventCall(hostName, udf.getString());
            this.callList.add(new Callback(hostName, udf, null));
            return true;
        }

        public boolean addEventCallInternal(ScriptHost host, FunctionValue function, List<Value> args) {
            if (function == null || function.getArguments().size() - args.size() != this.reqArgs) {
                return false;
            }
            this.removeEventCall(host.getName(), function.getString());
            this.callList.add(new Callback(host.getName(), function, args));
            return true;
        }

        public void removeEventCall(String hostName, String funName) {
            this.callList.removeIf(c -> c.function.getString().equals(funName) && (hostName == c.host || c.host != null && c.host.equalsIgnoreCase(hostName)));
        }

        public void removeAllCalls(String hostName) {
            this.callList.removeIf(c -> c.host != null && c.host.equals(hostName));
        }

        public void clearEverything() {
            this.callList.clear();
        }
    }

    public static class ScheduledCall
    extends Callback {
        private final CarpetContext ctx;
        public long dueTime;

        public ScheduledCall(CarpetContext context, FunctionValue function, List<Value> args, long dueTime) {
            super(context.host.getName(), function, args);
            this.ctx = context;
            this.dueTime = dueTime;
        }

        public void execute() {
            CarpetServer.scriptServer.runas(this.ctx.origin, this.ctx.s, this.host, this.function, this.parametrizedArgs);
        }
    }

    public static class Callback {
        public final String host;
        public final FunctionValue function;
        public final List<Value> parametrizedArgs;

        public Callback(String host, FunctionValue function, List<Value> parametrizedArgs) {
            this.host = host;
            this.function = function;
            this.parametrizedArgs = parametrizedArgs == null ? NOARGS : parametrizedArgs;
        }

        public boolean execute(class_2168 asSource, List<Value> runtimeArgs) {
            if (this.parametrizedArgs.isEmpty()) {
                return CarpetServer.scriptServer.runas(asSource.method_9206(CarpetSettings.runPermissionLevel), this.host, this.function, runtimeArgs);
            }
            ArrayList<Value> combinedArgs = new ArrayList<Value>(runtimeArgs);
            combinedArgs.addAll(this.parametrizedArgs);
            return CarpetServer.scriptServer.runas(asSource.method_9206(CarpetSettings.runPermissionLevel), this.host, this.function, combinedArgs);
        }

        public String toString() {
            return this.function.getString() + (this.host == null ? "" : "(from " + this.host + ")");
        }
    }
}

