/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Rectangle2d;
import org.lwjgl.opengl.GL11;

public class GhostIngredientDrag<T> {
    private static final int targetColor = 1075038474;
    private static final int hoverColor = -2142451431;
    private final IGhostIngredientHandler<?> handler;
    private final List<IGhostIngredientHandler.Target<T>> targets;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final T ingredient;
    private final double mouseStartX;
    private final double mouseStartY;
    @Nullable
    private final Rectangle2d origin;

    public GhostIngredientDrag(IGhostIngredientHandler<?> handler, List<IGhostIngredientHandler.Target<T>> targets, IIngredientRenderer<T> ingredientRenderer, T ingredient, double mouseX, double mouseY, @Nullable Rectangle2d origin) {
        this.handler = handler;
        this.targets = targets;
        this.ingredientRenderer = ingredientRenderer;
        this.ingredient = ingredient;
        this.origin = origin;
        this.mouseStartX = mouseX;
        this.mouseStartY = mouseY;
    }

    public void drawTargets(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.handler.shouldHighlightTargets()) {
            GhostIngredientDrag.drawTargets(matrixStack, mouseX, mouseY, this.targets);
        }
    }

    public void drawItem(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        double mouseXDist = this.mouseStartX - (double)mouseX;
        double mouseYDist = this.mouseStartY - (double)mouseY;
        double mouseDistSq = mouseXDist * mouseXDist + mouseYDist * mouseYDist;
        if (mouseDistSq < 10.0) {
            return;
        }
        if (this.origin != null) {
            int originX = this.origin.func_199318_a() + this.origin.func_199316_c() / 2;
            int originY = this.origin.func_199319_b() + this.origin.func_199317_d() / 2;
            int xDist = originX - mouseX;
            int yDist = originY - mouseY;
            float lineWidth = 2.0f;
            if (minecraft.field_71462_r != null) {
                long distanceSq = (long)xDist * (long)xDist + (long)yDist * (long)yDist;
                int screenDim = minecraft.field_71462_r.field_230708_k_ * minecraft.field_71462_r.field_230709_l_;
                float percentOfDim = Math.min(1.0f, (float)distanceSq / (float)screenDim);
                lineWidth = 1.0f + (1.0f - percentOfDim) * 3.0f;
            }
            GL11.glDisable((int)3553);
            RenderSystem.disableDepthTest();
            GL11.glLineWidth((float)lineWidth);
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
            GL11.glBegin((int)1);
            float red = 0.2509804f;
            float green = 0.07450981f;
            float blue = 0.7882353f;
            float alpha = 0.039215688f;
            RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
            GL11.glVertex3f((float)mouseX, (float)mouseY, (float)150.0f);
            GL11.glVertex3f((float)originX, (float)originY, (float)150.0f);
            GL11.glEnd();
            RenderSystem.enableDepthTest();
            GL11.glEnable((int)3553);
        }
        ItemRenderer itemRenderer = minecraft.func_175599_af();
        itemRenderer.field_77023_b += 150.0f;
        this.ingredientRenderer.render(matrixStack, mouseX - 8, mouseY - 8, this.ingredient);
        itemRenderer.field_77023_b -= 150.0f;
    }

    public static <V> void drawTargets(MatrixStack matrixStack, int mouseX, int mouseY, List<IGhostIngredientHandler.Target<V>> targets) {
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        for (IGhostIngredientHandler.Target<V> target : targets) {
            Rectangle2d area = target.getArea();
            int color = MathUtil.contains(area, (double)mouseX, (double)mouseY) ? -2142451431 : 1075038474;
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)area.func_199318_a(), (int)area.func_199319_b(), (int)(area.func_199318_a() + area.func_199316_c()), (int)(area.func_199319_b() + area.func_199317_d()), (int)color);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean onClick(double mouseX, double mouseY) {
        for (IGhostIngredientHandler.Target<T> target : this.targets) {
            Rectangle2d area = target.getArea();
            if (!MathUtil.contains(area, mouseX, mouseY)) continue;
            target.accept(this.ingredient);
            this.handler.onComplete();
            return true;
        }
        this.handler.onComplete();
        return false;
    }

    public void stop() {
        this.handler.onComplete();
    }

    public IIngredientRenderer<T> getIngredientRenderer() {
        return this.ingredientRenderer;
    }

    public T getIngredient() {
        return this.ingredient;
    }

    @Nullable
    public Rectangle2d getOrigin() {
        return this.origin;
    }
}

