#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['cogent3',
 'cogent3.align',
 'cogent3.app',
 'cogent3.cluster',
 'cogent3.core',
 'cogent3.data',
 'cogent3.draw',
 'cogent3.evolve',
 'cogent3.format',
 'cogent3.maths',
 'cogent3.maths.stats',
 'cogent3.parse',
 'cogent3.phylo',
 'cogent3.recalculation',
 'cogent3.util']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['chardet', 'numpy', 'scitrack', 'tqdm', 'tinydb']

extras_require = \
{":python_version<'3.9'": ['numba>0.48.0'],
 ":python_version>='3.9'": ['numba>0.53'],
 'dev': ['black',
         'click',
         'flit',
         'ipykernel',
         'ipython',
         'ipywidgets',
         'isort',
         'jupyter-sphinx',
         'jupyter_client',
         'jupyterlab',
         'jupytext',
         'kaleido',
         'matplotlib',
         'nbconvert',
         'nbconvert!=5.4',
         'nbformat',
         'nbsphinx',
         'numpydoc',
         'pandas',
         'pillow',
         'plotly',
         'psutil',
         'pytest',
         'pytest-cov',
         'sphinx',
         'sphinx-autobuild',
         'sphinx-gallery==0.7',
         'sphinx>=1.6',
         'sphinx_bootstrap_theme',
         'sphinx_panels',
         'sphinxcontrib-bibtex',
         'sphinxcontrib-bibtex<2.0.0',
         'tox'],
 'doc': ['click',
         'ipykernel',
         'ipython',
         'ipywidgets',
         'jupyter-sphinx',
         'jupyter_client',
         'jupyterlab',
         'jupytext',
         'kaleido',
         'matplotlib',
         'nbconvert',
         'nbconvert!=5.4',
         'nbformat',
         'nbsphinx',
         'numpydoc',
         'pillow',
         'plotly',
         'psutil',
         'sphinx',
         'sphinx-autobuild',
         'sphinx-gallery==0.7',
         'sphinx>=1.6',
         'sphinx_bootstrap_theme',
         'sphinx_panels',
         'sphinxcontrib-bibtex<2.0.0'],
 'extra': ['pandas', 'plotly', 'psutil', 'kaleido'],
 'test': ['black', 'isort', 'pytest', 'pytest-cov', 'tox']}

setup(name='cogent3',
      version='2021.10.12a1',
      description='The most commonly used constructors are available from this toplevel module.',
      author='Gavin Huttley',
      author_email='Gavin.Huttley@anu.edu.au',
      url='https://cogent3.org',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.7',
     )
