# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#

import datetime
import uuid
import time
import dataclasses
import typing
import mettle.io
import mettle.db

from .msg_key import tMsgKey

@dataclasses.dataclass(slots=True)
class tMsg(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    id: int = dataclasses.field(default=0, compare=True, hash=True)
    msgreq_id: int = dataclasses.field(default=0, compare=False)
    corrtype_id: str = dataclasses.field(default='', compare=False)
    notype_id: str = dataclasses.field(default='', compare=False)
    priority: int = dataclasses.field(default=0, compare=False)
    status: str = dataclasses.field(default='', compare=False)
    retry_cnt: int = dataclasses.field(default=0, compare=False)
    fail_cnt: int = dataclasses.field(default=0, compare=False)
    time_sent: typing.Optional[datetime.datetime] = dataclasses.field(default=None, compare=False)
    time_taken: float = dataclasses.field(default=0.0, compare=False)
    corrprov_id: str = dataclasses.field(default='', compare=False)
    msglog: typing.Optional[dict] = dataclasses.field(default=None, compare=False)
    payload: typing.Optional[dict] = dataclasses.field(default=None, compare=False)
    modified_by: str = dataclasses.field(default='', compare=False)
    tm_stamp: typing.Optional[datetime.datetime] = dataclasses.field(default=None, compare=False)

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = 0
        self.msgreq_id = 0
        self.corrtype_id = ''
        self.notype_id = ''
        self.priority = 0
        self.status = ''
        self.retry_cnt = 0
        self.fail_cnt = 0
        self.time_sent = None
        self.time_taken = 0.0
        self.corrprov_id = ''
        self.msglog = None
        self.payload = None
        self.modified_by = ''
        self.tm_stamp = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tMsg'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int64("id", self.id)
        _w.write_int64("msgreq_id", self.msgreq_id)
        _w.write_string("corrtype_id", self.corrtype_id)
        _w.write_string("notype_id", self.notype_id)
        _w.write_int32("priority", self.priority)
        _w.write_char("status", self.status)
        _w.write_int32("retry_cnt", self.retry_cnt)
        _w.write_int32("fail_cnt", self.fail_cnt)
        _w.write_datetime("time_sent", self.time_sent)
        _w.write_double("time_taken", self.time_taken)
        _w.write_string("corrprov_id", self.corrprov_id)
        _w.write_json("msglog", self.msglog)
        _w.write_json("payload", self.payload)
        _w.write_string("modified_by", self.modified_by)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_int64("id")
        self.msgreq_id = _r.read_int64("msgreq_id")
        self.corrtype_id = _r.read_string("corrtype_id")
        self.notype_id = _r.read_string("notype_id")
        self.priority = _r.read_int32("priority")
        self.status = _r.read_char("status")
        self.retry_cnt = _r.read_int32("retry_cnt")
        self.fail_cnt = _r.read_int32("fail_cnt")
        self.time_sent = _r.read_datetime("time_sent")
        self.time_taken = _r.read_double("time_taken")
        self.corrprov_id = _r.read_string("corrprov_id")
        self.msglog = _r.read_json("msglog")
        self.payload = _r.read_json("payload")
        self.modified_by = _r.read_string("modified_by")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tMsg"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.msgreq_id = rec.msgreq_id
        self.corrtype_id = rec.corrtype_id
        self.notype_id = rec.notype_id
        self.priority = rec.priority
        self.status = rec.status
        self.retry_cnt = rec.retry_cnt
        self.fail_cnt = rec.fail_cnt
        self.time_sent = rec.time_sent
        self.time_taken = rec.time_taken
        self.corrprov_id = rec.corrprov_id
        self.msglog = rec.msglog
        self.payload = rec.payload
        self.modified_by = rec.modified_by
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tMsg"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tMsg"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tMsgKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tMsgKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        if not for_ins:
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))

        if key_only:
            return dvc

        dvc.add_targ("msgreq_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("corrtype_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 16))
        dvc.add_targ("notype_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        dvc.add_targ("priority", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['P','S','F','R','C','T']))
        dvc.add_targ("retry_cnt", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("fail_cnt", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("time_taken", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("corrprov_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 16))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tMsg._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tMsgKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id

    def _read_key(self, _key: tMsgKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id

    class Status_Couplet(dict):
        key_pending = "P"
        key_sent = "S"
        key_failed = "F"
        key_retry = "R"
        key_cancelled = "C"
        key_template_error = "T"

        value_pending = "Pending"
        value_sent = "Sent"
        value_failed = "Failed"
        value_retry = "Retry"
        value_cancelled = "Cancelled"
        value_template_error = "Template Error"

        def __init__(self):
            self[self.key_pending] = self.value_pending
            self[self.key_sent] = self.value_sent
            self[self.key_failed] = self.value_failed
            self[self.key_retry] = self.value_retry
            self[self.key_cancelled] = self.value_cancelled
            self[self.key_template_error] = self.value_template_error

        @staticmethod
        def get_value(key):
            if key == tMsg.Status_Couplet.key_pending:
                return tMsg.Status_Couplet.value_pending

            if key == tMsg.Status_Couplet.key_sent:
                return tMsg.Status_Couplet.value_sent

            if key == tMsg.Status_Couplet.key_failed:
                return tMsg.Status_Couplet.value_failed

            if key == tMsg.Status_Couplet.key_retry:
                return tMsg.Status_Couplet.value_retry

            if key == tMsg.Status_Couplet.key_cancelled:
                return tMsg.Status_Couplet.value_cancelled

            if key == tMsg.Status_Couplet.key_template_error:
                return tMsg.Status_Couplet.value_template_error

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return x.id - y.id

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tMsg.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tMsg()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tMsg._cache_davs(dvc, for_ins, key_only)

