# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.snap_prov_key import tSnapProvKey

class dSnapProvDeleteOne:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tSnapProvKey()

    async def __aenter__(self):
        """
        With statement enter.
        """
        return self

    async def __aexit__(self, type, value, traceback):
        """
        With statement exit.
        """
        await self._destroy()

    async def _destroy(self):
        if self._dbstmnt:
            await self._dbstmnt.destroy()
            self._dbstmnt = None

    async def exec_deft(self,
                        valuedate: datetime.date,
                        corrtype_id: str,
                        corrprov_id: str) -> "dSnapProvDeleteOne":
        """
        Execute the query by setting all the inputs.

        :param valuedate: datetime.date
        :param corrtype_id: str
        :param corrprov_id: str
        :return: Self for convenience.
        """
        self.irec.valuedate = valuedate
        self.irec.corrtype_id = corrtype_id
        self.irec.corrprov_id = corrprov_id

        return await self.exec()

    async def exec(self, irec: tSnapProvKey = None) -> "dSnapProvDeleteOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        await self._destroy()

        self._dbstmnt = await self._dbcon.statement("SnapProvDeleteOne", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""delete from
  loco.SnapProv
where
  valuedate = :valuedate and
  corrtype_id = :corrtype_id and
  corrprov_id = :corrprov_id""")

        self._dbstmnt.bind_in("valuedate", self.irec.valuedate, datetime.date)
        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("corrprov_id", self.irec.corrprov_id, str, 16)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

