# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_type import tNoType

class dNoTypeUpdate:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoType()

    async def __aenter__(self):
        """
        With statement enter.
        """
        return self

    async def __aexit__(self, type, value, traceback):
        """
        With statement exit.
        """
        await self._destroy()

    async def _destroy(self):
        if self._dbstmnt:
            await self._dbstmnt.destroy()
            self._dbstmnt = None

    async def exec_deft(self,
                        id: str,
                        status: str,
                        descr: str,
                        grp: str,
                        priority: int,
                        pref_corr: dict,
                        corr_cnt: int,
                        max_life: int,
                        modified_by: str) -> "dNoTypeUpdate":
        """
        Execute the query by setting all the inputs.

        :param id: str
        :param status: str
        :param descr: str
        :param grp: str
        :param priority: int
        :param pref_corr: dict
        :param corr_cnt: int
        :param max_life: int
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.status = status
        self.irec.descr = descr
        self.irec.grp = grp
        self.irec.priority = priority
        self.irec.pref_corr = pref_corr
        self.irec.corr_cnt = corr_cnt
        self.irec.max_life = max_life
        self.irec.modified_by = modified_by

        return await self.exec()

    async def exec(self, irec: tNoType = None) -> "dNoTypeUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        await self._destroy()

        self._dbstmnt = await self._dbcon.statement("NoTypeUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  loco.NoType
set
  status = :status,
  descr = :descr,
  grp = :grp,
  priority = :priority,
  pref_corr = :pref_corr,
  corr_cnt = :corr_cnt,
  max_life = :max_life,
  modified_by = :modified_by,
  tm_stamp = :tm_stamp
where
  id = :id""")

        self.irec.tm_stamp = await self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("id", self.irec.id, str, 128)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("descr", self.irec.descr, str, 256)
        self._dbstmnt.bind_in("grp", self.irec.grp, str, 64)
        self._dbstmnt.bind_in("priority", self.irec.priority, int, 4)
        self._dbstmnt.bind_in("pref_corr", self.irec.pref_corr, dict)
        self._dbstmnt.bind_in("corr_cnt", self.irec.corr_cnt, int, 4)
        self._dbstmnt.bind_in("max_life", self.irec.max_life, int, 4)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

