# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_dict_key import tNoDictKey
from bs_loco.db.tables.no_dict import tNoDict

class dNoDictLockOne:
    __slots__ = ("_dbcon", "_dbstmnt", "irec", "orec")

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoDictKey()
        self.orec     = None

    async def __aenter__(self):
        """
        With statement enter.
        """
        return self

    async def __aexit__(self, type, value, traceback):
        """
        With statement exit.
        """
        await self._destroy()

    async def _destroy(self):
        if self._dbstmnt:
            await self._dbstmnt.destroy()
            self._dbstmnt = None

    async def exec_deft(self,
                        id: str) -> "dNoDictLockOne":
        """
        Execute the query by setting all the inputs.

        :param id: str
        :return: Self for convenience.
        """
        self.irec.id = id

        return await self.exec()

    async def exec(self, irec: tNoDictKey = None) -> "dNoDictLockOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        await self._destroy()

        self._dbstmnt = await self._dbcon.statement("NoDictLockOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  id,
  value,
  modified_by,
  tm_stamp
from
  loco.NoDict
where
  id = :id for update nowait""")

        self._dbstmnt.bind_in("id", self.irec.id, str, 128)

        self._dbstmnt.bind_out("id", str, 128)
        self._dbstmnt.bind_out("value", str, 256)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        await self._dbcon.lock(self._dbstmnt)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self, must_exist: bool = False) -> bool:
        """
        Fetches the next row from the executed query.

        :param must_exist:
        :return: True if a row was fetched, else False.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            if must_exist:
                raise mettle.lib.xMettle(f"Record not found: [table:NoDict, proc:LockOne, row:{self.irec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)
            return False

        self.orec = tNoDict()

        self.orec.id = self._dbstmnt.result[0]
        self.orec.value = self._dbstmnt.result[1]
        self.orec.modified_by = self._dbstmnt.result[2]
        self.orec.tm_stamp = self._dbstmnt.result[3]

        return True

    async def fetch_iter(self) -> tNoDict:
        """
        Yield all the rows one at a time.

        :return: Iterator for output rows
        """
        while await self.fetch():
            yield self.orec

    async def fetch_all(self, out_list: tNoDict.List, clear_list: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param out_list:
        :param clear_list:
        :return: Number of rows fetched.
        """
        if clear_list:
            out_list.clear()

        while await self.fetch():
            out_list.append(self.orec)

        return len(out_list)

