# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_dict import tNoDict

class dNoDictInsert:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tNoDict()

    async def __aenter__(self):
        """
        With statement enter.
        """
        return self

    async def __aexit__(self, type, value, traceback):
        """
        With statement exit.
        """
        await self._destroy()

    async def _destroy(self):
        if self._dbstmnt:
            await self._dbstmnt.destroy()
            self._dbstmnt = None

    async def exec_deft(self,
                        id: str,
                        value: str,
                        modified_by: str,
                        tm_stamp: datetime.datetime) -> "dNoDictInsert":
        """
        Execute the query by setting all the inputs.

        :param id: str
        :param value: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.value = value
        self.irec.modified_by = modified_by
        self.irec.tm_stamp = tm_stamp

        return await self.exec()

    async def exec(self, irec: tNoDict = None) -> "dNoDictInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        await self._destroy()

        self._dbstmnt = await self._dbcon.statement("NoDictInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into loco.NoDict (
  id,
  value,
  modified_by,
  tm_stamp
) values (
  :id,
  :value,
  :modified_by,
  :tm_stamp
)""")

        self.irec.tm_stamp = await self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("id", self.irec.id, str, 128)
        self._dbstmnt.bind_in("value", self.irec.value, str, 256)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

