# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.msg_hist import tMsgHist

class dMsgHistUpdate:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tMsgHist()

    async def __aenter__(self):
        """
        With statement enter.
        """
        return self

    async def __aexit__(self, type, value, traceback):
        """
        With statement exit.
        """
        await self._destroy()

    async def _destroy(self):
        if self._dbstmnt:
            await self._dbstmnt.destroy()
            self._dbstmnt = None

    async def exec_deft(self,
                        id: int,
                        status: str,
                        msgdate: datetime.datetime,
                        msg: dict) -> "dMsgHistUpdate":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param status: str
        :param msgdate: datetime.datetime
        :param msg: dict
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.status = status
        self.irec.msgdate = msgdate
        self.irec.msg = msg

        return await self.exec()

    async def exec(self, irec: tMsgHist = None) -> "dMsgHistUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        await self._destroy()

        self._dbstmnt = await self._dbcon.statement("MsgHistUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  loco.MsgHist
set
  status = :status,
  msgdate = :msgdate,
  msg = :msg
where
  id = :id""")

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("msgdate", self.irec.msgdate, datetime.datetime)
        self._dbstmnt.bind_in("msg", self.irec.msg, dict)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

