# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.icorr_type_allow_regex_for_type import iCorrTypeAllowRegexForType
from bs_loco.db.tables.ocorr_type_allow_regex_for_type import oCorrTypeAllowRegexForType

class dCorrTypeAllowRegexForType:
    __slots__ = ("_dbcon", "_dbstmnt", "irec", "orec")

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iCorrTypeAllowRegexForType()
        self.orec     = None

    async def __aenter__(self):
        """
        With statement enter.
        """
        return self

    async def __aexit__(self, type, value, traceback):
        """
        With statement exit.
        """
        await self._destroy()

    async def _destroy(self):
        if self._dbstmnt:
            await self._dbstmnt.destroy()
            self._dbstmnt = None

    async def exec_deft(self,
                        corrtype_id: str,
                        allow_id: str,
                        status: str) -> "dCorrTypeAllowRegexForType":
        """
        Execute the query by setting all the inputs.

        :param corrtype_id: str
        :param allow_id: str
        :param status: str
        :return: Self for convenience.
        """
        self.irec.corrtype_id = corrtype_id
        self.irec.allow_id = allow_id
        self.irec.status = status

        return await self.exec()

    async def exec(self, irec: iCorrTypeAllowRegexForType = None) -> "dCorrTypeAllowRegexForType":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        await self._destroy()

        self._dbstmnt = await self._dbcon.statement("CorrTypeAllowRegexForType", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  ca.allow_id,
  ca.regex
from
  loco.corrtypeallow ca
where
  ca.corrtype_id = :corrtype_id and
  regex is not null and
  (:allow_id is null or ca.allow_id = :allow_id) and
  (:status   is null or ca.status   = :status)
order by
  1""")

        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("allow_id", self.irec.allow_id, str, 32)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)

        self._dbstmnt.bind_out("allow_id", str, 32)
        self._dbstmnt.bind_out("regex", str, 256)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self, must_exist: bool = False) -> bool:
        """
        Fetches the next row from the executed query.

        :param must_exist:
        :return: True if a row was fetched, else False.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            if must_exist:
                raise mettle.lib.xMettle(f"Record not found: [table:CorrTypeAllow, proc:RegexForType, row:{self.irec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)
            return False

        self.orec = oCorrTypeAllowRegexForType()

        self.orec.allow_id = self._dbstmnt.result[0]
        self.orec.regex = self._dbstmnt.result[1]

        return True

    async def fetch_iter(self) -> oCorrTypeAllowRegexForType:
        """
        Yield all the rows one at a time.

        :return: Iterator for output rows
        """
        while await self.fetch():
            yield self.orec

    async def fetch_all(self, out_list: oCorrTypeAllowRegexForType.List, clear_list: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param out_list:
        :param clear_list:
        :return: Number of rows fetched.
        """
        if clear_list:
            out_list.clear()

        while await self.fetch():
            out_list.append(self.orec)

        return len(out_list)

