# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.iconfig_search import iConfigSearch
from bs_loco.db.tables.config import tConfig

class dConfigSearch:
    __slots__ = ("_dbcon", "_dbstmnt", "irec", "orec")

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iConfigSearch()
        self.orec     = None

    async def __aenter__(self):
        """
        With statement enter.
        """
        return self

    async def __aexit__(self, type, value, traceback):
        """
        With statement exit.
        """
        await self._destroy()

    async def _destroy(self):
        if self._dbstmnt:
            await self._dbstmnt.destroy()
            self._dbstmnt = None

    async def exec_deft(self,
                        criteria: str) -> "dConfigSearch":
        """
        Execute the query by setting all the inputs.

        :param criteria: str
        :return: Self for convenience.
        """
        self.irec.criteria = criteria

        return await self.exec()

    async def exec(self, irec: iConfigSearch = None) -> "dConfigSearch":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        await self._destroy()

        self._dbstmnt = await self._dbcon.statement("ConfigSearch", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  c.*
from
  loco.config c
where
  (1=1)
  [criteria]
order by
  c.id""")

        self._dbstmnt.dynamic("[criteria]", self.irec.criteria)

        self._dbstmnt.bind_out("id", str)
        self._dbstmnt.bind_out("descr", str)
        self._dbstmnt.bind_out("value", str)
        self._dbstmnt.bind_out("grp", str)
        self._dbstmnt.bind_out("modified_by", str)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self, must_exist: bool = False) -> bool:
        """
        Fetches the next row from the executed query.

        :param must_exist:
        :return: True if a row was fetched, else False.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            if must_exist:
                raise mettle.lib.xMettle(f"Record not found: [table:Config, proc:Search, row:{self.irec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)
            return False

        self.orec = tConfig()

        self.orec.id = self._dbstmnt.result[0]
        self.orec.descr = self._dbstmnt.result[1]
        self.orec.value = self._dbstmnt.result[2]
        self.orec.grp = self._dbstmnt.result[3]
        self.orec.modified_by = self._dbstmnt.result[4]
        self.orec.tm_stamp = self._dbstmnt.result[5]

        return True

    async def fetch_iter(self) -> tConfig:
        """
        Yield all the rows one at a time.

        :return: Iterator for output rows
        """
        while await self.fetch():
            yield self.orec

    async def fetch_all(self, out_list: tConfig.List, clear_list: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param out_list:
        :param clear_list:
        :return: Number of rows fetched.
        """
        if clear_list:
            out_list.clear()

        while await self.fetch():
            out_list.append(self.orec)

        return len(out_list)

