# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.snap_prov import tSnapProv

class dSnapProvInsert:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tSnapProv()

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  valuedate: datetime.date,
                  corrtype_id: str,
                  corrprov_id: str,
                  msg_sent: int,
                  msg_failed: int,
                  msg_retry: int,
                  avg_msg_time: float,
                  tot_msg_time: float) -> "dSnapProvInsert":
        """
        Execute the query by setting all the inputs.

        :param valuedate: datetime.date
        :param corrtype_id: str
        :param corrprov_id: str
        :param msg_sent: int
        :param msg_failed: int
        :param msg_retry: int
        :param avg_msg_time: float
        :param tot_msg_time: float
        :return: Self for convenience.
        """
        self.irec.valuedate = valuedate
        self.irec.corrtype_id = corrtype_id
        self.irec.corrprov_id = corrprov_id
        self.irec.msg_sent = msg_sent
        self.irec.msg_failed = msg_failed
        self.irec.msg_retry = msg_retry
        self.irec.avg_msg_time = avg_msg_time
        self.irec.tot_msg_time = tot_msg_time

        return self.exec()

    def exec(self, irec: tSnapProv = None) -> "dSnapProvInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("SnapProvInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into loco.SnapProv (
  valuedate,
  corrtype_id,
  corrprov_id,
  msg_sent,
  msg_failed,
  msg_retry,
  avg_msgTime,
  tot_msgTime
) values (
  :valuedate,
  :corrtype_id,
  :corrprov_id,
  :msg_sent,
  :msg_failed,
  :msg_retry,
  :avg_msgTime,
  :tot_msgTime
)""")

        self._dbstmnt.bind_in("valuedate", self.irec.valuedate, datetime.date)
        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("corrprov_id", self.irec.corrprov_id, str, 16)
        self._dbstmnt.bind_in("msg_sent", self.irec.msg_sent, int, 4)
        self._dbstmnt.bind_in("msg_failed", self.irec.msg_failed, int, 4)
        self._dbstmnt.bind_in("msg_retry", self.irec.msg_retry, int, 4)
        self._dbstmnt.bind_in("avg_msgTime", self.irec.avg_msg_time, float)
        self._dbstmnt.bind_in("tot_msgTime", self.irec.tot_msg_time, float)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

