# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.snap_msg_req_key import tSnapMsgReqKey
from bs_loco.db.tables.snap_msg_req import tSnapMsgReq

class dSnapMsgReqLockOne:
    __slots__ = ("_dbcon", "_dbstmnt", "irec", "orec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tSnapMsgReqKey()
        self.orec     = None

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  valuedate: datetime.date,
                  notype_id: str) -> "dSnapMsgReqLockOne":
        """
        Execute the query by setting all the inputs.

        :param valuedate: datetime.date
        :param notype_id: str
        :return: Self for convenience.
        """
        self.irec.valuedate = valuedate
        self.irec.notype_id = notype_id

        return self.exec()

    def exec(self, irec: tSnapMsgReqKey = None) -> "dSnapMsgReqLockOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("SnapMsgReqLockOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  valuedate,
  notype_id,
  tot_req,
  tot_proc,
  tot_cancelled,
  tot_part_canc,
  tot_msgs,
  tot_msgs_sent,
  tot_msgs_failed,
  tot_msgs_retrys
from
  loco.SnapMsgReq
where
  valuedate = :valuedate and
  notype_id = :notype_id for update nowait""")

        self._dbstmnt.bind_in("valuedate", self.irec.valuedate, datetime.date)
        self._dbstmnt.bind_in("notype_id", self.irec.notype_id, str, 64)

        self._dbstmnt.bind_out("valuedate", datetime.date)
        self._dbstmnt.bind_out("notype_id", str, 64)
        self._dbstmnt.bind_out("tot_req", int, 4)
        self._dbstmnt.bind_out("tot_proc", int, 4)
        self._dbstmnt.bind_out("tot_cancelled", int, 4)
        self._dbstmnt.bind_out("tot_part_canc", int, 4)
        self._dbstmnt.bind_out("tot_msgs", int, 4)
        self._dbstmnt.bind_out("tot_msgs_sent", int, 4)
        self._dbstmnt.bind_out("tot_msgs_failed", int, 4)
        self._dbstmnt.bind_out("tot_msgs_retrys", int, 4)

        self._dbcon.lock(self._dbstmnt)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self, must_exist: bool = False) -> bool:
        """
        Fetches the next row from the executed query.

        :param must_exist:
        :return: True if a row was fetched, else False.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            if must_exist:
                raise mettle.lib.xMettle(f"Record not found: [table:SnapMsgReq, proc:LockOne, row:{self.irec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)
            return False

        self.orec = tSnapMsgReq()

        self.orec.valuedate = self._dbstmnt.result[0]
        self.orec.notype_id = self._dbstmnt.result[1]
        self.orec.tot_req = self._dbstmnt.result[2]
        self.orec.tot_proc = self._dbstmnt.result[3]
        self.orec.tot_cancelled = self._dbstmnt.result[4]
        self.orec.tot_part_canc = self._dbstmnt.result[5]
        self.orec.tot_msgs = self._dbstmnt.result[6]
        self.orec.tot_msgs_sent = self._dbstmnt.result[7]
        self.orec.tot_msgs_failed = self._dbstmnt.result[8]
        self.orec.tot_msgs_retrys = self._dbstmnt.result[9]

        return True

    def fetch_iter(self) -> tSnapMsgReq:
        """
        Yield all the rows one at a time.

        :return: Iterator for output rows
        """
        while self.fetch():
            yield self.orec

    def fetch_all(self, out_list: tSnapMsgReq.List, clear_list: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param out_list:
        :param clear_list:
        :return: Number of rows fetched.
        """
        if clear_list:
            out_list.clear()

        while self.fetch():
            out_list.append(self.orec)

        return len(out_list)

