# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.snap_msg_req_key import tSnapMsgReqKey

class dSnapMsgReqDeleteOne:
    __slots__ = ("_dbcon", "_dbstmnt", "irec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tSnapMsgReqKey()

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt:
            self._dbstmnt.destroy()
            self._dbstmnt = None

    def exec_deft(self,
                  valuedate: datetime.date,
                  notype_id: str) -> "dSnapMsgReqDeleteOne":
        """
        Execute the query by setting all the inputs.

        :param valuedate: datetime.date
        :param notype_id: str
        :return: Self for convenience.
        """
        self.irec.valuedate = valuedate
        self.irec.notype_id = notype_id

        return self.exec()

    def exec(self, irec: tSnapMsgReqKey = None) -> "dSnapMsgReqDeleteOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("SnapMsgReqDeleteOne", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""delete from
  loco.SnapMsgReq
where
  valuedate = :valuedate and
  notype_id = :notype_id""")

        self._dbstmnt.bind_in("valuedate", self.irec.valuedate, datetime.date)
        self._dbstmnt.bind_in("notype_id", self.irec.notype_id, str, 64)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

