# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Sep  8 08:23:42 2022
#  Target Database = postgresql
#
import asyncio
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_templ_cfg import tNoTemplCfg
from bs_loco.db.tables.no_templ_cfg_key import tNoTemplCfgKey

from .no_templ_cfg_lock_one import dNoTemplCfgLockOne
from .no_templ_cfg_select_one import dNoTemplCfgSelectOne
from .no_templ_cfg_update import dNoTemplCfgUpdate
from .no_templ_cfg_insert import dNoTemplCfgInsert

class dNoTemplCfg:
    __slots__ = ("_dbcon", "rec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tNoTemplCfg()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    def lock_one(self, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record.

        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tNoTemplCfgKey()

        self.rec._write_key(_key)

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_with(self, _rec: tNoTemplCfg, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record using a record.

        :param _rec: The table rec to select with and into.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tNoTemplCfgKey()
        _rec._write_key(_key)

        self.lock_one_by_key(_key, _lock4update, _expected)
        _rec._copy_from(self.rec)
        return True

    def lock_one_deft(self,
                      id: int,
                      _lock4update: mettle.db.DBLock,
                      _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record by it's primary key columns.

        :param id: int
        :param _lock4update:  The db lock object to use. 
        :param _expected: bool
        """
        _key = tNoTemplCfgKey()

        _key.id = id

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_by_key(self, _key: tNoTemplCfgKey, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record with it's primary key.

        :param _key: Primary key of the table record.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        with dNoTemplCfgLockOne(self._dbcon) as _qry:
            _dex = _lock4update.retrys - 1 if _lock4update.retrys > 0 else 0

            while _dex >= 0:
                try:
                    _qry.exec(_key)
                    if not _qry.fetch():
                        if not _expected:
                            return False

                        raise mettle.lib.xMettle(f"Lock not found: [table:dNoTemplCfg, row:{_key}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)

                    break
                except mettle.lib.xMettle as _x:
                    if _x.get_error_code() != mettle.lib.xMettle.eCode.DBLockNoWaitFailed:
                        raise _x

                    if _dex == 0:
                        raise mettle.lib.xMettle("Could not lock NoTemplCfg record after %d attempt(s) at %d mili second intervals!" % (
_lock4update.retrys, _lock4update.mili_seconds), err_code = mettle.lib.xMettle.eCode.DBLockNoWaitFailed)

                    if _lock4update.mili_seconds > 0:
                        time.sleep(_lock4update.mili_seconds * 0.001)
                _dex -= 1

            self.rec = _qry.orec

            return True

    def try_select_one(self) -> bool:
        """
        Attempt to select the record.

        :return: True if the record was found.
        """
        _key = tNoTemplCfgKey()

        self.rec._write_key(_key)

        return self.try_select_one_by_key(_key)

    def try_select_one_with(self, _rec: tNoTemplCfg) -> bool:
        """
        Attempt to select the record using a table rec.

        :param _rec: The table rec to select with and into.
        :return: True if the row as selectd.
        """
        _key = tNoTemplCfgKey()
        _rec._write_key(_key)

        if not self.try_select_one_by_key(_key):
            return False

        _rec._copy_from(self.rec)

        return True

    def try_select_one_deft(self,
                            id: int) -> bool:
        """
        Attempt to select the record by it's primary key columns.

        :param id: int
        :return: True if the row as selectd.
        """
        _key = tNoTemplCfgKey()

        _key.id = id

        return self.try_select_one_by_key(_key)

    def try_select_one_by_key(self, _key: tNoTemplCfgKey) -> bool:
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :returns: True if row was selected.
        """
        with dNoTemplCfgSelectOne(self._dbcon) as _qry:
            _qry.exec(_key)
            if not _qry.fetch():
                return False

            self.rec = _qry.orec

        return True

    def select_one(self) -> "dNoTemplCfg":
        """
        Selects the record, raises and error if it does not exist.

        :return: Self for convenience.
        """
        if not self.try_select_one():
            raise mettle.lib.xMettle(f"Not found: [table:dNoTemplCfg, row:{self.rec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)

        return self

    def select_one_with(self, _rec: tNoTemplCfg) -> "dNoTemplCfg":
        """
        Attempt to select the record with the table record.

        :param _rec: Table record.
        :returns: Self for convenience.
        """
        if not self.try_select_one_with(_rec):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dNoTemplCfg)")

        return self

    def select_one_deft(self,
                        id: int) -> "dNoTemplCfg":
        """
        Selects the record by its primary key columns, raises and error if it does not exist.

        :param id: int
        """
        _key = tNoTemplCfgKey()

        _key.id = id

        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle(f"Not found: [table:dNoTemplCfg, row:{_key}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)

        return self

    def select_one_by_key(self, _key: tNoTemplCfgKey) -> "dNoTemplCfg":
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :return: Self for convenience.
        """
        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle(f"Not found: [table:dNoTemplCfg, row:{self.irec}]", xMettle.eCode.DBNotFound)

        return self

    def update_deft(self,
                    id: int,
                    notype_id: str,
                    corrtype_id: str,
                    status: str,
                    activate: datetime.datetime,
                    deactivate: datetime.datetime,
                    templ: dict,
                    res_list: dict,
                    modified_by: str):
        """
        Update the record by setting all column values.

        :param id: int
        :param notype_id: str
        :param corrtype_id: str
        :param status: str
        :param activate: datetime.datetime
        :param deactivate: datetime.datetime
        :param templ: dict
        :param res_list: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.id = id
        self.rec.notype_id = notype_id
        self.rec.corrtype_id = corrtype_id
        self.rec.status = status
        self.rec.activate = activate
        self.rec.deactivate = deactivate
        self.rec.templ = templ
        self.rec.res_list = res_list
        self.rec.modified_by = modified_by

        self.update()

    def update(self, irec: tNoTemplCfg = None):
        """
        Update the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to update the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dNoTemplCfgUpdate(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def insert_deft(self,
                    notype_id: str,
                    corrtype_id: str,
                    status: str,
                    activate: datetime.datetime,
                    deactivate: datetime.datetime,
                    templ: dict,
                    res_list: dict,
                    modified_by: str):
        """
        Insert the record setting all column values.

        :param id: int
        :param notype_id: str
        :param corrtype_id: str
        :param status: str
        :param activate: datetime.datetime
        :param deactivate: datetime.datetime
        :param templ: dict
        :param res_list: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.notype_id = notype_id
        self.rec.corrtype_id = corrtype_id
        self.rec.status = status
        self.rec.activate = activate
        self.rec.deactivate = deactivate
        self.rec.templ = templ
        self.rec.res_list = res_list
        self.rec.modified_by = modified_by

        self.insert()

    def insert(self, irec: tNoTemplCfg = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dNoTemplCfgInsert(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

